/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BaseCellRenderer;
import com.sybase.resultSetTable.LongValue;
import com.sybase.resultSetTable.NullAwareTable;

class BinaryCellRenderer
extends BaseCellRenderer {
    BinaryCellRenderer() {
    }

    @Override
    protected Object getDisplayValue(NullAwareTable nullAwareTable, Object object) {
        String string;
        if (object != null && object instanceof LongValue) {
            object = ((LongValue)object).getTruncatedValue();
        }
        if (object == null) {
            string = "";
        } else if (object instanceof byte[]) {
            int n = nullAwareTable.getResultSetTable().getTruncationLength();
            string = this.blobToString((byte[])object, n);
        } else {
            string = object.toString();
        }
        return string;
    }

    private String blobToString(byte[] byArray, int n) {
        int n2 = byArray.length;
        if (n != 0) {
            n2 = Math.min(n2, n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * 2 + 2);
        if (n2 > 0) {
            stringBuilder.append("0x");
            for (int i = 0; i < n2; ++i) {
                int n3 = byArray[i];
                if (n3 < 0) {
                    n3 += 256;
                }
                int n4 = n3 >> 4;
                int n5 = n3 & 0xF;
                if (n4 < 10) {
                    stringBuilder.append((char)(48 + n4));
                } else {
                    stringBuilder.append((char)(97 + n4 - 10));
                }
                if (n5 < 10) {
                    stringBuilder.append((char)(48 + n5));
                    continue;
                }
                stringBuilder.append((char)(97 + n5 - 10));
            }
        }
        return stringBuilder.toString();
    }
}

