/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.ExtendedFileChooser;
import com.sybase.resultSetTable.FilePreviewer;
import com.sybase.resultSetTable.ImageMetadata;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.XMLEncodingFinder;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

class CustomFileDialog
extends JDialog
implements PropertyChangeListener {
    static final String ENCODING_FOR_INVALID_XML = "UTF-8";
    private static final int LAYOUT_FALLBACK = 0;
    private static final int LAYOUT_WINDOWS = 1;
    private static final int LAYOUT_MOTIF = 2;
    private static final int LAYOUT_MAC = 3;
    private static ResultSetTableResourcesBase _bundle = null;
    private int _minHeight;
    private int _minWidth;
    private int _layout = 0;
    private ExtendedFileChooser _fileChooser;
    private FilePreviewer _filePreviewer = null;
    private boolean _allowNonexistentFile = false;
    private boolean _isSaving = false;
    private boolean _promptForOverwrite = false;
    private boolean _showEncoding = false;
    private File _selectedFile = null;
    private ImageMetadata _selectedImageMetadata = null;
    private Charset _selectedCharset = null;
    private File _lastDirectory = null;
    private boolean _isXMLFilterSelected = false;
    private boolean _isFilePreviewerSet = false;
    private boolean _isFileSelected = false;
    private ComboBoxModel _standardEncodingModel;
    private ComboBoxModel _xmlEncodingModel;
    private JPanel _buttonsPanel;
    private JSeparator _buttonsSeparator;
    private SybButton _cancelButton;
    private JComboBox _encodingComboBox;
    private SybLabel _encodingLabel;
    private JPanel _encodingPanel;
    private SybButton _okButton;
    private SybButton _updateButton;

    CustomFileDialog(Window window) {
        super(window, Dialog.ModalityType.DOCUMENT_MODAL);
        if (_bundle == null) {
            _bundle = ResultSetTableResourcesBase.getBundle();
        }
        String[] stringArray = new String[]{_bundle.getString("SYSTEM_DEFAULT_ENCODING"), ENCODING_FOR_INVALID_XML};
        this._standardEncodingModel = new DefaultComboBoxModel<String>(stringArray);
        stringArray = new String[]{_bundle.getString("USE_XML_ENCODING")};
        this._xmlEncodingModel = new DefaultComboBoxModel<String>(stringArray);
        this.initComponents();
        this._fileChooser = new ExtendedFileChooser();
        this._fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomFileDialog.this.fileChooserActionPerformed(actionEvent);
            }
        });
        this._fileChooser.addPropertyChangeListener("fileFilterChanged", this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this._fileChooser, gridBagConstraints);
        this.pack();
        if (UIManager.getLookAndFeel().getID().equals("Windows")) {
            if (this.tryWindowsLayout()) {
                this._layout = 1;
            } else {
                this.doFallbackLayout();
                this._layout = 0;
            }
        } else if (UIManager.getLookAndFeel().getID().equals("Motif")) {
            this.doMotifLayout();
            this._layout = 2;
        } else if (UIManager.getLookAndFeel().getID().equals("Motif")) {
            this.doMacLayout();
            this._layout = 3;
        } else {
            this.doFallbackLayout();
            this._layout = 0;
        }
        this.pack();
        this._minWidth = this.getWidth();
        this._minHeight = this.getHeight();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomFileDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape pressed");
        this.getRootPane().getActionMap().put("escape pressed", abstractAction);
    }

    void destroy() {
        if (this._fileChooser != null) {
            this._fileChooser.destroy();
            this._fileChooser = null;
        }
        if (this._filePreviewer != null) {
            this._filePreviewer.destroy();
            this._filePreviewer = null;
        }
        this._selectedFile = null;
        this._selectedImageMetadata = null;
        this._selectedCharset = null;
        this._lastDirectory = null;
        this._standardEncodingModel = null;
        this._xmlEncodingModel = null;
        this._buttonsPanel = null;
        this._buttonsSeparator = null;
        this._cancelButton = null;
        this._encodingComboBox = null;
        this._encodingLabel = null;
        this._encodingPanel = null;
        this._okButton = null;
        this._updateButton = null;
    }

    File getCurrentDirectory() {
        return this._fileChooser.getCurrentDirectory();
    }

    Charset getSelectedCharset() {
        return this._selectedCharset;
    }

    File getSelectedFile() {
        return this._selectedFile;
    }

    ImageMetadata getSelectedImageMetadata() {
        return this._selectedImageMetadata;
    }

    boolean isXMLFilterSelected() {
        return this._isXMLFilterSelected;
    }

    boolean showOpenDialog(String string, boolean bl, boolean bl2, FileNameExtensionFilter[] fileNameExtensionFilterArray, int n) {
        this._fileChooser.setFileExtensionFilters(fileNameExtensionFilterArray, n);
        if (fileNameExtensionFilterArray == null || n < 0) {
            this.fileFilterChanged(null);
        } else {
            this.fileFilterChanged(fileNameExtensionFilterArray[n]);
        }
        this._fileChooser.setAutoAddExtension(false);
        this._fileChooser.setDialogType(0);
        if (this._layout == 2) {
            this._okButton.setText(_bundle.getString("OK"));
        } else {
            this._okButton.setText(_bundle.getString("OPEN_BUTTON"));
        }
        this.setTitle(_bundle.getString("OPEN_DIALOG_TITLE"));
        this._allowNonexistentFile = false;
        this._isSaving = false;
        this._promptForOverwrite = false;
        return this.showDialog(string, bl, bl2);
    }

    boolean showSaveDialog(String string, boolean bl, boolean bl2, FileNameExtensionFilter[] fileNameExtensionFilterArray, int n) {
        this._fileChooser.setFileExtensionFilters(fileNameExtensionFilterArray, n);
        if (fileNameExtensionFilterArray == null || n < 0) {
            this.fileFilterChanged(null);
        } else {
            this.fileFilterChanged(fileNameExtensionFilterArray[n]);
        }
        this._fileChooser.setAutoAddExtension(true);
        this._fileChooser.setDialogType(1);
        if (this._layout == 2) {
            this._okButton.setText(_bundle.getString("OK"));
        } else {
            this._okButton.setText(_bundle.getString("SAVE_BUTTON"));
        }
        this.setTitle(_bundle.getString("SAVE_DIALOG_TITLE"));
        this._allowNonexistentFile = true;
        this._isSaving = true;
        this._promptForOverwrite = true;
        return this.showDialog(string, bl, bl2);
    }

    private void doFallbackLayout() {
        this._fileChooser.setControlButtonsAreShown(false);
        this._encodingPanel.setVisible(true);
        this._buttonsSeparator.setVisible(false);
        this._buttonsPanel.setVisible(true);
        this._okButton.setText(_bundle.getString("OK"));
        this._encodingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this._encodingPanel.add((Component)this._encodingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this._encodingPanel.add((Component)this._encodingComboBox, gridBagConstraints);
        this._updateButton.setVisible(false);
        this._buttonsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 11, 11, 0);
        this._buttonsPanel.add((Component)this._okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 11, 11, 11);
        this._buttonsPanel.add((Component)this._cancelButton, gridBagConstraints);
    }

    private void doMacLayout() {
        this.doFallbackLayout();
    }

    private void doMotifLayout() {
        this._fileChooser.setControlButtonsAreShown(false);
        this._encodingPanel.setVisible(true);
        this._buttonsSeparator.setVisible(true);
        this._buttonsPanel.setVisible(true);
        this._okButton.setText(_bundle.getString("OK"));
        this._encodingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this._encodingPanel.add((Component)this._encodingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this._encodingPanel.add((Component)this._encodingComboBox, gridBagConstraints);
    }

    private void fileChooserActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().compareTo("ApproveSelection") == 0) {
            if (this.verifyFile(this._fileChooser.getSelectedFile())) {
                this.fileChosen();
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void fileChosen() {
        this._isFileSelected = true;
        this._selectedFile = this._fileChooser.getSelectedFile();
        this._lastDirectory = this._selectedFile.getParentFile();
        if (this._encodingComboBox.getSelectedIndex() == 0) {
            if (this._isXMLFilterSelected) {
                if (this._isSaving) {
                    this._selectedCharset = null;
                } else {
                    try {
                        String string = XMLEncodingFinder.getEncoding(this._selectedFile);
                        if (string == null) {
                            string = ENCODING_FOR_INVALID_XML;
                        }
                        this._selectedCharset = Charset.forName(string);
                    }
                    catch (IOException iOException) {
                        this._selectedCharset = Charset.forName(ENCODING_FOR_INVALID_XML);
                    }
                }
            } else {
                this._selectedCharset = Charset.defaultCharset();
            }
        } else {
            this._selectedCharset = Charset.forName(this._encodingComboBox.getSelectedItem().toString());
        }
        this._selectedImageMetadata = this._isFilePreviewerSet && this._filePreviewer.getFile().compareTo(this._selectedFile) == 0 ? this._filePreviewer.getImageMetadata() : null;
    }

    private void fileFilterChanged(Object object) {
        if (object != null && object instanceof FileNameExtensionFilter) {
            FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)object;
            String[] stringArray = fileNameExtensionFilter.getExtensions();
            if (stringArray[0].equalsIgnoreCase("xml")) {
                this._encodingComboBox.setModel(this._xmlEncodingModel);
                this._encodingComboBox.setEnabled(false);
                this._isXMLFilterSelected = true;
            } else {
                this._encodingComboBox.setModel(this._standardEncodingModel);
                this._encodingComboBox.setEnabled(true);
                this._isXMLFilterSelected = false;
            }
        } else {
            this._encodingComboBox.setModel(this._standardEncodingModel);
            this._encodingComboBox.setEnabled(true);
            this._isXMLFilterSelected = false;
        }
    }

    private void setEncodingVisible(boolean bl) {
        if (this._layout == 1) {
            this._fileChooser.setEncodingVisible(bl);
        } else {
            this._encodingPanel.setVisible(bl);
        }
    }

    private boolean showDialog(String string, boolean bl, boolean bl2) {
        if (this._lastDirectory == null) {
            this._lastDirectory = this._fileChooser.getCurrentDirectory();
        }
        if (string == null || string.isEmpty()) {
            this._fileChooser.setSelectedFile(null, true);
            this._fileChooser.setCurrentDirectory(this._lastDirectory);
        } else {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(this._lastDirectory, string);
            }
            this._fileChooser.setSelectedFile(file, true);
        }
        this._showEncoding = bl;
        this.setEncodingVisible(bl);
        if (this._filePreviewer == null) {
            this._filePreviewer = new FilePreviewer(this._fileChooser, this);
            this._isFilePreviewerSet = false;
        }
        if (bl2 && !this._isFilePreviewerSet) {
            this._fileChooser.setAccessory(this._filePreviewer);
            this._isFilePreviewerSet = true;
        } else if (!bl2 && this._isFilePreviewerSet) {
            this._fileChooser.setAccessory(null);
            this._isFilePreviewerSet = false;
        }
        if (bl2) {
            this._filePreviewer.resetPreview();
        }
        this.pack();
        this._fileChooser.rescanCurrentDirectory();
        this.getRootPane().setDefaultButton((JButton)this._okButton);
        this.setLocationRelativeTo(this.getParent());
        this._isFileSelected = false;
        this.setVisible(true);
        return this._isFileSelected;
    }

    private boolean tryWindowsLayout() {
        if (!this._fileChooser.addEncodingForWindows((Component)this._encodingLabel, this._encodingComboBox)) {
            return false;
        }
        this._fileChooser.setControlButtonsAreShown(true);
        this._encodingPanel.setVisible(false);
        this._buttonsSeparator.setVisible(false);
        this._buttonsPanel.setVisible(false);
        return true;
    }

    private boolean verifyFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            if (this._allowNonexistentFile) {
                File file2 = file.getParentFile();
                try {
                    if (file2 == null || file2.isDirectory()) {
                        return true;
                    }
                    if (file2.mkdirs()) {
                        return true;
                    }
                    SybOptionPane.showMessageDialog((Component)this, (Object)("Unable to create directory '" + file2.getAbsolutePath() + "'."), (String)this.getTitle(), (int)0);
                    return false;
                }
                catch (Exception exception) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)("Error creating new file:\n" + exception.getMessage()), (String)this.getTitle(), (int)0);
                    return false;
                }
            }
            SybOptionPane.showMessageDialog((Component)this, (Object)("The file '" + file.getAbsolutePath() + "' does not exist.\n" + "Please select an existing file."), (String)this.getTitle(), (int)0);
            return false;
        }
        if (file.isDirectory()) {
            SybOptionPane.showMessageDialog((Component)this, (Object)("'" + file.getAbsolutePath() + "' is a directory.\n" + "Please select a file that is not a directory."), (String)this.getTitle(), (int)0);
            return false;
        }
        if (!file.isFile()) {
            SybOptionPane.showMessageDialog((Component)this, (Object)("The file '" + file.getAbsolutePath() + "' is not a normal file.\n" + "Please select a different file."), (String)this.getTitle(), (int)0);
            return false;
        }
        if (this._promptForOverwrite) {
            int n = SybOptionPane.showConfirmDialog((Component)this, (Object)("The file '" + file.getAbsolutePath() + "' already exists.\n" + "Do you want to replace it?"), (String)this.getTitle(), (int)0);
            return n == 0;
        }
        return true;
    }

    private void initComponents() {
        this._encodingLabel = new SybLabel();
        this._encodingComboBox = new JComboBox();
        this._encodingPanel = new JPanel();
        this._buttonsSeparator = new JSeparator();
        this._buttonsPanel = new JPanel();
        this._okButton = new SybButton();
        this._updateButton = new SybButton();
        this._cancelButton = new SybButton();
        this._encodingLabel.setLabelFor((Component)this._encodingComboBox);
        this._encodingLabel.setText(_bundle.getString("FILE_DIALOG_ENCODING_LABEL"));
        this._encodingComboBox.setModel(this._standardEncodingModel);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CustomFileDialog.this.formComponentResized(componentEvent);
            }
        });
        this._encodingPanel.setLayout(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.getContentPane().add((Component)this._encodingPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 10, 0);
        this.getContentPane().add((Component)this._buttonsSeparator, gridBagConstraints);
        this._buttonsPanel.setLayout(new GridBagLayout());
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomFileDialog.this._okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.33;
        this._buttonsPanel.add((Component)this._okButton, gridBagConstraints);
        this._updateButton.setText(_bundle.getString("UPDATE_BUTTON"));
        this._updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomFileDialog.this._updateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.33;
        this._buttonsPanel.add((Component)this._updateButton, gridBagConstraints);
        this._cancelButton.setText(_bundle.getString("CancelButton"));
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomFileDialog.this._cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.33;
        this._buttonsPanel.add((Component)this._cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this._buttonsPanel, gridBagConstraints);
        this.pack();
    }

    private void _updateButtonActionPerformed(ActionEvent actionEvent) {
        this._fileChooser.rescanCurrentDirectory();
    }

    private void _cancelButtonActionPerformed(ActionEvent actionEvent) {
        this._fileChooser.cancelSelection();
    }

    private void _okButtonActionPerformed(ActionEvent actionEvent) {
        FileChooserUI fileChooserUI = this._fileChooser.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)fileChooserUI;
            basicFileChooserUI.getApproveSelectionAction().actionPerformed(actionEvent);
        } else {
            this._fileChooser.approveSelection();
        }
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        if (this.getHeight() < this._minHeight) {
            if (this.getWidth() < this._minWidth) {
                this.setSize(this._minWidth, this._minHeight);
            } else {
                this.setSize(this.getWidth(), this._minHeight);
            }
        } else if (this.getWidth() < this._minWidth) {
            this.setSize(this._minWidth, this.getHeight());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this._showEncoding) {
            return;
        }
        this.fileFilterChanged(propertyChangeEvent.getNewValue());
    }
}

