/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.datechooser.DateChangeEvent;
import com.sybase.datechooser.DateChangeListener;
import com.sybase.datechooser.SybDateChooser;
import com.sybase.resultSetTable.BaseCellEditor;
import com.sybase.resultSetTable.DateCellEditorDialog;
import com.sybase.resultSetTable.DefaultValue;
import com.sybase.util.SybButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DateCellEditor
extends BaseCellEditor {
    private static final String POPUP_COMMAND = "togglePopup";
    private static SimpleDateFormat _isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static TextFieldWithButton _textFieldWithButton = null;
    protected static KeyStroke _buttonKeyStroke = null;

    DateCellEditor() {
    }

    private void discoverButtonKeyStroke() {
        if (_buttonKeyStroke == null) {
            JComboBox jComboBox = new JComboBox();
            InputMap inputMap = jComboBox.getInputMap(1);
            KeyStroke[] keyStrokeArray = inputMap.allKeys();
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                Object object = inputMap.get(keyStrokeArray[i]);
                if (object == null || !object.toString().equals(POPUP_COMMAND)) continue;
                _buttonKeyStroke = keyStrokeArray[i];
                break;
            }
        }
    }

    static KeyStroke getButtonKeyStroke() {
        return _buttonKeyStroke;
    }

    @Override
    protected Component createEditor(JTable jTable, int n) {
        if (_textFieldWithButton == null) {
            this.discoverButtonKeyStroke();
            _textFieldWithButton = new TextFieldWithButton();
            _textFieldWithButton.setBackground(jTable.getBackground());
        }
        return _textFieldWithButton;
    }

    @Override
    protected void setInitialValue(Object object) {
        if (object != null && object instanceof String && object.toString().trim().length() == 0) {
            object = this._showNullItem ? null : Calendar.getInstance().getTime();
        }
        _textFieldWithButton.setValue(object);
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        object = _textFieldWithButton.getValue();
        if (object != null && object.getClass() == java.util.Date.class) {
            object = new Date(((java.util.Date)object).getTime());
        }
        return object;
    }

    static String formatDate(java.util.Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        String string = dateFormat.format(date);
        return string;
    }

    static java.util.Date parseDate(String string) {
        java.util.Date date;
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                date = _isoDateFormatter.parse(string);
            }
            catch (ParseException parseException2) {
                date = null;
            }
        }
        return date;
    }

    class TextFieldWithButton
    extends JPanel
    implements ActionListener,
    DateChangeListener,
    DocumentListener {
        Object _value = null;
        JTextField _dateField = new JTextField();
        JLabel _label;
        JButton _button;
        boolean _popupVisible = false;
        DateCellEditorDialog _dlg = null;
        SybDateChooser _dateChooser;

        TextFieldWithButton() {
            DateCellEditor.this.setEditorBorder(this._dateField);
            this._dateField.getDocument().addDocumentListener(this);
            this._button = new SybButton("...");
            this._button.setFocusable(false);
            this._button.setMargin(new Insets(2, 2, 2, 2));
            this._button.addActionListener(this);
            this._label = new JLabel();
            this.setLayout(new BorderLayout());
            this.add(this._button);
            if (_buttonKeyStroke != null) {
                this.registerKeyboardAction(this, DateCellEditor.POPUP_COMMAND, _buttonKeyStroke, 1);
            }
        }

        void setValue(Object object) {
            assert (object == null || object instanceof java.util.Date || object instanceof DefaultValue || object instanceof String);
            this._dateField.getDocument().removeDocumentListener(this);
            this._value = object;
            Component component = this.getComponent(0);
            if (object == null || object instanceof DefaultValue) {
                if (component != this._label) {
                    this.removeAll();
                    this.add((Component)this._label, "Center");
                    this.add((Component)this._button, "East");
                    this.validate();
                }
                if (object == null) {
                    this._label.setText(DateCellEditor.this._nullDisplayText);
                } else {
                    this._label.setText(DateCellEditor.this._defaultDisplayText);
                }
            } else if (object instanceof String) {
                this._dateField.setText((String)object);
            } else {
                if (component != this._dateField) {
                    this.removeAll();
                    this.add((Component)this._dateField, "Center");
                    this.add((Component)this._button, "East");
                    this.validate();
                }
                if (!(object instanceof java.util.Date)) {
                    throw new IllegalArgumentException("Expected Date value, but got " + object.getClass().getName());
                }
                this._dateField.setText(DateCellEditor.formatDate((java.util.Date)object));
            }
            this.repaint();
            this._dateField.getDocument().addDocumentListener(this);
        }

        Object getValue() {
            return this._value;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this._value = this._dateField.getText();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this._value = this._dateField.getText();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this._value = this._dateField.getText();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DateCellEditor.this._showNullItem && !DateCellEditor.this._showDefaultValueItem) {
                java.util.Date date = this._value instanceof DefaultValue || this._value instanceof String && ((String)this._value).trim().isEmpty() ? Calendar.getInstance().getTime() : (java.util.Date)this._value;
                if (this._dateChooser != null) {
                    this._dateChooser.removeDateChangeListener((DateChangeListener)this);
                }
                this._dateChooser = SybDateChooser.getDialog((Component)this, null, (java.util.Date)date);
                this._dateChooser.addDateChangeListener((DateChangeListener)this);
                this._dateChooser.setVisible(true);
            } else {
                this.togglePopupVisibility();
            }
        }

        public void dateChanged(DateChangeEvent dateChangeEvent) {
            this.setValue(dateChangeEvent.getDate());
        }

        private void togglePopupVisibility() {
            if (this._dlg == null) {
                this._popupVisible = false;
            } else {
                this._popupVisible = this._dlg.isVisible();
                if (!this._popupVisible) {
                    long l = System.currentTimeMillis();
                    long l2 = this._dlg.getDeactivationTime();
                    this._dlg = null;
                    if (l2 != 0L && l - l2 < 250L) {
                        return;
                    }
                }
            }
            boolean bl = this._popupVisible = !this._popupVisible;
            if (this._popupVisible) {
                Rectangle rectangle = this.getBounds();
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, this);
                point.y += rectangle.height;
                Object object = this._value == null || this._value instanceof DefaultValue ? this._value : DateCellEditor.parseDate(this._dateField.getText());
                this._dlg = DateCellEditorDialog.create(this, object, DateCellEditor.this._showNullItem, DateCellEditor.this._showDefaultValueItem, point);
            } else if (this._dlg != null) {
                this._dlg.close();
                this._dlg = null;
            }
        }

        void destroy() {
            if (this._dateChooser != null) {
                this._dateChooser.removeDateChangeListener((DateChangeListener)this);
                this._dateChooser = null;
            }
        }
    }
}

