/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.datechooser.DateChangeEvent;
import com.sybase.datechooser.DateChangeListener;
import com.sybase.datechooser.SybDateChooserPanel;
import com.sybase.resultSetTable.DateCellEditor;
import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DateCellEditorDialog
extends JDialog
implements ActionListener,
DateChangeListener,
DocumentListener,
ItemListener,
WindowListener {
    private static final String ESCAPE_COMMAND = "Esc";
    private static final String ENTER_COMMAND = "Enter";
    private JTextField _dateField = null;
    private SybDateChooserPanel _dateChooser = null;
    private SybRadioButton _date = null;
    private SybRadioButton _null = null;
    private SybRadioButton _default = null;
    private DateCellEditor.TextFieldWithButton _editor = null;
    private long _deactivationTime = 0L;

    static DateCellEditorDialog create(DateCellEditor.TextFieldWithButton textFieldWithButton, Object object, boolean bl, boolean bl2, Point point) {
        DateCellEditorDialog dateCellEditorDialog;
        Container container = SwingUtilities.getAncestorOfClass(Dialog.class, textFieldWithButton);
        if (container != null) {
            dateCellEditorDialog = new DateCellEditorDialog((Dialog)container, textFieldWithButton, object, bl, bl2, point);
        } else {
            container = SwingUtilities.getAncestorOfClass(Frame.class, textFieldWithButton);
            dateCellEditorDialog = new DateCellEditorDialog((Frame)container, textFieldWithButton, object, bl, bl2, point);
        }
        UIUtils.ensureWindowIsVisible((Window)dateCellEditorDialog);
        dateCellEditorDialog.setVisible(true);
        return dateCellEditorDialog;
    }

    private DateCellEditorDialog(Frame frame, DateCellEditor.TextFieldWithButton textFieldWithButton, Object object, boolean bl, boolean bl2, Point point) {
        super(frame);
        this.createUI(object, textFieldWithButton, bl, bl2, point);
    }

    private DateCellEditorDialog(Dialog dialog, DateCellEditor.TextFieldWithButton textFieldWithButton, Object object, boolean bl, boolean bl2, Point point) {
        super(dialog);
        this.createUI(object, textFieldWithButton, bl, bl2, point);
    }

    private void createUI(Object object, DateCellEditor.TextFieldWithButton textFieldWithButton, boolean bl, boolean bl2, Point point) {
        this._editor = textFieldWithButton;
        this.setUndecorated(true);
        JRootPane jRootPane = this.getRootPane();
        Container container = jRootPane.getContentPane();
        this.addWindowListener(this);
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.windowBorder), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._date = new SybRadioButton(resultSetTableResourcesBase.get("DateEditorDate"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._date, gridBagConstraints);
        this._dateField = new JTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._dateField, gridBagConstraints);
        this._dateChooser = new SybDateChooserPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        Insets insets = gridBagConstraints.insets;
        jPanel2.add((Component)this._dateChooser, gridBagConstraints);
        this._null = new SybRadioButton(resultSetTableResourcesBase.get("DateEditorNull"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        if (bl) {
            jPanel2.add((Component)this._null, gridBagConstraints);
        }
        this._default = new SybRadioButton(resultSetTableResourcesBase.get("DateEditorDefault"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        if (bl2) {
            jPanel2.add((Component)this._default, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        this._date.addItemListener((ItemListener)this);
        this._null.addItemListener((ItemListener)this);
        this._default.addItemListener((ItemListener)this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._date);
        buttonGroup.add((AbstractButton)this._null);
        buttonGroup.add((AbstractButton)this._default);
        jPanel.add((Component)jPanel2, "Center");
        if (object == null || object.toString().length() == 0) {
            Date date = Calendar.getInstance().getTime();
            this._dateField.setText(DateCellEditor.formatDate(date));
            this._dateChooser.setSelectedDate(date);
            this._null.setSelected(true);
        } else if (object instanceof DefaultValue) {
            Date date = Calendar.getInstance().getTime();
            this._dateField.setText(DateCellEditor.formatDate(date));
            this._dateChooser.setSelectedDate(date);
            this._default.setSelected(true);
        } else {
            if (!(object instanceof Date)) {
                throw new IllegalArgumentException("Expected Date value, but got " + object.getClass().getName());
            }
            this._dateField.setText(DateCellEditor.formatDate((Date)object));
            this._dateChooser.setSelectedDate((Date)object);
            this._date.setSelected(true);
        }
        if (!bl) {
            this._null.setEnabled(false);
        }
        if (!bl2) {
            this._default.setEnabled(false);
        }
        this._dateChooser.addDateChangeListener((DateChangeListener)this);
        this._dateField.getDocument().addDocumentListener(this);
        jRootPane.registerKeyboardAction(this, ESCAPE_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, ENTER_COMMAND, KeyStroke.getKeyStroke(10, 0), 1);
        KeyStroke keyStroke = DateCellEditor.getButtonKeyStroke();
        if (keyStroke != null) {
            jRootPane.registerKeyboardAction(this, ENTER_COMMAND, keyStroke, 1);
        }
        container.add(jPanel);
        this.pack();
        if (this._null.isSelected()) {
            this._null.requestFocusInWindow();
        } else if (this._default.isSelected()) {
            this._default.requestFocusInWindow();
        } else {
            this._dateField.requestFocusInWindow();
        }
        if (point != null) {
            this.setLocation(point);
        }
    }

    private void destroy() {
        if (this._dateChooser != null) {
            this._dateChooser.destroy();
            this._dateChooser.removeDateChangeListener((DateChangeListener)this);
            this._dateChooser = null;
        }
        if (this._dateField != null) {
            this._dateField.getDocument().removeDocumentListener(this);
            this._dateField = null;
        }
        if (this._date != null) {
            this._date.removeItemListener((ItemListener)this);
            this._date = null;
        }
        if (this._null != null) {
            this._null.removeItemListener((ItemListener)this);
            this._null = null;
        }
        if (this._default != null) {
            this._default.removeItemListener((ItemListener)this);
            this._default = null;
        }
        if (this._editor != null) {
            this._editor.destroy();
            this._editor = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this._date.isSelected();
        this._dateField.setEnabled(bl);
        this._dateChooser.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(ESCAPE_COMMAND)) {
                this.close();
            } else if (string.equals(ENTER_COMMAND)) {
                this.handleOK();
            }
        }
    }

    void close() {
        this.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DateCellEditorDialog.this.destroy();
            }
        });
    }

    private void handleOK() {
        if (!this.isVisible()) {
            return;
        }
        Object object = this._null.isSelected() ? null : (this._default.isSelected() ? new DefaultValue() : DateCellEditor.parseDate(this._dateField.getText()));
        this._editor.setValue(object);
        this.close();
    }

    public void dateChanged(DateChangeEvent dateChangeEvent) {
        this._dateField.setText(DateCellEditor.formatDate(dateChangeEvent.getDate()));
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateDateChooser();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateDateChooser();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateDateChooser();
    }

    private void updateDateChooser() {
        Date date;
        String string = this._dateField.getText().trim();
        if (string != null && string.length() > 0 && (date = DateCellEditor.parseDate(string)) != null) {
            this._dateChooser.removeDateChangeListener((DateChangeListener)this);
            this._dateChooser.setSelectedDate(date);
            this._dateChooser.addDateChangeListener((DateChangeListener)this);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this._deactivationTime = System.currentTimeMillis();
        this.handleOK();
    }

    long getDeactivationTime() {
        return this._deactivationTime;
    }
}

