/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.ResultSetTable;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.resultSetTable.WorkerThread;
import com.sybase.util.Dbg;
import java.awt.EventQueue;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DefaultWorkerThread
extends Thread
implements WorkerThread {
    protected ResultSetTable _resultSetTable = null;
    protected boolean _quit = false;
    protected int _rowsToFetch = 0;
    protected boolean _abort = false;
    protected int _pauseCount = 0;
    protected Object _pauseObject = new Object();
    private boolean _isPaused = false;

    public static WorkerThread create(ResultSetTable resultSetTable) {
        if (resultSetTable == null) {
            throw new IllegalArgumentException("ResultSetTable cannot be null");
        }
        DefaultWorkerThread defaultWorkerThread = new DefaultWorkerThread();
        defaultWorkerThread._resultSetTable = resultSetTable;
        defaultWorkerThread.setName("RST DefaultWorkerThread");
        defaultWorkerThread.start();
        return defaultWorkerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            DefaultWorkerThread defaultWorkerThread;
            block34: {
                boolean bl;
                defaultWorkerThread = this;
                synchronized (defaultWorkerThread) {
                    int n = this._rowsToFetch;
                    if (n == 0) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.allowPause();
                defaultWorkerThread = this;
                synchronized (defaultWorkerThread) {
                    if (this._quit) {
                        break;
                    }
                }
                do {
                    boolean bl2;
                    defaultWorkerThread = this;
                    synchronized (defaultWorkerThread) {
                        if (this._rowsToFetch == 0 || this._quit) {
                            break block34;
                        }
                    }
                    this.allowPause();
                    try {
                        bl2 = this.moveNext();
                    }
                    catch (SQLException sQLException) {
                        bl2 = false;
                        this._resultSetTable.notifyFetcherException(sQLException);
                    }
                    if (!bl2) {
                        defaultWorkerThread = this;
                        synchronized (defaultWorkerThread) {
                            this._rowsToFetch = 0;
                        }
                        this._resultSetTable.notifyEndOfResultSet();
                        break block34;
                    }
                    defaultWorkerThread = this;
                    synchronized (defaultWorkerThread) {
                        if (this._abort) {
                            this._abort = false;
                            break block34;
                        }
                    }
                    this._resultSetTable.readRowData();
                    bl = false;
                    defaultWorkerThread = this;
                    synchronized (defaultWorkerThread) {
                        --this._rowsToFetch;
                        if (this._rowsToFetch <= 0) {
                            this._rowsToFetch = 0;
                            bl = true;
                        }
                    }
                } while (!bl);
                this._resultSetTable.notifyFetcherIdle();
            }
            defaultWorkerThread = this;
            synchronized (defaultWorkerThread) {
                if (this._quit) {
                    break;
                }
            }
        }
        this._resultSetTable = null;
    }

    protected boolean moveNext() throws SQLException {
        ScrollableResultSet scrollableResultSet = this._resultSetTable.getScrollableResultSet();
        boolean bl = scrollableResultSet != null ? scrollableResultSet.next() : false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchRows(int n) {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            if (n > this._rowsToFetch) {
                this._rowsToFetch = n;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchCount() {
        int n;
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            n = this._rowsToFetch;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortFetch() {
        int n;
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            this._abort = true;
            n = this._rowsToFetch;
            this._rowsToFetch = 0;
        }
        if (n != 0) {
            this.interruptFetch();
        }
    }

    protected void interruptFetch() {
        if (this._resultSetTable != null) {
            ResultSet resultSet = this._resultSetTable.getResultSet();
            try {
                final Statement statement = resultSet.getStatement();
                if (statement != null) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                statement.cancel();
                            }
                            catch (SQLException sQLException) {
                                Dbg.printlnEx((Throwable)sQLException, (String)("Could not cancel statement " + Integer.toHexString(statement.hashCode())));
                            }
                        }
                    }.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            this._quit = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pause() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("This method must be called from the AWT thread. It was called from " + Thread.currentThread().getName());
        }
        Object object = this._pauseObject;
        synchronized (object) {
            ++this._pauseCount;
            if (this._pauseCount == 1) {
                DefaultWorkerThread defaultWorkerThread = this;
                synchronized (defaultWorkerThread) {
                    this.notify();
                }
                try {
                    this._pauseObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this._isPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpause() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("This method must be called from the AWT thread. It was called from " + Thread.currentThread().getName());
        }
        Object object = this._pauseObject;
        synchronized (object) {
            if (this._pauseCount != 0) {
                --this._pauseCount;
                if (this._pauseCount == 0) {
                    this._pauseObject.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allowPause() {
        Object object = this._pauseObject;
        synchronized (object) {
            if (this._pauseCount != 0) {
                this._pauseObject.notify();
                try {
                    this._isPaused = true;
                    this._pauseObject.wait();
                    this._isPaused = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean dbgEnabled() {
        return ResultSetTable.dbgEnabled("+WorkerThread") || Dbg.isMessageTypeEnabled((String)this.getClass().getName());
    }
}

