/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.CustomFileDialog;
import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.ImageMetadata;
import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.LongBinaryValuePanel;
import com.sybase.resultSetTable.LongTextValue;
import com.sybase.resultSetTable.LongTextValuePanel;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.RSTFile;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.SelectNewlineFormatDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;

class EditLongValueDialog
extends JDialog {
    private static final int CELL_TYPE_NULL = 0;
    private static final int CELL_TYPE_LITERAL = 1;
    private static final int CELL_TYPE_DEFAULT = 2;
    private static final int CELL_TYPE_FILE = 3;
    private static final int MODE_TEXT = 0;
    private static final int MODE_BINARY = 1;
    private static final int MAX_PATH_FIELD_LENGTH = 400;
    private static ResultSetTableResourcesBase _bundle = null;
    private boolean _allowDefault = false;
    private boolean _allowNull = false;
    private int _cellType = 0;
    private boolean _hasUnsavedChanges = false;
    private boolean _isEditable = false;
    private boolean _isModified = false;
    private LongTextValue _longTextValue = null;
    private int _mode = 0;
    private RSTFile _rstFile = null;
    private NullAwareTable _nat = null;
    private SelectNewlineFormatDialog _newlineDialog;
    private ImageIcon _noPreviewIcon;
    private ImageIcon _imageTooLargeIcon;
    private boolean _ignoreDocumentListenerEvents = true;
    private LongBinaryValuePanel _binaryPanel;
    private SybButton _browseButton;
    private JPanel _buttonPanel;
    private SybButton _cancelButton;
    private ButtonGroup _dataSourceBtnGroup;
    private JPanel _dataSourcePanel;
    private SybRadioButton _defaultRadioBtn;
    private JPanel _fileDetailsPanel;
    private SybLabel _fileDimensionsLabel;
    private SybLabel _fileDimensionsLabel2;
    private SybLabel _fileEncodingLabel;
    private SybLabel _fileEncodingLabel2;
    private JPanel _fileImageDetailsPanel;
    private JPanel _fileImageDetailsPanel2;
    private SybMultiLineLabel _fileImageTooLargeLabel;
    private SybLabel _fileModifiedLabel;
    private SybLabel _fileModifiedLabel2;
    private JPanel _filePanel;
    private JTextField _filePathField;
    private SybLabel _filePreviewLabel;
    private SybRadioButton _fileRadioBtn;
    private SybLabel _fileSizeLabel;
    private SybLabel _fileSizeLabel2;
    private SybLabel _fileTypeLabel;
    private SybLabel _fileTypeLabel2;
    private SybRadioButton _nullRadioBtn;
    private SybButton _okButton;
    private LongTextValuePanel _textPanel;
    private JPanel _valuePanel;
    private SybRadioButton _valueRadioBtn;

    EditLongValueDialog(NullAwareTable nullAwareTable, Window window) {
        super(window, Dialog.ModalityType.DOCUMENT_MODAL);
        this._nat = nullAwareTable;
        if (_bundle == null) {
            _bundle = ResultSetTableResourcesBase.getBundle();
        }
        this.initComponents();
        this.setLocationRelativeTo(window);
        this._newlineDialog = new SelectNewlineFormatDialog((Window)this);
        this._textPanel.addDocumentListenerToText(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!EditLongValueDialog.this._ignoreDocumentListenerEvents && EditLongValueDialog.this._textPanel.isEditable()) {
                    EditLongValueDialog.this.madeChange();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (!EditLongValueDialog.this._ignoreDocumentListenerEvents && EditLongValueDialog.this._textPanel.isEditable()) {
                    EditLongValueDialog.this.madeChange();
                }
            }
        });
        Dimension dimension = new Dimension(96, 72);
        this._filePreviewLabel.setMinimumSize(dimension);
        this._filePreviewLabel.setMaximumSize(dimension);
        this._filePreviewLabel.setPreferredSize(dimension);
        dimension = new Dimension(86, 62);
        this._fileImageTooLargeLabel.setMinimumSize(dimension);
        this._fileImageTooLargeLabel.setMaximumSize(dimension);
        this._fileImageTooLargeLabel.setPreferredSize(dimension);
        this._noPreviewIcon = new ImageIcon(this.getClass().getResource("/com/sybase/util/new32.gif"));
        this._imageTooLargeIcon = new ImageIcon(this.getClass().getResource("/com/sybase/util/new32.gif"));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this.closeWindow(true, false);
            }
        };
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape pressed");
        this.getRootPane().getActionMap().put("escape pressed", abstractAction);
    }

    void destroy() {
        this._longTextValue = null;
        this._rstFile = null;
        this._nat = null;
        if (this._binaryPanel != null) {
            this._binaryPanel.destroy();
            this._binaryPanel = null;
        }
        if (this._textPanel != null) {
            this._textPanel.destroy();
            this._textPanel = null;
        }
        if (this._newlineDialog != null) {
            this._newlineDialog.destroy();
            this._newlineDialog = null;
        }
        this._noPreviewIcon = null;
        this._imageTooLargeIcon = null;
        this._browseButton = null;
        this._buttonPanel = null;
        this._cancelButton = null;
        this._dataSourceBtnGroup = null;
        this._dataSourcePanel = null;
        this._defaultRadioBtn = null;
        this._fileDetailsPanel = null;
        this._fileDimensionsLabel = null;
        this._fileDimensionsLabel2 = null;
        this._fileEncodingLabel = null;
        this._fileEncodingLabel2 = null;
        this._fileImageDetailsPanel = null;
        this._fileImageDetailsPanel2 = null;
        this._fileImageTooLargeLabel = null;
        this._fileModifiedLabel = null;
        this._fileModifiedLabel2 = null;
        this._filePanel = null;
        this._filePathField = null;
        this._filePreviewLabel = null;
        this._fileRadioBtn = null;
        this._fileSizeLabel = null;
        this._fileSizeLabel2 = null;
        this._fileTypeLabel = null;
        this._fileTypeLabel2 = null;
        this._nullRadioBtn = null;
        this._okButton = null;
        this._valuePanel = null;
        this._valueRadioBtn = null;
    }

    Object getModifiedObject() {
        switch (this._cellType) {
            case 0: {
                return null;
            }
            case 1: {
                if (this._mode == 0) {
                    if (this._longTextValue == null) {
                        return this._textPanel.getText();
                    }
                    return this._longTextValue;
                }
                return this._binaryPanel.getData();
            }
            case 2: {
                return new DefaultValue();
            }
            case 3: {
                return this._rstFile;
            }
        }
        return null;
    }

    boolean showBinaryDialog(Object object, String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = SybMessageFormat.format((String)_bundle.getString("COLUMN_VALUE_WINDOW_TITLE"), (Object[])new Object[]{string});
        this.setTitle(string2);
        this._cellType = object == null ? 0 : (object instanceof DefaultValue ? 2 : (object instanceof RSTFile ? 3 : 1));
        this._isModified = false;
        this._isEditable = bl;
        this._allowNull = bl2;
        this._allowDefault = bl3;
        this._longTextValue = null;
        this.setMode(1);
        this.resetBinaryPanel();
        this.resetFilePanel();
        switch (this._cellType) {
            case 1: {
                this._valueRadioBtn.setSelected(true);
                if (object instanceof byte[]) {
                    this._binaryPanel.loadData((byte[])object);
                } else if (object instanceof LongBinaryValue) {
                    this._binaryPanel.loadData((LongBinaryValue)object);
                } else {
                    this._binaryPanel.loadData(new byte[0]);
                }
                this.setBinaryPanelEnabled(true);
                break;
            }
            case 0: {
                this._nullRadioBtn.setSelected(true);
                break;
            }
            case 2: {
                this._defaultRadioBtn.setSelected(true);
                break;
            }
            case 3: {
                this._fileRadioBtn.setSelected(true);
                this._rstFile = new RSTFile((RSTFile)object);
                this._filePathField.setText(this._rstFile.getAbsolutePath());
                this.showFileDetails(this._rstFile);
                this.setFilePanelEnabled(true);
                break;
            }
            default: {
                return false;
            }
        }
        this._valueRadioBtn.setEnabled(bl & this._cellType == 1);
        this._nullRadioBtn.setEnabled(bl);
        this._defaultRadioBtn.setEnabled(bl);
        this._fileRadioBtn.setEnabled(bl);
        if (!bl) {
            this.setFilePanelEnabled(false);
        }
        this._nullRadioBtn.setVisible(bl2);
        this._defaultRadioBtn.setVisible(bl3);
        this.validate();
        this._hasUnsavedChanges = false;
        this._okButton.setEnabled(false);
        this.getRootPane().setDefaultButton((JButton)this._okButton);
        if (this._filePathField.getWidth() > 400) {
            this._filePathField.setPreferredSize(new Dimension(400, this._filePathField.getHeight()));
        }
        this.pack();
        UIUtils.ensureWindowIsVisible((Window)this);
        this.setMinimumSize(this.getPreferredSize());
        this._ignoreDocumentListenerEvents = false;
        this.setVisible(true);
        this._ignoreDocumentListenerEvents = true;
        return this._isModified;
    }

    boolean showTextDialog(Object object, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string2 = SybMessageFormat.format((String)_bundle.getString("COLUMN_VALUE_WINDOW_TITLE"), (Object[])new Object[]{string});
        this.setTitle(string2);
        this._cellType = object == null ? 0 : (object instanceof DefaultValue ? 2 : (object instanceof RSTFile ? 3 : 1));
        this._isModified = false;
        this._isEditable = bl;
        this._allowNull = bl2;
        this._allowDefault = bl3;
        this._longTextValue = null;
        this._textPanel.setIsXMLColumn(bl4);
        this.setMode(0);
        this.resetTextPanel();
        this.resetFilePanel();
        switch (this._cellType) {
            case 1: {
                this._valueRadioBtn.setSelected(true);
                boolean bl5 = false;
                if (object instanceof LongTextValue) {
                    this._longTextValue = (LongTextValue)object;
                    this._textPanel.loadText(this._longTextValue, bl);
                } else {
                    this._textPanel.loadText(object.toString(), bl);
                }
                this.setTextPanelEnabled(true);
                break;
            }
            case 0: {
                this._nullRadioBtn.setSelected(true);
                break;
            }
            case 2: {
                this._defaultRadioBtn.setSelected(true);
                break;
            }
            case 3: {
                this._fileRadioBtn.setSelected(true);
                this._rstFile = new RSTFile((RSTFile)object);
                this._filePathField.setText(this._rstFile.getAbsolutePath());
                this.showFileDetails(this._rstFile);
                this.setFilePanelEnabled(true);
                break;
            }
            default: {
                return false;
            }
        }
        this._valueRadioBtn.setEnabled(bl);
        this._nullRadioBtn.setEnabled(bl);
        this._defaultRadioBtn.setEnabled(bl);
        this._fileRadioBtn.setEnabled(bl);
        if (!bl) {
            this.setFilePanelEnabled(false);
        }
        this._nullRadioBtn.setVisible(bl2);
        this._defaultRadioBtn.setVisible(bl3);
        this._hasUnsavedChanges = false;
        this._okButton.setEnabled(false);
        this.getRootPane().setDefaultButton((JButton)this._okButton);
        if (this._filePathField.getWidth() > 400) {
            this._filePathField.setPreferredSize(new Dimension(400, this._filePathField.getHeight()));
        }
        this.pack();
        UIUtils.ensureWindowIsVisible((Window)this);
        this.setMinimumSize(this.getPreferredSize());
        this._ignoreDocumentListenerEvents = false;
        this.setVisible(true);
        this._ignoreDocumentListenerEvents = true;
        return this._isModified;
    }

    private void setMode(int n) {
        this._mode = n;
        boolean bl = n == 0;
        this._textPanel.setVisible(bl);
        this._fileEncodingLabel.setVisible(bl);
        this._fileEncodingLabel2.setVisible(bl);
        bl = n == 1;
        this._binaryPanel.setVisible(bl);
        this._filePreviewLabel.setVisible(bl);
        this._fileImageTooLargeLabel.setVisible(bl);
        this._fileTypeLabel.setVisible(bl);
        this._fileTypeLabel2.setVisible(bl);
        this._fileDimensionsLabel.setVisible(bl);
        this._fileDimensionsLabel2.setVisible(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeWindow(boolean bl, boolean bl2) {
        boolean bl3;
        if (bl) {
            if (this._hasUnsavedChanges) {
                int n = SybOptionPane.showConfirmDialog((Component)this, (Object)_bundle.getString("SAVE_CHANGES_PROMPT"), (String)this.getTitle(), (int)1);
                if (n == 0) {
                    bl3 = true;
                } else {
                    if (n != 1) return;
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
        } else {
            bl3 = bl2;
        }
        if (bl3 && this.verifyChanges()) {
            this.saveChanges();
            if (this._hasUnsavedChanges) {
                this._isModified = true;
            }
        }
        this.setVisible(false);
    }

    private void filePathModified() {
        String string = this._filePathField.getText();
        if (string.length() == 0) {
            this._rstFile = null;
            this.showFileDetails(null);
        } else if (this._rstFile == null || this._rstFile.compareTo(new File(string)) != 0) {
            if (this._mode == 0) {
                this._rstFile = RSTFile.createTextFile(string);
            } else {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this._rstFile = RSTFile.createBinaryFile(string);
                this.setCursor(null);
            }
            this.showFileDetails(this._rstFile);
        }
    }

    private void madeChange() {
        this._hasUnsavedChanges = true;
        this._okButton.setEnabled(true);
    }

    private void resetBinaryPanel() {
        this._binaryPanel.resetData();
        this.setBinaryPanelEnabled(false);
    }

    private void resetFilePanel() {
        this._rstFile = null;
        this._filePathField.setText("");
        this.showFileDetails(null);
        this.setFilePanelEnabled(false);
    }

    private void resetTextPanel() {
        this._textPanel.resetText();
        this.setTextPanelEnabled(false);
    }

    private void saveChanges() {
        if (this._mode == 0) {
            switch (this._cellType) {
                case 1: {
                    if (!this._textPanel.isEditable()) break;
                    if (!this._textPanel.showNewlineFormatDialog(this._newlineDialog)) {
                        return;
                    }
                    String string = this._textPanel.getText();
                    if (this._longTextValue == null || this._longTextValue.equals(string)) break;
                    this._longTextValue = new LongTextValue(string, this._longTextValue.getTruncationLength(), this._nat, true);
                    this._isModified = true;
                    break;
                }
                case 3: {
                    if (!this._newlineDialog.showFileDialog()) break;
                    if (this._rstFile == null) {
                        return;
                    }
                    if (this._newlineDialog.isPreserveSelected()) {
                        this._rstFile.setLineSeparator(null);
                    } else {
                        this._rstFile.setLineSeparator(this._newlineDialog.getSelectedLineSeparator());
                    }
                    this._isModified = true;
                }
            }
        }
    }

    private void setBinaryPanelEnabled(boolean bl) {
        this._binaryPanel.setAllEnabled(bl);
    }

    private void setFilePanelEnabled(boolean bl) {
        this._filePanel.setEnabled(bl);
        this._filePathField.setEnabled(bl);
        this._browseButton.setEnabled(bl);
        this._fileSizeLabel.setEnabled(bl);
        this._fileSizeLabel2.setEnabled(bl);
        this._fileModifiedLabel.setEnabled(bl);
        this._fileModifiedLabel2.setEnabled(bl);
        this._fileEncodingLabel.setEnabled(bl);
        this._fileEncodingLabel2.setEnabled(bl);
        this._fileImageTooLargeLabel.setEnabled(bl);
        this._fileTypeLabel.setEnabled(bl);
        this._fileTypeLabel2.setEnabled(bl);
        this._fileDimensionsLabel.setEnabled(bl);
        this._fileDimensionsLabel2.setEnabled(bl);
    }

    private void setTextPanelEnabled(boolean bl) {
        this._textPanel.setEnabled(bl);
        this._textPanel.setAllEnabled(bl);
    }

    private void setValuePanelEnabled(boolean bl) {
        if (this._mode == 0) {
            this.setTextPanelEnabled(bl);
        } else {
            this.setBinaryPanelEnabled(bl);
        }
    }

    private void showFileDetails(RSTFile rSTFile) {
        if (rSTFile == null || !rSTFile.isFile()) {
            this._fileSizeLabel2.setText("");
            this._fileModifiedLabel2.setText("");
            if (this._mode == 0) {
                this._fileEncodingLabel2.setText("");
            } else {
                this._filePreviewLabel.setIcon(null);
                this._fileImageTooLargeLabel.setText("");
                this._fileImageDetailsPanel.setVisible(false);
                this._fileImageDetailsPanel2.setVisible(false);
            }
        } else {
            this._fileSizeLabel2.setText(rSTFile.getFormattedLength());
            Date date = new Date(rSTFile.lastModified());
            this._fileModifiedLabel2.setText(date.toString());
            if (this._mode == 0) {
                this._fileEncodingLabel2.setText(rSTFile.getCharset().displayName());
            } else if (rSTFile.isImage()) {
                this._fileImageDetailsPanel.setVisible(true);
                this._fileImageDetailsPanel2.setVisible(true);
                ImageMetadata imageMetadata = rSTFile.getImageMetadata();
                this._fileTypeLabel2.setText(imageMetadata._formatName);
                this._fileDimensionsLabel2.setText(imageMetadata._width + " x " + imageMetadata._height);
                if (imageMetadata._isTooLarge) {
                    this._filePreviewLabel.setIcon(null);
                    this._fileImageTooLargeLabel.setText(_bundle.getString("IMAGE_TOO_BIG_MESSAGE"));
                } else {
                    this._filePreviewLabel.setIcon((Icon)imageMetadata._preview);
                    this._fileImageTooLargeLabel.setText("");
                }
            } else {
                this._fileImageDetailsPanel.setVisible(false);
                this._fileImageDetailsPanel2.setVisible(false);
                this._filePreviewLabel.setIcon((Icon)this._noPreviewIcon);
                this._fileImageTooLargeLabel.setText("");
            }
        }
    }

    private boolean verifyChanges() {
        switch (this._cellType) {
            case 3: {
                if (this._rstFile == null) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)_bundle.getString("FILE_NOT_ENTERED"), (String)this.getTitle(), (int)0);
                    this._filePathField.grabFocus();
                    return false;
                }
                if (!this._rstFile.exists()) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)SybMessageFormat.format((String)_bundle.get("FILE_DOES_NOT_EXIST"), (Object[])new Object[]{this._rstFile.getAbsolutePath()}), (String)this.getTitle(), (int)0);
                    this._filePathField.grabFocus();
                    return false;
                }
                if (this._rstFile.isDirectory()) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)SybMessageFormat.format((String)_bundle.get("FILE_DOES_NOT_EXIST"), (Object[])new Object[]{this._rstFile.getAbsolutePath()}), (String)this.getTitle(), (int)0);
                    this._filePathField.grabFocus();
                    return false;
                }
                if (!this._rstFile.isFile()) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)SybMessageFormat.format((String)_bundle.get("FILE_DOES_NOT_EXIST"), (Object[])new Object[]{this._rstFile.getAbsolutePath()}), (String)this.getTitle(), (int)0);
                    this._filePathField.grabFocus();
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private void initComponents() {
        this._dataSourceBtnGroup = new ButtonGroup();
        this._dataSourcePanel = new JPanel();
        this._valueRadioBtn = new SybRadioButton();
        this._nullRadioBtn = new SybRadioButton();
        this._defaultRadioBtn = new SybRadioButton();
        this._fileRadioBtn = new SybRadioButton();
        this._valuePanel = new JPanel();
        this._textPanel = new LongTextValuePanel(this._nat, this);
        this._binaryPanel = new LongBinaryValuePanel(this._nat, this);
        this._filePanel = new JPanel();
        this._filePathField = new JTextField();
        this._browseButton = new SybButton();
        this._fileDetailsPanel = new JPanel();
        this._fileSizeLabel = new SybLabel();
        this._fileSizeLabel2 = new SybLabel();
        this._fileModifiedLabel = new SybLabel();
        this._fileModifiedLabel2 = new SybLabel();
        this._fileEncodingLabel = new SybLabel();
        this._fileEncodingLabel2 = new SybLabel();
        this._filePreviewLabel = new SybLabel();
        this._fileImageTooLargeLabel = new SybMultiLineLabel();
        this._fileImageDetailsPanel = new JPanel();
        this._fileTypeLabel = new SybLabel();
        this._fileDimensionsLabel = new SybLabel();
        this._fileImageDetailsPanel2 = new JPanel();
        this._fileTypeLabel2 = new SybLabel();
        this._fileDimensionsLabel2 = new SybLabel();
        this._buttonPanel = new JPanel();
        this._okButton = new SybButton();
        this._cancelButton = new SybButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EditLongValueDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                EditLongValueDialog.this.formComponentResized(componentEvent);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                EditLongValueDialog.this.formComponentShown(componentEvent);
            }
        });
        this._dataSourcePanel.setLayout(new GridBagLayout());
        this._valueRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._dataSourceBtnGroup.add((AbstractButton)this._valueRadioBtn);
        this._valueRadioBtn.setText(_bundle.getString("VALUE_RADIO_BUTTON"));
        this._valueRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        this._valueRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this._valueRadioBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this._dataSourcePanel.add((Component)this._valueRadioBtn, gridBagConstraints);
        this._nullRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._dataSourceBtnGroup.add((AbstractButton)this._nullRadioBtn);
        this._nullRadioBtn.setText(_bundle.getString("NULL_RADIO_BUTTON"));
        this._nullRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        this._nullRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this._nullRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._dataSourcePanel.add((Component)this._nullRadioBtn, gridBagConstraints);
        this._defaultRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._dataSourceBtnGroup.add((AbstractButton)this._defaultRadioBtn);
        this._defaultRadioBtn.setText(_bundle.getString("DEFAULT_RADIO_BUTTON"));
        this._defaultRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        this._defaultRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this._defaultRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._dataSourcePanel.add((Component)this._defaultRadioBtn, gridBagConstraints);
        this._fileRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._dataSourceBtnGroup.add((AbstractButton)this._fileRadioBtn);
        this._fileRadioBtn.setText(_bundle.getString("LOAD_FILE_RADIO_BUTTON"));
        this._fileRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        this._fileRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this._fileRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._dataSourcePanel.add((Component)this._fileRadioBtn, gridBagConstraints);
        this._valuePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._valuePanel.add((Component)this._textPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._valuePanel.add((Component)this._binaryPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        this._dataSourcePanel.add((Component)this._valuePanel, gridBagConstraints);
        this._filePanel.setLayout(new GridBagLayout());
        this._filePathField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                EditLongValueDialog.this._filePathFieldFocusLost(focusEvent);
            }
        });
        this._filePathField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                EditLongValueDialog.this._filePathFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._filePanel.add((Component)this._filePathField, gridBagConstraints);
        this._browseButton.setText(_bundle.getString("BROWSE_BUTTON"));
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._filePanel.add((Component)this._browseButton, gridBagConstraints);
        this._fileDetailsPanel.setLayout(new GridBagLayout());
        this._fileSizeLabel.setLabelFor((Component)this._fileSizeLabel2);
        this._fileSizeLabel.setText(_bundle.getString("SIZE_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this._fileDetailsPanel.add((Component)this._fileSizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._fileDetailsPanel.add((Component)this._fileSizeLabel2, gridBagConstraints);
        this._fileModifiedLabel.setLabelFor((Component)this._fileModifiedLabel2);
        this._fileModifiedLabel.setText(_bundle.getString("DATE_MODIFIED_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this._fileDetailsPanel.add((Component)this._fileModifiedLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._fileDetailsPanel.add((Component)this._fileModifiedLabel2, gridBagConstraints);
        this._fileEncodingLabel.setText(_bundle.getString("ENCODING_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this._fileDetailsPanel.add((Component)this._fileEncodingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._fileDetailsPanel.add((Component)this._fileEncodingLabel2, gridBagConstraints);
        this._filePreviewLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this._filePreviewLabel.setHorizontalAlignment(0);
        this._filePreviewLabel.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this._fileDetailsPanel.add((Component)this._filePreviewLabel, gridBagConstraints);
        this._fileImageTooLargeLabel.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this._fileDetailsPanel.add((Component)this._fileImageTooLargeLabel, gridBagConstraints);
        this._fileImageDetailsPanel.setLayout(new GridBagLayout());
        this._fileTypeLabel.setText(_bundle.getString("IMAGE_TYPE_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this._fileImageDetailsPanel.add((Component)this._fileTypeLabel, gridBagConstraints);
        this._fileDimensionsLabel.setText(_bundle.getString("IMAGE_DIMENSIONS_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this._fileImageDetailsPanel.add((Component)this._fileDimensionsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        this._fileDetailsPanel.add((Component)this._fileImageDetailsPanel, gridBagConstraints);
        this._fileImageDetailsPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._fileImageDetailsPanel2.add((Component)this._fileTypeLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._fileImageDetailsPanel2.add((Component)this._fileDimensionsLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        this._fileDetailsPanel.add((Component)this._fileImageDetailsPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._filePanel.add((Component)this._fileDetailsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        this._dataSourcePanel.add((Component)this._filePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this._dataSourcePanel, gridBagConstraints);
        this._buttonPanel.setLayout(new GridBagLayout());
        this._okButton.setText(_bundle.getString("OK"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this._buttonPanel.add((Component)this._okButton, gridBagConstraints);
        this._cancelButton.setText(_bundle.getString("CancelButton"));
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditLongValueDialog.this._cancelButtonActionPerformed(actionEvent);
            }
        });
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._okButton, this._cancelButton});
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._buttonPanel.add((Component)this._cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)this._buttonPanel, gridBagConstraints);
    }

    private void _filePathFieldKeyReleased(KeyEvent keyEvent) {
        this.filePathModified();
        this.madeChange();
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        if (this._cellType == 1) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this._ignoreDocumentListenerEvents = true;
            if (this._mode == 0) {
                this._textPanel.showText();
            } else {
                this._binaryPanel.showData();
            }
            this._ignoreDocumentListenerEvents = false;
            this.setCursor(null);
        }
    }

    private void _filePathFieldFocusLost(FocusEvent focusEvent) {
        this.filePathModified();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        FileNameExtensionFilter[] fileNameExtensionFilterArray;
        boolean bl;
        String string = this._filePathField.getText();
        boolean bl2 = this._mode == 0;
        boolean bl3 = bl = this._mode == 1;
        if (this._mode == 0) {
            fileNameExtensionFilterArray = this._textPanel.getFileFilters();
            n = this._textPanel.getFileFilterIndex();
        } else {
            fileNameExtensionFilterArray = this._binaryPanel.getFileFilters();
            n = this._binaryPanel.getFileFilterIndex();
        }
        CustomFileDialog customFileDialog = new CustomFileDialog((Window)this);
        if (customFileDialog.showOpenDialog(string, bl2, bl, fileNameExtensionFilterArray, n)) {
            String string2 = customFileDialog.getSelectedFile().getPath();
            this._filePathField.setText(string2);
            if (this._mode == 0) {
                Charset charset = customFileDialog.getSelectedCharset();
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                this._rstFile = RSTFile.createTextFile(string2, charset);
            } else {
                ImageMetadata imageMetadata = customFileDialog.getSelectedImageMetadata();
                if (imageMetadata == null) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this._rstFile = RSTFile.createBinaryFile(string2);
                    this.setCursor(null);
                } else {
                    this._rstFile = RSTFile.createBinaryFile(string2, imageMetadata);
                }
            }
            this.showFileDetails(this._rstFile);
            this.madeChange();
        }
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        if (this._mode == 1) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this._binaryPanel.resizePreview();
            this.setCursor(null);
        }
    }

    private void _fileRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.setValuePanelEnabled(false);
        this.setFilePanelEnabled(true);
        this._cellType = 3;
        this.madeChange();
    }

    private void _valueRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.setValuePanelEnabled(true);
        this.setFilePanelEnabled(false);
        this._cellType = 1;
        this.madeChange();
    }

    private void _defaultRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.setValuePanelEnabled(false);
        this.setFilePanelEnabled(false);
        this._cellType = 2;
        this.madeChange();
    }

    private void _nullRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.setValuePanelEnabled(false);
        this.setFilePanelEnabled(false);
        this._cellType = 0;
        this.madeChange();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.closeWindow(true, false);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this._okButton.setEnabled(false);
        this.closeWindow(false, true);
        this._okButton.setEnabled(true);
    }

    private void _cancelButtonActionPerformed(ActionEvent actionEvent) {
        this._cancelButton.setEnabled(false);
        this.closeWindow(false, false);
        this._cancelButton.setEnabled(true);
    }
}

