/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.ImageMetadata;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.util.SybMultiLineLabel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FilePreviewer
extends JPanel
implements PropertyChangeListener {
    private static final int MAX_CACHE_SIZE = 99;
    private static String _imageTooBigMessage = null;
    private File _file;
    private HashMap<String, ImageMetadata> _imageCache;
    private ImageMetadata _metadata = null;
    private JDialog _parentDialog;
    private SybMultiLineLabel _imageTooLargeLabel;
    private JLabel _previewLabel;

    FilePreviewer(JFileChooser jFileChooser, JDialog jDialog) {
        if (_imageTooBigMessage == null) {
            _imageTooBigMessage = ResultSetTableResourcesBase.getBundle().getString("IMAGE_TOO_BIG_MESSAGE");
        }
        this._imageCache = new HashMap();
        this.initComponents();
        Dimension dimension = new Dimension(96, 72);
        this._previewLabel.setMinimumSize(dimension);
        this._previewLabel.setMaximumSize(dimension);
        this._previewLabel.setPreferredSize(dimension);
        this._imageTooLargeLabel.setMinimumSize(dimension);
        this._imageTooLargeLabel.setMaximumSize(dimension);
        this._imageTooLargeLabel.setPreferredSize(dimension);
        this.validate();
        jFileChooser.addPropertyChangeListener(this);
        this._parentDialog = jDialog;
    }

    void destroy() {
        if (this._imageCache != null) {
            this._imageCache.clear();
            this._imageCache = null;
        }
        this._file = null;
        this._metadata = null;
        this._parentDialog = null;
        this._imageTooLargeLabel = null;
        this._previewLabel = null;
    }

    File getFile() {
        return this._file;
    }

    ImageMetadata getImageMetadata() {
        return this._metadata;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "SelectedFileChangedProperty" && this.isShowing()) {
            if (propertyChangeEvent.getNewValue() == null || !(propertyChangeEvent.getNewValue() instanceof File)) {
                this.resetPreview();
            } else {
                this._imageTooLargeLabel.setText("");
                this._parentDialog.setCursor(Cursor.getPredefinedCursor(3));
                this._file = (File)propertyChangeEvent.getNewValue();
                String string2 = this._file.getAbsolutePath();
                if (this._imageCache.containsKey(string2)) {
                    this._metadata = this._imageCache.get(string2);
                } else {
                    this._metadata = ImageMetadata.createMetadata(this._file);
                    if (this._imageCache.size() > 99) {
                        this._imageCache.clear();
                    }
                    this._imageCache.put(string2, this._metadata);
                }
                if (this._metadata == null) {
                    this._previewLabel.setIcon(null);
                } else if (this._metadata._isTooLarge) {
                    this._imageTooLargeLabel.setText(_imageTooBigMessage);
                    this._previewLabel.setIcon(null);
                } else {
                    this._previewLabel.setIcon(this._metadata._preview);
                }
                this._parentDialog.setCursor(null);
            }
        }
    }

    void resetPreview() {
        this._file = null;
        this._metadata = null;
        this._imageTooLargeLabel.setText("");
        this._previewLabel.setIcon(null);
    }

    private void initComponents() {
        this._previewLabel = new JLabel();
        this._imageTooLargeLabel = new SybMultiLineLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
        this._previewLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._previewLabel, gridBagConstraints);
        this._imageTooLargeLabel.setHorizontalAlignment(0);
        this._imageTooLargeLabel.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._imageTooLargeLabel, gridBagConstraints);
    }
}

