/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.InputStreamBlob;
import com.sybase.resultSetTable.ResultSetTable;
import com.sybase.resultSetTable.ResultSetTableClient;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.util.Dbg;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import javax.swing.JFrame;

public class GenericResultSetTableClient
implements ResultSetTableClient,
ResultSetTableClient.UI {
    protected static int _savepointSerial = 1;
    protected static ResultSetTableResourcesBase _bundle = null;
    protected Connection _connection;
    protected JFrame _parent;
    protected boolean _supportsSavepoints;
    private ResultSetTableClient.UI _ui;

    public GenericResultSetTableClient(Connection connection, JFrame jFrame) {
        this._connection = connection;
        this._parent = jFrame;
        if (_bundle == null) {
            _bundle = ResultSetTableResourcesBase.getBundle();
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this._supportsSavepoints = databaseMetaData.supportsSavepoints();
        }
        catch (SQLException sQLException) {
            this._supportsSavepoints = false;
        }
        this._ui = this;
    }

    @Override
    public void setUI(ResultSetTableClient.UI uI) {
        this._ui = uI;
    }

    @Override
    public ResultSetTableClient.UI getUI() {
        return this._ui;
    }

    protected Object turnOffBlocking() {
        return null;
    }

    protected void restoreBlocking(Object object) {
    }

    protected void prepareToCommit() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetTableClient.NextAction executeSQL(ResultSetTable resultSetTable, ResultSetTableClient.Operation operation, String string, Object[] objectArray, int[] nArray) {
        Statement statement = null;
        SQLException sQLException = null;
        Savepoint savepoint = null;
        ResultSetTableClient.NextAction nextAction = ResultSetTableClient.NextAction.COMPLETE;
        Object object = this.turnOffBlocking();
        try {
            if (this._supportsSavepoints) {
                try {
                    savepoint = this._connection.setSavepoint("RST" + _savepointSerial);
                }
                catch (SQLException sQLException2) {
                    this._supportsSavepoints = false;
                }
            }
            try {
                int n;
                statement = this._connection.prepareStatement(string, 1003, 1007);
                if (nArray != null) {
                    this.setParameters((PreparedStatement)statement, objectArray, nArray);
                }
                try {
                    n = statement.executeUpdate();
                }
                catch (SQLException sQLException3) {
                    if (savepoint != null && sQLException3.getErrorCode() == -134) {
                        this._connection.releaseSavepoint(savepoint);
                        savepoint = null;
                        if (nArray != null) {
                            this.setParameters((PreparedStatement)statement, objectArray, nArray);
                        }
                        n = statement.executeUpdate();
                    }
                    throw sQLException3;
                }
                if (n == 0) {
                    this._ui.warnNoRowsAffected(operation);
                } else if (n > 1 && (nextAction = this._ui.warnMultipleRowsAffected(operation, n)) == ResultSetTableClient.NextAction.CANCEL) {
                    if (savepoint != null) {
                        this._connection.rollback(savepoint);
                    }
                    ResultSetTableClient.NextAction nextAction2 = nextAction;
                    return nextAction2;
                }
            }
            catch (SQLException sQLException4) {
                sQLException = sQLException4;
            }
            try {
                this.prepareToCommit();
                if (savepoint != null) {
                    this._connection.releaseSavepoint(savepoint);
                }
            }
            catch (SQLException sQLException5) {
                if (sQLException5.getErrorCode() != -220) {
                    sQLException = sQLException5;
                    if (savepoint != null) {
                        this._connection.rollback(savepoint);
                    }
                }
            }
        }
        catch (SQLException sQLException6) {
            nextAction = this._ui.handleSQLException(operation, sQLException6);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException sQLException7) {}
            }
            if (object != null) {
                this.restoreBlocking(object);
            }
            ++_savepointSerial;
            if (sQLException != null) {
                nextAction = this._ui.handleSQLException(operation, sQLException);
            }
        }
        return nextAction;
    }

    private void setParameters(PreparedStatement preparedStatement, Object[] objectArray, int[] nArray) throws SQLException {
        block10: for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                preparedStatement.setNull(i + 1, nArray[i]);
                continue;
            }
            switch (nArray[i]) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    Reader reader = (Reader)objectArray[i];
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        int n;
                        while ((n = reader.read()) != -1) {
                            stringBuilder.append((char)n);
                        }
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getLocalizedMessage());
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        stringBuilder.setLength(0);
                        stringBuilder = null;
                        throw new SQLException(outOfMemoryError.getLocalizedMessage());
                    }
                    preparedStatement.setString(i + 1, stringBuilder.toString());
                    stringBuilder = null;
                    continue block10;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    InputStreamBlob inputStreamBlob = new InputStreamBlob((InputStream)objectArray[i]);
                    preparedStatement.setBlob(i + 1, inputStreamBlob);
                    continue block10;
                }
                case 91: {
                    Date date;
                    if (objectArray[i] instanceof Date) {
                        date = (Date)objectArray[i];
                    } else if (objectArray[i] instanceof java.util.Date) {
                        date = new Date(((java.util.Date)objectArray[i]).getTime());
                    } else {
                        throw new IllegalArgumentException("Unexpected time type " + objectArray[i].getClass().getName());
                    }
                    preparedStatement.setDate(i + 1, date);
                    continue block10;
                }
                case 92: {
                    preparedStatement.setTime(i + 1, (Time)objectArray[i]);
                    continue block10;
                }
                case 93: {
                    preparedStatement.setTimestamp(i + 1, (Timestamp)objectArray[i]);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected data type " + nArray[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] executeRefetchSQL(ResultSetTable resultSetTable, ResultSetTableClient.Operation operation, String string) {
        Object[] objectArray;
        block18: {
            Statement statement = null;
            ResultSet resultSet = null;
            objectArray = null;
            ScrollableResultSet scrollableResultSet = resultSetTable.getScrollableResultSet();
            if (scrollableResultSet == null) {
                return null;
            }
            Object object = this.turnOffBlocking();
            try {
                statement = this._connection.createStatement(1003, 1007);
                resultSet = statement.executeQuery(string);
                if (!resultSet.next()) break block18;
                if (operation == ResultSetTableClient.Operation.REFETCH_AFTER_INSERT || operation == ResultSetTableClient.Operation.REFETCH_AFTER_UPDATE) {
                    objectArray = scrollableResultSet.readRowDataForRefetch(resultSet);
                    if (resultSet.next()) {
                        objectArray = null;
                        this._ui.handleSQLException(operation, null);
                    }
                    break block18;
                }
                if (operation == ResultSetTableClient.Operation.REFETCH_LONG_VALUE) {
                    try {
                        objectArray = new Object[]{this.readColumnValueForRefetch(resultSet)};
                    }
                    catch (SQLException sQLException) {
                        this._ui.handleSQLException(operation, sQLException);
                    }
                    break block18;
                }
                throw new IllegalArgumentException(operation.toString());
            }
            catch (SQLException sQLException) {
                this._ui.handleSQLException(operation, sQLException);
            }
            finally {
                if (operation != ResultSetTableClient.Operation.REFETCH_LONG_VALUE && statement != null) {
                    try {
                        statement.close();
                        statement = null;
                        resultSet = null;
                    }
                    catch (SQLException sQLException) {}
                }
                this.restoreBlocking(object);
            }
        }
        return objectArray;
    }

    private Object readColumnValueForRefetch(ResultSet resultSet) throws SQLException {
        Closeable closeable;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnType(1);
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                try {
                    closeable = resultSet.getClob(1).getCharacterStream();
                }
                catch (Exception exception) {
                    closeable = resultSet.getCharacterStream(1);
                }
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                closeable = resultSet.getBinaryStream(1);
                break;
            }
            default: {
                closeable = null;
            }
        }
        return closeable;
    }

    @Override
    public void executeCallback(ResultSetTable resultSetTable, Runnable runnable) {
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTableEditable(String string, String string2, String string3) {
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            String string4;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            resultSet = databaseMetaData.getTables(null, string2, string3, null);
            if (resultSet.next() && !(string4 = resultSet.getString(4).toLowerCase()).equals("materialized view")) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
        return bl;
    }

    public void destroy() {
        this._connection = null;
        this._parent = null;
    }

    @Override
    public ResultSetTableClient.NextAction handleSQLException(ResultSetTableClient.Operation operation, SQLException sQLException) {
        return GenericResultSetTableClient.handleSQLException(this._parent, operation, sQLException);
    }

    protected static String getOperationDescription(ResultSetTableClient.Operation operation) {
        String string;
        switch (operation) {
            case INSERT: {
                string = _bundle.get("INSERT_ROW_TITLE");
                break;
            }
            case UPDATE: {
                string = _bundle.get("UPDATE_ROW_TITLE");
                break;
            }
            case MULTIPLE_DELETE: 
            case DELETE: {
                string = _bundle.get("DELETE_ROW_TITLE");
                break;
            }
            case REFETCH_LONG_VALUE: {
                string = _bundle.get("REFETCH_LONG_VALUE_TITLE");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void warnNoRowsAffected(ResultSetTableClient.Operation operation) {
        SybOptionPane.showMessageDialog((Component)this._parent, (Object)_bundle.get("WARNING_NO_ROWS_AFFECTED"), (String)GenericResultSetTableClient.getOperationDescription(operation), (int)2);
    }

    @Override
    public ResultSetTableClient.NextAction warnMultipleRowsAffected(ResultSetTableClient.Operation operation, int n) {
        ResultSetTableClient.NextAction nextAction;
        if (this._supportsSavepoints) {
            int n2 = SybOptionPane.showConfirmDialog((Component)this._parent, (Object)SybMessageFormat.format((String)_bundle.get("WARNING_MULTIPLE_ROWS_AFFECTED_WITH_PROMPT"), (Object[])new Object[]{Integer.toString(n)}), (String)GenericResultSetTableClient.getOperationDescription(operation), (int)0);
            nextAction = n2 == 0 ? ResultSetTableClient.NextAction.COMPLETE : ResultSetTableClient.NextAction.CANCEL;
        } else {
            SybOptionPane.showMessageDialog((Component)this._parent, (Object)SybMessageFormat.format((String)_bundle.get("WARNING_MULTIPLE_ROWS_AFFECTED"), (Object[])new Object[]{Integer.toString(n)}), (String)GenericResultSetTableClient.getOperationDescription(operation), (int)2);
            nextAction = ResultSetTableClient.NextAction.COMPLETE;
        }
        return nextAction;
    }

    public static ResultSetTableClient.NextAction handleSQLException(JFrame jFrame, ResultSetTableClient.Operation operation, SQLException sQLException) {
        ResultSetTableClient.NextAction nextAction;
        String string = sQLException != null ? sQLException.getLocalizedMessage() : "";
        switch (operation) {
            case DELETE: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_DELETE_ROW"), (Object[])new Object[]{string}), (String)GenericResultSetTableClient.getOperationDescription(operation), (int)0);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case MULTIPLE_DELETE: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_DELETE_ROWS"), (Object[])new Object[]{string}), (String)GenericResultSetTableClient.getOperationDescription(operation), (int)0);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case INSERT: {
                Object[] objectArray = new String[]{_bundle.get("ChangeButton"), _bundle.get("CancelButton")};
                int n = SybOptionPane.showOptionDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_INSERT_ROW"), (Object[])new Object[]{string}), (String)GenericResultSetTableClient.getOperationDescription(operation), (int)-1, (int)0, null, (Object[])objectArray, (Object)objectArray[1]);
                if (n == 0) {
                    nextAction = ResultSetTableClient.NextAction.RETRY;
                    break;
                }
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case UPDATE: {
                Object[] objectArray = new String[]{_bundle.get("ChangeButton"), _bundle.get("CancelButton")};
                int n = SybOptionPane.showOptionDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_UPDATE_ROW"), (Object[])new Object[]{string}), (String)GenericResultSetTableClient.getOperationDescription(operation), (int)-1, (int)0, null, (Object[])objectArray, (Object)objectArray[1]);
                if (n == 0) {
                    nextAction = ResultSetTableClient.NextAction.RETRY;
                    break;
                }
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case REFETCH_AFTER_INSERT: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("REFETCH_AFTER_INSERT_REQUIRED"), (Object[])new Object[]{sQLException != null ? string : ""}), (String)jFrame.getTitle(), (int)1);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case REFETCH_AFTER_UPDATE: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("REFETCH_AFTER_UPDATE_REQUIRED"), (Object[])new Object[]{sQLException != null ? string : ""}), (String)jFrame.getTitle(), (int)1);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case REFETCH_LONG_VALUE: {
                if (sQLException != null && sQLException.getErrorCode() == -143) {
                    string = _bundle.get("ERR_CANT_GET_LONG_VALUE");
                }
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("REFETCH_LONG_VALUE_FAILED"), (Object[])new Object[]{string}), (String)jFrame.getTitle(), (int)0);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            default: {
                nextAction = ResultSetTableClient.NextAction.CANCEL;
            }
        }
        return nextAction;
    }

    private boolean dbgEnabled() {
        return ResultSetTable.dbgEnabled("+Model") || Dbg.isMessageTypeEnabled((String)this.getClass().getName());
    }
}

