/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.ImageIcon;

class ImageMetadata {
    static final int MAX_PREVIEW_WIDTH = 96;
    static final int MAX_PREVIEW_HEIGHT = 72;
    int _width;
    int _height;
    String _formatName;
    ImageIcon _preview;
    boolean _isTooLarge;
    private static ImageProcessor _imageProcessor = new ImageProcessor();

    ImageMetadata() {
        this._width = 0;
        this._height = 0;
        this._formatName = "";
        this._preview = null;
        this._isTooLarge = false;
    }

    ImageMetadata(int n, int n2, String string, ImageIcon imageIcon, boolean bl) {
        this._width = n;
        this._height = n2;
        this._formatName = string;
        this._preview = imageIcon;
        this._isTooLarge = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImageMetadata createMetadata(File file) {
        ImageMetadata imageMetadata;
        FileImageInputStream fileImageInputStream = null;
        try {
            BufferedImage bufferedImage = _imageProcessor.createImage(file, true);
            if (bufferedImage == null) {
                int n = _imageProcessor.getLastFailureReason();
                if (n == 1) {
                    imageMetadata = new ImageMetadata();
                    ImageReader imageReader = _imageProcessor.getLastImageReader();
                    imageReader.reset();
                    fileImageInputStream = new FileImageInputStream(file);
                    imageReader.setInput(fileImageInputStream);
                    imageMetadata._width = imageReader.getWidth(0);
                    imageMetadata._height = imageReader.getHeight(0);
                    imageMetadata._formatName = imageReader.getFormatName();
                    imageMetadata._isTooLarge = true;
                } else {
                    imageMetadata = null;
                }
            } else {
                imageMetadata = new ImageMetadata();
                imageMetadata._width = bufferedImage.getWidth();
                imageMetadata._height = bufferedImage.getHeight();
                ImageReader imageReader = _imageProcessor.getLastImageReader();
                imageReader.reset();
                fileImageInputStream = new FileImageInputStream(file);
                imageReader.setInput(fileImageInputStream);
                imageMetadata._formatName = imageReader.getFormatName();
                imageMetadata._preview = ImageProcessor.createImageIcon(bufferedImage, 96, 72);
            }
        }
        catch (IOException iOException) {
            imageMetadata = null;
        }
        finally {
            if (fileImageInputStream != null) {
                try {
                    fileImageInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageMetadata;
    }
}

