/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;

class ImageProcessor {
    static final int FORMAT_NOT_IMAGE = 0;
    static final int FORMAT_JPEG = 1;
    static final int FORMAT_GIF = 2;
    static final int FORMAT_PNG = 3;
    static final int FORMAT_BITMAP = 4;
    static final int REASON_NOT_AN_IMAGE = 0;
    static final int REASON_IMAGE_TOO_BIG = 1;
    private static final int MAX_AREA = 5000000;
    private int _failureReason = 0;
    private ImageReader _imageReader = null;

    ImageProcessor() {
    }

    BufferedImage createImage(byte[] byArray, boolean bl) {
        ImageInputStream imageInputStream = ImageProcessor.createIIS(byArray);
        BufferedImage bufferedImage = this.createImage(imageInputStream, bl);
        if (imageInputStream != null) {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedImage;
    }

    BufferedImage createImage(File file, boolean bl) {
        ImageInputStream imageInputStream = ImageProcessor.createIIS(file);
        BufferedImage bufferedImage = this.createImage(imageInputStream, bl);
        if (imageInputStream != null) {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedImage;
    }

    BufferedImage createImage(ImageInputStream imageInputStream, boolean bl) {
        this._failureReason = 0;
        this._imageReader = null;
        if (imageInputStream == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            while (iterator.hasNext() && bufferedImage == null) {
                ImageReader imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                this._imageReader = imageReader;
                if (bl && imageReader.hasThumbnails(0)) {
                    bufferedImage = imageReader.readThumbnail(0, 0);
                    continue;
                }
                if (imageReader.getWidth(0) * imageReader.getHeight(0) > 5000000) {
                    if (imageReader.hasThumbnails(0)) {
                        bufferedImage = imageReader.readThumbnail(0, 0);
                        continue;
                    }
                    this._failureReason = 1;
                    continue;
                }
                bufferedImage = imageReader.read(0);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedImage;
    }

    static ImageIcon createImageIcon(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            return null;
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (n3 > n || n4 > n2) {
            float f = (float)n / (float)n3;
            float f2 = (float)n2 / (float)n4;
            if (f < f2) {
                n3 = (int)((float)n3 * f);
                n4 = (int)((float)n4 * f);
            } else {
                n3 = (int)((float)n3 * f2);
                n4 = (int)((float)n4 * f2);
            }
        }
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        return new ImageIcon(bufferedImage.getScaledInstance(n3, n4, 4));
    }

    int getLastFailureReason() {
        return this._failureReason;
    }

    ImageReader getLastImageReader() {
        return this._imageReader;
    }

    static boolean isImage(byte[] byArray) {
        ImageInputStream imageInputStream = ImageProcessor.createIIS(byArray);
        if (imageInputStream == null) {
            return false;
        }
        return ImageIO.getImageReaders(imageInputStream).hasNext();
    }

    static boolean isImage(File file) {
        ImageInputStream imageInputStream = ImageProcessor.createIIS(file);
        if (imageInputStream == null) {
            return false;
        }
        boolean bl = ImageIO.getImageReaders(imageInputStream).hasNext();
        try {
            imageInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private static ImageInputStream createIIS(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            return new FileCacheImageInputStream(new ByteArrayInputStream(byArray), null);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ImageInputStream createIIS(File file) {
        if (file == null) {
            return null;
        }
        try {
            return new FileImageInputStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

