/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.LongValue;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class LongBinaryValue
extends LongValue {
    private byte[] _truncatedValue;

    LongBinaryValue(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        this._truncatedValue = byArray;
        this._truncationLength = n;
        this._file = null;
        this._isPartialValue = byArray.length >= n;
        this._isModified = false;
    }

    LongBinaryValue(byte[] byArray, int n, NullAwareTable nullAwareTable, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        this._truncationLength = n;
        this._isModified = bl;
        boolean bl2 = this._isPartialValue = byArray.length > this._truncationLength;
        if (this._isPartialValue) {
            try {
                this._file = LongBinaryValue.createTempFile(nullAwareTable, byArray);
            }
            catch (IOException iOException) {
                this._file = null;
            }
            this._truncatedValue = Arrays.copyOf(byArray, this._truncationLength);
        } else {
            this._truncatedValue = byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File createTempFile(NullAwareTable nullAwareTable, byte[] byArray) throws IOException {
        FilterOutputStream filterOutputStream = null;
        File file = null;
        try {
            if (nullAwareTable == null) {
                file = FileUtil.createSecureTempFile((String)"rst", null);
                file.deleteOnExit();
            } else {
                file = nullAwareTable.createTempFile();
            }
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            filterOutputStream.write(byArray);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getValueFromFile(int n) throws IOException {
        byte[] byArray;
        Object var3_2 = null;
        BufferedInputStream bufferedInputStream = null;
        this._wasLastValueTruncated = false;
        if (this._file == null) {
            if (this._isPartialValue) {
                // empty if block
            }
            return this._truncatedValue;
        }
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this._file));
            if (this._file.length() <= (long)n) {
                byArray = new byte[(int)this._file.length()];
                bufferedInputStream.read(byArray);
            } else {
                byArray = new byte[n];
                bufferedInputStream.read(byArray);
                this._wasLastValueTruncated = true;
            }
            bufferedInputStream.close();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    public byte[] getTruncatedValue() {
        return this._truncatedValue;
    }

    public String toString() {
        return Arrays.toString(this._truncatedValue);
    }
}

