/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.CustomFileDialog;
import com.sybase.resultSetTable.ImageProcessor;
import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.RSTFile;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import com.sybase.util.WarningBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

class LongBinaryValuePanel
extends JPanel {
    private static final int MAX_LENGTH = 65536;
    private static ResultSetTableResourcesBase _bundle = null;
    private FileNameExtensionFilter _jpgFilter = null;
    private FileNameExtensionFilter _gifFilter = null;
    private FileNameExtensionFilter _pngFilter = null;
    private FileNameExtensionFilter _bmpFilter = null;
    private FileNameExtensionFilter[] _imageFilters = null;
    private boolean _filtersInitialized = false;
    private boolean _isPreviewTabAvailable;
    private Component _previewTabComponent;
    private BufferedImage _bufferedImage = null;
    private byte[] _binaryData = null;
    private File _fullValueFile = null;
    private boolean _isImage = false;
    private boolean _isTruncated = false;
    private NullAwareTable _nat;
    private Dialog _parentDialog;
    private ImageProcessor _imageProcessor = new ImageProcessor();
    private JPanel _hexPanel;
    private JScrollPane _hexScrollPane;
    private JTextArea _hexTextArea;
    private SybLabel _imageSizeLabel;
    private SybLabel _imageSizeLabel2;
    private SybLabel _imageTooLargeLabel;
    private SybLabel _imageTypeLabel;
    private SybLabel _imageTypeLabel2;
    private SybLabel _lengthLabel;
    private SybLabel _lengthLabel2;
    private SybLabel _previewLabel;
    private JPanel _previewPanel;
    private SybButton _saveButton;
    private JTabbedPane _tabbedPane;
    private WarningBox _truncationWarning;

    LongBinaryValuePanel(NullAwareTable nullAwareTable, Dialog dialog) {
        if (_bundle == null) {
            _bundle = ResultSetTableResourcesBase.getBundle();
        }
        this.initComponents();
        this._tabbedPane.addTab(_bundle.getString("IMAGE_PREVIEW_TAB"), this._previewPanel);
        this._tabbedPane.addTab(_bundle.getString("BINARY_TAB"), this._hexPanel);
        this._isPreviewTabAvailable = true;
        this._nat = nullAwareTable;
        this._parentDialog = dialog;
    }

    void destroy() {
        this._jpgFilter = null;
        this._gifFilter = null;
        this._pngFilter = null;
        this._bmpFilter = null;
        this._imageFilters = null;
        this._previewTabComponent = null;
        this._bufferedImage = null;
        this._binaryData = null;
        this._fullValueFile = null;
        this._nat = null;
        this._parentDialog = null;
        this._imageProcessor = null;
        this._hexPanel = null;
        this._hexScrollPane = null;
        this._hexTextArea = null;
        this._imageSizeLabel = null;
        this._imageSizeLabel2 = null;
        this._imageTooLargeLabel = null;
        this._imageTypeLabel = null;
        this._imageTypeLabel2 = null;
        this._lengthLabel = null;
        this._lengthLabel2 = null;
        this._previewLabel = null;
        this._previewPanel = null;
        this._saveButton = null;
        this._tabbedPane = null;
        this._truncationWarning = null;
    }

    byte[] getData() {
        return this._binaryData;
    }

    int getFileFilterIndex() {
        return -1;
    }

    FileNameExtensionFilter[] getFileFilters() {
        if (!this._filtersInitialized) {
            this.initializeFilters();
        }
        return this._imageFilters;
    }

    boolean isTruncated() {
        return this._isTruncated;
    }

    void loadData(byte[] byArray) {
        this._binaryData = byArray;
        boolean bl = this._isTruncated = byArray.length > 65536;
        if (this._isTruncated) {
            try {
                this._fullValueFile = LongBinaryValue.createTempFile(this._nat, byArray);
            }
            catch (IOException iOException) {
                this._fullValueFile = null;
            }
        } else {
            this._fullValueFile = null;
        }
        this._previewLabel.setIcon(null);
        this._previewLabel.setText(_bundle.getString("LOADING_IMAGE_LABEL"));
        this._imageTooLargeLabel.setVisible(false);
        this._imageTypeLabel2.setText("");
        this._imageSizeLabel2.setText("");
        this._truncationWarning.setVisible(false);
        this._isImage = ImageProcessor.isImage(byArray);
        this.setPreviewTabAvailable(this._isImage);
        this._tabbedPane.setSelectedIndex(0);
    }

    void loadData(LongBinaryValue longBinaryValue) {
        this._isTruncated = false;
        if (longBinaryValue.isPartialValue()) {
            try {
                this._binaryData = longBinaryValue.getValueFromFile(65536);
                this._isTruncated = longBinaryValue.wasLastValueTruncated();
                this._fullValueFile = longBinaryValue.getFile();
                this._isImage = ImageProcessor.isImage(this._fullValueFile);
            }
            catch (IOException iOException) {
                this._binaryData = longBinaryValue.getTruncatedValue();
                this._fullValueFile = null;
                this._isImage = ImageProcessor.isImage(this._binaryData);
            }
        } else {
            this._binaryData = longBinaryValue.getTruncatedValue();
            this._fullValueFile = null;
            this._isImage = ImageProcessor.isImage(this._binaryData);
        }
        if (this._binaryData.length > 65536) {
            this._isTruncated = true;
        }
        this._previewLabel.setIcon(null);
        this._previewLabel.setText(_bundle.getString("LOADING_IMAGE_LABEL"));
        this._imageTooLargeLabel.setVisible(false);
        this._imageTypeLabel2.setText("");
        this._imageSizeLabel2.setText("");
        this._truncationWarning.setVisible(false);
        this.setPreviewTabAvailable(this._isImage);
        this._tabbedPane.setSelectedIndex(0);
    }

    void resetData() {
        this.setPreviewTabAvailable(false);
        this._tabbedPane.setSelectedIndex(0);
        this._binaryData = null;
        this._hexTextArea.setText("");
        this._lengthLabel2.setText("");
        this._isImage = false;
        this._bufferedImage = null;
        this._fullValueFile = null;
        this._previewLabel.setIcon(null);
        this._previewLabel.setText("");
        this._imageTooLargeLabel.setVisible(false);
        this._imageTypeLabel2.setText("");
        this._imageSizeLabel2.setText("");
        this._truncationWarning.setVisible(false);
    }

    void resizePreview() {
        if (this._isImage) {
            this._previewLabel.setIcon((Icon)ImageProcessor.createImageIcon(this._bufferedImage, this._previewLabel.getWidth(), this._previewLabel.getHeight()));
        }
    }

    void setAllEnabled(boolean bl) {
        this._tabbedPane.setEnabled(bl);
        this._hexScrollPane.setEnabled(bl);
        this._hexTextArea.setEnabled(bl);
        this._lengthLabel.setEnabled(bl);
        this._lengthLabel2.setEnabled(bl);
        this._imageTooLargeLabel.setEnabled(bl);
        this._imageTypeLabel.setEnabled(bl);
        this._imageTypeLabel2.setEnabled(bl);
        this._imageSizeLabel.setEnabled(bl);
        this._imageSizeLabel2.setEnabled(bl);
        this._saveButton.setEnabled(bl);
        this._truncationWarning.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showData() {
        ImageInputStreamImpl imageInputStreamImpl = null;
        if (this._binaryData == null) {
            throw new IllegalStateException();
        }
        this.formatBinaryContent(this._binaryData);
        if (this._fullValueFile == null) {
            this._lengthLabel2.setText(RSTFile.formatLength(this._binaryData.length));
        } else {
            this._lengthLabel2.setText(RSTFile.formatLength(this._fullValueFile.length()));
        }
        this._truncationWarning.setVisible(this._isTruncated);
        this._previewLabel.setText("");
        if (this._isImage) {
            this._bufferedImage = this._fullValueFile == null ? this._imageProcessor.createImage(this._binaryData, false) : this._imageProcessor.createImage(this._fullValueFile, false);
            if (this._bufferedImage == null) {
                this._imageTooLargeLabel.setVisible(true);
            }
            this._previewLabel.setIcon((Icon)ImageProcessor.createImageIcon(this._bufferedImage, this._previewLabel.getWidth(), this._previewLabel.getHeight()));
            ImageReader imageReader = this._imageProcessor.getLastImageReader();
            try {
                imageReader.reset();
                imageInputStreamImpl = this._fullValueFile != null ? new FileImageInputStream(this._fullValueFile) : new FileCacheImageInputStream(new ByteArrayInputStream(this._binaryData), null);
                imageReader.setInput(imageInputStreamImpl);
                String string = imageReader.getWidth(0) + " x " + imageReader.getHeight(0);
                this._imageSizeLabel2.setText(string);
                this._imageTypeLabel2.setText(imageReader.getFormatName());
            }
            catch (IOException iOException) {
                this._imageTypeLabel2.setText("");
                this._imageSizeLabel2.setText("");
            }
            finally {
                if (imageInputStreamImpl != null) {
                    try {
                        imageInputStreamImpl.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private String formatBinaryContent(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[16];
        int n = byArray.length > 65536 ? 65536 : byArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            if ((i & 0xF) == 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                string = "00000000" + Integer.toHexString(i);
                string = string.substring(string.length() - 8);
                stringBuilder.append(string);
                stringBuilder.append(':');
                Arrays.fill(cArray, ' ');
            }
            if ((i & 0xF) == 8) {
                stringBuilder.append(" -");
            }
            string = "00" + Integer.toHexString(byArray[i]);
            string = string.substring(string.length() - 2);
            stringBuilder.append(" ");
            stringBuilder.append(string);
            int n2 = byArray[i];
            cArray[i & 0xF] = Character.isDefined((char)n2) && !Character.isISOControl((char)n2) ? n2 : 46;
            if ((i & 0xF) == 15) {
                stringBuilder.append("  ");
                stringBuilder.append(cArray);
                continue;
            }
            if (i != byArray.length - 1) continue;
            string = "                                                  ";
            stringBuilder.append(string.substring(0, (16 - (i & 0xF)) * 3 - 1));
            if ((i & 0xF) < 8) {
                stringBuilder.append("  ");
            }
            stringBuilder.append(cArray);
        }
        this._hexTextArea.setText(stringBuilder.toString());
        this._hexTextArea.getCaret().setVisible(true);
        this._hexTextArea.setCaretPosition(0);
        return stringBuilder.toString();
    }

    private void initializeFilters() {
        this._jpgFilter = new FileNameExtensionFilter(_bundle.getString("JPEG_FILE_FILTER"), "jpg", "jpeg", "jpe", "jfif");
        this._gifFilter = new FileNameExtensionFilter(_bundle.getString("GIF_FILE_FILTER"), "gif");
        this._pngFilter = new FileNameExtensionFilter(_bundle.getString("PNG_FILE_FILTER"), "png");
        this._bmpFilter = new FileNameExtensionFilter(_bundle.getString("BMP_FILE_FILTER"), "bmp", "dib");
        this._imageFilters = new FileNameExtensionFilter[]{this._jpgFilter, this._gifFilter, this._pngFilter, this._bmpFilter};
        this._filtersInitialized = true;
    }

    private void setPreviewTabAvailable(boolean bl) {
        if (this._isPreviewTabAvailable != bl) {
            if (bl) {
                this._tabbedPane.insertTab(_bundle.getString("IMAGE_PREVIEW_TAB"), null, this._previewPanel, null, 0);
            } else {
                this._tabbedPane.removeTabAt(0);
            }
            this._isPreviewTabAvailable = bl;
        }
    }

    private void initComponents() {
        this._previewPanel = new JPanel();
        this._previewLabel = new SybLabel();
        this._imageTooLargeLabel = new SybLabel();
        this._imageTypeLabel = new SybLabel();
        this._imageTypeLabel2 = new SybLabel();
        this._imageSizeLabel = new SybLabel();
        this._imageSizeLabel2 = new SybLabel();
        this._hexPanel = new JPanel();
        this._truncationWarning = new WarningBox();
        this._hexScrollPane = new JScrollPane();
        this._hexTextArea = new JTextArea();
        this._tabbedPane = new JTabbedPane();
        this._lengthLabel = new SybLabel();
        this._lengthLabel2 = new SybLabel();
        this._saveButton = new SybButton();
        this._previewPanel.setLayout(new GridBagLayout());
        this._previewPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._previewPanel.setOpaque(false);
        this._previewLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._previewPanel.add((Component)this._previewLabel, gridBagConstraints);
        this._imageTooLargeLabel.setHorizontalAlignment(0);
        this._imageTooLargeLabel.setText(_bundle.getString("IMAGE_TOO_BIG_MESSAGE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this._previewPanel.add((Component)this._imageTooLargeLabel, gridBagConstraints);
        this._imageTypeLabel.setText(_bundle.getString("IMAGE_TYPE_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._previewPanel.add((Component)this._imageTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this._previewPanel.add((Component)this._imageTypeLabel2, gridBagConstraints);
        this._imageSizeLabel.setText(_bundle.getString("IMAGE_DIMENSIONS_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this._previewPanel.add((Component)this._imageSizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._previewPanel.add((Component)this._imageSizeLabel2, gridBagConstraints);
        this._hexPanel.setLayout(new GridBagLayout());
        this._truncationWarning.setMessage(SybMessageFormat.format((String)_bundle.get("BINARY_TRUNCATION_WARNING"), (Object[])new Object[]{65536}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._hexPanel.add((Component)this._truncationWarning, gridBagConstraints);
        this._hexScrollPane.setHorizontalScrollBarPolicy(31);
        this._hexScrollPane.setVerticalScrollBarPolicy(22);
        this._hexTextArea.setColumns(80);
        this._hexTextArea.setEditable(false);
        this._hexTextArea.setFont(new Font("Monospaced", 0, 12));
        this._hexTextArea.setRows(12);
        this._hexScrollPane.setViewportView(this._hexTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._hexPanel.add((Component)this._hexScrollPane, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._tabbedPane, gridBagConstraints);
        this._tabbedPane.getAccessibleContext().setAccessibleName("Preview");
        this._lengthLabel.setText(_bundle.getString("SIZE_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this._lengthLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this._lengthLabel2, gridBagConstraints);
        this._saveButton.setIcon((Icon)new ImageIcon(this.getClass().getResource("/com/sybase/util/save16.gif")));
        this._saveButton.setText(_bundle.getString("SAVE_TO_FILE_BUTTON"));
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LongBinaryValuePanel.this.saveButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this._saveButton, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        if (this._parentDialog == null || this._binaryData == null) {
            throw new IllegalStateException();
        }
        this._saveButton.setEnabled(false);
        if (!this._filtersInitialized) {
            this.initializeFilters();
        }
        String string = this._parentDialog.getTitle();
        string = string.replace("\"", "");
        if (this._isImage) {
            object2 = this._imageTypeLabel2.getText();
            object = ((String)object2).equalsIgnoreCase("JPEG") ? new FileNameExtensionFilter[]{this._jpgFilter} : (((String)object2).equalsIgnoreCase("gif") ? new FileNameExtensionFilter[]{this._gifFilter} : (((String)object2).equalsIgnoreCase("png") ? new FileNameExtensionFilter[]{this._pngFilter} : (((String)object2).equalsIgnoreCase("bmp") ? new FileNameExtensionFilter[]{this._bmpFilter} : null)));
        } else {
            object = null;
            string = string + ".bin";
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        CustomFileDialog customFileDialog = new CustomFileDialog((Window)this._parentDialog);
        if (!customFileDialog.showSaveDialog(string, false, false, (FileNameExtensionFilter[])object, 0)) {
            this.setCursor(null);
            this._saveButton.setEnabled(true);
            return;
        }
        object2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(customFileDialog.getSelectedFile());
            if (this._fullValueFile == null) {
                fileOutputStream.write(this._binaryData);
            } else {
                object2 = new FileInputStream(this._fullValueFile);
                MappedByteBuffer mappedByteBuffer = ((FileInputStream)object2).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, ((FileInputStream)object2).getChannel().size());
                fileOutputStream.getChannel().write(mappedByteBuffer);
            }
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog((Component)this, (Object)SybMessageFormat.format((String)_bundle.get("CANT_SAVE_TO_FILE"), (Object[])new Object[]{iOException.getLocalizedMessage()}), (String)this._parentDialog.getTitle(), (int)0);
        }
        finally {
            if (object2 != null) {
                try {
                    ((FileInputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.setCursor(null);
        this._saveButton.setEnabled(true);
    }
}

