/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.LongValue;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.util.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

class LongTextValue
extends LongValue {
    static final String FILE_ENCODING = "utf8";
    private String _truncatedValue;

    LongTextValue(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this._truncatedValue = string;
        this._truncationLength = n;
        this._file = null;
        this._isPartialValue = string != null && string.length() >= n;
        this._isModified = false;
    }

    LongTextValue(String string, int n, NullAwareTable nullAwareTable, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this._truncationLength = n;
        this._isModified = bl;
        boolean bl2 = this._isPartialValue = string.length() > this._truncationLength;
        if (this._isPartialValue) {
            try {
                this._file = LongTextValue.createTempFile(nullAwareTable, string);
            }
            catch (IOException iOException) {
                this._file = null;
            }
            this._truncatedValue = string.substring(0, this._truncationLength);
        } else {
            this._truncatedValue = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File createTempFile(NullAwareTable nullAwareTable, String string) throws IOException {
        BufferedWriter bufferedWriter = null;
        File file = null;
        try {
            if (nullAwareTable == null) {
                file = FileUtil.createSecureTempFile((String)"rst", null);
                file.deleteOnExit();
            } else {
                file = nullAwareTable.createTempFile();
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), FILE_ENCODING));
            bufferedWriter.write(string);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getValueFromFile(int n) throws IOException {
        String string;
        BufferedReader bufferedReader = null;
        Object var4_3 = null;
        this._wasLastValueTruncated = false;
        if (this._file == null) {
            if (this._isPartialValue) {
                // empty if block
            }
            return this._truncatedValue;
        }
        try {
            int n2;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), FILE_ENCODING));
            StringBuilder stringBuilder = new StringBuilder(4096);
            char[] cArray = new char[4096];
            int n3 = n2 = bufferedReader.read(cArray);
            while (n2 >= 0) {
                if (n3 > n) {
                    stringBuilder.append(cArray, 0, n - n3 + n2);
                    this._wasLastValueTruncated = true;
                    break;
                }
                stringBuilder.append(cArray, 0, n2);
                n2 = bufferedReader.read(cArray);
                n3 += n2;
            }
            string = stringBuilder.toString();
            bufferedReader.close();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    @Override
    protected String getTruncatedValue() {
        return this._truncatedValue;
    }

    public String toString() {
        return this._truncatedValue;
    }
}

