/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.CustomFileDialog;
import com.sybase.resultSetTable.LimitedDocument;
import com.sybase.resultSetTable.LongTextValue;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.SelectNewlineFormatDialog;
import com.sybase.resultSetTable.XMLEncodingFinder;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import com.sybase.util.WarningBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;

class LongTextValuePanel
extends JPanel
implements ClipboardOwner {
    static final int MAX_LENGTH = 65536;
    final String SYSTEM_NEWLINE;
    private final Clipboard CLIPBOARD;
    private static ResultSetTableResourcesBase _bundle = null;
    private FileNameExtensionFilter[] _fileFilters = null;
    private FileNameExtensionFilter _textFileFilter = null;
    private FileNameExtensionFilter _xmlFileFilter = null;
    private boolean _filtersInitialized = false;
    private boolean _isTruncated = false;
    private boolean _isXMLColumn = false;
    private File _fullValueFile = null;
    private String _originalText = null;
    private NullAwareTable _nat;
    private Dialog _parentDialog;
    private String _lineSeparator;
    private SybButton _copyButton;
    private SybButton _saveButton;
    private JTextArea _textArea;
    private JScrollPane _textScrollPane;
    private WarningBox _truncationWarning;
    private SybCheckBox _wordWrapCheckBox;

    LongTextValuePanel(NullAwareTable nullAwareTable, Dialog dialog) {
        if (_bundle == null) {
            _bundle = ResultSetTableResourcesBase.getBundle();
        }
        this.initComponents();
        this._nat = nullAwareTable;
        this._parentDialog = dialog;
        this.CLIPBOARD = this.getToolkit().getSystemClipboard();
        this._lineSeparator = this.SYSTEM_NEWLINE = System.getProperty("line.separator");
    }

    void destroy() {
        this._fileFilters = null;
        this._textFileFilter = null;
        this._xmlFileFilter = null;
        this._fullValueFile = null;
        this._originalText = null;
        this._nat = null;
        this._parentDialog = null;
        this._lineSeparator = null;
        this._copyButton = null;
        this._saveButton = null;
        this._textArea = null;
        this._textScrollPane = null;
        this._truncationWarning = null;
        this._wordWrapCheckBox = null;
    }

    void addDocumentListenerToText(DocumentListener documentListener) {
        this._textArea.getDocument().addDocumentListener(documentListener);
    }

    int getFileFilterIndex() {
        if (this._isXMLColumn) {
            return 1;
        }
        if (XMLEncodingFinder.isXML(this._textArea.getText())) {
            return 1;
        }
        return 0;
    }

    FileNameExtensionFilter[] getFileFilters() {
        if (!this._filtersInitialized) {
            this.initializeFilters();
        }
        return this._fileFilters;
    }

    String getLineSeparator() {
        return this._lineSeparator;
    }

    String getText() {
        if (this._isTruncated) {
            return this._originalText;
        }
        return this._textArea.getText().replace("\n", this._lineSeparator);
    }

    boolean isEditable() {
        return this._textArea.isEditable();
    }

    boolean isTruncated() {
        return this._isTruncated;
    }

    void loadText(String string, boolean bl) {
        this._originalText = string;
        boolean bl2 = this._isTruncated = string.length() > 65536;
        if (this._isTruncated) {
            try {
                this._fullValueFile = LongTextValue.createTempFile(this._nat, string);
            }
            catch (IOException iOException) {
                this._fullValueFile = null;
            }
        } else {
            this._fullValueFile = null;
        }
        this._textArea.setEditable(bl & !this._isTruncated);
        this._truncationWarning.setVisible(false);
    }

    void loadText(LongTextValue longTextValue, boolean bl) {
        try {
            this._originalText = longTextValue.getValueFromFile(65536);
            this._isTruncated = longTextValue.wasLastValueTruncated() || this._originalText.length() > 65536;
        }
        catch (IOException iOException) {
            this._originalText = longTextValue.getTruncatedValue();
            this._isTruncated = this._originalText.length() > 65536;
        }
        this._fullValueFile = longTextValue.getFile();
        this._textArea.setEditable(bl & !this._isTruncated);
        this._truncationWarning.setVisible(false);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    void resetText() {
        this._textArea.setText("");
        this._originalText = null;
        this._isTruncated = false;
        this._textArea.setEditable(true);
        this._truncationWarning.setVisible(false);
    }

    void setAllEnabled(boolean bl) {
        this._textArea.setEnabled(bl);
        this._textScrollPane.setEnabled(bl);
        this._copyButton.setEnabled(bl);
        this._saveButton.setEnabled(bl);
        this._wordWrapCheckBox.setEnabled(bl);
        this._truncationWarning.setEnabled(bl);
    }

    void setIsXMLColumn(boolean bl) {
        this._isXMLColumn = bl;
    }

    boolean showNewlineFormatDialog(SelectNewlineFormatDialog selectNewlineFormatDialog) {
        if (this._textArea.getText().contains("\n")) {
            if (selectNewlineFormatDialog.showValueDialog()) {
                this._lineSeparator = selectNewlineFormatDialog.getSelectedLineSeparator();
                return true;
            }
            return false;
        }
        return true;
    }

    void showText() {
        if (this._originalText == null) {
            throw new IllegalStateException();
        }
        String string = this._originalText.length() > 65536 ? this._originalText.substring(0, 65536) : this._originalText;
        this._lineSeparator = this.SYSTEM_NEWLINE;
        string = string.replace("\r\n", "\n").replace("\r", "\n");
        this._truncationWarning.setVisible(this._isTruncated);
        this._textArea.setText(string);
    }

    private void initializeFilters() {
        this._fileFilters = new FileNameExtensionFilter[2];
        this._textFileFilter = new FileNameExtensionFilter(_bundle.getString("TEXT_FILE_FILTER"), "txt");
        this._xmlFileFilter = new FileNameExtensionFilter(_bundle.getString("XML_FILE_FILTER"), "xml");
        this._fileFilters[0] = this._textFileFilter;
        this._fileFilters[1] = this._xmlFileFilter;
        this._filtersInitialized = true;
    }

    private void initComponents() {
        this._truncationWarning = new WarningBox();
        this._textScrollPane = new JScrollPane();
        this._textArea = new JTextArea();
        this._wordWrapCheckBox = new SybCheckBox();
        this._copyButton = new SybButton();
        this._saveButton = new SybButton();
        this.setLayout(new GridBagLayout());
        this._truncationWarning.setMessage(SybMessageFormat.format((String)_bundle.get("TEXT_TRUNCATION_WARNING"), (Object[])new Object[]{65536}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._truncationWarning, gridBagConstraints);
        this._textArea.setColumns(80);
        this._textArea.setDocument(new LimitedDocument(65536));
        this._textArea.setFont(new Font("Monospaced", 0, 12));
        this._textArea.setRows(12);
        this._textArea.setWrapStyleWord(true);
        this._textScrollPane.setViewportView(this._textArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._textScrollPane, gridBagConstraints);
        this._wordWrapCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._wordWrapCheckBox.setText(_bundle.getString("WORD_WRAP"));
        this._wordWrapCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this._wordWrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LongTextValuePanel.this._wordWrapCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.add((Component)this._wordWrapCheckBox, gridBagConstraints);
        this._copyButton.setIcon((Icon)new ImageIcon(this.getClass().getResource("/com/sybase/util/copy16.gif")));
        this._copyButton.setText(_bundle.getString("COPY_TO_CLIPBOARD_BUTTON"));
        this._copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LongTextValuePanel.this._copyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this._copyButton, gridBagConstraints);
        this._saveButton.setIcon((Icon)new ImageIcon(this.getClass().getResource("/com/sybase/util/save16.gif")));
        this._saveButton.setText(_bundle.getString("SAVE_TO_FILE_BUTTON"));
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LongTextValuePanel.this.saveButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this._saveButton, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        InputStreamReader inputStreamReader = null;
        OutputStreamWriter outputStreamWriter = null;
        if (this._parentDialog == null) {
            throw new IllegalStateException();
        }
        this._saveButton.setEnabled(false);
        String string = this._textArea.getText().replace("\n", this.SYSTEM_NEWLINE);
        String string2 = this._parentDialog.getTitle();
        string2 = string2.replace("\"", "");
        boolean bl = XMLEncodingFinder.isXML(string);
        FileNameExtensionFilter[] fileNameExtensionFilterArray = this.getFileFilters();
        int n = this.getFileFilterIndex();
        this.setCursor(Cursor.getPredefinedCursor(3));
        CustomFileDialog customFileDialog = new CustomFileDialog((Window)this._parentDialog);
        if (!customFileDialog.showSaveDialog(string2, true, false, fileNameExtensionFilterArray, n)) {
            this.setCursor(null);
            this._saveButton.setEnabled(true);
            return;
        }
        try {
            Charset charset = customFileDialog.getSelectedCharset();
            if (charset == null) {
                if (customFileDialog.isXMLFilterSelected()) {
                    String string3;
                    if (bl) {
                        string3 = XMLEncodingFinder.getEncoding(string);
                        if (string3 == null) {
                            string3 = "UTF-8";
                        }
                    } else {
                        string3 = "UTF-8";
                    }
                    charset = Charset.forName(string3);
                } else {
                    charset = Charset.defaultCharset();
                }
            }
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(customFileDialog.getSelectedFile()), charset);
            if (this._fullValueFile == null || !this._isTruncated) {
                outputStreamWriter.write(string);
            } else {
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this._fullValueFile), "utf8");
                char[] cArray = new char[4096];
                int n2 = inputStreamReader.read(cArray);
                while (n2 >= 0) {
                    outputStreamWriter.write(cArray, 0, n2);
                    n2 = inputStreamReader.read(cArray);
                }
            }
        }
        catch (IOException iOException) {
            SybOptionPane.showMessageDialog((Component)this, (Object)SybMessageFormat.format((String)_bundle.get("CANT_SAVE_TO_FILE"), (Object[])new Object[]{iOException.getLocalizedMessage()}), (String)this._parentDialog.getTitle(), (int)0);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.setCursor(null);
        this._saveButton.setEnabled(true);
    }

    private void _copyButtonActionPerformed(ActionEvent actionEvent) {
        String string = this._textArea.getText().replace("\n", this.SYSTEM_NEWLINE);
        this.CLIPBOARD.setContents(new StringSelection(string), this);
    }

    private void _wordWrapCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._textArea.setLineWrap(this._wordWrapCheckBox.isSelected());
    }
}

