/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BaseCellEditor;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;

class LongValueButton
extends JButton {
    private int _row = -1;
    private int _column = -1;
    private BaseCellEditor _cellEditor = null;
    private Border _rendererBorder;
    private int _insetInCell;
    private JPanel _panel;
    private JTable _table;
    private boolean _onTable = false;
    private boolean _isHidden = true;

    LongValueButton(JTable jTable) {
        if (jTable == null) {
            throw new IllegalArgumentException("Parent table is null.");
        }
        this._panel = new JPanel();
        this._panel.setLayout(null);
        this._panel.setOpaque(false);
        this.setText("...");
        this.setMnemonic(10);
        this.setFocusable(false);
        this._panel.add(this);
        this._table = jTable;
        this.addToTable();
        int n = jTable.getRowHeight() - jTable.getRowMargin();
        Dimension dimension = new Dimension(n, n);
        this._panel.setPreferredSize(dimension);
        this._panel.setSize(dimension);
        this._insetInCell = n;
        String string = UIManager.getLookAndFeel().getID();
        String string2 = UIManager.getLookAndFeel().getClass().getName();
        if (string2.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && UIUtils.isXPLookAndFeelActive()) {
            this.setLocation(-1, -1);
            dimension = new Dimension(n + 2, n + 2);
            this.setOpaque(false);
        } else if (string.equals("Motif")) {
            this.setLocation(-6, -6);
            dimension = new Dimension(n + 12, n + 12);
        } else {
            this.setLocation(0, 0);
            dimension = new Dimension(n, n);
        }
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    void destroy() {
        if (this._panel.getParent() != null) {
            this._panel.getParent().remove(this._panel);
        }
        this._panel.remove(this);
        this._panel = null;
        this._rendererBorder = null;
    }

    BaseCellEditor getCellEditor() {
        return this._cellEditor;
    }

    int getColumn() {
        return this._column;
    }

    int getRow() {
        return this._row;
    }

    void hideFromCellEditor() {
        if (this._panel.getParent() != null) {
            this._panel.getParent().remove(this._panel);
        }
        this._onTable = false;
        this.setEnabled(false);
        this._isHidden = true;
        this._row = -1;
        this._column = -1;
        this._cellEditor = null;
    }

    void hideFromTable() {
        if (!this._onTable) {
            this.addToTable();
        }
        this.setEnabled(false);
        this._isHidden = true;
        this._row = -1;
        this._column = -1;
        this._panel.setLocation(-this.getWidth(), -this.getHeight());
    }

    boolean isHidden() {
        return this._isHidden;
    }

    void moveToCellEditor(BaseCellEditor baseCellEditor, Container container, Object object, int n, int n2) {
        if (this._panel.getParent() != container) {
            if (this._panel.getParent() != null) {
                this._panel.getParent().remove(this._panel);
            }
            container.add((Component)this._panel, object);
        }
        this._onTable = false;
        this.setEnabled(true);
        this._isHidden = false;
        this._row = n;
        this._column = n2;
        this._cellEditor = baseCellEditor;
    }

    void moveToTableCell(int n, int n2) {
        if (!this._onTable) {
            this.addToTable();
        }
        this.setEnabled(true);
        this._isHidden = false;
        int n3 = this._row;
        int n4 = this._column;
        this._row = n;
        this._column = n2;
        Rectangle rectangle = this._table.getCellRect(n, n2, false);
        this._panel.setLocation(rectangle.x + rectangle.width - this._insetInCell, rectangle.y);
    }

    Border getCellRendererBorder() {
        if (this._rendererBorder == null) {
            this._rendererBorder = BorderFactory.createEmptyBorder(0, 0, 0, this._insetInCell);
        }
        return this._rendererBorder;
    }

    private void addToTable() {
        if (this._panel.getParent() != null) {
            this._panel.getParent().remove(this._panel);
        }
        this._table.add(this._panel);
        this._onTable = true;
        this._cellEditor = null;
    }
}

