/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

class NewlineConvertingReader
extends InputStreamReader {
    private boolean _preserveNewlines = false;
    private char _newline1 = '\u0000';
    private char _newline2 = '\u0000';
    private boolean _newline2IsBuffered = false;
    private boolean _twoCharNewline = false;
    private int _cpBuffer = 0;
    private boolean _cpIsBuffered = false;
    private char[] _charBuffer = new char[0];
    private int _charBufferSize = 0;
    private int _charBufferHead = 0;

    NewlineConvertingReader(InputStream inputStream, Charset charset, String string) {
        super(inputStream, charset);
        if (string == null) {
            this._preserveNewlines = true;
        } else {
            this._preserveNewlines = false;
            if (string.length() == 1) {
                this._newline1 = string.charAt(0);
                this._twoCharNewline = false;
            } else if (string.length() == 2) {
                this._newline1 = string.charAt(0);
                this._newline2 = string.charAt(1);
                this._twoCharNewline = true;
            } else {
                throw new IllegalArgumentException("Line separator must have length 1 or 2.");
            }
        }
    }

    NewlineConvertingReader(InputStream inputStream, String string) {
        super(inputStream);
        if (string == null) {
            this._preserveNewlines = true;
        } else {
            this._preserveNewlines = false;
            if (string.length() == 1) {
                this._newline1 = string.charAt(0);
                this._twoCharNewline = false;
            } else if (string.length() == 2) {
                this._newline1 = string.charAt(0);
                this._newline2 = string.charAt(1);
                this._twoCharNewline = true;
            } else {
                throw new IllegalArgumentException("Line separator must have length 1 or 2.");
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this._preserveNewlines) {
            return super.read();
        }
        if (this._newline2IsBuffered) {
            this._newline2IsBuffered = false;
            return this._newline2;
        }
        if (this._cpIsBuffered || this._charBufferHead >= this._charBufferSize) {
            int n;
            if (this._cpIsBuffered) {
                this._cpIsBuffered = false;
                n = this._cpBuffer;
            } else {
                n = super.read();
                if (n == -1) {
                    return -1;
                }
            }
            if (n == 13) {
                int n2 = super.read();
                if (n2 != 10 && n2 != -1) {
                    this._cpBuffer = n2;
                    this._cpIsBuffered = true;
                }
                if (this._twoCharNewline) {
                    this._newline2IsBuffered = true;
                }
                return this._newline1;
            }
            if (n == 10) {
                if (this._twoCharNewline) {
                    this._newline2IsBuffered = true;
                }
                return this._newline1;
            }
            return n;
        }
        char c = this._charBuffer[this._charBufferHead];
        ++this._charBufferHead;
        if (Character.isHighSurrogate(c)) {
            char c2;
            if (this._charBufferHead < this._charBufferSize) {
                c2 = this._charBuffer[this._charBufferHead];
                ++this._charBufferHead;
            } else {
                this._charBufferSize = super.read(this._charBuffer, 0, this._charBuffer.length);
                this._charBufferHead = 0;
                if (this._charBufferSize > 0) {
                    c2 = this._charBuffer[0];
                    this._charBufferHead = 1;
                } else {
                    return c;
                }
            }
            return Character.toCodePoint(c, c2);
        }
        if (c == '\r') {
            if (this._charBufferHead < this._charBufferSize) {
                if (this._charBuffer[this._charBufferHead] == '\n') {
                    ++this._charBufferHead;
                }
            } else {
                this._charBufferSize = super.read(this._charBuffer, 0, this._charBuffer.length);
                this._charBufferHead = 0;
                if (this._charBufferSize > 0 && this._charBuffer[0] == '\n') {
                    this._charBufferHead = 1;
                }
            }
            if (this._twoCharNewline) {
                this._newline2IsBuffered = true;
            }
            return this._newline1;
        }
        if (c == '\n') {
            if (this._twoCharNewline) {
                this._newline2IsBuffered = true;
            }
            return this._newline1;
        }
        return c;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        char[] cArray = new char[charBuffer.length()];
        int n = this.read(cArray);
        charBuffer.put(cArray);
        return n;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this._preserveNewlines) {
            return super.read(cArray, n, n2);
        }
        int n3 = n;
        int n4 = n + n2;
        if (this._newline2IsBuffered) {
            this._newline2IsBuffered = false;
            cArray[n3] = this._newline2;
            ++n3;
        }
        if (n3 < n4 && this._cpIsBuffered) {
            this._cpIsBuffered = false;
            if (this._cpBuffer == 13) {
                int n5 = super.read();
                if (n5 != 10) {
                    this._cpBuffer = n5;
                    this._cpIsBuffered = true;
                }
                cArray[n3] = this._newline1;
                ++n3;
                if (this._twoCharNewline) {
                    if (n3 < n4) {
                        cArray[n3] = this._newline2;
                        ++n3;
                    } else {
                        this._newline2IsBuffered = true;
                    }
                }
            } else if (this._cpBuffer == 10) {
                cArray[n3] = this._newline1;
                ++n3;
                if (this._twoCharNewline) {
                    if (n3 < n4) {
                        cArray[n3] = this._newline2;
                        ++n3;
                    } else {
                        this._newline2IsBuffered = true;
                    }
                }
            } else {
                char[] cArray2 = Character.toChars(this._cpBuffer);
                cArray[n3] = cArray2[0];
                ++n3;
                if (cArray2.length == 2) {
                    if (n3 < n4) {
                        cArray[n3] = cArray2[1];
                        ++n3;
                    } else {
                        this._cpBuffer = cArray2[1];
                        this._cpIsBuffered = true;
                    }
                }
            }
        }
        while (n3 < n4) {
            if (this._charBufferHead >= this._charBufferSize) {
                if (this._charBuffer.length < n2) {
                    this._charBuffer = new char[n2];
                }
                this._charBufferSize = super.read(this._charBuffer, 0, this._charBuffer.length);
                this._charBufferHead = 0;
                if (this._charBufferSize == -1) break;
            }
            char c = this._charBuffer[this._charBufferHead];
            ++this._charBufferHead;
            if (c == '\r') {
                if (this._charBufferHead < this._charBufferSize) {
                    if (this._charBuffer[this._charBufferHead] == '\n') {
                        ++this._charBufferHead;
                    }
                } else {
                    this._charBufferSize = super.read(this._charBuffer, 0, this._charBuffer.length);
                    this._charBufferHead = 0;
                    if (this._charBufferSize > 0 && this._charBuffer[0] == '\n') {
                        this._charBufferHead = 1;
                    }
                }
                cArray[n3] = this._newline1;
                ++n3;
                if (!this._twoCharNewline) continue;
                if (n3 < n4) {
                    cArray[n3] = this._newline2;
                    ++n3;
                    continue;
                }
                this._newline2IsBuffered = true;
                continue;
            }
            if (c == '\n') {
                cArray[n3] = this._newline1;
                ++n3;
                if (!this._twoCharNewline) continue;
                if (n3 < n4) {
                    cArray[n3] = this._newline2;
                    ++n3;
                    continue;
                }
                this._newline2IsBuffered = true;
                continue;
            }
            cArray[n3] = c;
            ++n3;
        }
        if (n3 == 0) {
            return -1;
        }
        return n3;
    }
}

