/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.central.editor.SCEditor;
import com.sybase.resultSetTable.BaseCellEditor;
import com.sybase.resultSetTable.BinaryCellEditor;
import com.sybase.resultSetTable.BinaryCellRenderer;
import com.sybase.resultSetTable.BitCellEditor;
import com.sybase.resultSetTable.BitCellRenderer;
import com.sybase.resultSetTable.ClipboardFormat;
import com.sybase.resultSetTable.DateCellEditor;
import com.sybase.resultSetTable.DateCellRenderer;
import com.sybase.resultSetTable.DefaultWorkerThread;
import com.sybase.resultSetTable.EditLongValueDialog;
import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.LongTextValue;
import com.sybase.resultSetTable.LongValue;
import com.sybase.resultSetTable.LongValueButton;
import com.sybase.resultSetTable.NullAwareTableHeader;
import com.sybase.resultSetTable.NumericCellEditor;
import com.sybase.resultSetTable.NumericCellRenderer;
import com.sybase.resultSetTable.ResultSetTable;
import com.sybase.resultSetTable.ResultSetTableClient;
import com.sybase.resultSetTable.ResultSetTableModel;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.SQLGenerationException;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.resultSetTable.TextCellEditor;
import com.sybase.resultSetTable.TextCellRenderer;
import com.sybase.resultSetTable.TimeCellEditor;
import com.sybase.resultSetTable.TimeCellRenderer;
import com.sybase.resultSetTable.TimestampCellEditor;
import com.sybase.resultSetTable.TimestampCellRenderer;
import com.sybase.resultSetTable.UniqueIdentifierEditor;
import com.sybase.resultSetTable.UniqueIdentifierRenderer;
import com.sybase.resultSetTable.WorkerThread;
import com.sybase.util.Dbg;
import com.sybase.util.FileUtil;
import com.sybase.util.JREUtils;
import com.sybase.util.PrintDialog;
import com.sybase.util.SybChangeNotificationListener;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybListSelectionModel;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.WeakHashMap;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;

public class NullAwareTable
extends JTable
implements SybChangeNotificationListener,
TableColumnModelListener {
    private static final String DEFAULT_NULL_DISPLAY_STRING = "(NULL)";
    private static final String DEFAULT_VALUE_DISPLAY_STRING = "(DEFAULT)";
    protected static ClipboardOwner _defaultClipboardOwner = null;
    private static ArrayList<File> _tempFiles;
    private TableCellRenderer[] _renderers;
    private String _nullDisplayString = "(NULL)";
    private String _defaultValueDisplayString = "(DEFAULT)";
    private String _fileDisplayString = null;
    private String _imageDisplayString = null;
    private ResultSetTableModel _model;
    private ResultSetTable _resultSetTable = null;
    private LongValueButton _longValueButton;
    private int _longValueButtonRow;
    private int _longValueButtonColumn;
    private EditLongValueDialog _editLongValueDialog;
    private boolean _editingArmed = false;
    protected int _editingRow = -1;
    protected int _lastEditedRow = -1;
    protected int _lastEditedColumn = -1;
    protected int _fontType = 0;
    protected Font _customFont = null;
    private boolean _useHyphensForUUID = true;
    private boolean _sortable = false;
    private boolean _showHeaderToolTips = true;
    private boolean _mouseEditCancelled = false;
    private boolean _ignoreRowSelectionChanges;
    private boolean _ignoreUpdateButtonPosition = false;
    private boolean _updateRequired = false;
    private boolean _insertRequired = false;
    private boolean _ignoreRemoveEditor = false;
    private boolean _editable = true;
    protected ClipboardFormat _clipboardFormat = new ClipboardFormat();
    protected static final char[] _hexTable;
    SybListSelectionModel _listSelectionModel = null;
    ListSelectionModel _columnSelectionModel = null;
    private static PrinterJob _printerJob;
    private static PageFormat _pageFormat;
    private RowSorter.SortKey _sortKey = null;

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new NullAwareTableHeader(this);
    }

    NullAwareTable(ResultSetTable resultSetTable) {
        this._resultSetTable = resultSetTable;
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.setEditable(true);
        this.setGridColor(SystemColor.controlShadow);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NullAwareTable.this.isEditing()) {
                    NullAwareTable.this._resultSetTable.beginUpdate();
                }
            }
        }, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NullAwareTable.this.enterKeyPressed();
            }
        }, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NullAwareTable.this.escapeKeyPressed();
            }
        }, keyStroke, 1);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NullAwareTable.this.isEditing()) {
                    NullAwareTable.this.notifyEditorTab((actionEvent.getModifiers() & 1) != 0);
                }
            }
        };
        keyStroke = KeyStroke.getKeyStroke(9, 0);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(actionListener, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(9, 1);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(actionListener, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(65, 128);
        this.unregisterKeyboardAction(keyStroke);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NullAwareTable.this.notifySelectAll();
            }
        };
        this.registerKeyboardAction(actionListener, keyStroke, 1);
        this.setDefaultRenderer(byte[].class, new BinaryCellRenderer());
        this.setDefaultRenderer(Date.class, new DateCellRenderer());
        this.setDefaultRenderer(Time.class, new TimeCellRenderer());
        this.setDefaultRenderer(Timestamp.class, new TimestampCellRenderer());
        this.setDefaultRenderer(Number.class, new NumericCellRenderer());
        this.setDefaultRenderer(Object.class, new TextCellRenderer());
        this.setSelectionMode(0);
        this._listSelectionModel = new SybListSelectionModel();
        this._listSelectionModel.addChangeNotificationListener((SybChangeNotificationListener)this);
        this.setSelectionModel((ListSelectionModel)this._listSelectionModel);
        this._columnSelectionModel = this.getColumnModel().getSelectionModel();
        this.getColumnModel().addColumnModelListener(this);
        this.setLayout(null);
        this._longValueButton = new LongValueButton(this);
        this._longValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NullAwareTable.this._longValueButton.setEnabled(false);
                NullAwareTable.this.longValueButtonClicked();
                if (NullAwareTable.this._longValueButton == null) {
                    return;
                }
                NullAwareTable.this._longValueButton.setEnabled(true);
            }
        });
        this._longValueButton.hideFromTable();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (NullAwareTable.this._longValueButton != null) {
                    NullAwareTable.this.updateLongValueButtonPosition();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!NullAwareTable.this._editingArmed && NullAwareTable.this._longValueButton != null) {
                    NullAwareTable.this._longValueButton.hideFromTable();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePrint(boolean bl) {
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
        try {
            PageFormat pageFormat;
            PrinterJob printerJob;
            jFrame.setCursor(Cursor.getPredefinedCursor(3));
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(resultSetTableResourcesBase.get("PRINT_OPTIONS")));
            SybCheckBox sybCheckBox = new SybCheckBox(resultSetTableResourcesBase.get("PRINT_SCALE_WIDTH"));
            sybCheckBox.setSelected(true);
            SybCheckBox sybCheckBox2 = new SybCheckBox(resultSetTableResourcesBase.get("PRINT_PAGE_NUMBERS"));
            jPanel.add((Component)sybCheckBox, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)sybCheckBox2, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            PrintDialog printDialog = new PrintDialog((Frame)jFrame);
            if (_printerJob == null || _pageFormat == null) {
                printerJob = PrinterJob.getPrinterJob();
                pageFormat = printerJob.defaultPage();
            } else {
                printerJob = _printerJob;
                pageFormat = _pageFormat;
            }
            if (!bl || printDialog.showDialog(1, printerJob, pageFormat, (JComponent)jPanel)) {
                boolean bl2;
                JTable.PrintMode printMode = sybCheckBox.isSelected() ? JTable.PrintMode.FIT_WIDTH : JTable.PrintMode.NORMAL;
                MessageFormat messageFormat = sybCheckBox2.isSelected() ? new MessageFormat(resultSetTableResourcesBase.get("PRINT_FOOTER")) : null;
                PrintService printService = printerJob.getPrintService();
                HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                hashPrintRequestAttributeSet.add(new Copies(printerJob.getCopies()));
                switch (pageFormat.getOrientation()) {
                    case 0: {
                        hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
                        break;
                    }
                    case 1: {
                        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
                        break;
                    }
                    case 2: {
                        hashPrintRequestAttributeSet.add(OrientationRequested.REVERSE_LANDSCAPE);
                    }
                }
                hashPrintRequestAttributeSet.add(new JobName(jFrame.getTitle(), null));
                switch (pageFormat.getOrientation()) {
                    case 0: 
                    case 2: {
                        hashPrintRequestAttributeSet.add(new MediaPrintableArea((float)(pageFormat.getImageableX() / 72.0), (float)(pageFormat.getImageableY() / 72.0), (float)(pageFormat.getImageableHeight() / 72.0), (float)(pageFormat.getImageableWidth() / 72.0), 25400));
                        break;
                    }
                    case 1: {
                        hashPrintRequestAttributeSet.add(new MediaPrintableArea((float)(pageFormat.getImageableX() / 72.0), (float)(pageFormat.getImageableY() / 72.0), (float)(pageFormat.getImageableWidth() / 72.0), (float)(pageFormat.getImageableHeight() / 72.0), 25400));
                    }
                }
                Paper paper = pageFormat.getPaper();
                MediaSizeName mediaSizeName = MediaSize.findMedia((float)(paper.getWidth() / 72.0), (float)(paper.getHeight() / 72.0), 25400);
                if (mediaSizeName != null) {
                    hashPrintRequestAttributeSet.add(mediaSizeName);
                }
                if (bl2 = this.print(printMode, null, messageFormat, false, hashPrintRequestAttributeSet, true, printService)) {
                    _printerJob = printerJob;
                    _pageFormat = pageFormat;
                    SybOptionPane.showMessageDialog((Component)jFrame, (Object)resultSetTableResourcesBase.get("PRINTING_COMPLETED"), (String)resultSetTableResourcesBase.get("PRINT_CAPTION"), (int)1);
                } else {
                    SybOptionPane.showMessageDialog((Component)jFrame, (Object)resultSetTableResourcesBase.get("PRINTING_CANCELLED"), (String)resultSetTableResourcesBase.get("PRINT_CAPTION"), (int)2);
                }
            }
        }
        catch (PrinterException printerException) {
            SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)"PRINT_ERROR", (Object[])new Object[]{printerException.getLocalizedMessage()}), (String)resultSetTableResourcesBase.get("PRINT_CAPTION"), (int)0);
        }
        finally {
            jFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void showHeaderToolTips(boolean bl) {
        this._showHeaderToolTips = bl;
    }

    boolean isShowingHeaderToolTips() {
        return this._showHeaderToolTips;
    }

    void enterKeyPressed() {
        this._resultSetTable.completeEditing();
    }

    private void escapeKeyPressed() {
        this._resultSetTable.cancelEditing();
    }

    void setSortable(boolean bl) {
        this._sortable = bl;
    }

    boolean isSortable() {
        return this._sortable;
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.updateLongValueButtonPosition();
        this._ignoreRemoveEditor = true;
        super.columnMarginChanged(changeEvent);
        this._ignoreRemoveEditor = false;
    }

    @Override
    public void removeEditor() {
        if (!this._ignoreRemoveEditor) {
            super.removeEditor();
            this.requestFocusInWindow();
        }
    }

    private void notifySelectAll() {
        boolean bl = this._resultSetTable.fireSelectAllEvent();
        if (!bl) {
            this.selectAll();
        }
    }

    void notifyEditorTab(boolean bl) {
        int n = this.getEditingRow();
        int n2 = this.getEditingColumn();
        int n3 = this.getColumnCount();
        this.editingStopped(new ChangeEvent(this));
        if (!bl) {
            if (++n2 == n3) {
                n2 = 0;
            }
        } else if (--n2 == -1) {
            n2 = n3 - 1;
        }
        this.startEditing(n, n2);
    }

    void setResultSet(Connection connection, ResultSet resultSet, int n, String string, String string2, WorkerThread workerThread, boolean bl) {
        ResultSetTableModel resultSetTableModel = this._model;
        this._model = new ResultSetTableModel(this, connection, resultSet, n, bl);
        this._model.setOwnerAndTableNames(string, string2);
        this.setModel(this._model);
        if (workerThread == null) {
            workerThread = DefaultWorkerThread.create(this._resultSetTable);
        }
        this._model.setWorkerThread(workerThread);
        if (resultSetTableModel != null) {
            resultSetTableModel.destroy();
        }
        this._longValueButton.hideFromTable();
    }

    void setResultSet(Connection connection, ScrollableResultSet scrollableResultSet, WorkerThread workerThread) {
        ResultSetTableModel resultSetTableModel = this._model;
        int n = this._resultSetTable.getTruncationLength();
        if (n == 0) {
            n = 32768;
        }
        scrollableResultSet.setMaxClobCharacters(n);
        scrollableResultSet.setMaxBlobBytes(n);
        this._model = new ResultSetTableModel(this, connection, scrollableResultSet);
        this._model.setOwnerAndTableNames(null, null);
        this.setModel(this._model);
        if (workerThread == null) {
            workerThread = DefaultWorkerThread.create(this._resultSetTable);
        }
        this._model.setWorkerThread(workerThread);
        if (resultSetTableModel != null) {
            resultSetTableModel.destroy();
        }
        this._longValueButton.hideFromTable();
        if (scrollableResultSet.getRowCount() != -1 && ColumnWidthInfo.getColumnWidthInfo(connection, this) != null) {
            this.setInitialColumnWidths(connection);
        }
    }

    private void dbgPrintModelMetaData() {
    }

    public ResultSet getResultSet() {
        if (this._model == null) {
            return null;
        }
        return this._model.getScrollableResultSet().getJDBCResultSet();
    }

    void notifyTruncationLengthChanged(int n) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableDataChanged();
        }
    }

    void setInitialColumnWidths(Connection connection) {
        ColumnWidthInfo columnWidthInfo = ColumnWidthInfo.getColumnWidthInfo(connection, this);
        if (columnWidthInfo != null) {
            columnWidthInfo.setColumnWidths(this);
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this._model.getColumnCount();
        int n2 = this.getPreferredScrollableViewportSize().height;
        int n3 = n2 / this.getRowHeight();
        int n4 = this.getRowCount();
        int n5 = Math.min(n4, n3);
        if (n5 < 10 && n4 >= 10) {
            n5 = 10;
        }
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer = JREUtils.getTableCellRenderer((JTable)this, (int)i);
            int n6 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)i).getPreferredSize().width;
            n6 = Math.max(n6, tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)this._nullDisplayString, (boolean)false, (boolean)false, (int)0, (int)i).getPreferredSize().width);
            for (int j = 0; j < n5; ++j) {
                tableCellRenderer = this.getCellRenderer(j, i);
                Object object = this._model.getValueAt(j, i);
                if (object == null && j >= (n5 = Math.min(this.getRowCount(), 10))) break;
                int n7 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n6 = Math.max(n6, n7);
            }
            tableColumn.setPreferredWidth(n6 + 20);
        }
        this.sizeColumnsToFit(-1);
    }

    @Override
    public void setModel(TableModel tableModel) {
        this._ignoreUpdateButtonPosition = true;
        super.setModel(tableModel);
        this._ignoreUpdateButtonPosition = false;
        if (this._sortable) {
            VetoableRowSorter vetoableRowSorter = new VetoableRowSorter(tableModel);
            this.setRowSorter(vetoableRowSorter);
        }
    }

    public void destroy() {
        if (this._model != null) {
            ColumnWidthInfo.create(this._model.getConnection(), this);
            this.setModel(new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return 0;
                }

                @Override
                public int getColumnCount() {
                    return 0;
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    return null;
                }
            });
            this._model.destroy();
            this._model = null;
        }
        if (this._longValueButton != null) {
            this._longValueButton.destroy();
            this._longValueButton = null;
        }
        if (this._editLongValueDialog != null) {
            this._editLongValueDialog.destroy();
            this._editLongValueDialog = null;
        }
        if (_tempFiles != null) {
            int n = _tempFiles.size();
            for (int i = 0; i < n; ++i) {
                _tempFiles.get(i).delete();
            }
            _tempFiles.clear();
            _tempFiles = null;
        }
        this._nullDisplayString = null;
        this._defaultValueDisplayString = null;
        this._fileDisplayString = null;
        this._imageDisplayString = null;
        this._resultSetTable = null;
        this._renderers = null;
    }

    void setEditable(boolean bl) {
        this._editable = bl;
    }

    boolean isEditable() {
        if (this._model != null && this._model.isEditable()) {
            return this._editable;
        }
        return false;
    }

    File getFullColumnValue(int n, int n2) throws SQLException {
        File file;
        block48: {
            String string;
            Object object;
            ScrollableResultSet scrollableResultSet;
            OutputStream outputStream;
            BufferedWriter bufferedWriter;
            block47: {
                file = null;
                bufferedWriter = null;
                outputStream = null;
                RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
                if (rowSorter != null) {
                    n = rowSorter.convertRowIndexToModel(n);
                }
                if (!(scrollableResultSet = this._model.getScrollableResultSet()).hasPartialData()) {
                    try {
                        file = this.createTempFile();
                        object = this._model.getValueAt(n, n2);
                        if (object instanceof String) {
                            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf8"));
                            bufferedWriter.write((String)object);
                            break block47;
                        }
                        if (object instanceof byte[]) {
                            outputStream = new BufferedOutputStream(new FileOutputStream(file));
                            outputStream.write((byte[])object);
                            break block47;
                        }
                        File file2 = null;
                        return file2;
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getLocalizedMessage());
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (bufferedWriter != null) {
                            try {
                                bufferedWriter.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                object = this._model.getValueAt(n, n2);
                if (object == null) {
                    return null;
                }
            }
            if ((string = scrollableResultSet.getColumnTableName(n2)) == null || string.equals("")) {
                return null;
            }
            String string2 = this._model.composeSingleColumnSelect(n, n2);
            ResultSetTableClient resultSetTableClient = this._resultSetTable.getClient();
            Object[] objectArray = resultSetTableClient.executeRefetchSQL(this._resultSetTable, ResultSetTableClient.Operation.REFETCH_LONG_VALUE, string2);
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            object = objectArray[0];
            if (!(object instanceof Reader) && !(object instanceof InputStream)) {
                throw new IllegalArgumentException("Host returned unaccepted data type (" + object.getClass().getName() + "). " + "Was expecting Reader or InputStatement.");
            }
            try {
                int n3;
                file = this.createTempFile();
                if (object instanceof Reader) {
                    Reader reader = (Reader)object;
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf8"));
                    int n4 = 0;
                    char[] cArray = new char[4096];
                    while (true) {
                        int n5;
                        if ((n5 = reader.read(cArray)) == -1) {
                            break block48;
                        }
                        n4 += n5;
                        bufferedWriter.write(cArray, 0, n5);
                    }
                }
                InputStream inputStream = (InputStream)object;
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n6 = 0;
                byte[] byArray = new byte[4096];
                while ((n3 = inputStream.read(byArray)) != -1) {
                    n6 += n3;
                    outputStream.write(byArray, 0, n3);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getLocalizedMessage());
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return file;
    }

    File createTempFile() throws IOException {
        File file = FileUtil.createSecureTempFile((String)"rst", null);
        file.deleteOnExit();
        if (_tempFiles == null) {
            _tempFiles = new ArrayList();
        }
        _tempFiles.add(file);
        return file;
    }

    Object getLongValueAt(int n, int n2, int n3) {
        Object object = this.getValueAt(n, n2);
        if (NullAwareTable.canTypeHaveLongBinaryValues(n3) || NullAwareTable.canTypeHaveLongTextValues(n3)) {
            int n4;
            ScrollableResultSet scrollableResultSet = this._model.getScrollableResultSet();
            if (object instanceof String) {
                int n5 = scrollableResultSet.getMaxClobCharacters();
                object = new LongTextValue((String)object, n5, this, false);
            } else if (scrollableResultSet.hasPartialData() && object instanceof byte[] && ((byte[])object).length >= (n4 = scrollableResultSet.getMaxBlobBytes())) {
                object = new LongBinaryValue((byte[])object, n4);
            }
        }
        return object;
    }

    void deleteRows() {
        int n;
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = rowSorter.convertRowIndexToModel(nArray[n]);
            }
        }
        ResultSetTableClient resultSetTableClient = this._resultSetTable.getClient();
        ResultSetTableClient.Operation operation = nArray.length > 1 ? ResultSetTableClient.Operation.MULTIPLE_DELETE : ResultSetTableClient.Operation.DELETE;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            try {
                String string = this._model.composeDeleteStatement(nArray[n]);
                ResultSetTableClient.NextAction nextAction = resultSetTableClient.executeSQL(this._resultSetTable, operation, string, null, null);
                if (nextAction == ResultSetTableClient.NextAction.CANCEL_ALL) break;
                if (nextAction == ResultSetTableClient.NextAction.CANCEL) continue;
                arrayList.add(nArray[n]);
                continue;
            }
            catch (SQLException sQLException) {
                ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
                SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)SybMessageFormat.format((String)resultSetTableResourcesBase.get("COULD_NOT_DELETE_ROW"), (Object[])new Object[]{sQLException.getLocalizedMessage()}), (String)resultSetTableResourcesBase.get("DELETE_ROW_TITLE"), (int)0);
                break;
            }
        }
        if (arrayList.size() > 0) {
            this._model.removeRowsFromModel(arrayList);
        }
    }

    private void enableSorting(boolean bl) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null && rowSorter instanceof VetoableRowSorter) {
            ((VetoableRowSorter)rowSorter).setEnabled(bl);
        }
    }

    void startInsert(int n) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(null);
        }
        if (n == -1) {
            n = this.getSelectedRow();
            n = n == -1 ? -2 : ++n;
        }
        this._editingArmed = true;
        this.enableSorting(false);
        int n2 = this._model.startInsert(n);
        if (n2 != -1) {
            this._ignoreRowSelectionChanges = true;
            this.clearSelection();
            this._ignoreRowSelectionChanges = false;
            this.setEditingRow(n2);
            this._editingRow = n2;
            this.scrollRectToVisible(this.getCellRect(n2, 0, true));
            boolean bl = false;
            int n3 = this.getModel().getColumnCount();
            for (int i = 0; i < n3; ++i) {
                this.setEditingColumn(i);
                bl = this.editCellAt(n2, i);
                if (bl) break;
            }
            if (!bl) {
                // empty if block
            }
        } else {
            this._editingArmed = false;
        }
    }

    void setNullDisplayString(String string) {
        this._nullDisplayString = string == null ? DEFAULT_NULL_DISPLAY_STRING : string;
        if (this._model != null) {
            this._model.fireTableDataChanged();
        }
    }

    String getNullDisplayString() {
        return this._nullDisplayString;
    }

    void setDefaultValueDisplayString(String string) {
        this._defaultValueDisplayString = string == null ? DEFAULT_VALUE_DISPLAY_STRING : string;
        if (this._model != null) {
            this._model.fireTableDataChanged();
        }
    }

    String getDefaultValueDisplayString() {
        return this._defaultValueDisplayString;
    }

    String getFileDisplayString() {
        if (this._fileDisplayString == null) {
            this._fileDisplayString = ResultSetTableResourcesBase.getBundle().getString("FILE_DISPLAY_STRING");
        }
        return this._fileDisplayString;
    }

    String getImageDisplayString() {
        if (this._imageDisplayString == null) {
            this._imageDisplayString = ResultSetTableResourcesBase.getBundle().getString("IMAGE_DISPLAY_STRING");
        }
        return this._imageDisplayString;
    }

    @Override
    public void createDefaultColumnsFromModel() {
        int n = this.getModel().getColumnCount();
        this._renderers = new TableCellRenderer[n];
        super.createDefaultColumnsFromModel();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this._renderers[n2] == null) {
            TableCellRenderer tableCellRenderer;
            int n3 = this._model.getColumnType(n2);
            switch (n3) {
                case -7: {
                    tableCellRenderer = new BitCellRenderer();
                    break;
                }
                case 2: 
                case 3: {
                    int n4 = this._model.getColumnPrecision(n2);
                    int n5 = this._model.getColumnScale(n2);
                    tableCellRenderer = new NumericCellRenderer(n4, n5);
                    break;
                }
                case 7: {
                    tableCellRenderer = new NumericCellRenderer(n3);
                    break;
                }
                case 6: 
                case 8: {
                    tableCellRenderer = new NumericCellRenderer(n3);
                    break;
                }
                case -3: {
                    String string = this._model.getColumnTypeName(n2);
                    if (string != null && string.equalsIgnoreCase("uniqueidentifier")) {
                        tableCellRenderer = new UniqueIdentifierRenderer(this._useHyphensForUUID);
                        break;
                    }
                    tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
                    break;
                }
                default: {
                    tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
                }
            }
            this._renderers[n2] = tableCellRenderer;
        }
        return this._renderers[n2];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._editable && this._editingArmed && this._model != null && this._model.isEditable() && super.isCellEditable(n, n2);
    }

    boolean isInserting() {
        return this._model != null && this._model.isInserting();
    }

    boolean startEditing(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, true);
        this.scrollRectToVisible(rectangle);
        this._editingArmed = true;
        if (this.isCellEditable(n, n2)) {
            this.enableSorting(false);
            this.setRowSelectionInterval(n, n);
            this.setColumnSelectionInterval(n2, n2);
            this.setEditingRow(n);
            this.setEditingColumn(n2);
            this._editingRow = n;
            this.editCellAt(n, n2, null);
        } else {
            this._editingArmed = false;
            Toolkit.getDefaultToolkit().beep();
        }
        return this._editingArmed;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl;
        if (this._resultSetTable.getCurrentEditingOperation() != ResultSetTableClient.Operation.NONE && this._lastEditedRow != -1 && this._lastEditedRow != n && !(bl = this._resultSetTable.completeEditing())) {
            return false;
        }
        this._lastEditedRow = n;
        this._lastEditedColumn = n2;
        bl = super.editCellAt(n, n2, eventObject);
        if (bl) {
            this._ignoreRowSelectionChanges = true;
            this.setRowSelectionInterval(n, n);
            this._ignoreRowSelectionChanges = false;
            Component component = this.getEditorComponent();
            if (component != null) {
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                component.requestFocusInWindow();
            }
        }
        return bl;
    }

    int getLastEditedRow() {
        return this._lastEditedRow;
    }

    int getLastEditedColumn() {
        return this._lastEditedColumn;
    }

    boolean stopEditing() {
        boolean bl;
        int n;
        int n2;
        if (this.isEditing()) {
            n2 = this.getEditingColumn();
            n = this.getEditingRow();
            TableCellEditor tableCellEditor = this.getCellEditor();
            bl = tableCellEditor.stopCellEditing();
            if (!bl) {
                return false;
            }
        } else {
            n2 = 1;
            n = -1;
        }
        ResultSetTableClient.Operation operation = this._resultSetTable.getCurrentEditingOperation();
        ResultSetTableClient resultSetTableClient = this._resultSetTable.getClient();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (operation == ResultSetTableClient.Operation.UPDATE) {
            if (this._model.isEditRowDirty()) {
                Object[] objectArray;
                int n3;
                int[] nArray;
                String string;
                RowSorter<? extends TableModel> rowSorter;
                if (n == -1) {
                    n = this._model.getUpdateRow();
                }
                if ((rowSorter = this.getRowSorter()) != null) {
                    n = rowSorter.convertRowIndexToModel(n);
                }
                try {
                    string = this._model.composeUpdateStatement(arrayList, arrayList2, n);
                }
                catch (SQLException sQLException) {
                    ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
                    SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)resultSetTableResourcesBase.getFormatted("ERR_COULD_NOT_UPDATE", sQLException.getLocalizedMessage()), (String)resultSetTableResourcesBase.get("UPDATE_ROW_TITLE"), (int)0);
                    return false;
                }
                if (arrayList2.size() > 0) {
                    nArray = new int[arrayList2.size()];
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        nArray[n3] = arrayList2.get(n3);
                    }
                    objectArray = arrayList.toArray();
                } else {
                    nArray = null;
                    objectArray = null;
                }
                this._resultSetTable.setCursor(Cursor.getPredefinedCursor(3));
                ResultSetTableClient.NextAction nextAction = resultSetTableClient.executeSQL(this._resultSetTable, ResultSetTableClient.Operation.UPDATE, string, objectArray, nArray);
                if (objectArray != null) {
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        try {
                            if (objectArray[n3] instanceof InputStream) {
                                ((InputStream)objectArray[n3]).close();
                                continue;
                            }
                            if (!(objectArray[n3] instanceof Reader)) continue;
                            ((Reader)objectArray[n3]).close();
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (nextAction == ResultSetTableClient.NextAction.CANCEL) {
                    this.cancelEditing();
                } else if (nextAction == ResultSetTableClient.NextAction.RETRY) {
                    this.editCellAt(n, n2);
                } else {
                    try {
                        string = this._model.composeRefetchStatement(false);
                        Object[] objectArray2 = resultSetTableClient.executeRefetchSQL(this._resultSetTable, ResultSetTableClient.Operation.REFETCH_AFTER_UPDATE, string);
                        if (objectArray2 != null) {
                            this._model.updateCachedRow(ResultSetTableClient.Operation.UPDATE, n, objectArray2);
                        }
                    }
                    catch (SQLException sQLException) {
                        this._resultSetTable.fireResultSetTableExceptionEvent(sQLException);
                    }
                }
                this._resultSetTable.setCursor(null);
            } else {
                this.cancelEditing();
            }
        } else if (operation == ResultSetTableClient.Operation.INSERT) {
            Object[] objectArray;
            int n4;
            int[] nArray;
            String string = this._model.composeInsertStatement(arrayList, arrayList2);
            if (arrayList2.size() > 0) {
                nArray = new int[arrayList2.size()];
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    nArray[n4] = arrayList2.get(n4);
                }
                objectArray = arrayList.toArray();
            } else {
                nArray = null;
                objectArray = null;
            }
            if (n == -1) {
                n = this._model.getInsertRow();
            }
            this._resultSetTable.setCursor(Cursor.getPredefinedCursor(3));
            ResultSetTableClient.NextAction nextAction = resultSetTableClient.executeSQL(this._resultSetTable, ResultSetTableClient.Operation.INSERT, string.toString(), objectArray, nArray);
            if (objectArray != null) {
                for (n4 = 0; n4 < objectArray.length; ++n4) {
                    try {
                        if (objectArray[n4] instanceof InputStream) {
                            ((InputStream)objectArray[n4]).close();
                            continue;
                        }
                        if (!(objectArray[n4] instanceof Reader)) continue;
                        ((Reader)objectArray[n4]).close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (nextAction == ResultSetTableClient.NextAction.CANCEL) {
                this.cancelEditing();
            } else if (nextAction == ResultSetTableClient.NextAction.RETRY) {
                this.editCellAt(n, n2);
            } else {
                try {
                    string = this._model.composeRefetchStatement(true);
                    Object[] objectArray3 = resultSetTableClient.executeRefetchSQL(this._resultSetTable, ResultSetTableClient.Operation.REFETCH_AFTER_INSERT, string);
                    this._ignoreRowSelectionChanges = true;
                    this._model.updateCachedRow(ResultSetTableClient.Operation.INSERT, n, objectArray3);
                    this._ignoreRowSelectionChanges = false;
                }
                catch (SQLException sQLException) {
                    this._resultSetTable.fireResultSetTableExceptionEvent(sQLException);
                }
            }
            this._resultSetTable.setCursor(null);
        }
        boolean bl2 = bl = !this.isEditing();
        if (bl) {
            this.enableSorting(true);
            this._editingArmed = false;
            this._lastEditedRow = -1;
            this.updateLongValueButtonPosition();
        }
        return bl;
    }

    void cancelEditing() {
        int n = this._editingRow;
        if (this.isEditing()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
        this._ignoreRowSelectionChanges = true;
        ResultSetTableClient.Operation operation = this._resultSetTable.getCurrentEditingOperation();
        if (operation == ResultSetTableClient.Operation.UPDATE) {
            this._model.cancelUpdate();
        } else if (operation == ResultSetTableClient.Operation.INSERT) {
            this._model.cancelInsertion();
            if (--n < 0) {
                n = 0;
            }
            if (n >= 0 && n < this.getRowCount()) {
                this.setRowSelectionInterval(n, n);
            }
        }
        this._ignoreRowSelectionChanges = false;
        this._insertRequired = false;
        this._updateRequired = false;
        this._editingArmed = false;
        this._editingRow = -1;
        this.enableSorting(true);
        this.updateLongValueButtonPosition();
        this.fireNotificationEvent(6);
    }

    void generateInsertStatements(int[] nArray) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";\n");
                }
                int n = nArray[i];
                if (rowSorter != null) {
                    n = rowSorter.convertRowIndexToModel(n);
                }
                this._model.composeInsertStatementForRow(stringBuilder, n);
            }
            this.saveStringToClipboard(stringBuilder.toString());
            SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)resultSetTableResourcesBase.getFormatted("INSERT_STATEMENT_GENERATED", Integer.toString(nArray.length)), (String)resultSetTableResourcesBase.get("GENERATE_INSERT_STATEMENT_CAPTION"), (int)1);
        }
        catch (SQLGenerationException sQLGenerationException) {
            SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)resultSetTableResourcesBase.getFormatted("ERR_COULD_NOT_GENERATE_INSERT_STATEMENT", sQLGenerationException.getLocalizedMessage()), (String)resultSetTableResourcesBase.get("GENERATE_INSERT_STATEMENT_CAPTION"), (int)0);
        }
    }

    void generateUpdateStatements(int[] nArray) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";\n");
                }
                int n = nArray[i];
                if (rowSorter != null) {
                    n = rowSorter.convertRowIndexToModel(n);
                }
                this._model.composeUpdateStatement(stringBuilder, n);
            }
            this.saveStringToClipboard(stringBuilder.toString());
            SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)resultSetTableResourcesBase.getFormatted("UPDATE_STATEMENT_GENERATED", Integer.toString(nArray.length)), (String)resultSetTableResourcesBase.get("GENERATE_UPDATE_STATEMENT_CAPTION"), (int)1);
        }
        catch (SQLGenerationException sQLGenerationException) {
            SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)resultSetTableResourcesBase.getFormatted("ERR_COULD_NOT_GENERATE_UPDATE_STATEMENT", sQLGenerationException.getLocalizedMessage()), (String)resultSetTableResourcesBase.get("GENERATE_UPDATE_STATEMENT_CAPTION"), (int)0);
        }
    }

    void generateDeleteStatement(int[] nArray) {
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";\n");
                }
                int n = nArray[i];
                if (rowSorter != null) {
                    n = rowSorter.convertRowIndexToModel(n);
                }
                stringBuilder.append(this._model.composeDeleteStatement(n));
            }
            this.saveStringToClipboard(stringBuilder.toString());
            SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)resultSetTableResourcesBase.getFormatted("DELETE_STATEMENT_GENERATED", Integer.toString(nArray.length)), (String)resultSetTableResourcesBase.get("GENERATE_DELETE_STATEMENT_CAPTION"), (int)1);
        }
        catch (SQLException sQLException) {
            SybOptionPane.showMessageDialog((Component)SwingUtilities.getWindowAncestor(this), (Object)resultSetTableResourcesBase.getFormatted("ERR_COULD_NOT_GENERATE_DELETE_STATEMENT", sQLException.getLocalizedMessage()), (String)resultSetTableResourcesBase.get("GENERATE_DELETE_STATEMENT_CAPTION"), (int)0);
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
        if (!this._updateRequired && this._model.isEditing()) {
            this._updateRequired = true;
        } else if (!this._insertRequired && this._model.isInserting()) {
            this._insertRequired = true;
        }
    }

    @Override
    protected void createDefaultEditors() {
        super.createDefaultEditors();
        this.setDefaultEditor(Time.class, new TimeCellEditor());
        this.setDefaultEditor(Date.class, new DateCellEditor());
        this.setDefaultEditor(Timestamp.class, new TimestampCellEditor());
        this.setDefaultEditor(Number.class, new NumericCellEditor());
        this.setDefaultEditor(Boolean.class, new BitCellEditor());
        this.setDefaultEditor(byte[].class, new BinaryCellEditor());
        this.setDefaultEditor(Object.class, new TextCellEditor());
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        String string = this._model.getColumnTypeName(n2);
        TableCellEditor tableCellEditor = string.equalsIgnoreCase("uniqueidentifier") ? new UniqueIdentifierEditor(this._useHyphensForUUID) : super.getCellEditor(n, n2);
        return tableCellEditor;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        int n3 = this._model.getColumnType(n2);
        Object object = this.getLongValueAt(n, n2, n3);
        if (n3 == 91 || n3 == 92 || n3 == 93) {
            try {
                object = this._model.getScrollableResultSet().convertDateTimeValue(n2, object);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        boolean bl = this.isCellSelected(n, n2);
        Component component = tableCellEditor.getTableCellEditorComponent(this, object, bl, n, n2);
        return component;
    }

    void copyCell() {
        int n;
        int n2 = this.getSelectedRow();
        if (n2 != -1 && (n = this.getSelectedColumn()) != -1) {
            String string;
            Object object = this.getValueAt(n2, n);
            if (object == null) {
                string = this._nullDisplayString;
            } else if (object instanceof byte[]) {
                string = BinaryCellEditor.blobToString((byte[])object, ((byte[])object).length);
            } else if (object instanceof LongBinaryValue) {
                byte[] byArray = ((LongBinaryValue)object).getTruncatedValue();
                string = BinaryCellEditor.blobToString(byArray, byArray.length);
            } else {
                string = object.toString();
            }
            this.saveStringToClipboard(string);
        }
    }

    private void saveStringToClipboard(String string) {
        if (_defaultClipboardOwner == null) {
            _defaultClipboardOwner = new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            };
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, _defaultClipboardOwner);
    }

    void copyColumn(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.getColumnName(n));
            stringBuilder.append('\n');
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string;
                Object object = this.getValueAt(i, n);
                if (object == null) {
                    string = this._nullDisplayString;
                } else {
                    if (object instanceof LongBinaryValue) {
                        object = ((LongBinaryValue)object).getTruncatedValue();
                    }
                    string = object instanceof byte[] ? BinaryCellEditor.blobToString((byte[])object, ((byte[])object).length) : object.toString();
                }
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            this.saveStringToClipboard(stringBuilder.toString());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            stringBuilder.setLength(0);
            stringBuilder = null;
            System.gc();
            ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
            SybOptionPane.showMessageDialog((Component)((JFrame)SwingUtilities.getWindowAncestor(this)), (Object)resultSetTableResourcesBase.get("ERR_NOT_ENOUGH_MEMORY_TO_COPY"), (String)resultSetTableResourcesBase.get("COPY_CAPTION"), (int)0);
        }
    }

    public void copy() {
        int n;
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = rowSorter.convertRowIndexToModel(nArray[n]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (this._clipboardFormat.copyWithHeader) {
                int n2 = this._model.getColumnCount();
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuilder.append(this._clipboardFormat.columnDelimiter);
                    }
                    stringBuilder.append(this._model.getColumnName(n));
                }
                stringBuilder.append("\n");
            }
            for (n = 0; n < nArray.length; ++n) {
                this.formatRow(stringBuilder, nArray[n]);
                stringBuilder.append("\n");
            }
            this.saveStringToClipboard(stringBuilder.toString());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            stringBuilder.setLength(0);
            stringBuilder = null;
            System.gc();
            ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
            SybOptionPane.showMessageDialog((Component)((JFrame)SwingUtilities.getWindowAncestor(this)), (Object)resultSetTableResourcesBase.get("ERR_NOT_ENOUGH_MEMORY_TO_COPY"), (String)resultSetTableResourcesBase.get("COPY_CAPTION"), (int)0);
        }
    }

    protected void formatRow(StringBuilder stringBuilder, int n) {
        int n2 = this._model.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(this._clipboardFormat.columnDelimiter);
            }
            if ((object = this._model.getValueAt(n, i)) == null) continue;
            if (object instanceof LongBinaryValue) {
                object = ((LongBinaryValue)object).getTruncatedValue();
            }
            if (object instanceof byte[]) {
                if (this._clipboardFormat.formatBinaryAsHex) {
                    NullAwareTable.formatBinaryValue(stringBuilder, (byte[])object);
                    continue;
                }
                object = new String((byte[])object);
            }
            boolean bl = this._clipboardFormat.quoteAllValues || object instanceof String;
            String string = object.toString();
            if (this._clipboardFormat.maxValueLength != 0 && string.length() > this._clipboardFormat.maxValueLength) {
                string = string.substring(0, this._clipboardFormat.maxValueLength);
            }
            NullAwareTable.formatString(stringBuilder, string, bl, this._clipboardFormat.quoteString, this._clipboardFormat.escapeChar);
        }
    }

    static void formatBinaryValue(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.ensureCapacity(stringBuilder.length() + byArray.length * 2 + 2);
        if (byArray.length > 0) {
            stringBuilder.append("0x");
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] >> 4 & 0xF;
                int n2 = byArray[i] & 0xF;
                stringBuilder.append(_hexTable[n]);
                stringBuilder.append(_hexTable[n2]);
            }
        }
    }

    static void formatString(StringBuilder stringBuilder, String string, boolean bl, String string2, char c) {
        stringBuilder.ensureCapacity(stringBuilder.length() + string.length());
        boolean bl2 = bl && string2.length() == 1;
        char c2 = bl2 ? string2.charAt(0) : (char)'\u0000';
        if (bl) {
            stringBuilder.append(string2);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (NullAwareTable.isPrintableASCII((char)n2)) {
                if (bl2 && n2 == c2) {
                    stringBuilder.append(c2);
                    stringBuilder.append(c2);
                    continue;
                }
                if (n2 == c) {
                    stringBuilder.append(c);
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append((char)n2);
                continue;
            }
            stringBuilder.append(c);
            int n3 = n2;
            if (n3 < -1) {
                n3 += 65536;
            }
            if (n3 < 256) {
                stringBuilder.append("x");
                stringBuilder.append(_hexTable[n3 >> 4 & 0xF]);
                stringBuilder.append(_hexTable[n3 & 0xF]);
                continue;
            }
            stringBuilder.append("u");
            stringBuilder.append(_hexTable[n3 >> 12 & 0xF]);
            stringBuilder.append(_hexTable[n3 >> 8 & 0xF]);
            stringBuilder.append(_hexTable[n3 >> 4 & 0xF]);
            stringBuilder.append(_hexTable[n3 & 0xF]);
        }
        if (bl) {
            stringBuilder.append(string2);
        }
    }

    private static boolean isPrintableASCII(char c) {
        int n = Character.getType(c);
        return n != 15 && n != 13 && n != 0;
    }

    void setClipboardFormat(ClipboardFormat clipboardFormat) {
        this._clipboardFormat = clipboardFormat == null ? new ClipboardFormat() : clipboardFormat;
    }

    ClipboardFormat getClipboardFormat() {
        return this._clipboardFormat;
    }

    void notifyEndOfResultSet() {
        if (this._model != null) {
            this._model.notifyEndOfResultSet();
        }
    }

    void readRowData() {
        if (this._model == null) {
            throw new IllegalStateException("Table has no model");
        }
        if (this._model != null) {
            this._model.readRowData();
        }
    }

    void fireNotificationEvent(int n) {
        if (this._resultSetTable != null) {
            this._resultSetTable.fireNotificationEvent(n);
        }
    }

    ResultSetTable getResultSetTable() {
        return this._resultSetTable;
    }

    void setFont(int n, Font font) {
        Font font2 = null;
        if (n != this._fontType || n == 2 && font != this._customFont) {
            this._fontType = n;
            if (n == 2) {
                this._customFont = font;
                font2 = font;
            } else if (n == 0) {
                JTable jTable = new JTable();
                font2 = jTable.getFont();
            } else {
                SCEditor sCEditor = new SCEditor();
                font2 = sCEditor.getFont();
            }
            if (font2 != null) {
                this.setFont(font2);
                JTableHeader jTableHeader = this.getTableHeader();
                if (jTableHeader != null) {
                    jTableHeader.setFont(font2);
                }
                if (this._renderers != null) {
                    for (int i = 0; i < this._renderers.length; ++i) {
                        Component component;
                        TableCellRenderer tableCellRenderer = this._renderers[i];
                        if (tableCellRenderer == null || (component = tableCellRenderer.getTableCellRendererComponent(this, null, false, false, 0, 0)) == null || !(component instanceof JComponent)) continue;
                        ((JComponent)component).setFont(font2);
                    }
                }
            }
        }
    }

    boolean dbgEnabled() {
        return ResultSetTable.dbgEnabled("+Table") || Dbg.isMessageTypeEnabled((String)(NullAwareTable.class.getName() + "." + "+Table"));
    }

    @Override
    public int[] getSelectedRows() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = this.getRowCount();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n2 >= n) {
            int n3 = listSelectionModel.getLeadSelectionIndex();
            int n4 = listSelectionModel.getAnchorSelectionIndex();
            listSelectionModel.setSelectionInterval(n4, n3);
        }
        int[] nArray = super.getSelectedRows();
        return nArray;
    }

    void setShowUUIDWithHyphens(boolean bl) {
        this._useHyphensForUUID = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void longValueButtonClicked() {
        Object object = null;
        File file = null;
        if (this._model == null) {
            throw new IllegalStateException("Table has no model");
        }
        if (this._longValueButton.isHidden()) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (this._editLongValueDialog == null) {
            this._editLongValueDialog = new EditLongValueDialog(this, window);
        }
        int n = this._longValueButton.getRow();
        int n2 = this._longValueButton.getColumn();
        int n3 = this._model.getColumnType(n2);
        boolean bl = BaseCellEditor.shouldShowNullOption(n2, this._model);
        boolean bl2 = BaseCellEditor.shouldShowDefaultOption(n2, this._model);
        object = this._editingArmed ? this._longValueButton.getCellEditor().getCellEditorValue() : this.getLongValueAt(n, n2, n3);
        if (NullAwareTable.canTypeHaveLongBinaryValues(n3)) {
            boolean bl3;
            if (object != null && object instanceof LongValue && ((LongValue)object).needsFullValueFile()) {
                this._resultSetTable.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ResultSetTableResourcesBase resultSetTableResourcesBase;
                    int n4;
                    file = this.getFullColumnValue(n, n2);
                    if (file == null && (n4 = SybOptionPane.showConfirmDialog((Component)window, (Object)(resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle()).get("ERR_CANT_READ_LONG_VALUE"), (String)resultSetTableResourcesBase.get("REFETCH_LONG_VALUE_TITLE"), (int)0, (int)2)) == 1) {
                        return;
                    }
                    ((LongValue)object).setFile(file);
                }
                catch (SQLException sQLException) {
                }
                finally {
                    this._resultSetTable.setCursor(null);
                }
            }
            if (bl3 = this._editLongValueDialog.showBinaryDialog(object, this.getColumnName(n2), this._editingArmed, bl, bl2)) {
                int n5;
                object = this._editLongValueDialog.getModifiedObject();
                if (object instanceof byte[] && ((byte[])object).length > (n5 = this._model.getScrollableResultSet().getMaxBlobBytes())) {
                    object = new LongBinaryValue((byte[])object, n5, this, true);
                }
                this._longValueButton.getCellEditor().modifyCellEditorValue(object);
            }
        } else if (NullAwareTable.canTypeHaveLongTextValues(n3)) {
            if (object != null && object instanceof LongValue && ((LongValue)object).needsFullValueFile()) {
                this._resultSetTable.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    file = this.getFullColumnValue(n, n2);
                    if (file == null) {
                        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
                        int n6 = SybOptionPane.showConfirmDialog((Component)window, (Object)resultSetTableResourcesBase.get("ERR_CANT_READ_LONG_VALUE"), (String)resultSetTableResourcesBase.get("REFETCH_LONG_VALUE_TITLE"), (int)0, (int)2);
                        if (n6 == 1) {
                            return;
                        }
                    } else {
                        ((LongValue)object).setFile(file);
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    this._resultSetTable.setCursor(null);
                }
            }
            boolean bl4 = this._model.getColumnTypeName(n2).equalsIgnoreCase("xml");
            boolean bl5 = this._editLongValueDialog.showTextDialog(object, this.getColumnName(n2), this._editingArmed, bl, bl2, bl4);
            if (bl5) {
                object = this._editLongValueDialog.getModifiedObject();
                if (object instanceof String) {
                    int n7 = this._model.getScrollableResultSet().getMaxClobCharacters();
                    if (((String)object).length() > n7) {
                        object = new LongTextValue((String)object, n7, this, true);
                    }
                }
                this._longValueButton.getCellEditor().modifyCellEditorValue(object);
            }
        }
    }

    boolean canColumnHaveLongValues(int n) {
        if (this._model == null) {
            throw new IllegalStateException("Table has no model");
        }
        int n2 = this._model.getColumnType(n);
        return NullAwareTable.canTypeHaveLongBinaryValues(n2) || NullAwareTable.canTypeHaveLongTextValues(n2);
    }

    private static boolean canClassHaveLongValues(Class clazz) {
        return clazz == String.class || clazz == byte[].class;
    }

    private static boolean canTypeHaveLongBinaryValues(int n) {
        return n == -2 || n == -3 || n == -4;
    }

    private static boolean canTypeHaveLongTextValues(int n) {
        return n == 1 || n == 12 || n == -1 || n == -15 || n == -9 || n == -16 || n == 2009;
    }

    private void updateLongValueButtonPosition() {
        if (!this._editingArmed && !this._ignoreUpdateButtonPosition) {
            int n = this._listSelectionModel.getLeadSelectionIndex();
            int n2 = this._columnSelectionModel.getLeadSelectionIndex();
            if (n >= 0 && n2 >= 0) {
                if (this.canColumnHaveLongValues(n2) && this.hasFocus() && (this.getSelectedRowCount() >= 1 || this.getSelectedColumnCount() >= 1)) {
                    this._longValueButton.moveToTableCell(n, n2);
                } else {
                    this._longValueButton.hideFromTable();
                }
            }
        }
    }

    LongValueButton getLongValueButton() {
        return this._longValueButton;
    }

    public boolean notifyChange(ChangeEvent changeEvent) {
        ResultSetTableClient.Operation operation;
        boolean bl = true;
        if (!(this._ignoreRowSelectionChanges || this._listSelectionModel.getValueIsAdjusting() || !this._listSelectionModel.isSelectionChanging() || (operation = this._resultSetTable.getCurrentEditingOperation()) != ResultSetTableClient.Operation.UPDATE && operation != ResultSetTableClient.Operation.INSERT || this._resultSetTable.completeEditing())) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateLongValueButtonPosition();
        super.valueChanged(listSelectionEvent);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.updateLongValueButtonPosition();
        super.columnSelectionChanged(listSelectionEvent);
    }

    static {
        _hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        _printerJob = null;
        _pageFormat = null;
    }

    class VetoableRowSorter
    extends TableRowSorter<TableModel> {
        private boolean _requiresConfirmation;
        private boolean _allowSort;
        private boolean _enabled;

        VetoableRowSorter(TableModel tableModel) {
            super(tableModel);
            this._requiresConfirmation = true;
            this._allowSort = true;
            this._enabled = true;
            LongValueComparator longValueComparator = null;
            int n = tableModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = tableModel.getColumnClass(i);
                if (!NullAwareTable.canClassHaveLongValues(clazz)) continue;
                if (longValueComparator == null) {
                    longValueComparator = new LongValueComparator();
                }
                this.setComparator(i, longValueComparator);
            }
        }

        @Override
        public void sort() {
            if (this.shouldDoSort()) {
                super.sort();
            }
        }

        @Override
        public void toggleSortOrder(int n) {
            if (this.shouldDoSort()) {
                super.toggleSortOrder(n);
            }
        }

        private boolean shouldDoSort() {
            List<RowSorter.SortKey> list;
            if (!this._enabled) {
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
            if (this._requiresConfirmation && (list = this.getSortKeys()) != null && list.size() > 0) {
                this._requiresConfirmation = false;
                RowSorter.SortKey sortKey = list.get(0);
                if (NullAwareTable.this._sortKey != null) {
                    if (NullAwareTable.this._sortKey.getColumn() == sortKey.getColumn()) {
                        if (NullAwareTable.this._sortKey.getSortOrder() == SortOrder.ASCENDING) {
                            NullAwareTable.this._sortKey = new RowSorter.SortKey(sortKey.getColumn(), SortOrder.DESCENDING);
                        } else {
                            NullAwareTable.this._sortKey = new RowSorter.SortKey(sortKey.getColumn(), SortOrder.ASCENDING);
                        }
                    } else {
                        NullAwareTable.this._sortKey = sortKey;
                    }
                } else {
                    NullAwareTable.this._sortKey = sortKey;
                }
                boolean bl = NullAwareTable.this._resultSetTable.fireSortEvent(NullAwareTable.this._sortKey);
                boolean bl2 = this._allowSort = !bl;
                if (this._allowSort) {
                    NullAwareTable.this._sortKey = null;
                }
            }
            return this._allowSort;
        }

        void setEnabled(boolean bl) {
            this._enabled = bl;
        }
    }

    static class LongValueComparator
    implements Comparator<Object> {
        private static Collator _collator = null;

        LongValueComparator() {
            if (_collator == null) {
                _collator = Collator.getInstance();
            }
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                String string = (String)object;
                if (object2 instanceof String) {
                    return _collator.compare(string, (String)object2);
                }
                if (object2 instanceof LongTextValue) {
                    String string2 = ((LongTextValue)object2).getTruncatedValue();
                    return _collator.compare(string, string2);
                }
                throw new IllegalArgumentException("Can't compare a String to a " + object2.getClass().getName());
            }
            if (object instanceof LongTextValue) {
                String string = ((LongTextValue)object).getTruncatedValue();
                if (object2 instanceof String) {
                    return _collator.compare(string, (String)object2);
                }
                if (object2 instanceof LongTextValue) {
                    String string3 = ((LongTextValue)object2).getTruncatedValue();
                    return _collator.compare(string, string3);
                }
                throw new IllegalArgumentException("Can't compare a LongTextValue to a " + object2.getClass().getName());
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (object2 instanceof byte[]) {
                    return this.compareByteArrays(byArray, (byte[])object2);
                }
                if (object2 instanceof LongBinaryValue) {
                    byte[] byArray2 = ((LongBinaryValue)object2).getTruncatedValue();
                    return this.compareByteArrays(byArray, byArray2);
                }
                throw new IllegalArgumentException("Can't compare a byte[] to a " + object2.getClass().getName());
            }
            if (object instanceof LongBinaryValue) {
                byte[] byArray = ((LongBinaryValue)object).getTruncatedValue();
                if (object2 instanceof byte[]) {
                    return this.compareByteArrays(byArray, (byte[])object2);
                }
                if (object2 instanceof LongBinaryValue) {
                    byte[] byArray3 = ((LongBinaryValue)object2).getTruncatedValue();
                    return this.compareByteArrays(byArray, byArray3);
                }
                throw new IllegalArgumentException("Can't compare a LongBinaryValue to a " + object2.getClass().getName());
            }
            throw new IllegalArgumentException("Can't compare a " + object.getClass().getName());
        }

        private int compareByteArrays(byte[] byArray, byte[] byArray2) {
            int n;
            if (byArray == null && byArray2 == null) {
                n = 0;
            } else if (byArray == null && byArray2 != null) {
                n = -1;
            } else if (byArray != null && byArray2 == null) {
                n = 1;
            } else {
                n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    int n2;
                    if (i >= byArray2.length) {
                        n = 1;
                        break;
                    }
                    int n3 = byArray[i];
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    if ((n2 = byArray2[i]) < 0) {
                        n2 += 256;
                    }
                    if (n3 < n2) {
                        n = -1;
                        break;
                    }
                    if (n3 <= n2) continue;
                    n = 1;
                    break;
                }
                if (n == 0 && byArray.length < byArray2.length) {
                    n = -1;
                }
            }
            return n;
        }
    }

    private static class ColumnWidthInfo {
        private static WeakHashMap<Connection, ColumnWidthInfo> ColumnWidthMap = new WeakHashMap();
        private String[] _columnNames;
        private int[] _columnWidths;

        static ColumnWidthInfo getColumnWidthInfo(Connection connection, JTable jTable) {
            ColumnWidthInfo columnWidthInfo = null;
            if (connection != null && (columnWidthInfo = ColumnWidthMap.get(connection)) != null) {
                if (columnWidthInfo._columnNames.length != jTable.getColumnCount()) {
                    columnWidthInfo = null;
                } else {
                    for (int i = 0; i < columnWidthInfo._columnNames.length; ++i) {
                        if (columnWidthInfo._columnNames[i].equals(jTable.getColumnName(i))) continue;
                        columnWidthInfo = null;
                        break;
                    }
                }
            }
            return columnWidthInfo;
        }

        static void create(Connection connection, JTable jTable) {
            if (connection != null) {
                ColumnWidthInfo columnWidthInfo = new ColumnWidthInfo(connection, jTable);
                ColumnWidthMap.put(connection, columnWidthInfo);
            }
        }

        void setColumnWidths(JTable jTable) {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < this._columnWidths.length; ++i) {
                tableColumnModel.getColumn(i).setPreferredWidth(this._columnWidths[i]);
            }
            jTable.sizeColumnsToFit(-1);
        }

        private ColumnWidthInfo(Connection connection, JTable jTable) {
            int n = jTable.getModel().getColumnCount();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            this._columnNames = new String[n];
            this._columnWidths = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                this._columnNames[i] = jTable.getColumnName(i);
                this._columnWidths[i] = n2 = tableColumnModel.getColumn(i).getPreferredWidth();
            }
        }
    }
}

