/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.ResultSetTableModel;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.ScrollableResultSet;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class NullAwareTableHeader
extends JTableHeader {
    private NullAwareTable _nat = null;

    NullAwareTableHeader(NullAwareTable nullAwareTable) {
        super(nullAwareTable.getColumnModel());
        this._nat = nullAwareTable;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        if (!this._nat.isShowingHeaderToolTips()) {
            return super.getToolTipText(mouseEvent);
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel != null) {
            Point point = mouseEvent.getPoint();
            int n = tableColumnModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Rectangle rectangle = this.getHeaderRect(i);
                if (!rectangle.contains(point)) continue;
                string = this.getToolTipForColumn(i);
                break;
            }
        }
        return string;
    }

    private String getToolTipForColumn(int n) {
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this._nat.getModel();
        ScrollableResultSet scrollableResultSet = resultSetTableModel.getScrollableResultSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(resultSetTableResourcesBase.get("DataType"));
        StringBuilder stringBuilder = new StringBuilder(64);
        int n2 = scrollableResultSet.getColumnType(n);
        String string = scrollableResultSet.getColumnTypeName(n);
        stringBuilder.append(string);
        switch (n2) {
            case 2: 
            case 3: {
                stringBuilder.append("(");
                stringBuilder.append(scrollableResultSet.getColumnPrecision(n));
                stringBuilder.append(",");
                stringBuilder.append(scrollableResultSet.getColumnScale(n));
                stringBuilder.append(")");
                break;
            }
            case -3: {
                if (string.equals("uniqueidentifier")) break;
            }
            case -2: 
            case 1: 
            case 6: 
            case 12: {
                stringBuilder.append("(");
                stringBuilder.append(scrollableResultSet.getColumnWidth(n));
                stringBuilder.append(")");
            }
        }
        arrayList.add(stringBuilder.toString());
        int n3 = scrollableResultSet.getColumnNullability(n);
        arrayList.add(resultSetTableResourcesBase.get("AllowsNulls"));
        switch (n3) {
            case 0: {
                arrayList.add(resultSetTableResourcesBase.get("No"));
                break;
            }
            case 1: {
                arrayList.add(resultSetTableResourcesBase.get("Yes"));
                break;
            }
            case 2: {
                arrayList.add(resultSetTableResourcesBase.get("Unknown"));
            }
        }
        String string2 = scrollableResultSet.getColumnDefaultValue(n);
        if (string2 != null && !string2.equals("NULL")) {
            arrayList.add(resultSetTableResourcesBase.get("Default"));
            arrayList.add(string2);
        }
        boolean bl = scrollableResultSet.isPrimaryKey(n);
        stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body style=\"margin:4pt\">");
        stringBuilder.append("<table border=0 cellspacing=0 cellpadding=0>");
        stringBuilder.append("<tr><td colspan=2><b>");
        if (bl) {
            URL uRL = ASAComponentsImageLoader.class.getResource("/com/sybase/asa/common/pkey16.gif");
            stringBuilder.append("<img src=\"");
            stringBuilder.append(uRL.toExternalForm());
            stringBuilder.append("\">");
            stringBuilder.append("&nbsp;");
        }
        stringBuilder.append(resultSetTableModel.getColumnName(n));
        stringBuilder.append("</b></td></tr>");
        for (n = 0; n < arrayList.size(); n += 2) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>");
            stringBuilder.append(this.escapeHTML((String)arrayList.get(n)));
            stringBuilder.append("</td>");
            stringBuilder.append("<td>&nbsp;</td>");
            stringBuilder.append("<td>");
            stringBuilder.append(this.escapeHTML((String)arrayList.get(n + 1)));
            stringBuilder.append("</td>");
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    String escapeHTML(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 50);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

