/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BaseCellEditor;
import java.awt.Component;
import java.awt.Toolkit;
import java.math.BigDecimal;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class NumericCellEditor
extends BaseCellEditor {
    NumericCellEditor() {
    }

    @Override
    protected Component createEditor(JTable jTable, int n) {
        Component component;
        JTextField jTextField = null;
        Component component2 = super.createEditor(jTable, n);
        if (component2 instanceof JTextField) {
            jTextField = (JTextField)component2;
        } else if (component2 instanceof JComboBox && (component = ((JComboBox)component2).getEditor().getEditorComponent()) instanceof JTextField) {
            jTextField = (JTextField)component;
        }
        if (jTextField != null) {
            jTextField.setDocument(new NumericDocument());
        }
        return component2;
    }

    @Override
    protected int getAlignment() {
        return 2;
    }

    @Override
    protected Object convertStringToCellValue(String string) {
        Object object;
        string = string.trim();
        try {
            switch (this._sqlType) {
                case -5: {
                    object = Long.valueOf(string);
                    break;
                }
                case 5: {
                    if (this._isSigned) {
                        object = Short.valueOf(string);
                        break;
                    }
                    object = Integer.valueOf(string);
                    break;
                }
                case -6: {
                    object = Integer.valueOf(string);
                    break;
                }
                case 4: {
                    if (this._isSigned) {
                        object = Integer.valueOf(string);
                        break;
                    }
                    object = Long.valueOf(string);
                    break;
                }
                case 2: 
                case 3: {
                    object = new BigDecimal(string);
                    break;
                }
                case 7: {
                    object = Float.valueOf(string);
                    break;
                }
                default: {
                    object = Double.valueOf(string);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = "0";
        }
        return object;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            block5: {
                if (string != null) {
                    String string2 = this.getText(0, this.getLength());
                    super.insertString(n, string, attributeSet);
                    if (this.getLength() != 0) {
                        String string3 = this.getText(0, this.getLength());
                        if (!(NumericCellEditor.this._showNullItem && string3.equals(NumericCellEditor.this._nullDisplayText) || NumericCellEditor.this._showDefaultValueItem && string3.equals(NumericCellEditor.this._defaultDisplayText))) {
                            try {
                                Double.valueOf(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (string3.equals(".") || string3.equals("-") || string3.equals("-.") || string3.endsWith("e")) break block5;
                                this.remove(0, this.getLength());
                                super.insertString(0, string2, null);
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                    }
                }
            }
        }
    }
}

