/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BaseCellRenderer;
import com.sybase.resultSetTable.NullAwareTable;
import java.text.NumberFormat;

class NumericCellRenderer
extends BaseCellRenderer {
    NumberFormat _formatter = NumberFormat.getInstance();

    NumericCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    NumericCellRenderer(int n) {
        if (n == 7) {
            this._formatter.setMaximumFractionDigits(10);
        } else if (n == 8 || n == 6) {
            this._formatter.setMaximumFractionDigits(15);
        } else {
            throw new IllegalArgumentException("Unsupported SQLType " + n);
        }
        this.setHorizontalAlignment(4);
    }

    NumericCellRenderer(int n, int n2) {
        this._formatter.setMaximumIntegerDigits(n);
        this._formatter.setMaximumFractionDigits(n2);
        this._formatter.setMinimumFractionDigits(n2);
        this.setHorizontalAlignment(4);
    }

    @Override
    protected Object getDisplayValue(NullAwareTable nullAwareTable, Object object) {
        try {
            object = this._formatter.format(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return object;
    }
}

