/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.ImageMetadata;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import java.io.File;
import java.nio.charset.Charset;

class RSTFile
extends File {
    private boolean _isTextFile;
    private String _lineSeparator = null;
    private Charset _charset;
    private ImageMetadata _imageMetadata;
    private boolean _isImage;

    private RSTFile(String string) {
        super(string);
    }

    RSTFile(RSTFile rSTFile) {
        super(rSTFile.getAbsolutePath());
        this._isTextFile = rSTFile._isTextFile;
        this._lineSeparator = rSTFile._lineSeparator;
        this._charset = rSTFile._charset;
        this._imageMetadata = rSTFile._imageMetadata;
        this._isImage = rSTFile._isImage;
    }

    boolean areNewlinesPreserved() {
        return this._lineSeparator == null;
    }

    static RSTFile createTextFile(String string) {
        RSTFile rSTFile = new RSTFile(string);
        rSTFile._isTextFile = true;
        rSTFile._charset = Charset.defaultCharset();
        rSTFile._imageMetadata = null;
        rSTFile._isImage = false;
        return rSTFile;
    }

    static RSTFile createTextFile(String string, Charset charset) {
        RSTFile rSTFile = new RSTFile(string);
        rSTFile._isTextFile = true;
        rSTFile._charset = charset;
        rSTFile._imageMetadata = null;
        rSTFile._isImage = false;
        return rSTFile;
    }

    static RSTFile createBinaryFile(String string) {
        RSTFile rSTFile = new RSTFile(string);
        rSTFile._isTextFile = false;
        rSTFile._charset = null;
        rSTFile._imageMetadata = ImageMetadata.createMetadata(rSTFile);
        rSTFile._isImage = rSTFile._imageMetadata != null;
        return rSTFile;
    }

    static RSTFile createBinaryFile(String string, ImageMetadata imageMetadata) {
        RSTFile rSTFile = new RSTFile(string);
        rSTFile._isTextFile = false;
        rSTFile._charset = null;
        rSTFile._imageMetadata = imageMetadata;
        rSTFile._isImage = imageMetadata != null;
        return rSTFile;
    }

    static String formatLength(long l) {
        if (l >= 0x40000000L) {
            return String.format(ResultSetTableResourcesBase.getBundle().getString("FILE_SIZE_GIGABYTES"), (double)l / 1.073741824E9);
        }
        if (l >= 0x100000L) {
            return String.format(ResultSetTableResourcesBase.getBundle().getString("FILE_SIZE_MEGABYTES"), (double)l / 1048576.0);
        }
        if (l >= 1024L) {
            return String.format(ResultSetTableResourcesBase.getBundle().getString("FILE_SIZE_KILOBYTES"), (double)l / 1024.0);
        }
        return String.format(ResultSetTableResourcesBase.getBundle().getString("FILE_SIZE_BYTES"), l);
    }

    Charset getCharset() {
        return this._charset;
    }

    String getLineSeparator() {
        return this._lineSeparator;
    }

    ImageMetadata getImageMetadata() {
        return this._imageMetadata;
    }

    boolean isImage() {
        return this._isImage;
    }

    String getFormattedLength() {
        return RSTFile.formatLength(this.length());
    }

    boolean isTextFile() {
        return this._isTextFile;
    }

    void setLineSeparator(String string) {
        this._lineSeparator = string;
    }

    void setImageMetadata(ImageMetadata imageMetadata) {
        this._imageMetadata = imageMetadata;
    }
}

