/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.ClipboardFormat;
import com.sybase.resultSetTable.DefaultResultSetTableClient;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.ResultSetTableClient;
import com.sybase.resultSetTable.ResultSetTableEvent;
import com.sybase.resultSetTable.ResultSetTableImages;
import com.sybase.resultSetTable.ResultSetTableListener;
import com.sybase.resultSetTable.ResultSetTableModel;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.resultSetTable.WorkerThread;
import com.sybase.util.SybMenu;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybRowHeader;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableModel;

public class ResultSetTable
extends JPanel
implements MouseListener,
ListSelectionListener,
PopupMenuListener {
    public static final int AFTER_SELECTION = -1;
    public static final int AT_END = -2;
    public static final int SYSTEM_FONT = 0;
    public static final int EDITOR_FONT = 1;
    public static final int CUSTOM_FONT = 2;
    protected int _maxRows = 1000;
    private static final int DEFAULT_MAX_ROWS = 1000;
    public static final String DBG_TABLE = "+Table";
    public static final String DBG_TABLE_MODEL = "+Model";
    public static final String DBG_WORKER_THREAD = "+WorkerThread";
    protected NullAwareTable _table;
    protected JScrollPane _scrollPane;
    protected SybRowHeader _rowHeader = null;
    protected EventListenerList _listeners;
    private int _truncationLength = 0;
    private JPopupMenu _contextMenu = null;
    private ResultSetTableClient _client = null;
    private ResultSetTableClient.Operation _currentEditingOperation = ResultSetTableClient.Operation.NONE;

    public ResultSetTable() {
        this(new DefaultResultSetTableClient());
        this.setEditable(false);
    }

    public ResultSetTable(ResultSetTableClient resultSetTableClient) {
        if (resultSetTableClient == null) {
            throw new IllegalArgumentException("ResultSetTableClient cannot be null");
        }
        this._client = resultSetTableClient;
        this.setLayout(new GridLayout(0, 1));
        this.setOpaque(true);
        this.setBackground(SystemColor.window);
        this.setAlignmentX(0.0f);
        this._table = new NullAwareTable(this);
        this._table.addMouseListener(this);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setOpaque(true);
        this.installDefaultKeyboardActions();
        this._scrollPane = new JScrollPane(this._table);
        this._scrollPane.addMouseListener(this);
        this.add(this._scrollPane);
        this._scrollPane.getViewport().setBackground(this._table.getBackground());
    }

    public void setResultSet(Connection connection, ResultSet resultSet) {
        this.setResultSet(connection, resultSet, null, null, null);
    }

    public void setResultSet(Connection connection, ResultSet resultSet, String string, String string2) {
        this.setResultSet(connection, resultSet, string, string2, null);
    }

    public void setResultSet(Connection connection, ResultSet resultSet, String string, String string2, WorkerThread workerThread, boolean bl) {
        if (resultSet == null) {
            throw new IllegalArgumentException();
        }
        this.closeContextMenu();
        this._table.setResultSet(connection, resultSet, this._maxRows, string, string2, workerThread, bl);
    }

    public void setResultSet(Connection connection, ResultSet resultSet, String string, String string2, WorkerThread workerThread) {
        this.setResultSet(connection, resultSet, string, string2, workerThread, false);
    }

    public void setResultSet(Connection connection, ScrollableResultSet scrollableResultSet) {
        this.setResultSet(connection, scrollableResultSet, null);
    }

    public void setResultSet(Connection connection, ScrollableResultSet scrollableResultSet, WorkerThread workerThread) {
        if (scrollableResultSet == null) {
            throw new IllegalArgumentException();
        }
        this.closeContextMenu();
        this._maxRows = scrollableResultSet.getMaxRows();
        if (this._table.getResultSet() != null) {
            this._table.destroy();
            this._table = new NullAwareTable(this);
            this._table.setOpaque(true);
            this.installDefaultKeyboardActions();
        }
        this._table.setResultSet(connection, scrollableResultSet, workerThread);
    }

    public ResultSet getResultSet() {
        return this._table.getResultSet();
    }

    public void showRowHeader(boolean bl) {
        if (bl) {
            if (this._rowHeader == null) {
                this._rowHeader = new SybRowHeader((JTable)this._table);
            }
            this._scrollPane.setRowHeaderView((Component)this._rowHeader);
            this._rowHeader.addMouseListener((MouseListener)this);
        } else {
            this._scrollPane.setRowHeaderView(null);
            this._rowHeader.removeMouseListener((MouseListener)this);
            this._rowHeader.destroy();
            this._rowHeader = null;
        }
    }

    public void showHeaderToolTips(boolean bl) {
        this._table.showHeaderToolTips(bl);
    }

    public ScrollableResultSet getScrollableResultSet() {
        TableModel tableModel;
        ScrollableResultSet scrollableResultSet = null;
        if (this._table != null && (tableModel = this._table.getModel()) instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
            scrollableResultSet = resultSetTableModel.getScrollableResultSet();
        }
        return scrollableResultSet;
    }

    private void installDefaultKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTable.this.fireNotificationEvent(0);
                ResultSetTable.this.copy();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._table.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(actionListener, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(155, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this._table.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(actionListener, keyStroke, 1);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ResultSetTable.this._table.isEditable()) {
                    ResultSetTable.this.deleteRows();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
        keyStroke = KeyStroke.getKeyStroke(127, 0);
        this._table.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(actionListener, keyStroke, 1);
    }

    public void setNullDisplayString(String string) {
        if (this._table != null) {
            this._table.setNullDisplayString(string);
        }
    }

    public void setDefaultValueDisplayString(String string) {
        if (this._table != null) {
            this._table.setDefaultValueDisplayString(string);
        }
    }

    public void setTruncationLength(int n) {
        if (n != this._truncationLength) {
            this._truncationLength = n;
            if (this._table != null) {
                this._table.notifyTruncationLengthChanged(n);
            }
        }
    }

    public int getTruncationLength() {
        return this._truncationLength;
    }

    public void setMaximumRows(int n) {
        this._maxRows = n < 0 ? Integer.MAX_VALUE : n;
    }

    public int getMaximumRows() {
        return this._maxRows;
    }

    public void setSortable(boolean bl) {
        this._table.setSortable(bl);
    }

    public boolean isSortable() {
        return this._table.isSortable();
    }

    public RowSorter.SortKey getSortKey() {
        List<RowSorter.SortKey> list;
        RowSorter.SortKey sortKey = null;
        RowSorter<? extends TableModel> rowSorter = this._table.getRowSorter();
        if (rowSorter != null && (list = rowSorter.getSortKeys()).size() > 0) {
            sortKey = list.get(0);
        }
        return sortKey;
    }

    public void setSortKey(RowSorter.SortKey sortKey) {
        if (this._table == null) {
            throw new IllegalStateException("Table has not been created yet");
        }
        RowSorter<? extends TableModel> rowSorter = this._table.getRowSorter();
        if (rowSorter != null) {
            ArrayList<RowSorter.SortKey> arrayList;
            if (sortKey != null) {
                arrayList = new ArrayList<RowSorter.SortKey>();
                arrayList.add(sortKey);
            } else {
                arrayList = null;
            }
            rowSorter.setSortKeys(arrayList);
        }
    }

    public void setEditable(boolean bl) {
        this._table.setEditable(bl);
    }

    public boolean isEditable() {
        return this._table != null && this._table.isEditable();
    }

    private boolean canGenerateSQL() {
        TableModel tableModel;
        boolean bl = false;
        if (this._table != null && (tableModel = this._table.getModel()) instanceof ResultSetTableModel) {
            bl = ((ResultSetTableModel)tableModel).canGenerateSQL();
        }
        return bl;
    }

    public void deleteRows() {
        if (this._table.isEditable() && this._currentEditingOperation == ResultSetTableClient.Operation.NONE) {
            this._table.deleteRows();
        }
    }

    public ResultSetTableClient.Operation getCurrentEditingOperation() {
        return this._currentEditingOperation;
    }

    public void beginInsert(int n) {
        if (n < 0 && n != -2 && n != -1) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        if (n >= this._table.getRowCount()) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        if (this._currentEditingOperation != ResultSetTableClient.Operation.NONE) {
            throw new IllegalStateException("Cannot start insertion already " + (this._currentEditingOperation == ResultSetTableClient.Operation.INSERT ? "inserting" : "updating"));
        }
        if (this._table.isEditable()) {
            this._table.startInsert(n);
            this._currentEditingOperation = ResultSetTableClient.Operation.INSERT;
        }
    }

    public boolean isInserting() {
        return this._table != null && this._table.isInserting();
    }

    public void addResultSetTableListener(ResultSetTableListener resultSetTableListener) {
        if (resultSetTableListener != null) {
            if (this._listeners == null) {
                this._listeners = new EventListenerList();
            }
            this._listeners.add(ResultSetTableListener.class, resultSetTableListener);
        }
    }

    public void removeResultSetTableListener(ResultSetTableListener resultSetTableListener) {
        if (resultSetTableListener != null && this._listeners != null) {
            this._listeners.remove(ResultSetTableListener.class, resultSetTableListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (focusListener != null && this._table != null) {
            this._table.addFocusListener(focusListener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        if (focusListener != null && this._table != null) {
            this._table.removeFocusListener(focusListener);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null && this._table != null) {
            this._table.getSelectionModel().addListSelectionListener(listSelectionListener);
        }
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null && this._table != null) {
            this._table.getSelectionModel().removeListSelectionListener(listSelectionListener);
        }
    }

    protected void fireResultSetTableExceptionEvent(Exception exception) {
        if (this._listeners != null && exception != null) {
            int n;
            Object[] objectArray = this._listeners.getListenerList();
            for (int i = n = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ResultSetTableListener.class) continue;
                ResultSetTableEvent resultSetTableEvent = new ResultSetTableEvent(this, exception);
                ((ResultSetTableListener)objectArray[i + 1]).exception(resultSetTableEvent);
            }
        }
    }

    void fireNotificationEvent(int n) {
        Object[] objectArray;
        int n2;
        if (this._listeners != null && (n2 = (objectArray = this._listeners.getListenerList()).length - 2) >= 0) {
            ResultSetTableEvent resultSetTableEvent = new ResultSetTableEvent(this, n, this._table.getSelectedRow());
            for (int i = n2; i >= 0; i -= 2) {
                if (objectArray[i] != ResultSetTableListener.class) continue;
                ((ResultSetTableListener)objectArray[i + 1]).notify(resultSetTableEvent);
            }
        }
    }

    boolean fireSortEvent(RowSorter.SortKey sortKey) {
        Object[] objectArray;
        int n;
        boolean bl = false;
        ResultSetTableEvent resultSetTableEvent = null;
        if (this._listeners != null && (n = (objectArray = this._listeners.getListenerList()).length - 2) >= 0) {
            for (int i = n; i >= 0; i -= 2) {
                if (objectArray[i] != ResultSetTableListener.class) continue;
                if (resultSetTableEvent == null) {
                    resultSetTableEvent = new ResultSetTableEvent(this, sortKey);
                }
                if (bl = ((ResultSetTableListener)objectArray[i + 1]).sortColumn(resultSetTableEvent)) break;
            }
        }
        return bl;
    }

    boolean fireSelectAllEvent() {
        Object[] objectArray;
        int n;
        boolean bl = false;
        ResultSetTableEvent resultSetTableEvent = null;
        if (this._listeners != null && (n = (objectArray = this._listeners.getListenerList()).length - 2) >= 0) {
            for (int i = n; i >= 0; i -= 2) {
                if (objectArray[i] != ResultSetTableListener.class) continue;
                if (resultSetTableEvent == null) {
                    resultSetTableEvent = new ResultSetTableEvent(this);
                }
                if (bl = ((ResultSetTableListener)objectArray[i + 1]).selectAll(resultSetTableEvent)) break;
            }
        }
        return bl;
    }

    private boolean fireCopyColumnEvent(int n) {
        Object[] objectArray;
        int n2;
        boolean bl = false;
        ResultSetTableEvent resultSetTableEvent = null;
        if (this._listeners != null && (n2 = (objectArray = this._listeners.getListenerList()).length - 2) >= 0) {
            for (int i = n2; i >= 0; i -= 2) {
                if (objectArray[i] != ResultSetTableListener.class) continue;
                if (resultSetTableEvent == null) {
                    resultSetTableEvent = new ResultSetTableEvent(this);
                    resultSetTableEvent.setColumn(n);
                }
                if (bl = ((ResultSetTableListener)objectArray[i + 1]).copyColumn(resultSetTableEvent)) break;
            }
        }
        return bl;
    }

    private void closeContextMenu() {
        if (this._contextMenu != null) {
            this._contextMenu.setVisible(false);
        }
    }

    ResultSetTableClient getClient() {
        return this._client;
    }

    public void destroy() {
        this.closeContextMenu();
        if (this._scrollPane != null) {
            this._scrollPane.removeMouseListener(this);
            this._scrollPane = null;
        }
        if (this._rowHeader != null) {
            this._rowHeader.removeMouseListener((MouseListener)this);
            this._rowHeader.destroy();
            this._rowHeader = null;
        }
        if (this._table != null) {
            this._table.cancelEditing();
            this._table.removeMouseListener(this);
            this._table.getSelectionModel().removeListSelectionListener(this);
            this._table.destroy();
            this._table = null;
        }
        if (this._listeners != null) {
            int n = this._listeners.getListenerCount();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = this._listeners.getListenerList();
                this._listeners.remove(ResultSetTableListener.class, (ResultSetTableListener)objectArray[1]);
            }
            this._listeners = null;
        }
        this._client = null;
    }

    public boolean isEditing() {
        return this._table != null && this._table.isEditing();
    }

    public void beginUpdate() {
        if (this._table == null) {
            throw new IllegalStateException();
        }
        int n = this._table.getSelectedRow();
        if (n != -1) {
            boolean bl;
            int n2 = this._table.getSelectedColumn();
            if (n2 == -1) {
                n2 = 0;
            }
            if (bl = this._table.startEditing(n, n2)) {
                this._currentEditingOperation = ResultSetTableClient.Operation.UPDATE;
            }
        }
    }

    public boolean completeEditing() {
        boolean bl;
        if (this._currentEditingOperation != ResultSetTableClient.Operation.NONE && this._table != null && (bl = this._table.stopEditing())) {
            this._currentEditingOperation = ResultSetTableClient.Operation.NONE;
        }
        return this._currentEditingOperation == ResultSetTableClient.Operation.NONE;
    }

    public void cancelEditing() {
        if (this._currentEditingOperation != ResultSetTableClient.Operation.NONE && this._table != null) {
            this._table.cancelEditing();
        }
        this._currentEditingOperation = ResultSetTableClient.Operation.NONE;
    }

    public void copy() {
        this._table.copy();
    }

    public void copyCell() {
        this._table.copyCell();
    }

    public void copyColumn(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("Illegal column number: " + n);
        }
        this._table.copyColumn(n);
    }

    @Override
    public void requestFocus() {
        if (this._table != null) {
            this._table.requestFocus();
        }
    }

    @Override
    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        if (this._table == null) {
            throw new IllegalStateException();
        }
        this._table.registerKeyboardAction(actionListener, string, keyStroke, n);
    }

    @Override
    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    @Override
    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        if (this._table == null) {
            throw new IllegalStateException();
        }
        this._table.unregisterKeyboardAction(keyStroke);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            this.showPopupMenu(mouseEvent);
        } else if (mouseEvent.getSource() == this._scrollPane) {
            this.deselectAllRows();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this._table.getSelectionModel() && this._listeners != null) {
            int n;
            Object[] objectArray = this._listeners.getListenerList();
            for (int i = n = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ResultSetTableListener.class) continue;
                ((ResultSetTableListener)objectArray[i + 1]).selectionChanged(new ListSelectionEvent(this, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting()));
            }
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        int n;
        Point point = null;
        point = mouseEvent.getSource() == this._scrollPane || mouseEvent.getSource() == this._rowHeader ? SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._table) : mouseEvent.getPoint();
        if (mouseEvent.getSource() == this._scrollPane && !this.deselectAllRows()) {
            return;
        }
        int n2 = this._table.rowAtPoint(point);
        if (n2 > -1 && !this._table.isRowSelected(n2)) {
            if (this.getCurrentEditingOperation() != ResultSetTableClient.Operation.NONE) {
                return;
            }
            this._table.setRowSelectionInterval(n2, n2);
        }
        if ((n = this._table.columnAtPoint(point)) != -1) {
            this._table.setColumnSelectionInterval(n, n);
        }
        this._contextMenu = this.createContextMenu();
        if (this._contextMenu != null) {
            this._contextMenu.addPopupMenuListener(this);
            UIUtils.showJPopupMenu((JPopupMenu)this._contextMenu, (JComponent)this._table, (Point)point);
        }
    }

    protected JPopupMenu createContextMenu() {
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        int n = this._table.getSelectedRow();
        int n2 = this._table.getSelectedColumn();
        JPopupMenu jPopupMenu = new JPopupMenu();
        SybMenu sybMenu = new SybMenu(resultSetTableResourcesBase.get("Copy"));
        sybMenu.setIcon(new ImageIcon(ResultSetTableImages.getCopyRec()));
        SybMenuItem sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("COPY_CELL"));
        sybMenuItem.setIcon(new ImageIcon(ResultSetTableImages.getCopyCell()));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTable.this.fireNotificationEvent(0);
                ResultSetTable.this.copyCell();
            }
        });
        if (n == -1) {
            sybMenuItem.setEnabled(false);
        }
        sybMenu.add((JMenuItem)sybMenuItem);
        sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("COPY_ROW"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTable.this.fireNotificationEvent(0);
                ResultSetTable.this.copy();
            }
        });
        if (n == -1) {
            sybMenuItem.setEnabled(false);
        }
        sybMenu.add((JMenuItem)sybMenuItem);
        sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("COPY_COLUMN"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ResultSetTable.this._table.getSelectedColumn();
                if (n != -1 && !ResultSetTable.this.fireCopyColumnEvent(n)) {
                    ResultSetTable.this.copyColumn(n);
                }
            }
        });
        if (n2 == -1) {
            sybMenuItem.setEnabled(false);
        }
        sybMenu.add((JMenuItem)sybMenuItem);
        jPopupMenu.add((JMenuItem)sybMenu);
        if (this.isEditable()) {
            jPopupMenu.addSeparator();
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("Insert"));
            sybMenuItem.setIcon(new ImageIcon(ResultSetTableImages.getAddRec()));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.beginInsert(-1);
                }
            });
            sybMenuItem.setEnabled(this.canInsert());
            jPopupMenu.add((JMenuItem)sybMenuItem);
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("Edit"));
            sybMenuItem.setIcon(new ImageIcon(ResultSetTableImages.getEditRec()));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.beginUpdate();
                }
            });
            sybMenuItem.setEnabled(this.canEditOrDelete());
            jPopupMenu.add((JMenuItem)sybMenuItem);
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("Delete"));
            sybMenuItem.setIcon(new ImageIcon(ResultSetTableImages.getDeleteRec()));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.deleteRows();
                }
            });
            sybMenuItem.setEnabled(this.canEditOrDelete());
            jPopupMenu.add((JMenuItem)sybMenuItem);
            jPopupMenu.addSeparator();
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("Update"));
            sybMenuItem.setIcon(new ImageIcon(ResultSetTableImages.getUpdateRec()));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.completeEditing();
                }
            });
            sybMenuItem.setEnabled(this.canUpdateOrCancel());
            jPopupMenu.add((JMenuItem)sybMenuItem);
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("Cancel"));
            sybMenuItem.setIcon(new ImageIcon(ResultSetTableImages.getCancelRec()));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.cancelEditing();
                }
            });
            sybMenuItem.setEnabled(this.canUpdateOrCancel());
            jPopupMenu.add((JMenuItem)sybMenuItem);
        }
        if (this.canGenerateSQL()) {
            sybMenu = new SybMenu(resultSetTableResourcesBase.get("GENERATE"));
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("GENERATE_INSERT"));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = ResultSetTable.this.getSelectedRows();
                    ResultSetTable.this._table.generateInsertStatements(nArray);
                }
            });
            sybMenu.add((JMenuItem)sybMenuItem);
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("GENERATE_DELETE"));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = ResultSetTable.this.getSelectedRows();
                    ResultSetTable.this._table.generateDeleteStatement(nArray);
                }
            });
            sybMenu.add((JMenuItem)sybMenuItem);
            sybMenuItem = new SybMenuItem(resultSetTableResourcesBase.get("GENERATE_UPDATE"));
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = ResultSetTable.this.getSelectedRows();
                    ResultSetTable.this._table.generateUpdateStatements(nArray);
                }
            });
            sybMenu.add((JMenuItem)sybMenuItem);
            jPopupMenu.addSeparator();
            jPopupMenu.add((JMenuItem)sybMenu);
        }
        if (jPopupMenu.getSubElements().length > 0) {
            return jPopupMenu;
        }
        return null;
    }

    public boolean canInsert() {
        return this.isEditable() && !this.isEditing() && !this.isInserting();
    }

    public boolean canEditOrDelete() {
        return this.isEditable() && !this.isEditing() && !this.isInserting() && this.getSelectedRow() != -1;
    }

    public boolean canUpdateOrCancel() {
        return this._currentEditingOperation == ResultSetTableClient.Operation.INSERT || this._currentEditingOperation == ResultSetTableClient.Operation.UPDATE;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this._contextMenu = null;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this._contextMenu = null;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void setSelectionMode(int n) {
        if (this._table == null) {
            throw new IllegalStateException();
        }
        this._table.setSelectionMode(n);
    }

    public void setClipboardFormat(ClipboardFormat clipboardFormat) {
        if (this._table == null) {
            throw new IllegalStateException();
        }
        this._table.setClipboardFormat(clipboardFormat);
    }

    public ClipboardFormat getClipboardFormat() {
        if (this._table == null) {
            throw new IllegalStateException();
        }
        return this._table.getClipboardFormat();
    }

    public void selectRow(int n) {
        this._table.getSelectionModel().addSelectionInterval(n, n);
    }

    public void selectRows(int n, int n2) {
        if (this._table.getSelectionModel().getSelectionMode() != 0) {
            this._table.getSelectionModel().addSelectionInterval(n, n2);
        } else {
            this.selectRow(n);
        }
    }

    public void selectAll() {
        if (this._table != null) {
            this._table.selectAll();
        }
    }

    public boolean deselectAllRows() {
        boolean bl = false;
        if (this._table != null) {
            if (this.getCurrentEditingOperation() != ResultSetTableClient.Operation.NONE) {
                bl = this.completeEditing();
                if (bl) {
                    this._table.clearSelection();
                }
            } else {
                this._table.clearSelection();
                bl = true;
            }
        }
        return bl;
    }

    public int getSelectedRow() {
        return this._table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this._table.getSelectedRows();
    }

    public void readRowData() {
        if (this._table != null) {
            this._table.readRowData();
        }
    }

    public void notifyEndOfResultSet() {
        if (this._table != null) {
            this._table.notifyEndOfResultSet();
            if (SwingUtilities.isEventDispatchThread()) {
                this.fireNotificationEvent(7);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ResultSetTable.this.fireNotificationEvent(7);
                    }
                });
            }
        }
    }

    public void notifyFetcherIdle() {
        TableModel tableModel;
        if (this._table != null && (tableModel = this._table.getModel()) != null && tableModel instanceof ResultSetTableModel) {
            ((ResultSetTableModel)tableModel).notifyFetcherIdle();
        }
    }

    public void notifyFetcherException(final Exception exception) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireResultSetTableExceptionEvent(exception);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ResultSetTable.this.fireResultSetTableExceptionEvent(exception);
                }
            });
        }
    }

    public void interrupt() {
        ResultSetTableModel resultSetTableModel;
        if (this._table != null && (resultSetTableModel = (ResultSetTableModel)this._table.getModel()) != null) {
            resultSetTableModel.interrupt();
            this.fireNotificationEvent(10);
        }
    }

    public boolean isBusy() {
        ResultSetTableModel resultSetTableModel;
        boolean bl = false;
        if (this._table != null && (resultSetTableModel = (ResultSetTableModel)this._table.getModel()) != null) {
            bl = resultSetTableModel.isFetchInProgress();
        }
        return bl;
    }

    public int getRowCount() {
        int n = 0;
        if (this._table != null) {
            n = this._table.getRowCount();
        }
        return n;
    }

    public int getColumnCount() {
        int n = this._table != null ? this._table.getColumnCount() : 0;
        return n;
    }

    public Object getValueAt(int n, int n2) {
        Object object = this._table != null ? this._table.getValueAt(n, n2) : null;
        return object;
    }

    public boolean isRowCountAnEstimate() {
        ResultSetTableModel resultSetTableModel;
        boolean bl = false;
        if (this._table != null && (resultSetTableModel = (ResultSetTableModel)this._table.getModel()) != null) {
            bl = resultSetTableModel.isRowCountAnEstimate();
        }
        return bl;
    }

    public static void setDebuggingOptions(String string) {
        System.setProperty("com.sybase.resultSetTable.debug", string);
    }

    protected static boolean dbgEnabled(String string) {
        boolean bl = false;
        return bl;
    }

    private static String getSystemProperty(String string) {
        String string2 = "com.sybase.resultSetTable." + string;
        String string3 = System.getProperty(string2);
        return string3;
    }

    public void setFont(int n, Font font) {
        if (this._table != null) {
            this._table.setFont(n, font);
        }
    }

    public void setShowUUIDWithHyphens(boolean bl) {
        if (this._table != null) {
            this._table.setShowUUIDWithHyphens(bl);
        }
    }

    public void synchronizeTableModelWithResultSet() {
        TableModel tableModel;
        if (this._table != null && (tableModel = this._table.getModel()) instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
            resultSetTableModel.synchronizeTableModelWithResultSet();
        }
    }

    public void print(boolean bl) {
        if (this._table != null) {
            this._table.handlePrint(bl);
        }
    }
}

