/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BinaryCellEditor;
import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.LongTextValue;
import com.sybase.resultSetTable.LongValue;
import com.sybase.resultSetTable.NewlineConvertingReader;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.OutOfMemoryException;
import com.sybase.resultSetTable.RSTFile;
import com.sybase.resultSetTable.ResultSetTable;
import com.sybase.resultSetTable.ResultSetTableClient;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.SQLGenerationException;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.resultSetTable.ScrollableResultSetEvent;
import com.sybase.resultSetTable.ScrollableResultSetListener;
import com.sybase.resultSetTable.WorkerThread;
import com.sybase.util.Dbg;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

class ResultSetTableModel
extends AbstractTableModel
implements ScrollableResultSetListener {
    private static final int MAX_BINARY_LITERAL_SIZE = Integer.MAX_VALUE;
    private static final int MAX_TEXT_LITERAL_SIZE = Integer.MAX_VALUE;
    private static final int INITIAL_ROW_COUNT_ESTIMATE = 100;
    private static final int GUARD_RANGE_PERCENTAGE = 20;
    private static final int ROW_COUNT_ESTIMATE_GROWTH_PERCENTAGE = 10;
    private static final int UNKNOWN = -1;
    private ScrollableResultSet _resultSet;
    private int _preliminaryRowCount = 0;
    private int _actualRowCount = -1;
    private Connection _connection = null;
    private boolean _createdScrollableResultSet = false;
    private String _tableName = null;
    private String _ownerName = null;
    private Object[] _editBuffer = null;
    private int _editBufferRow = -1;
    private int _insertRow = -1;
    private Object[] _insertBuffer = null;
    private WorkerThread _workerThread = null;
    private NullAwareTable _nullAwareTable = null;
    private int _firstAsyncRow = -1;
    private int _lastAsyncRow = -1;
    private long _firstAsyncRowTime = 0L;
    private static final int EDITABLE_UNKNOWN = -1;
    private static final int EDITABLE_NO = 0;
    private static final int EDITABLE_YES = 1;
    private int _editable = -1;

    ResultSetTableModel(NullAwareTable nullAwareTable, Connection connection, ResultSet resultSet, int n, boolean bl) {
        this._nullAwareTable = nullAwareTable;
        this._connection = connection;
        int n2 = bl ? 2 : 0;
        this._resultSet = new ScrollableResultSet(connection, resultSet, n, n2);
        int n3 = nullAwareTable.getResultSetTable().getTruncationLength();
        if (n3 == 0) {
            n3 = 32768;
        }
        this._resultSet.setMaxClobCharacters(n3);
        this._resultSet.setMaxBlobBytes(n3);
        this._createdScrollableResultSet = true;
    }

    ResultSetTableModel(NullAwareTable nullAwareTable, Connection connection, ScrollableResultSet scrollableResultSet) {
        this._nullAwareTable = nullAwareTable;
        this._connection = connection;
        this._resultSet = scrollableResultSet;
        this._resultSet.addScrollableResultSetListener(this);
        this._createdScrollableResultSet = false;
        int n = scrollableResultSet.getRowCount();
        if (n == -1) {
            this._actualRowCount = -1;
        } else {
            this._actualRowCount = n;
            this._preliminaryRowCount = n;
        }
    }

    void setOwnerAndTableNames(String string, String string2) {
        this._ownerName = string;
        this._tableName = string2;
    }

    ScrollableResultSet getScrollableResultSet() {
        return this._resultSet;
    }

    Connection getConnection() {
        return this._connection;
    }

    void destroy() {
        if (this._workerThread != null) {
            this._workerThread.terminate();
            this._workerThread = null;
        }
        if (this._createdScrollableResultSet) {
            this._resultSet.destroy();
        }
        if (this._resultSet != null) {
            this._resultSet.removeScrollableResultSetListener(this);
            this._resultSet = null;
        }
        this._editBuffer = null;
        this._connection = null;
        this._nullAwareTable = null;
    }

    @Override
    public int getRowCount() {
        if (this._resultSet == null) {
            return 0;
        }
        return this._preliminaryRowCount;
    }

    boolean isRowCountAnEstimate() {
        return this._actualRowCount == -1;
    }

    private boolean areAnyColumnsWritable() {
        boolean bl = false;
        int n = this._resultSet.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (this._resultSet.isColumnReadOnly(i) && !this._resultSet.isPrimaryKey(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public int getColumnCount() {
        if (this._resultSet == null) {
            return 0;
        }
        int n = this._resultSet.getColumnCount();
        return n;
    }

    @Override
    public String getColumnName(int n) {
        if (this._resultSet == null) {
            throw new IllegalStateException();
        }
        String string = this._resultSet.getColumnLabel(n);
        if (string == null) {
            string = this._resultSet.getColumnName(n);
        }
        if (string != null && string.length() == 0) {
            string = " ";
        }
        return string;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        if (this._resultSet == null) {
            throw new IllegalStateException();
        }
        if (n == this._editBufferRow) {
            return this._editBuffer[n2];
        }
        if (this._insertRow != -1) {
            if (n == this._insertRow) {
                return this._insertBuffer[n2];
            }
            if (n > this._insertRow) {
                --n;
            }
        }
        try {
            object = this._resultSet.getValueAt(n, n2);
            if (this._actualRowCount == -1 && (this._preliminaryRowCount - n) * 100 / this._preliminaryRowCount < 20) {
                int n3 = this._preliminaryRowCount * 10 / 100;
                int n4 = this._nullAwareTable.getResultSetTable().getMaximumRows();
                if (this._preliminaryRowCount + n3 > n4) {
                    n3 = n4 - this._preliminaryRowCount;
                }
                if (n3 > 0) {
                    this._nullAwareTable.fireNotificationEvent(8);
                    this._workerThread.fetchRows(n3);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            return "";
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this._actualRowCount == -1) {
                this._actualRowCount = this._preliminaryRowCount;
            }
            object = null;
        }
        return object;
    }

    public Class getColumnClass(int n) {
        if (this._resultSet == null) {
            throw new IllegalStateException();
        }
        Class clazz = this._resultSet.getColumnClass(n);
        return clazz;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this._resultSet == null) {
            throw new IllegalStateException();
        }
        boolean bl = this._resultSet.isCellEditable(n, n2);
        if (!bl && this._insertRow != -1) {
            bl = this._resultSet.isPrimaryKey(n2);
        }
        return bl;
    }

    void removeRowsFromModel(ArrayList<Integer> arrayList) {
        int n;
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = arrayList.get(n);
        }
        Arrays.sort(nArray);
        for (n = n2 - 1; n >= 0; --n) {
            this._resultSet.removeRowFromCache(nArray[n]);
            this.fireTableRowsDeleted(nArray[n], nArray[n]);
            if (this._actualRowCount != -1) {
                this._preliminaryRowCount = --this._actualRowCount;
                continue;
            }
            --this._preliminaryRowCount;
        }
    }

    String composeSingleColumnSelect(int n, int n2) throws SQLException {
        Object object;
        int n3;
        this.ensureTableNameIsKnown();
        int n4 = this._resultSet.getColumnCount();
        for (n3 = 0; n3 < n4; ++n3) {
            object = this._resultSet.getValueAt(n, n3);
            if (!(object instanceof DefaultValue)) continue;
            String string = ResultSetTableResourcesBase.getBundle().get("RefreshTableBeforeDeleting");
            throw new SQLException(string);
        }
        boolean bl = true;
        boolean[] blArray = new boolean[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            blArray[n3] = this._resultSet.isPrimaryKey(n3);
            if (!blArray[n3]) continue;
            bl = false;
        }
        if (bl) {
            Arrays.fill(blArray, true);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("SELECT ");
        stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n2)));
        stringBuilder.append(" FROM ");
        if (this._ownerName != null) {
            stringBuilder.append(this._resultSet.quoteIdentifier(this._ownerName));
            stringBuilder.append(".");
        }
        stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
        stringBuilder.append(" WHERE ");
        boolean bl2 = true;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!blArray[n3]) continue;
            if (!bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n3)));
            object = this._resultSet.getValueAt(n, n3);
            if (object == null) {
                stringBuilder.append(" IS NULL");
            } else {
                stringBuilder.append("=");
                this.appendDelimitedValue(stringBuilder, object, this._resultSet.getColumnType(n3));
            }
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    String composeDeleteStatement(int n) throws SQLException {
        Object object;
        int n2;
        this.ensureTableNameIsKnown();
        if (this._tableName == null) {
            throw new SQLException(ResultSetTableResourcesBase.getBundle().get("ERR_COULD_NOT_GENERATE_NO_TABLE"));
        }
        int n3 = this._resultSet.getColumnCount();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this._resultSet.getValueAt(n, n2);
            if (!(object instanceof DefaultValue)) continue;
            String string = ResultSetTableResourcesBase.getBundle().get("RefreshTableBeforeDeleting");
            throw new SQLException(string);
        }
        boolean bl = true;
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = this._resultSet.isPrimaryKey(n2);
            if (!blArray[n2]) continue;
            bl = false;
        }
        if (bl) {
            Arrays.fill(blArray, true);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("DELETE FROM ");
        if (this._ownerName != null) {
            stringBuilder.append(this._resultSet.quoteIdentifier(this._ownerName));
            stringBuilder.append(".");
        }
        stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
        stringBuilder.append(" WHERE ");
        boolean bl2 = true;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray[n2]) continue;
            if (!bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n2)));
            object = this._resultSet.getValueAt(n, n2);
            if (object == null) {
                stringBuilder.append(" IS NULL");
            } else {
                stringBuilder.append("=");
                this.appendDelimitedValue(stringBuilder, object, this._resultSet.getColumnType(n2));
            }
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    private void appendParameterToSQL(StringBuilder stringBuilder, Object object, int n, ArrayList<Object> arrayList, ArrayList<Integer> arrayList2) {
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        Object var8_8 = null;
        Object var9_9 = null;
        File file = null;
        Object var11_11 = null;
        Object var12_12 = null;
        boolean bl = false;
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof LongValue) {
            if (((LongValue)object).isPartialValue()) {
                try {
                    file = ((LongValue)object).getFile();
                    fileInputStream = new FileInputStream(file);
                    if (object instanceof LongTextValue) {
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "utf8");
                        arrayList.add(inputStreamReader);
                    } else {
                        arrayList.add(fileInputStream);
                    }
                    stringBuilder.append("?");
                    arrayList2.add(n);
                }
                catch (IOException iOException) {
                    this.appendDelimitedValue(stringBuilder, ((LongValue)object).getTruncatedValue(), n);
                }
            } else {
                this.appendDelimitedValue(stringBuilder, ((LongValue)object).getTruncatedValue(), n);
            }
        } else if (object instanceof RSTFile) {
            try {
                fileInputStream = new FileInputStream((RSTFile)object);
                if (((RSTFile)object).isTextFile()) {
                    inputStreamReader = ((RSTFile)object).areNewlinesPreserved() ? new InputStreamReader((InputStream)fileInputStream, ((RSTFile)object).getCharset()) : new NewlineConvertingReader(fileInputStream, ((RSTFile)object).getCharset(), ((RSTFile)object).getLineSeparator());
                    arrayList.add(inputStreamReader);
                } else {
                    arrayList.add(fileInputStream);
                }
                stringBuilder.append("?");
                arrayList2.add(n);
            }
            catch (IOException iOException) {
                stringBuilder.append("null");
            }
        } else if (object instanceof Date || object instanceof Time || object instanceof Timestamp) {
            stringBuilder.append("?");
            arrayList.add(object);
            arrayList2.add(n);
        } else {
            this.appendDelimitedValue(stringBuilder, object, n);
        }
    }

    private void appendDelimitedValue(StringBuilder stringBuilder, Object object, int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                this.appendDelimitedString(stringBuilder, object.toString());
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                String string = object.toString();
                if (string.length() != 0) {
                    stringBuilder.append(string);
                    break;
                }
                stringBuilder.append("0");
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof LongValue) {
                    object = ((LongValue)object).getTruncatedValue();
                }
                if (object instanceof String) {
                    this.appendDelimitedString(stringBuilder, object.toString());
                    break;
                }
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if (byArray.length > 0) {
                        stringBuilder.append(BinaryCellEditor.blobToString(byArray, byArray.length));
                        break;
                    }
                    stringBuilder.append("''");
                    break;
                }
                stringBuilder.append(object.toString());
                break;
            }
            case -7: {
                if (object instanceof String) {
                    if (((String)object).equals("1") || ((String)object).equals("true")) {
                        stringBuilder.append("1");
                        break;
                    }
                    stringBuilder.append("0");
                    break;
                }
                if (object instanceof Boolean) {
                    if (((Boolean)object).booleanValue()) {
                        stringBuilder.append("1");
                        break;
                    }
                    stringBuilder.append("0");
                    break;
                }
                stringBuilder.append(object.toString());
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.appendDelimitedString(stringBuilder, object.toString());
                break;
            }
            default: {
                stringBuilder.append(object.toString());
            }
        }
    }

    private void appendDelimitedString(StringBuilder stringBuilder, String string) {
        stringBuilder.append("'");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append("''");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("'");
    }

    int startInsert(int n) {
        if (this._actualRowCount != -1) {
            if (n == -2 || n > this._actualRowCount) {
                n = this._actualRowCount;
            }
        } else if (n == -2 || n > this._preliminaryRowCount) {
            n = this._preliminaryRowCount;
        }
        this._insertRow = n;
        this._insertBuffer = new Object[this._resultSet.getColumnCount()];
        block8: for (int i = 0; i < this._resultSet.getColumnCount(); ++i) {
            if (this._resultSet.isColumnReadOnly(i) && !this._resultSet.isPrimaryKey(i)) {
                switch (this._resultSet.getColumnType(i)) {
                    case -7: {
                        this._insertBuffer[i] = Boolean.FALSE;
                        break;
                    }
                    default: {
                        this._insertBuffer[i] = "";
                        break;
                    }
                }
                continue;
            }
            String string = this._resultSet.getColumnDefaultValue(i);
            this._insertBuffer[i] = string != null ? (string.equalsIgnoreCase("NULL") ? null : new DefaultValue()) : this.getSafeInitialValue(i);
            if (this._insertBuffer[i] != null || this._resultSet.getColumnNullability(i) != 0) continue;
            switch (this.getColumnType(i)) {
                case 91: 
                case 92: {
                    this._insertBuffer[i] = Calendar.getInstance().getTime();
                    continue block8;
                }
                case 93: {
                    this._insertBuffer[i] = new Timestamp(Calendar.getInstance().getTimeInMillis());
                    continue block8;
                }
                case -3: {
                    String string2 = this.getColumnTypeName(i);
                    if (string2 == null || !string2.equalsIgnoreCase("uniqueidentifier")) continue block8;
                    this._insertBuffer[i] = new byte[16];
                    continue block8;
                }
                default: {
                    this._insertBuffer[i] = "";
                }
            }
        }
        ++this._preliminaryRowCount;
        this.fireTableRowsInserted(n, n);
        return n;
    }

    private Object getSafeInitialValue(int n) {
        Object object;
        if (this._resultSet.getColumnNullability(n) != 0) {
            object = null;
        } else {
            int n2 = this._resultSet.getColumnType(n);
            switch (n2) {
                case -7: {
                    object = Boolean.FALSE;
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    object = 0;
                    break;
                }
                default: {
                    object = "";
                }
            }
        }
        return object;
    }

    void cancelUpdate() {
        if (this._editBuffer != null) {
            int n = this._editBufferRow;
            this._editBuffer = null;
            this._editBufferRow = -1;
            this.fireTableRowsUpdated(n, n);
        }
    }

    void cancelInsertion() {
        if (this._insertBuffer == null) {
            throw new IllegalStateException("No edit buffer");
        }
        int n = this._insertRow;
        this._insertBuffer = null;
        this._insertRow = -1;
        --this._preliminaryRowCount;
        this.fireTableRowsDeleted(n, n);
    }

    private boolean isValueModified(Object object, Object object2) {
        if (object == null && object2 == null) {
            return false;
        }
        if (object == null ^ object2 == null) {
            return true;
        }
        if (object2 instanceof LongValue) {
            return ((LongValue)object2).isModified();
        }
        if (object2 instanceof RSTFile) {
            return true;
        }
        if (object2 instanceof byte[]) {
            if (object == object2) {
                return false;
            }
            if (object instanceof byte[] && ((byte[])object2).length == ((byte[])object2).length) {
                boolean bl = false;
                for (int i = 0; i < ((byte[])object2).length; ++i) {
                    if (((byte[])object2)[i] == ((byte[])object)[i]) continue;
                    bl = true;
                    break;
                }
                return bl;
            }
            return true;
        }
        return !object.toString().equals(object2.toString());
    }

    String composeUpdateStatement(ArrayList<Object> arrayList, ArrayList<Integer> arrayList2, int n) throws SQLException {
        int n2;
        Object var15_4 = null;
        if (this._editBuffer == null) {
            throw new IllegalStateException("No edit buffer");
        }
        this.ensureTableNameIsKnown();
        StringBuilder stringBuilder = new StringBuilder(256);
        int n3 = this._resultSet.getColumnCount();
        int n4 = 0;
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Object object = this._resultSet.getValueAt(n, n2);
            Object object2 = this._editBuffer[n2];
            blArray[n2] = this.isValueModified(object, object2);
            if (!blArray[n2]) continue;
            ++n4;
        }
        boolean bl = true;
        boolean[] blArray2 = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray2[n2] = this._resultSet.isPrimaryKey(n2);
            if (!blArray2[n2]) continue;
            bl = false;
        }
        if (bl) {
            Arrays.fill(blArray2, true);
        }
        if (n4 != 0) {
            Object object;
            stringBuilder.append("UPDATE ");
            if (this._ownerName != null) {
                stringBuilder.append(this._resultSet.quoteIdentifier(this._ownerName));
                stringBuilder.append(".");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
            stringBuilder.append(" SET ");
            boolean bl2 = false;
            for (n2 = 0; n2 < n3; ++n2) {
                if (!blArray[n2]) continue;
                if (bl2) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n2)));
                stringBuilder.append("=");
                object = this._editBuffer[n2];
                if (object == null) {
                    stringBuilder.append("null");
                } else {
                    this.appendParameterToSQL(stringBuilder, object, this._resultSet.getColumnType(n2), arrayList, arrayList2);
                }
                bl2 = true;
            }
            bl2 = false;
            stringBuilder.append(" WHERE ");
            for (n2 = 0; n2 < n3; ++n2) {
                if (!blArray2[n2]) continue;
                if (bl2) {
                    stringBuilder.append(" AND ");
                }
                stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n2)));
                object = this._resultSet.getValueAt(n, n2);
                if (object == null) {
                    stringBuilder.append(" IS NULL");
                } else {
                    stringBuilder.append("=");
                    if (object instanceof LongValue) {
                        this.ensureLongValueIsRead((LongValue)object, n, n2);
                    }
                    this.appendParameterToSQL(stringBuilder, object, this._resultSet.getColumnType(n2), arrayList, arrayList2);
                }
                bl2 = true;
            }
        }
        return stringBuilder.toString();
    }

    private void ensureLongValueIsRead(LongValue longValue, int n, int n2) throws SQLException {
        File file;
        if (longValue.isPartialValue() && (file = longValue.getFile()) == null) {
            file = this._nullAwareTable.getFullColumnValue(n, n2);
            if (file != null) {
                longValue.setFile(file);
            } else {
                throw new SQLException(ResultSetTableResourcesBase.getBundle().getFormatted("ERR_COULD_NOT_FETCH_COLUMN_VALUE", Integer.toString(n2 + 1)));
            }
        }
    }

    void composeUpdateStatement(StringBuilder stringBuilder, int n) throws SQLGenerationException {
        Object object;
        int n2;
        Object var9_3 = null;
        this.ensureTableNameIsKnown();
        if (this._tableName == null) {
            throw new SQLGenerationException(ResultSetTableResourcesBase.getBundle().get("ERR_COULD_NOT_GENERATE_NO_TABLE"), null);
        }
        int n3 = this._resultSet.getColumnCount();
        boolean bl = true;
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = this._resultSet.isPrimaryKey(n2);
            if (!blArray[n2]) continue;
            bl = false;
        }
        if (bl) {
            Arrays.fill(blArray, true);
        }
        stringBuilder.append("UPDATE ");
        if (this._ownerName != null) {
            stringBuilder.append(this._resultSet.quoteIdentifier(this._ownerName));
            stringBuilder.append(".");
        }
        stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
        stringBuilder.append(" SET ");
        boolean bl2 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            if (bl2) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n2)));
            stringBuilder.append("=");
            object = this._resultSet.getValueAt(n, n2);
            if (object == null) {
                stringBuilder.append("null");
            } else if (object instanceof LongTextValue) {
                this.formatLongTextValueAsString(stringBuilder, n, n2, (LongTextValue)object);
            } else if (object instanceof LongBinaryValue) {
                this.formatLongBinaryValueAsString(stringBuilder, n, n2, (LongBinaryValue)object);
            } else {
                this.appendDelimitedValue(stringBuilder, object, this._resultSet.getColumnType(n2));
            }
            bl2 = true;
        }
        bl2 = false;
        stringBuilder.append(" WHERE ");
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray[n2]) continue;
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n2)));
            object = this._resultSet.getValueAt(n, n2);
            if (object == null) {
                stringBuilder.append(" IS NULL");
            } else {
                stringBuilder.append("=");
                if (object instanceof LongTextValue) {
                    this.formatLongTextValueAsString(stringBuilder, n, n2, (LongTextValue)object);
                } else if (object instanceof LongBinaryValue) {
                    this.formatLongBinaryValueAsString(stringBuilder, n, n2, (LongBinaryValue)object);
                } else {
                    this.appendDelimitedValue(stringBuilder, object, this._resultSet.getColumnType(n2));
                }
            }
            bl2 = true;
        }
    }

    String composeRefetchStatement(boolean bl) throws SQLException {
        int n;
        Object[] objectArray = bl ? this._insertBuffer : this._editBuffer;
        int n2 = this._resultSet.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("SELECT ");
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            if (bl2) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n)));
            bl2 = true;
        }
        stringBuilder.append(" FROM ");
        if (this._ownerName != null && this._ownerName.length() != 0) {
            stringBuilder.append(this._resultSet.quoteIdentifier(this._ownerName));
            stringBuilder.append(".");
        }
        stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
        boolean bl3 = false;
        for (n = 0; n < n2; ++n) {
            if (objectArray[n] instanceof DefaultValue || !this._resultSet.isPrimaryKey(n)) continue;
            bl3 = true;
            break;
        }
        bl2 = false;
        for (n = 0; n < n2; ++n) {
            if (objectArray[n] instanceof DefaultValue || bl3 && !this._resultSet.isPrimaryKey(n)) continue;
            if (objectArray[n] instanceof RSTFile || objectArray[n] instanceof LongValue && ((LongValue)objectArray[n]).isPartialValue()) {
                String string = bl ? ResultSetTableResourcesBase.getBundle().get("CANT_COMPOSE_REFETCH_AFTER_INSERT") : ResultSetTableResourcesBase.getBundle().get("CANT_COMPOSE_REFETCH_AFTER_UPDATE");
                throw new SQLException(string);
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            } else {
                stringBuilder.append(" WHERE ");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n)));
            if (objectArray[n] != null) {
                stringBuilder.append('=');
                this.appendDelimitedValue(stringBuilder, objectArray[n], this._resultSet.getColumnType(n));
            } else {
                stringBuilder.append(" IS NULL");
            }
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    void updateCachedRow(ResultSetTableClient.Operation operation, int n, Object[] objectArray) {
        switch (operation) {
            case UPDATE: {
                this._editBuffer = null;
                this._editBufferRow = -1;
                this._resultSet.updateCachedRow(n, objectArray);
                this.fireTableRowsUpdated(n, n);
                break;
            }
            case INSERT: {
                int n2 = this._insertRow;
                this._insertRow = -1;
                if (objectArray == null) {
                    objectArray = this._insertBuffer;
                }
                this._insertBuffer = null;
                --this._preliminaryRowCount;
                this.fireTableRowsDeleted(n2, n2);
                if (this._resultSet.isCaching()) {
                    n = this._resultSet.addRowToCache(objectArray);
                    ++this._preliminaryRowCount;
                    this.fireTableRowsInserted(n, n);
                }
                if (this._actualRowCount == -1) break;
                ++this._actualRowCount;
            }
        }
    }

    String composeInsertStatement(ArrayList<Object> arrayList, ArrayList<Integer> arrayList2) {
        String string;
        this.ensureTableNameIsKnown();
        try {
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            string = databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            string = "";
        }
        StringBuilder stringBuilder = string.equalsIgnoreCase("UltraLite") ? this.createUltraLiteInsertStatement(arrayList, arrayList2) : this.createGenericInsertStatement(arrayList, arrayList2);
        return stringBuilder.toString();
    }

    private StringBuilder createUltraLiteInsertStatement(ArrayList<Object> arrayList, ArrayList<Integer> arrayList2) {
        int n;
        int n2 = this._resultSet.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (this._resultSet.isColumnReadOnly(n) && !this._resultSet.isPrimaryKey(n) || this._insertBuffer[n] instanceof DefaultValue) continue;
            bl = true;
            break;
        }
        if (bl) {
            stringBuilder.append(" (");
            boolean bl2 = false;
            for (n = 0; n < n2; ++n) {
                if (this._resultSet.isColumnReadOnly(n) && !this._resultSet.isPrimaryKey(n) || this._insertBuffer[n] instanceof DefaultValue) continue;
                if (bl2) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n)));
                bl2 = true;
            }
            stringBuilder.append(") VALUES(");
            bl2 = false;
            for (n = 0; n < n2; ++n) {
                Object object;
                if (this._resultSet.isColumnReadOnly(n) && !this._resultSet.isPrimaryKey(n) || this._insertBuffer[n] instanceof DefaultValue) continue;
                if (bl2) {
                    stringBuilder.append(",");
                }
                if ((object = this._insertBuffer[n]) == null) {
                    stringBuilder.append("NULL");
                } else {
                    this.appendParameterToSQL(stringBuilder, object, this._resultSet.getColumnType(n), arrayList, arrayList2);
                }
                bl2 = true;
            }
            stringBuilder.append(")");
        }
        return stringBuilder;
    }

    private StringBuilder createGenericInsertStatement(ArrayList<Object> arrayList, ArrayList<Integer> arrayList2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(256);
        int n2 = this._resultSet.getColumnCount();
        stringBuilder.append("INSERT INTO ");
        if (this._ownerName != null) {
            stringBuilder.append(this._resultSet.quoteIdentifier(this._ownerName));
            stringBuilder.append(".");
        }
        stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
        stringBuilder.append(" (");
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (this._resultSet.isColumnReadOnly(n)) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n)));
            bl = true;
        }
        stringBuilder.append(") VALUES(");
        bl = false;
        for (n = 0; n < n2; ++n) {
            if (this._resultSet.isColumnReadOnly(n)) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            if (this._insertBuffer[n] instanceof DefaultValue) {
                stringBuilder.append("DEFAULT");
            } else {
                Object object = this._insertBuffer[n];
                if (object == null) {
                    stringBuilder.append("NULL");
                } else {
                    this.appendParameterToSQL(stringBuilder, object, this._resultSet.getColumnType(n), arrayList, arrayList2);
                }
            }
            bl = true;
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    void composeInsertStatementForRow(StringBuilder stringBuilder, int n) throws SQLGenerationException {
        int n2;
        this.ensureTableNameIsKnown();
        if (this._tableName == null) {
            throw new SQLGenerationException(ResultSetTableResourcesBase.getBundle().get("ERR_COULD_NOT_GENERATE_NO_TABLE"), null);
        }
        int n3 = this._resultSet.getColumnCount();
        stringBuilder.append("INSERT INTO ");
        if (this._ownerName != null) {
            stringBuilder.append(this._resultSet.quoteIdentifier(this._ownerName));
            stringBuilder.append(".");
        }
        stringBuilder.append(this._resultSet.quoteIdentifier(this._tableName));
        stringBuilder.append(" (");
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this._resultSet.getColumnTableName(n2) == null) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this._resultSet.quoteIdentifier(this._resultSet.getColumnName(n2)));
            bl = true;
        }
        stringBuilder.append(") VALUES(");
        bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            Object object;
            if (this._resultSet.getColumnTableName(n2) == null) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            if ((object = this.getValueAt(n, n2)) == null) {
                stringBuilder.append("NULL");
            } else if (object instanceof LongTextValue) {
                this.formatLongTextValueAsString(stringBuilder, n, n2, (LongTextValue)object);
            } else if (object instanceof LongBinaryValue) {
                this.formatLongBinaryValueAsString(stringBuilder, n, n2, (LongBinaryValue)object);
            } else {
                this.appendDelimitedValue(stringBuilder, object, this._resultSet.getColumnType(n2));
            }
            bl = true;
        }
        stringBuilder.append(")");
    }

    private void formatLongTextValueAsString(StringBuilder stringBuilder, int n, int n2, LongTextValue longTextValue) throws SQLGenerationException {
        Object var5_5 = null;
        try {
            String string;
            if (longTextValue.isPartialValue()) {
                if (longTextValue.getFile() == null) {
                    File file = this._nullAwareTable.getFullColumnValue(n, n2);
                    if (file != null) {
                        longTextValue.setFile(file);
                        string = longTextValue.getValueFromFile(Integer.MAX_VALUE);
                    } else {
                        longTextValue.setNotPartial();
                        string = longTextValue.getTruncatedValue();
                    }
                } else {
                    string = longTextValue.getValueFromFile(Integer.MAX_VALUE);
                }
            } else {
                string = longTextValue.getTruncatedValue();
            }
            NullAwareTable.formatString(stringBuilder, string, true, "'", '\\');
        }
        catch (SQLException sQLException) {
            throw new SQLGenerationException(sQLException);
        }
        catch (IOException iOException) {
            throw new SQLGenerationException(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
            throw new SQLGenerationException(resultSetTableResourcesBase.get("OutOfMemory"), outOfMemoryError);
        }
    }

    private void formatLongBinaryValueAsString(StringBuilder stringBuilder, int n, int n2, LongBinaryValue longBinaryValue) throws SQLGenerationException {
        Object var5_5 = null;
        try {
            byte[] byArray;
            if (longBinaryValue.isPartialValue()) {
                if (longBinaryValue.getFile() == null) {
                    File file = this._nullAwareTable.getFullColumnValue(n, n2);
                    if (file != null) {
                        longBinaryValue.setFile(file);
                        byArray = longBinaryValue.getValueFromFile(Integer.MAX_VALUE);
                    } else {
                        longBinaryValue.setNotPartial();
                        byArray = longBinaryValue.getTruncatedValue();
                    }
                } else {
                    byArray = longBinaryValue.getValueFromFile(Integer.MAX_VALUE);
                }
            } else {
                byArray = longBinaryValue.getTruncatedValue();
            }
            NullAwareTable.formatBinaryValue(stringBuilder, byArray);
        }
        catch (SQLException sQLException) {
            throw new SQLGenerationException(sQLException);
        }
        catch (IOException iOException) {
            throw new SQLGenerationException(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
            throw new SQLGenerationException(resultSetTableResourcesBase.get("OutOfMemory"), outOfMemoryError);
        }
    }

    int getUpdateRow() {
        return this._editBufferRow;
    }

    boolean isEditRowDirty() {
        boolean bl = false;
        if (this._editBuffer != null) {
            int n = this._resultSet.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Object object = this._editBuffer[i];
                Object object2 = this._resultSet.getValueAt(this._editBufferRow, i);
                bl = this.isValueModified(object2, object);
                if (!bl) continue;
                if (!this.dbgEnabled()) break;
                Dbg.printlnEx((String)("Values for column " + i + " are different.\n" + "Buffer=" + object + "\nDatabase=" + object2 + (object != null ? "\nbuffer value is a " + object.getClass().getName() : "\nbuffer value is null") + (object2 != null ? "\ndatabase value is a " + object2.getClass().getName() : "\ndatabase value is null")));
                break;
            }
        }
        return bl;
    }

    int getInsertRow() {
        return this._insertRow;
    }

    private boolean ensureTableNameIsKnown() {
        if (this._tableName == null || this._tableName.length() == 0) {
            this._ownerName = null;
            int n = this._resultSet.getColumnCount();
            for (int i = 0; i < n; ++i) {
                try {
                    this._tableName = this._resultSet.getColumnTableName(i);
                    if (this._tableName == null || this._tableName.length() == 0) continue;
                    this._ownerName = this._resultSet.getColumnSchemaName(i);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this._tableName != null && this._tableName.length() != 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._resultSet == null) {
            throw new IllegalStateException();
        }
        if (n == this._insertRow) {
            this._insertBuffer[n2] = object;
        } else {
            int n3 = this._resultSet.getColumnCount();
            if (this._editBuffer == null) {
                this._editBuffer = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    this._editBuffer[i] = this.getValueAt(n, i);
                }
                this._editBufferRow = n;
            }
            this._editBuffer[n2] = object;
        }
        this.fireTableCellUpdated(n, n2);
    }

    boolean isInserting() {
        return this._insertBuffer != null;
    }

    boolean isEditing() {
        return this._editBuffer != null;
    }

    boolean canGenerateSQL() {
        return this.isEditable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEditable() {
        if (this._editable == -1) {
            boolean bl = this._workerThread.pause();
            if (!bl) {
                this._workerThread.unpause();
                return false;
            }
            try {
                this._editable = this._resultSet.isEditable() ? 1 : 0;
            }
            finally {
                this._workerThread.unpause();
            }
        }
        return this._editable == 1;
    }

    private int isTableEditable(String string, String string2, String string3) {
        boolean bl = this._nullAwareTable.getResultSetTable().getClient().isTableEditable(string, string2, string3);
        return bl ? 1 : 0;
    }

    void setWorkerThread(WorkerThread workerThread) {
        if (workerThread == this._workerThread) {
            return;
        }
        if (this._workerThread != null) {
            this._workerThread.terminate();
            this._workerThread = null;
        }
        this._workerThread = workerThread;
        if (workerThread != null && this._actualRowCount == -1) {
            int n;
            Dimension dimension = this._nullAwareTable.getPreferredScrollableViewportSize();
            int n2 = dimension.height;
            if (n2 == 0) {
                n2 = this._nullAwareTable.getHeight();
            }
            if (n2 != 0) {
                n = 5 * (n2 / this._nullAwareTable.getRowHeight());
                n = Math.max(100, n);
            } else {
                n = 100;
            }
            n = Math.min(n, this._nullAwareTable.getResultSetTable().getMaximumRows());
            if (n > 0) {
                this._nullAwareTable.fireNotificationEvent(8);
                workerThread.fetchRows(n);
            }
        } else if (this._actualRowCount != -1) {
            this._nullAwareTable.fireNotificationEvent(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyEndOfResultSet() {
        this._actualRowCount = this._preliminaryRowCount;
        ResultSetTableModel resultSetTableModel = this;
        synchronized (resultSetTableModel) {
            if (this._firstAsyncRow != -1) {
                this.callTableRowsInsertedOnAWTThread();
            } else if (this._actualRowCount == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ResultSetTableModel.this._nullAwareTable != null) {
                            ResultSetTableModel.this._nullAwareTable.setInitialColumnWidths(ResultSetTableModel.this._connection);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFetcherIdle() {
        boolean bl = false;
        ResultSetTableModel resultSetTableModel = this;
        synchronized (resultSetTableModel) {
            bl = this._firstAsyncRow != this._lastAsyncRow;
        }
        if (bl) {
            this.callTableRowsInsertedOnAWTThread();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ResultSetTableModel.this._nullAwareTable != null) {
                        ResultSetTableModel.this._nullAwareTable.fireNotificationEvent(9);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readRowData() {
        boolean bl;
        int n = this._nullAwareTable.getResultSetTable().getMaximumRows();
        if (this._preliminaryRowCount == n) {
            return;
        }
        try {
            bl = this._resultSet.cacheCurrentRow();
        }
        catch (OutOfMemoryException outOfMemoryException) {
            this._workerThread.abortFetch();
            ResultSetTableModel resultSetTableModel = this;
            synchronized (resultSetTableModel) {
                this.notifyEndOfResultSet();
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ResultSetTableModel resultSetTableModel = ResultSetTableModel.this;
                    synchronized (resultSetTableModel) {
                        ResultSetTableModel.this._preliminaryRowCount = (ResultSetTableModel.this._actualRowCount = 0);
                    }
                    ResultSetTableModel.this.fireTableDataChanged();
                }
            });
            bl = false;
        }
        if (bl) {
            ResultSetTableModel resultSetTableModel = this;
            synchronized (resultSetTableModel) {
                ++this._preliminaryRowCount;
                long l = Calendar.getInstance().getTime().getTime();
                if (this._firstAsyncRow == -1) {
                    this._firstAsyncRow = this._preliminaryRowCount;
                    this._firstAsyncRowTime = l;
                }
                this._lastAsyncRow = this._preliminaryRowCount;
                if (this._preliminaryRowCount == n) {
                    this.notifyEndOfResultSet();
                } else if (l - this._firstAsyncRowTime > 250L) {
                    this._firstAsyncRowTime = l;
                    this.callTableRowsInsertedOnAWTThread();
                }
            }
        }
    }

    private void callTableRowsInsertedOnAWTThread() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n;
                if (ResultSetTableModel.this._resultSet == null) {
                    return;
                }
                boolean bl = false;
                boolean bl2 = false;
                int n2 = 0;
                int n3 = 0;
                ResultSetTableModel resultSetTableModel = ResultSetTableModel.this;
                synchronized (resultSetTableModel) {
                    if (ResultSetTableModel.this._firstAsyncRow != -1) {
                        bl2 = true;
                        if (ResultSetTableModel.this._firstAsyncRow == 1) {
                            bl = true;
                        }
                        n2 = ResultSetTableModel.this._firstAsyncRow - 1;
                        n3 = ResultSetTableModel.this._lastAsyncRow - 1;
                        ResultSetTableModel.this._firstAsyncRow = -1;
                        ResultSetTableModel.this._lastAsyncRow = -1;
                    }
                }
                if (bl) {
                    ResultSetTableModel.this._nullAwareTable.setInitialColumnWidths(ResultSetTableModel.this._connection);
                }
                if (bl2) {
                    ResultSetTableModel.this.fireTableRowsInserted(n2, n3);
                }
                if ((n = ResultSetTableModel.this._workerThread.getFetchCount()) == 0) {
                    ResultSetTableModel.this._nullAwareTable.fireNotificationEvent(9);
                }
            }
        });
    }

    void interrupt() {
        this.notifyEndOfResultSet();
        if (this._workerThread != null) {
            this._workerThread.abortFetch();
        }
    }

    boolean isFetchInProgress() {
        boolean bl = this._workerThread != null ? this._workerThread.getFetchCount() != 0 : false;
        return bl;
    }

    int getColumnScale(int n) {
        return this._resultSet.getColumnScale(n);
    }

    int getColumnPrecision(int n) {
        return this._resultSet.getColumnPrecision(n);
    }

    int getColumnType(int n) {
        return this._resultSet.getColumnType(n);
    }

    String getColumnTypeName(int n) {
        return this._resultSet.getColumnTypeName(n);
    }

    @Override
    public void exception(ScrollableResultSetEvent scrollableResultSetEvent) {
        Exception exception = scrollableResultSetEvent.getException();
        if (exception instanceof OutOfMemoryException && this._workerThread != null) {
            this._workerThread.abortFetch();
        }
    }

    @Override
    public void stateChanged(ScrollableResultSetEvent scrollableResultSetEvent) {
        switch (scrollableResultSetEvent.getStateCode()) {
            case 1: {
                this._resultSet.removeScrollableResultSetListener(this);
                this._resultSet = null;
                this.fireTableStructureChanged();
            }
        }
    }

    void synchronizeTableModelWithResultSet() {
        int n = this._resultSet.getRowCount();
        if (n == -1) {
            this._actualRowCount = -1;
            this._preliminaryRowCount = this._resultSet.getCachedRowCount();
        } else {
            this._actualRowCount = n;
            this._preliminaryRowCount = n;
        }
        this.fireTableDataChanged();
    }

    private boolean dbgEnabled() {
        return ResultSetTable.dbgEnabled("+Model") || Dbg.isMessageTypeEnabled((String)this.getClass().getName());
    }
}

