/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.GenericResultSetTableClient;
import com.sybase.resultSetTable.ResultSetTable;
import com.sybase.resultSetTable.ResultSetTableClient;
import com.sybase.util.Dbg;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JFrame;

public class SAResultSetTableClient
extends GenericResultSetTableClient {
    private static final int DB_UNKNOWN = 0;
    private static final int DB_SQL_ANYWHERE = 1;
    private static final int DB_ULTRALITE = 2;
    private int _databaseType = 0;

    public SAResultSetTableClient(Connection connection, JFrame jFrame) {
        super(connection, jFrame);
        try {
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            this._databaseType = string.equalsIgnoreCase("UltraLite") ? 2 : 1;
        }
        catch (SQLException sQLException) {
            this._databaseType = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTableEditable(String string, String string2, String string3) {
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            String string4;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            resultSet = databaseMetaData.getTables(null, string2, string3, null);
            if (resultSet.next() && !(string4 = resultSet.getString(4).toLowerCase()).equals("materialized view")) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
        return bl;
    }

    @Override
    public ResultSetTableClient.NextAction handleSQLException(ResultSetTableClient.Operation operation, SQLException sQLException) {
        return SAResultSetTableClient.handleSQLException(this._parent, operation, sQLException);
    }

    public static ResultSetTableClient.NextAction handleSQLException(JFrame jFrame, ResultSetTableClient.Operation operation, SQLException sQLException) {
        ResultSetTableClient.NextAction nextAction;
        String string;
        int n;
        String string2;
        if (sQLException != null) {
            string2 = SAResultSetTableClient.stripODBCHeader(sQLException.getLocalizedMessage());
            n = sQLException.getErrorCode();
            string = sQLException.getSQLState();
            if (string == null) {
                string = "";
            }
        } else {
            string2 = "";
            string = "";
            n = 0;
        }
        string2 = SybMessageFormat.format((String)_bundle.get("ERR_SQLEXCEPTION"), (Object[])new Object[]{string2, Integer.toString(n), string});
        switch (operation) {
            case DELETE: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_DELETE_ROW"), (Object[])new Object[]{string2}), (String)SAResultSetTableClient.getOperationDescription(operation), (int)0);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case MULTIPLE_DELETE: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_DELETE_ROWS"), (Object[])new Object[]{string2}), (String)SAResultSetTableClient.getOperationDescription(operation), (int)0);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case INSERT: {
                Object[] objectArray = new String[]{_bundle.get("ChangeButton"), _bundle.get("CancelButton")};
                int n2 = SybOptionPane.showOptionDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_INSERT_ROW"), (Object[])new Object[]{string2}), (String)SAResultSetTableClient.getOperationDescription(operation), (int)-1, (int)0, null, (Object[])objectArray, (Object)objectArray[1]);
                if (n2 == 0) {
                    nextAction = ResultSetTableClient.NextAction.RETRY;
                    break;
                }
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case UPDATE: {
                Object[] objectArray = new String[]{_bundle.get("ChangeButton"), _bundle.get("CancelButton")};
                int n3 = SybOptionPane.showOptionDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("COULD_NOT_UPDATE_ROW"), (Object[])new Object[]{string2}), (String)SAResultSetTableClient.getOperationDescription(operation), (int)-1, (int)0, null, (Object[])objectArray, (Object)objectArray[1]);
                if (n3 == 0) {
                    nextAction = ResultSetTableClient.NextAction.RETRY;
                    break;
                }
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case REFETCH_AFTER_INSERT: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("REFETCH_AFTER_INSERT_REQUIRED"), (Object[])new Object[]{sQLException != null ? string2 : ""}), (String)jFrame.getTitle(), (int)1);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case REFETCH_AFTER_UPDATE: {
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("REFETCH_AFTER_UPDATE_REQUIRED"), (Object[])new Object[]{sQLException != null ? string2 : ""}), (String)jFrame.getTitle(), (int)1);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            case REFETCH_LONG_VALUE: {
                if (sQLException != null && sQLException.getErrorCode() == -143) {
                    string2 = _bundle.get("ERR_CANT_GET_LONG_VALUE");
                }
                SybOptionPane.showMessageDialog((Component)jFrame, (Object)SybMessageFormat.format((String)_bundle.get("REFETCH_LONG_VALUE_FAILED"), (Object[])new Object[]{string2}), (String)jFrame.getTitle(), (int)0);
                nextAction = ResultSetTableClient.NextAction.CANCEL;
                break;
            }
            default: {
                nextAction = ResultSetTableClient.NextAction.CANCEL;
            }
        }
        return nextAction;
    }

    static String stripODBCHeader(String string) {
        boolean bl = false;
        String string2 = string;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (bl) {
                if (c != ']') continue;
                bl = false;
                continue;
            }
            if (c == '[') {
                bl = true;
                continue;
            }
            string2 = string.substring(i);
            break;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareToCommit() throws SQLException {
        Statement statement = null;
        if (this._databaseType == 1) {
            try {
                statement = this._connection.createStatement(1003, 1007);
                statement.execute("PREPARE TO COMMIT");
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object turnOffBlocking() {
        Statement statement = null;
        ResultSet resultSet = null;
        Boolean bl = null;
        try {
            boolean bl2;
            statement = this._connection.createStatement();
            resultSet = statement.executeQuery("select Connection_property('Blocking')");
            resultSet.next();
            String string = resultSet.getString(1).trim();
            boolean bl3 = bl2 = string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("1");
            if (bl2) {
                statement.execute("set temporary option Blocking='off'");
                bl = Boolean.TRUE;
            } else {
                bl = Boolean.FALSE;
            }
        }
        catch (SQLException sQLException) {
            boolean bl4 = false;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreBlocking(Object object) {
        Statement statement = null;
        if (object != null && object == Boolean.TRUE) {
            try {
                statement = this._connection.createStatement();
                statement.execute("set temporary option Blocking='on'");
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                    statement = null;
                }
            }
        }
    }

    private boolean dbgEnabled() {
        return ResultSetTable.dbgEnabled("+Model") || Dbg.isMessageTypeEnabled((String)this.getClass().getName());
    }
}

