/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.LongTextValue;
import com.sybase.resultSetTable.OutOfMemoryException;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.ScrollableResultSetEvent;
import com.sybase.resultSetTable.ScrollableResultSetListener;
import com.sybase.util.Dbg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class ScrollableResultSet {
    public static final int DONT_CACHE = 1;
    public static final int DATE_TIME_ARE_STRINGS = 2;
    private static final int INITIAL_CACHE_CAPACITY = 100;
    public static final String DBG_EXCEPTIONS = "+Exceptions";
    public static final String DBG_BOUNDARIES = "+Boundaries";
    public static final String DBG_FUNCTION_CALLS = "+Calls";
    public static final String DBG_INFO = "+Info";
    protected int _traceIndent = 0;
    public static final int UNKNOWN = -1;
    private SQLWarning _lastWarning = null;
    private int _logWarnings = 0;
    private ResultSet _resultSet;
    private int _resultSetConcurrency;
    private Connection _connection = null;
    protected boolean _primaryKeyChecked;
    protected boolean _primaryKeyIncluded;
    protected int _maxBlobReadBytes = 32;
    protected int _maxClobReadChars = 32;
    private int _rowCount;
    private int _columnCount;
    private int[] _width;
    private int[] _scale;
    private int[] _precision;
    private Class[] _class;
    private int[] _sqlType;
    private String[] _sqlTypeName;
    private String[] _columnName;
    private String[] _columnSchemaName;
    private String[] _columnTableName;
    private String[] _columnLabel;
    private int[] _nullability;
    private boolean[] _readOnly;
    private boolean[] _autoIncrement;
    private String[] _defaultValue;
    private boolean[] _defaultValueFetched;
    private boolean[] _isPrimaryKey;
    private boolean[] _isSigned;
    private String _identifierQuoteString = null;
    private boolean _returnDateTimeAsString = false;
    private boolean _supportsSchemasInDML = true;
    private boolean _supportsCatalogsInDML = false;
    private List<ArrayList<Object>> _cachedRows = null;
    private int _maxRows = 1000;
    private boolean _hasPartialData = true;
    private boolean _hasTruncatedDataValues = false;
    protected EventListenerList _listeners;
    protected volatile boolean _interruptRequested;
    private int _databaseType = -1;
    static final int DB_UNKNOWN = -1;
    static final int DB_ASA = 1;
    static final int DB_ASE = 2;
    static final int DB_GENERIC = 3;
    private Boolean _usingJConnect = null;
    private boolean _cacheLastRowOnly = false;
    private Object _logWarningMutex = new Object();
    private static final int EDITABLE_UNKNOWN = -1;
    private static final int EDITABLE_NO = 0;
    private static final int EDITABLE_YES = 1;
    private int _editable = -1;

    public ScrollableResultSet(Connection connection, ResultSet resultSet, int n, int n2) {
        String string;
        boolean bl;
        if (connection == null) {
            throw new IllegalArgumentException("null connection is not allowed");
        }
        if (resultSet == null) {
            throw new IllegalArgumentException("null result set not allowed");
        }
        this._resultSet = resultSet;
        this._connection = connection;
        try {
            this._resultSetConcurrency = resultSet.getConcurrency();
        }
        catch (SQLException sQLException) {
            this._resultSetConcurrency = 1007;
        }
        this._primaryKeyChecked = false;
        this._rowCount = -1;
        this._maxRows = n < 0 ? Integer.MAX_VALUE : n;
        this._returnDateTimeAsString = (n2 & 2) != 0;
        this.cacheMetaData();
        if ((n2 & 1) == 0) {
            bl = true;
        } else {
            try {
                int n3 = resultSet.getType();
                bl = n3 == 1003;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (!bl && (string = ScrollableResultSet.getSystemProperty("dontCache")) != null && string.equals("1")) {
            bl = false;
        }
        if (bl) {
            this._cachedRows = new Vector<ArrayList<Object>>(100);
        }
    }

    public static String getSQLTypeName(int n) {
        switch (n) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case -5: {
                return "BIGINT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -2: {
                return "BINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 1: {
                return "CHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "SMALLINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 12: {
                return "VARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
        }
        return "TYPE_" + n;
    }

    public void setCacheLastRowOnly(boolean bl) {
        this._cacheLastRowOnly = bl;
    }

    public boolean getCacheLastRowOnly() {
        return this._cacheLastRowOnly;
    }

    int getDatabaseType() {
        if (this._databaseType == -1) {
            this._databaseType = 3;
            try {
                DatabaseMetaData databaseMetaData = this._connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if (string.indexOf("Adaptive Server Anywhere") != -1 || string.indexOf("Adaptive Server IQ") != -1 || string.indexOf("Sybase IQ") != -1 || string.indexOf("SQL Anywhere") != -1) {
                    this._databaseType = 1;
                } else if (string.equals("Sybase SQL Server") || string.equals("Adaptive Server Enterprise")) {
                    this._databaseType = 2;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this._databaseType;
    }

    String quoteIdentifier(String string) {
        String string2;
        int n = this.getDatabaseType();
        if (n == 2) {
            string2 = string;
        } else {
            if (this._identifierQuoteString == null) {
                try {
                    this._identifierQuoteString = this._connection.getMetaData().getIdentifierQuoteString();
                    if (this._identifierQuoteString == null || this._identifierQuoteString.equals(" ")) {
                        this._identifierQuoteString = "";
                    }
                }
                catch (Exception exception) {
                    this._identifierQuoteString = "";
                }
            }
            string2 = this._identifierQuoteString + string + this._identifierQuoteString;
        }
        return string2;
    }

    boolean supportsSchemasInDML() {
        return this._supportsSchemasInDML;
    }

    boolean supportsCatalogsInDML() {
        return this._supportsCatalogsInDML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyResultSetClosure() {
        try {
            this.startLoggingWarnings();
            if (this._rowCount == -1) {
                this._rowCount = this._cachedRows.size();
            }
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this._interruptRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getJDBCResultSet() {
        try {
            this.startLoggingWarnings();
            ResultSet resultSet = this._resultSet;
            return resultSet;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        this._maxRows = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxRows() {
        int n = this._maxRows;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        this.fireStateChangedEvent(1);
        this.removeAllListeners();
        this.clearMetaDataCache();
        this.clearDataCache();
        this.clearWarnings();
        this._resultSet = null;
        this._connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnCount() {
        try {
            this.startLoggingWarnings();
            int n = this._columnCount;
            return n;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getRowCount() {
        try {
            this.startLoggingWarnings();
            int n = this._rowCount;
            return n;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    public synchronized int getCachedRowCount() {
        int n = this._cachedRows != null ? this._cachedRows.size() : 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            String string = this._columnName[n];
            return string;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnSchemaName(int n) {
        if (n >= this._columnCount) {
            throw new IllegalArgumentException("Asked for column " + n + ", but only " + this._columnCount + " are known");
        }
        String string = this._columnSchemaName[n];
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnTableName(int n) {
        if (n >= this._columnCount) {
            throw new IllegalArgumentException("Asked for column " + n + ". Result set only has " + this._columnCount + " columns.");
        }
        String string = this._columnTableName[n];
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnLabel(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            String string = this._columnLabel[n];
            return string;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnWidth(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            int n2 = this._width[n];
            return n2;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getColumnClass(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            Class clazz = this._class[n];
            return clazz;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnType(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            int n2 = this._sqlType[n];
            return n2;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnTypeName(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            String string = this._sqlTypeName[n];
            return string;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnAutoIncrement(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            boolean bl = this._autoIncrement[n];
            return bl;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnReadOnly(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            if (this._readOnly == null) {
                this.cacheMetaDataForEditing();
            }
            boolean bl = this._readOnly[n];
            return bl;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnNullability(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            int n2 = this._nullability[n];
            return n2;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isColumnSigned(int n) {
        if (n >= this._columnCount) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        boolean bl = this._isSigned[n];
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimaryKey(int n) {
        boolean bl = false;
        try {
            this.startLoggingWarnings();
            if (this._isPrimaryKey == null) {
                this.cachePrimaryKeyMetaData();
            }
            boolean bl2 = bl = this._isPrimaryKey[n];
            return bl2;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePrimaryKeyMetaData() {
        this._primaryKeyIncluded = true;
        this._isPrimaryKey = new boolean[this._columnCount];
        if (this._columnCount > 0) {
            String string = this._columnSchemaName[0];
            String string2 = this._columnTableName[0];
            if (string2 != null && string2.length() > 0) {
                ResultSet resultSet = null;
                try {
                    DatabaseMetaData databaseMetaData = this._connection.getMetaData();
                    resultSet = databaseMetaData.getPrimaryKeys(null, string, string2);
                    while (resultSet.next()) {
                        int n;
                        String string3 = resultSet.getString(4);
                        for (n = 0; n < this._columnCount; ++n) {
                            if (!this._columnName[n].equalsIgnoreCase(string3)) continue;
                            this._isPrimaryKey[n] = true;
                            break;
                        }
                        if (n != this._columnCount) continue;
                        this._primaryKeyIncluded = false;
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                        resultSet = null;
                    }
                }
            } else {
                this._primaryKeyIncluded = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnDefaultValue(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            if (!this._defaultValueFetched[n]) {
                this.cacheDefaultValue(n);
            }
            String string = this._defaultValue[n];
            return string;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheDefaultValue(int n) {
        if (this._columnTableName[n] == null || this._columnTableName[n].isEmpty()) {
            return;
        }
        ResultSet resultSet = null;
        try {
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, this._columnSchemaName[n], this._columnTableName[n], "%");
            while (resultSet.next()) {
                String string = resultSet.getString(4);
                int n2 = this.findColumnByNames(this._columnSchemaName[n], this._columnTableName[n], string);
                if (n2 == -1 || this._defaultValueFetched[n2]) continue;
                this._defaultValue[n2] = resultSet.getString(13);
                if (this._defaultValue[n2] == null) {
                    this._defaultValue[n2] = "NULL";
                }
                this._defaultValueFetched[n2] = true;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnScale(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            int n2 = this._scale[n];
            return n2;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnPrecision(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            int n2 = this._precision[n];
            return n2;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnBinary(int n) {
        try {
            this.startLoggingWarnings();
            if (n >= this._columnCount) {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            boolean bl = this._class[n] == byte[].class;
            return bl;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasPartialData() {
        try {
            this.startLoggingWarnings();
            boolean bl = this._hasPartialData || this._hasTruncatedDataValues;
            return bl;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    public synchronized boolean hasCachedAllRows() {
        return !this._hasPartialData;
    }

    synchronized void updateCachedRow(int n, Object[] objectArray) {
        if (this._cachedRows != null && this._cachedRows.size() > n) {
            ArrayList<Object> arrayList = this._cachedRows.get(n);
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                arrayList.set(i, objectArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean updateCachedRow(Connection connection, String string, String string2, int n, Object[] objectArray) {
        boolean bl = false;
        if (this._cachedRows != null && this._cachedRows.size() > n) {
            bl = this.refetchRow(connection, string, string2, objectArray);
            ArrayList<Object> arrayList = this._cachedRows.get(n);
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                arrayList.set(i, objectArray[i]);
            }
        } else {
            try {
                ResultSet resultSet = this._resultSet;
                synchronized (resultSet) {
                    this._resultSet.absolute(n + 1);
                    this._resultSet.refreshRow();
                }
                bl = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    synchronized int addRowToCache(Object[] objectArray) {
        if (objectArray == null || objectArray.length != this._columnCount) {
            throw new IllegalArgumentException();
        }
        int n = this._cachedRows.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(this._columnCount);
        for (int i = 0; i < this._columnCount; ++i) {
            arrayList.add(objectArray[i]);
        }
        this._cachedRows.add(arrayList);
        if (this._rowCount != -1) {
            ++this._rowCount;
        }
        return n;
    }

    synchronized void removeRowFromCache(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this._cachedRows != null) {
            this._cachedRows.remove(n);
            if (this._rowCount != -1) {
                --this._rowCount;
            }
        }
    }

    private boolean refetchRow(Connection connection, String string, String string2, Object[] objectArray) {
        int n;
        boolean bl;
        if (this._isPrimaryKey == null) {
            this.cachePrimaryKeyMetaData();
        }
        if (bl = this._primaryKeyIncluded) {
            bl = false;
            for (n = 0; n < this._isPrimaryKey.length; ++n) {
                if (!this._isPrimaryKey[n]) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n = 0; n < this._isPrimaryKey.length; ++n) {
                    if (!this._isPrimaryKey[n] || objectArray[n] == null || !(objectArray[n] instanceof DefaultValue)) continue;
                    bl = false;
                    break;
                }
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("SELECT ");
            boolean bl2 = false;
            for (n = 0; n < this._columnCount; ++n) {
                if (bl2) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.quoteIdentifier(this._columnName[n]));
                bl2 = true;
            }
            stringBuilder.append(" FROM ");
            if (string != null && string.length() != 0) {
                stringBuilder.append(this.quoteIdentifier(string));
                stringBuilder.append(".");
            }
            stringBuilder.append(this.quoteIdentifier(string2));
            bl2 = false;
            for (n = 0; n < this._columnCount; ++n) {
                if (!this._isPrimaryKey[n]) continue;
                if (bl2) {
                    stringBuilder.append(" AND ");
                } else {
                    stringBuilder.append(" WHERE ");
                }
                stringBuilder.append(this.quoteIdentifier(this._columnName[n]));
                if (objectArray[n] != null) {
                    stringBuilder.append("=?");
                } else {
                    stringBuilder.append(" IS NULL");
                }
                bl2 = true;
            }
            try {
                Object object;
                PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
                int n2 = 1;
                for (n = 0; n < this._columnCount; ++n) {
                    if (!this._isPrimaryKey[n] || (object = objectArray[n]) == null) continue;
                    if (object instanceof Boolean) {
                        preparedStatement.setBoolean(n2, (Boolean)object);
                    } else if (object instanceof Integer) {
                        preparedStatement.setInt(n2, (Integer)object);
                    } else {
                        preparedStatement.setString(n2, object.toString().trim());
                    }
                    ++n2;
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                bl = resultSet.next();
                if (bl) {
                    for (n = 0; n < this._columnCount; ++n) {
                        object = this.getResultSetValue(resultSet, n, this._sqlType[n]);
                        objectArray[n] = object = this.convertToLongValue(object);
                    }
                }
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                this.fireExceptionEvent(exception);
                bl = false;
            }
        }
        return bl;
    }

    Object[] readRowDataForRefetch(ResultSet resultSet) {
        Object[] objectArray;
        try {
            objectArray = new Object[this._columnCount];
            for (int i = 0; i < this._columnCount; ++i) {
                Object object = this.getResultSetValue(resultSet, i, this._sqlType[i]);
                objectArray[i] = object = this.convertToLongValue(object);
            }
        }
        catch (Exception exception) {
            objectArray = null;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getValueAt(int n, int n2) {
        Object object = null;
        if (this._resultSet == null) {
            throw new IllegalStateException();
        }
        try {
            ResultSet resultSet;
            this.startLoggingWarnings();
            if (this._cachedRows != null) {
                if (this._rowCount == -1 && n >= this._cachedRows.size()) {
                    this._interruptRequested = false;
                    this.cacheRows(n + 1);
                    if (n >= this._cachedRows.size()) {
                        this._rowCount = this._cachedRows.size();
                    }
                }
                if (n >= this._cachedRows.size() || n2 >= this._columnCount) {
                    throw new NoSuchElementException("Attempt to read outside result set, row " + n + ", column " + n2);
                }
                ArrayList<Object> arrayList = this._cachedRows.get(n);
                object = arrayList.get(n2);
            } else {
                try {
                    if (this._rowCount != -1 && n >= this._rowCount) {
                        throw new NoSuchElementException(Integer.toString(n));
                    }
                    resultSet = this._resultSet;
                    synchronized (resultSet) {
                        boolean bl = this._resultSet.absolute(n + 1);
                        if (!bl) {
                            if (this._rowCount == -1 || this._rowCount > n + 1) {
                                this._rowCount = n;
                            }
                            throw new NoSuchElementException();
                        }
                        object = this.getResultSetValue(this._resultSet, n2, this._sqlType[n2]);
                    }
                }
                catch (Exception exception) {
                    object = null;
                    this.fireExceptionEvent(exception);
                }
            }
            resultSet = object;
            return resultSet;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allPrimaryKeysIncluded(Connection connection, String string, String string2) {
        ResultSet resultSet = null;
        if (connection == null) {
            throw new IllegalArgumentException("null connection not allowed");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("null or empty table not allowed");
        }
        if (!this._primaryKeyChecked) {
            this._primaryKeyIncluded = true;
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                resultSet = databaseMetaData.getPrimaryKeys(null, string, string2);
                while (resultSet.next()) {
                    int n;
                    String string3 = resultSet.getString(4);
                    for (n = 0; n < this._columnCount && !this._columnName[n].equalsIgnoreCase(string3); ++n) {
                    }
                    if (n != this._columnCount) continue;
                    this._primaryKeyIncluded = false;
                    break;
                }
                resultSet.close();
                resultSet = null;
            }
            catch (SQLException sQLException) {
                this._primaryKeyIncluded = false;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                }
                catch (SQLException sQLException) {}
            }
            this._primaryKeyChecked = true;
        }
        return this._primaryKeyIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() throws SQLException {
        SQLWarning sQLWarning = null;
        if (this._resultSet == null) {
            return false;
        }
        ResultSet resultSet = this._resultSet;
        synchronized (resultSet) {
            boolean bl;
            block13: {
                if (this.isClosed()) {
                    return false;
                }
                try {
                    this.startLoggingWarnings();
                    this._resultSet.clearWarnings();
                    bl = this._resultSet.next();
                    if (bl) {
                        try {
                            sQLWarning = this._resultSet.getWarnings();
                        }
                        catch (SQLException sQLException) {
                            this.stopLoggingWarnings();
                            boolean bl2 = false;
                            this.stopLoggingWarnings();
                            return bl2;
                        }
                        if (sQLWarning == null) return bl;
                        this.setWarning(sQLWarning);
                        break block13;
                    }
                    ScrollableResultSet scrollableResultSet = this;
                    synchronized (scrollableResultSet) {
                        this._hasPartialData = false;
                        if (this._rowCount != -1) return bl;
                        this._rowCount = this._cachedRows.size();
                    }
                }
                finally {
                    this.stopLoggingWarnings();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWarning(SQLWarning sQLWarning) {
        Object object = this._logWarningMutex;
        synchronized (object) {
            this._lastWarning = sQLWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() {
        Object object = this._logWarningMutex;
        synchronized (object) {
            this._lastWarning = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() {
        SQLWarning sQLWarning;
        Object object = this._logWarningMutex;
        synchronized (object) {
            sQLWarning = this._lastWarning;
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoggingWarnings() {
        int n;
        Object object = this._logWarningMutex;
        synchronized (object) {
            ++this._logWarnings;
            n = this._logWarnings;
        }
        if (n == 1) {
            this.clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLoggingWarnings() {
        Object object = this._logWarningMutex;
        synchronized (object) {
            --this._logWarnings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cacheRows(int n) {
        try {
            this.startLoggingWarnings();
            if (n > this._maxRows) {
                n = this._maxRows;
            }
            if (this._rowCount != -1 && n > this._rowCount) {
                return;
            }
            int n2 = this._cachedRows.size();
            while (n2 < n) {
                if (this._interruptRequested) {
                    this._interruptRequested = false;
                    break;
                }
                try {
                    boolean bl;
                    ResultSet resultSet = this._resultSet;
                    synchronized (resultSet) {
                        this._resultSet.clearWarnings();
                        bl = this._resultSet.next();
                        SQLWarning sQLWarning = this._resultSet.getWarnings();
                        if (sQLWarning != null) {
                            this.setWarning(sQLWarning);
                        }
                    }
                    if (bl) {
                        if (!this.cacheCurrentRow()) continue;
                        ++n2;
                        continue;
                    }
                    this._rowCount = this._cachedRows.size();
                    this._hasPartialData = false;
                }
                catch (OutOfMemoryException outOfMemoryException) {
                    this._rowCount = 0;
                    this._hasPartialData = true;
                    this._cachedRows.clear();
                    this.fireExceptionEvent(outOfMemoryException);
                }
                catch (Exception exception) {
                    this.fireExceptionEvent(exception);
                    this._rowCount = this._cachedRows.size();
                }
                break;
            }
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean cacheCurrentRow() throws OutOfMemoryException {
        boolean bl;
        try {
            int n;
            ArrayList<Object> arrayList = this.cacheOneRow();
            if (this._cacheLastRowOnly && (n = this._cachedRows.size()) > 0) {
                this._cachedRows.set(n - 1, null);
            }
            this._cachedRows.add(arrayList);
            bl = true;
        }
        catch (OutOfMemoryException outOfMemoryException) {
            this._rowCount = 0;
            this._hasPartialData = true;
            this._cachedRows.clear();
            throw outOfMemoryException;
        }
        catch (CachingAbortedException cachingAbortedException) {
            this._hasPartialData = true;
            bl = false;
        }
        boolean bl2 = bl;
        return bl2;
    }

    private static boolean isLowOnMemory() {
        long l;
        long l2;
        boolean bl = false;
        Runtime runtime = Runtime.getRuntime();
        long l3 = runtime.totalMemory();
        if (l3 == (l2 = runtime.maxMemory()) && (l = runtime.freeMemory()) < 0x1400000L) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Object> cacheOneRow() throws CachingAbortedException, OutOfMemoryException {
        ArrayList<Object> arrayList = null;
        boolean bl = false;
        Object var5_3 = null;
        if (ScrollableResultSet.isLowOnMemory()) {
            System.gc();
            if (ScrollableResultSet.isLowOnMemory()) {
                OutOfMemoryException outOfMemoryException = new OutOfMemoryException();
                this.fireExceptionEvent(outOfMemoryException);
                throw outOfMemoryException;
            }
        }
        try {
            arrayList = new ArrayList<Object>(this._columnCount);
            for (int i = 0; i < this._columnCount; ++i) {
                if (this._interruptRequested) {
                    bl = true;
                    break;
                }
                try {
                    Object object = this.getResultSetValue(this._resultSet, i, this._sqlType[i]);
                    object = this.convertToLongValue(object);
                    arrayList.add(object);
                    continue;
                }
                catch (Exception exception) {
                    this.fireExceptionEvent(exception);
                    bl = true;
                    break;
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            if (arrayList != null) {
                arrayList.clear();
                arrayList = null;
            }
            OutOfMemoryException outOfMemoryException = new OutOfMemoryException();
            this.fireExceptionEvent(outOfMemoryException);
            throw outOfMemoryException;
        }
        if (bl) {
            throw new CachingAbortedException();
        }
        ArrayList<Object> arrayList2 = arrayList;
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object convertToLongValue(Object object) throws IOException, SQLException {
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            if (!this._hasTruncatedDataValues) {
                try {
                    int n = inputStream.available();
                    if (n == this._maxBlobReadBytes) {
                        this._hasTruncatedDataValues = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            byte[] byArray = ScrollableResultSet.blobToArray(inputStream, this._maxBlobReadBytes);
            object = new LongBinaryValue(byArray, this._maxBlobReadBytes);
        } else if (object instanceof Reader) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                boolean bl = this._hasTruncatedDataValues;
                this._hasTruncatedDataValues = false;
                object = this.readerToString((Reader)object);
                if (this._hasTruncatedDataValues) {
                    object = new LongTextValue((String)object, this._maxClobReadChars);
                }
                this._hasTruncatedDataValues |= bl;
            }
        } else if (object instanceof Clob) {
            object = ((Clob)object).getSubString(0L, this._maxClobReadChars);
            object = new LongTextValue((String)object, this._maxClobReadChars);
        }
        return object;
    }

    private String readerToString(Reader reader) throws IOException {
        StringBuilder stringBuilder;
        block6: {
            int n = this._maxClobReadChars;
            if (n == 0) {
                n = Integer.MAX_VALUE;
            }
            char[] cArray = new char[8192];
            stringBuilder = new StringBuilder();
            int n2 = 8192;
            do {
                int n3;
                if (n2 + stringBuilder.length() > n) {
                    n2 = n - stringBuilder.length();
                }
                if ((n3 = reader.read(cArray, 0, n2)) == -1) break block6;
                stringBuilder.append(cArray, 0, n3);
            } while (stringBuilder.length() != n);
            try {
                if (reader.read() != -1) {
                    this._hasTruncatedDataValues = true;
                }
            }
            catch (IOException iOException) {
                this._hasTruncatedDataValues = true;
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rowExists(int n) {
        boolean bl;
        try {
            this.startLoggingWarnings();
            if (this._cachedRows != null) {
                if (n >= this._cachedRows.size()) {
                    this.cacheRows(n + 1);
                }
                bl = n < this._cachedRows.size();
            } else {
                bl = false;
            }
        }
        finally {
            this.stopLoggingWarnings();
        }
        return bl;
    }

    static byte[] blobToArray(InputStream inputStream, int n) {
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            while ((n2 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n2);
                if (byteArrayOutputStream.size() != n) continue;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResultSetValue(ResultSet resultSet, int n, int n2) throws Exception {
        Object object = null;
        ResultSet resultSet2 = resultSet;
        synchronized (resultSet2) {
            Object object2;
            Object object3;
            try {
                if (this._returnDateTimeAsString && (n2 == 92 || n2 == 91 || n2 == 93)) {
                    n2 = 12;
                }
                resultSet.clearWarnings();
                switch (n2) {
                    case 1: 
                    case 12: {
                        object = resultSet.getString(n + 1);
                        break;
                    }
                    case -1: {
                        try {
                            object = resultSet.getClob(n + 1).getCharacterStream();
                        }
                        catch (Exception exception) {
                            object = resultSet.getCharacterStream(n + 1);
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        try {
                            object = resultSet.getBigDecimal(n + 1);
                        }
                        catch (Exception exception) {
                            try {
                                object = resultSet.getObject(n + 1);
                            }
                            catch (Exception exception2) {
                                object = resultSet.getString(n + 1);
                            }
                        }
                        break;
                    }
                    case -7: {
                        object = resultSet.getBoolean(n + 1);
                        break;
                    }
                    case -6: {
                        int n3 = resultSet.getInt(n + 1);
                        if (n3 < 0) {
                            n3 += 256;
                        }
                        object = n3;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        try {
                            object3 = resultSet.getBlob(n + 1);
                            if (object3 != null) {
                                long l = object3.length();
                                if (l < 0L || this._maxBlobReadBytes != 0 && l > (long)this._maxBlobReadBytes) {
                                    l = this._maxBlobReadBytes;
                                }
                                if (l > 0L) {
                                    object2 = object3.getBytes(1L, (int)l);
                                    object = new ByteArrayInputStream((byte[])object2);
                                    break;
                                }
                                object = new ByteArrayInputStream(new byte[0]);
                                break;
                            }
                            object = null;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            object = resultSet.getBinaryStream(n + 1);
                        }
                        break;
                    }
                    case 5: {
                        if (this._isSigned[n]) {
                            object = resultSet.getShort(n + 1);
                            break;
                        }
                        object = resultSet.getInt(n + 1);
                        break;
                    }
                    case 4: {
                        if (this._isSigned[n]) {
                            object = resultSet.getInt(n + 1);
                            break;
                        }
                        object = resultSet.getLong(n + 1);
                        break;
                    }
                    case -5: {
                        if (this._isSigned[n]) {
                            object = resultSet.getLong(n + 1);
                            break;
                        }
                        object = resultSet.getBigDecimal(n + 1);
                        break;
                    }
                    case 6: 
                    case 8: {
                        object = resultSet.getDouble(n + 1);
                        break;
                    }
                    case 7: {
                        object = Float.valueOf(resultSet.getFloat(n + 1));
                        break;
                    }
                    case 91: {
                        object = resultSet.getDate(n + 1);
                        break;
                    }
                    case 92: {
                        object = resultSet.getTime(n + 1);
                        break;
                    }
                    case 93: {
                        object = resultSet.getTimestamp(n + 1);
                        break;
                    }
                    case 2000: {
                        object = ResultSetTableResourcesBase.getBundle().get("JavaObject");
                        break;
                    }
                    default: {
                        object = resultSet.getObject(n + 1);
                    }
                }
                if (n2 != 2000 && resultSet.wasNull()) {
                    object = null;
                }
                object3 = object;
            }
            catch (Throwable throwable) {
                SQLWarning sQLWarning = resultSet.getWarnings();
                if (sQLWarning != null) {
                    this.setWarning(sQLWarning);
                }
                throw throwable;
            }
            object2 = resultSet.getWarnings();
            if (object2 != null) {
                this.setWarning((SQLWarning)object2);
            }
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMetaData() {
        try {
            ResultSetMetaData resultSetMetaData;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            this._supportsCatalogsInDML = databaseMetaData.supportsCatalogsInDataManipulation();
            this._supportsSchemasInDML = databaseMetaData.supportsSchemasInDataManipulation();
            ResultSet resultSet = this._resultSet;
            synchronized (resultSet) {
                resultSetMetaData = this._resultSet.getMetaData();
            }
            this._columnCount = resultSetMetaData.getColumnCount();
            this.cacheColumnClasses(resultSetMetaData);
            this.cacheColumnNames(resultSetMetaData);
            if (this.getDatabaseType() == 1) {
                this.fixupDateTimeColumnTypes();
            } else {
                this._returnDateTimeAsString = false;
            }
        }
        catch (SQLException sQLException) {
            this.clearMetaDataCache();
            this.fireExceptionEvent(sQLException);
        }
        this._defaultValueFetched = new boolean[this._columnCount];
        this._defaultValue = new String[this._columnCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupDateTimeColumnTypes() {
        DatabaseMetaData databaseMetaData = null;
        ResultSet resultSet = null;
        this._returnDateTimeAsString = false;
        boolean[] blArray = new boolean[this._columnCount];
        Arrays.fill(blArray, false);
        try {
            for (int i = 0; i < this._columnCount; ++i) {
                if (blArray[i] || this._sqlType[i] != 12 && this._sqlType[i] != -1 || this._columnTableName[i] == null || this._columnTableName[i].isEmpty()) continue;
                if (databaseMetaData == null) {
                    databaseMetaData = this._connection.getMetaData();
                }
                resultSet = databaseMetaData.getColumns(null, this._columnSchemaName[i], this._columnTableName[i], "%");
                while (resultSet.next()) {
                    String string = resultSet.getString(4);
                    int n = this.findColumnByNames(this._columnSchemaName[i], this._columnTableName[i], string);
                    if (n == -1) continue;
                    int n2 = resultSet.getInt(5);
                    if (n2 == 91 || n2 == 92 || n2 == 93) {
                        this._sqlType[n] = n2;
                        this._class[n] = ScrollableResultSet.convertSQLTypeToJavaType(n2);
                        this._sqlTypeName[n] = resultSet.getString(6);
                        this._returnDateTimeAsString = true;
                    } else if (n2 == -1) {
                        this._sqlTypeName[n] = resultSet.getString(6);
                    }
                    blArray[n] = true;
                }
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private int findColumnByNames(String string, String string2, String string3) {
        int n = -1;
        for (int i = 0; i < this._columnCount; ++i) {
            if (!this.objectNamesMatch(string, this._columnSchemaName[i]) || !this.objectNamesMatch(string2, this._columnTableName[i]) || !this.objectNamesMatch(string3, this._columnName[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    private boolean objectNamesMatch(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null ^ string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    Object convertDateTimeValue(int n, Object object) throws SQLException {
        Object object2 = object;
        if (this._returnDateTimeAsString && object instanceof String) {
            int n2 = this._sqlType[n];
            if (n2 == 91) {
                object2 = this.getStringAsType(91, "date", (String)object);
            } else if (n2 == 92) {
                object2 = this.getStringAsType(92, "time", (String)object);
            } else if (n2 == 93) {
                object2 = this.getStringAsType(93, "timestamp", (String)object);
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object getStringAsType(int n, String string, String string2) throws SQLException {
        Object object = string2;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        try {
            statement = this._connection.createStatement();
            statement.execute("set temporary option Return_date_time_as_string='off'");
            statement2 = this._connection.prepareStatement("select cast( ? as " + string + ")");
            statement2.setString(1, string2);
            resultSet = statement2.executeQuery();
            if (resultSet.next()) {
                if (n == 91) {
                    object = resultSet.getDate(1);
                } else if (n == 92) {
                    object = resultSet.getTime(1);
                } else if (n == 93) {
                    object = resultSet.getTimestamp(1);
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            block42: {
                block43: {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                        resultSet = null;
                    }
                    if (statement2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (SQLException sQLException) {}
                        statement2 = null;
                    }
                    if (statement == null) break block42;
                    statement.execute("set temporary option Return_date_time_as_string='on'");
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                    break block43;
                    catch (SQLException sQLException) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException2) {}
                        catch (Throwable throwable) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException3) {}
                            throw throwable;
                        }
                    }
                }
                statement = null;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMetaDataForEditing() {
        try {
            ResultSetMetaData resultSetMetaData;
            ResultSet resultSet = this._resultSet;
            synchronized (resultSet) {
                resultSetMetaData = this._resultSet.getMetaData();
            }
            if (this._readOnly == null) {
                this.cacheReadOnly(resultSetMetaData);
            }
        }
        catch (SQLException sQLException) {
            this._readOnly = new boolean[this._columnCount];
            Arrays.fill(this._readOnly, true);
        }
    }

    private void cacheColumnClasses(ResultSetMetaData resultSetMetaData) {
        boolean bl = resultSetMetaData.getClass().getName().indexOf(".tds.") > 0;
        this._width = new int[this._columnCount];
        this._scale = new int[this._columnCount];
        this._precision = new int[this._columnCount];
        this._class = new Class[this._columnCount];
        this._sqlType = new int[this._columnCount];
        this._isSigned = new boolean[this._columnCount];
        this._sqlTypeName = new String[this._columnCount];
        this._nullability = new int[this._columnCount];
        this._autoIncrement = new boolean[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            boolean bl2;
            int n;
            try {
                n = resultSetMetaData.getColumnType(i + 1);
                bl2 = resultSetMetaData.isSigned(i + 1);
            }
            catch (SQLException sQLException) {
                n = 1;
                bl2 = true;
            }
            this._sqlType[i] = n;
            this._isSigned[i] = bl2;
            try {
                this._sqlTypeName[i] = bl ? ScrollableResultSet.getSQLTypeName(n) : resultSetMetaData.getColumnTypeName(i + 1);
            }
            catch (SQLException sQLException) {
                this._sqlTypeName[i] = null;
            }
            this._class[i] = ScrollableResultSet.convertSQLTypeToJavaType(n);
            if (this._class[i] == null) {
                this._class[i] = Object.class;
            }
            try {
                this._width[i] = resultSetMetaData.getColumnDisplaySize(i + 1);
            }
            catch (SQLException sQLException) {
                this._width[i] = 32;
            }
            try {
                this._scale[i] = resultSetMetaData.getScale(i + 1);
                this._precision[i] = resultSetMetaData.getPrecision(i + 1);
            }
            catch (SQLException sQLException) {
                this._scale[i] = 0;
                this._precision[i] = 0;
            }
            try {
                this._nullability[i] = resultSetMetaData.isNullable(i + 1);
            }
            catch (SQLException sQLException) {
                this._nullability[i] = 2;
            }
            try {
                this._autoIncrement[i] = resultSetMetaData.isAutoIncrement(i + 1);
                continue;
            }
            catch (SQLException sQLException) {
                this._autoIncrement[i] = false;
            }
        }
        if (!this.usingJConnect()) {
            this.cacheIsReadOnlyFromMetaData(resultSetMetaData);
        }
    }

    private boolean usingJConnect() {
        if (this._usingJConnect == null) {
            try {
                DatabaseMetaData databaseMetaData = this._connection.getMetaData();
                String string = databaseMetaData.getDriverName();
                this._usingJConnect = string != null && string.length() > 0 && string.toLowerCase().indexOf("jconnect") != -1 ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception exception) {
                this._usingJConnect = Boolean.FALSE;
            }
        }
        return this._usingJConnect;
    }

    private void cacheReadOnly(ResultSetMetaData resultSetMetaData) {
        if (this.usingJConnect()) {
            this.cacheResultSetMetaDataForJConnect(resultSetMetaData);
        } else {
            this.cacheIsReadOnlyFromMetaData(resultSetMetaData);
        }
    }

    private void cacheIsReadOnlyFromMetaData(ResultSetMetaData resultSetMetaData) {
        this._readOnly = new boolean[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            try {
                this._readOnly[i] = resultSetMetaData.isReadOnly(i + 1);
                continue;
            }
            catch (SQLException sQLException) {
                this._readOnly[i] = true;
            }
        }
    }

    private void cacheResultSetMetaDataForJConnect(ResultSetMetaData resultSetMetaData) {
        Statement statement = null;
        ResultSet resultSet = null;
        if (this._resultSetConcurrency != 1008) {
            int n;
            String string = null;
            for (n = 0; n < this._columnCount && ((string = this._columnTableName[n]) == null || string.length() == 0); ++n) {
            }
            if (string != null && string.length() != 0) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("SELECT ");
                boolean bl = false;
                for (n = 0; n < this._columnCount; ++n) {
                    if (bl) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(this.quoteIdentifier(this._columnName[n]));
                    bl = true;
                }
                stringBuilder.append(" FROM ");
                if (this._columnSchemaName[0] != null && this._columnSchemaName[0].length() != 0) {
                    stringBuilder.append(this.quoteIdentifier(this._columnSchemaName[0]));
                    stringBuilder.append(".");
                }
                stringBuilder.append(this.quoteIdentifier(this._columnTableName[0]));
                stringBuilder.append(" WHERE 1=2");
                try {
                    statement = this._connection.createStatement(1003, 1008);
                    resultSet = statement.executeQuery(stringBuilder.toString());
                    resultSetMetaData = resultSet.getMetaData();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this.cacheIsReadOnlyFromMetaData(resultSetMetaData);
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void cacheColumnNames(ResultSetMetaData resultSetMetaData) {
        String string;
        int n;
        this._columnName = new String[this._columnCount];
        for (n = 0; n < this._columnCount; ++n) {
            try {
                string = resultSetMetaData.getColumnName(n + 1);
            }
            catch (Exception exception) {
                string = "";
            }
            this._columnName[n] = string;
        }
        this._columnLabel = new String[this._columnCount];
        for (n = 0; n < this._columnCount; ++n) {
            try {
                string = resultSetMetaData.getColumnLabel(n + 1);
            }
            catch (Exception exception) {
                string = "";
            }
            this._columnLabel[n] = string;
        }
        this._columnSchemaName = new String[this._columnCount];
        for (n = 0; n < this._columnCount; ++n) {
            try {
                string = resultSetMetaData.getSchemaName(n + 1);
                if (string != null && string.isEmpty()) {
                    string = null;
                }
            }
            catch (Exception exception) {
                string = null;
            }
            this._columnSchemaName[n] = string;
        }
        this._columnTableName = new String[this._columnCount];
        for (n = 0; n < this._columnCount; ++n) {
            try {
                string = resultSetMetaData.getTableName(n + 1);
            }
            catch (Exception exception) {
                string = null;
            }
            this._columnTableName[n] = string;
        }
    }

    private void clearMetaDataCache() {
        this._columnCount = 0;
        this._class = null;
        this._sqlType = null;
        this._sqlTypeName = null;
        this._isSigned = null;
        this._columnName = null;
        this._columnSchemaName = null;
        this._columnTableName = null;
        this._columnLabel = null;
        this._width = null;
        this._scale = null;
        this._precision = null;
        this._nullability = null;
        this._readOnly = null;
        this._autoIncrement = null;
        this._defaultValue = null;
        this._isPrimaryKey = null;
    }

    public static Class convertSQLTypeToJavaType(int n) {
        Class clazz;
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case -7: {
                clazz = Boolean.class;
                break;
            }
            case -6: {
                clazz = Byte.class;
                break;
            }
            case 5: {
                clazz = Short.class;
                break;
            }
            case 4: {
                clazz = Integer.class;
                break;
            }
            case -5: {
                clazz = Long.class;
                break;
            }
            case 6: 
            case 8: {
                clazz = Double.class;
                break;
            }
            case 7: {
                clazz = Float.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                clazz = byte[].class;
                break;
            }
            case 1111: 
            case 2000: {
                clazz = Object.class;
                break;
            }
            default: {
                return null;
            }
        }
        return clazz;
    }

    protected synchronized void clearDataCache() {
        if (this._cachedRows != null) {
            int n = this._cachedRows.size();
            for (int i = 0; i < n; ++i) {
                ArrayList<Object> arrayList = this._cachedRows.get(i);
                if (arrayList == null) continue;
                arrayList.clear();
            }
            this._cachedRows.clear();
            this._cachedRows = null;
            this._rowCount = -1;
        }
    }

    boolean isCellEditable(int n, int n2) {
        if (n2 >= this._columnCount) {
            throw new IllegalArgumentException("Invalid column index " + n2);
        }
        if (this._readOnly == null) {
            this.cacheMetaDataForEditing();
        }
        return !this._readOnly[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void absolute(int n) throws SQLException {
        try {
            ResultSet resultSet = this._resultSet;
            synchronized (resultSet) {
                this._resultSet.absolute(n);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteRow() throws SQLException {
        try {
            ResultSet resultSet = this._resultSet;
            synchronized (resultSet) {
                this._resultSet.deleteRow();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n, int n2) {
        try {
            this.startLoggingWarnings();
            ResultSet resultSet = this._resultSet;
            synchronized (resultSet) {
                this._resultSet.absolute(n);
            }
            this.setResultSetValue(object, n2);
        }
        catch (Exception exception) {
            if (this._listeners != null) {
                this.fireExceptionEvent(exception);
            }
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResultSetValue(Object object, int n) throws Exception {
        if (object == null) {
            ResultSet resultSet = this._resultSet;
            synchronized (resultSet) {
                this._resultSet.updateNull(n);
            }
        }
    }

    public void addScrollableResultSetListener(ScrollableResultSetListener scrollableResultSetListener) {
        if (scrollableResultSetListener != null) {
            if (this._listeners == null) {
                this._listeners = new EventListenerList();
            }
            this._listeners.add(ScrollableResultSetListener.class, scrollableResultSetListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScrollableResultSetListener(ScrollableResultSetListener scrollableResultSetListener) {
        try {
            this.startLoggingWarnings();
            if (scrollableResultSetListener != null && this._listeners != null) {
                this._listeners.remove(ScrollableResultSetListener.class, scrollableResultSetListener);
            }
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    protected void removeAllListeners() {
        if (this._listeners != null) {
            int n = this._listeners.getListenerCount();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = this._listeners.getListenerList();
                this._listeners.remove(ScrollableResultSetListener.class, (ScrollableResultSetListener)objectArray[1]);
            }
            this._listeners = null;
        }
    }

    protected void fireStateChangedEvent(int n) {
        ScrollableResultSetEvent scrollableResultSetEvent = null;
        if (this._listeners != null) {
            int n2;
            Object[] objectArray = this._listeners.getListenerList();
            for (int i = n2 = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ScrollableResultSetListener.class) continue;
                if (scrollableResultSetEvent == null) {
                    scrollableResultSetEvent = new ScrollableResultSetEvent(this, n);
                }
                ((ScrollableResultSetListener)objectArray[i + 1]).stateChanged(scrollableResultSetEvent);
            }
        }
    }

    protected void fireExceptionEvent(Exception exception) {
        ScrollableResultSetEvent scrollableResultSetEvent = null;
        if (this._listeners != null && exception != null) {
            int n;
            Object[] objectArray = this._listeners.getListenerList();
            for (int i = n = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ScrollableResultSetListener.class) continue;
                if (scrollableResultSetEvent == null) {
                    scrollableResultSetEvent = new ScrollableResultSetEvent(this, exception);
                }
                ((ScrollableResultSetListener)objectArray[i + 1]).exception(scrollableResultSetEvent);
            }
        }
    }

    synchronized boolean isCaching() {
        return this._cachedRows != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaxBlobBytes(int n) {
        try {
            this.startLoggingWarnings();
            this._maxBlobReadBytes = n;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getMaxBlobBytes() {
        try {
            this.startLoggingWarnings();
            int n = this._maxBlobReadBytes;
            return n;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaxClobCharacters(int n) {
        try {
            this.startLoggingWarnings();
            this._maxClobReadChars = n;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getMaxClobCharacters() {
        try {
            this.startLoggingWarnings();
            int n = this._maxClobReadChars;
            return n;
        }
        finally {
            this.stopLoggingWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEditable() {
        block19: {
            if (this._editable == -1) {
                String string;
                String string2;
                int n;
                this._editable = 1;
                String string3 = null;
                String string4 = null;
                int n2 = this.getColumnCount();
                for (n = 0; n < n2; ++n) {
                    if (this.getColumnType(n) == 2000) {
                        this._editable = 0;
                        break;
                    }
                    string2 = this.getColumnTableName(n);
                    if (string2 != null && string2.isEmpty()) {
                        string2 = null;
                    }
                    if ((string = this.getColumnSchemaName(n)) != null && string.isEmpty()) {
                        string = null;
                    }
                    if (string4 == null) {
                        string4 = string2;
                    } else if (!string4.equalsIgnoreCase(string2)) {
                        this._editable = 0;
                        break;
                    }
                    if (string3 == null) {
                        string3 = string;
                        continue;
                    }
                    if (string3.equalsIgnoreCase(string)) continue;
                    this._editable = 0;
                    break;
                }
                if (string4 == null) {
                    this._editable = 0;
                }
                if (this._editable == 1 && n2 > 0) {
                    try {
                        Statement statement;
                        ResultSet resultSet = this._resultSet;
                        synchronized (resultSet) {
                            statement = this._resultSet.getStatement();
                        }
                        if (statement != null) {
                            Connection connection = statement.getConnection();
                            for (n = 0; n < n2; ++n) {
                                string2 = this.getColumnTableName(n);
                                string = this.getColumnSchemaName(n);
                                if (string2 == null || string2.length() <= 0) continue;
                                if (!this.allPrimaryKeysIncluded(connection, string, string2)) {
                                    this._editable = 0;
                                }
                                break block19;
                            }
                            break block19;
                        }
                        this._editable = 1;
                    }
                    catch (SQLException sQLException) {
                        this._editable = 1;
                    }
                }
            }
        }
        return this._editable == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        boolean bl = true;
        boolean bl2 = bl = this._resultSet == null;
        if (!bl) {
            ResultSet resultSet = this._resultSet;
            synchronized (resultSet) {
                try {
                    bl = this._resultSet.isClosed();
                }
                catch (AbstractMethodError abstractMethodError) {
                    if (this.usingJConnect()) {
                        try {
                            Method method = this._resultSet.getClass().getMethod("getState", new Class[0]);
                            Object object = method.invoke((Object)this._resultSet, new Object[0]);
                            if (object instanceof Integer) {
                                int n = (Integer)object;
                                boolean bl3 = n == 0;
                                return bl3;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        this._resultSet.wasNull();
                    }
                    catch (SQLException sQLException) {
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static void setDebuggingOptions(String string) {
        System.setProperty("com.sybase.resultSetTable.ScrollableResultSet.debug", string);
    }

    protected static boolean dbgEnabled(String string) {
        boolean bl = false;
        Object var2_2 = null;
        return bl;
    }

    protected static String getSystemProperty(String string) {
        String string2 = "com.sybase.resultSetTable.ScrollableResultSet." + string;
        String string3 = System.getProperty(string2);
        return string3;
    }

    protected void trace_call(String string) {
        if (ScrollableResultSet.dbgEnabled(DBG_FUNCTION_CALLS)) {
            StringBuilder stringBuilder = new StringBuilder(64);
            for (int i = 0; i < this._traceIndent; ++i) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("Call: " + string);
            Dbg.println((String)stringBuilder.toString());
            this._traceIndent += 2;
        }
    }

    protected void trace_return(String string) {
        if (ScrollableResultSet.dbgEnabled(DBG_FUNCTION_CALLS)) {
            this._traceIndent -= 2;
            StringBuilder stringBuilder = new StringBuilder(64);
            for (int i = 0; i < this._traceIndent; ++i) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("Return: " + string);
            Dbg.println((String)stringBuilder.toString());
        }
    }

    static class CachingAbortedException
    extends Exception {
        CachingAbortedException() {
        }
    }
}

