/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

class SelectNewlineFormatDialog
extends JDialog {
    private static final int SELECTION_WINDOWS = 0;
    private static final int SELECTION_UNIX = 1;
    private static final int SELECTION_MAC = 2;
    private static final int SELECTION_PRESERVE = 3;
    private static final int MODE_VALUE = 0;
    private static final int MODE_FILE = 1;
    private final String SYSTEM_NEWLINE;
    private static ResultSetTableResourcesBase _bundle = null;
    private int _lastFileSelection;
    private int _lastValueSelection;
    private boolean _isOKClicked = false;
    private boolean _isPreserveSelected = false;
    private String _lineSeparator = "\n";
    private int _mode = 0;
    private JPanel _buttonPanel;
    private SybButton _cancelButton;
    private SybLabel _iconLabel;
    private SybRadioButton _macRadioBtn;
    private JPanel _mainPanel;
    private JPanel _messagePanel;
    private ButtonGroup _newlineBtnGroup;
    private SybButton _okButton;
    private SybRadioButton _preserveRadioBtn;
    private JPanel _radioPanel;
    private SybMultiLineLabel _topLabel;
    private SybRadioButton _unixRadioBtn;
    private SybRadioButton _windowsRadioBtn;

    SelectNewlineFormatDialog(Window window) {
        super(window, Dialog.ModalityType.DOCUMENT_MODAL);
        if (_bundle == null) {
            _bundle = ResultSetTableResourcesBase.getBundle();
        }
        this.initComponents();
        this.SYSTEM_NEWLINE = System.getProperty("line.separator");
        if (this.SYSTEM_NEWLINE.equals("\r\n")) {
            this._lastFileSelection = 0;
            this._lastValueSelection = 0;
        } else if (this.SYSTEM_NEWLINE.equals("\n")) {
            this._lastFileSelection = 1;
            this._lastValueSelection = 1;
        } else if (this.SYSTEM_NEWLINE.equals("\r")) {
            this._lastFileSelection = 2;
            this._lastValueSelection = 2;
        } else {
            this._lastFileSelection = 0;
            this._lastValueSelection = 0;
        }
        this._iconLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectNewlineFormatDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape pressed");
        this.getRootPane().getActionMap().put("escape pressed", abstractAction);
    }

    void destroy() {
        this._lineSeparator = null;
        this._buttonPanel = null;
        this._cancelButton = null;
        this._iconLabel = null;
        this._macRadioBtn = null;
        this._mainPanel = null;
        this._messagePanel = null;
        this._newlineBtnGroup = null;
        this._okButton = null;
        this._preserveRadioBtn = null;
        this._radioPanel = null;
        this._topLabel = null;
        this._unixRadioBtn = null;
        this._windowsRadioBtn = null;
    }

    String getSelectedLineSeparator() {
        return this._lineSeparator;
    }

    boolean isPreserveSelected() {
        return this._isPreserveSelected;
    }

    boolean showFileDialog() {
        this._mode = 1;
        this.setTitle(_bundle.getString("SELECT_FILE_FORMAT_TITLE"));
        this._topLabel.setText(_bundle.getString("SELECT_FILE_FORMAT_LABEL"));
        this._windowsRadioBtn.setText(_bundle.getString("CONVERT_WINDOWS_NEWLINE_FORMAT"));
        this._unixRadioBtn.setText(_bundle.getString("CONVERT_UNIX_NEWLINE_FORMAT"));
        this._macRadioBtn.setText(_bundle.getString("CONVERT_MAC_NEWLINE_FORMAT"));
        this._preserveRadioBtn.setVisible(true);
        this.pack();
        return this.showDialog(this._lastFileSelection);
    }

    boolean showValueDialog() {
        this._mode = 0;
        this.setTitle(_bundle.getString("SELECT_TEXT_FORMAT_TITLE"));
        this._topLabel.setText(_bundle.getString("SELECT_TEXT_FORMAT_LABEL"));
        this._windowsRadioBtn.setText(_bundle.getString("WINDOWS_NEWLINE_FORMAT"));
        this._unixRadioBtn.setText(_bundle.getString("UNIX_NEWLINE_FORMAT"));
        this._macRadioBtn.setText(_bundle.getString("MAC_NEWLINE_FORMAT"));
        this._preserveRadioBtn.setVisible(false);
        this.pack();
        return this.showDialog(this._lastValueSelection);
    }

    private void setLastSelection(int n) {
        if (this._mode == 0) {
            this._lastValueSelection = n;
        } else {
            this._lastFileSelection = n;
        }
    }

    private boolean showDialog(int n) {
        switch (n) {
            case 3: {
                this._preserveRadioBtn.setSelected(true);
                this._preserveRadioBtn.grabFocus();
                break;
            }
            case 0: {
                this._windowsRadioBtn.setSelected(true);
                this._windowsRadioBtn.grabFocus();
                break;
            }
            case 1: {
                this._unixRadioBtn.setSelected(true);
                this._unixRadioBtn.grabFocus();
                break;
            }
            case 2: {
                this._macRadioBtn.setSelected(true);
                this._macRadioBtn.grabFocus();
            }
        }
        this._isOKClicked = false;
        this.getRootPane().setDefaultButton((JButton)this._okButton);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this._isOKClicked;
    }

    private void initComponents() {
        this._newlineBtnGroup = new ButtonGroup();
        this._mainPanel = new JPanel();
        this._iconLabel = new SybLabel();
        this._messagePanel = new JPanel();
        this._topLabel = new SybMultiLineLabel();
        this._radioPanel = new JPanel();
        this._preserveRadioBtn = new SybRadioButton();
        this._windowsRadioBtn = new SybRadioButton();
        this._unixRadioBtn = new SybRadioButton();
        this._macRadioBtn = new SybRadioButton();
        this._buttonPanel = new JPanel();
        this._okButton = new SybButton();
        this._cancelButton = new SybButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this._mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this._mainPanel.add((Component)this._iconLabel, gridBagConstraints);
        this._messagePanel.setLayout(new GridBagLayout());
        this._topLabel.setText(_bundle.getString("SELECT_TEXT_FORMAT_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this._messagePanel.add((Component)this._topLabel, gridBagConstraints);
        this._radioPanel.setLayout(new GridBagLayout());
        this._newlineBtnGroup.add((AbstractButton)this._preserveRadioBtn);
        this._preserveRadioBtn.setText(_bundle.getString("PRESERVE_NEWLINE_FORMAT"));
        this._preserveRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._preserveRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._radioPanel.add((Component)this._preserveRadioBtn, gridBagConstraints);
        this._newlineBtnGroup.add((AbstractButton)this._windowsRadioBtn);
        this._windowsRadioBtn.setText(_bundle.getString("WINDOWS_NEWLINE_FORMAT"));
        this._windowsRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._windowsRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._radioPanel.add((Component)this._windowsRadioBtn, gridBagConstraints);
        this._newlineBtnGroup.add((AbstractButton)this._unixRadioBtn);
        this._unixRadioBtn.setText(_bundle.getString("UNIX_NEWLINE_FORMAT"));
        this._unixRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._unixRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._radioPanel.add((Component)this._unixRadioBtn, gridBagConstraints);
        this._newlineBtnGroup.add((AbstractButton)this._macRadioBtn);
        this._macRadioBtn.setText(_bundle.getString("MAC_NEWLINE_FORMAT"));
        this._macRadioBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._macRadioBtn.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this._radioPanel.add((Component)this._macRadioBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this._messagePanel.add((Component)this._radioPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this._mainPanel.add((Component)this._messagePanel, gridBagConstraints);
        this._buttonPanel.setLayout(new GridBagLayout());
        this._okButton.setText(_bundle.getString("OK"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectNewlineFormatDialog.this._okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this._buttonPanel.add((Component)this._okButton, gridBagConstraints);
        this._cancelButton.setText(_bundle.getString("CancelButton"));
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectNewlineFormatDialog.this._cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this._buttonPanel.add((Component)this._cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this._mainPanel.add((Component)this._buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this._mainPanel, gridBagConstraints);
        this.pack();
    }

    private void _okButtonActionPerformed(ActionEvent actionEvent) {
        if (this._preserveRadioBtn.isSelected()) {
            this.setLastSelection(3);
            this._isPreserveSelected = true;
        } else if (this._windowsRadioBtn.isSelected()) {
            this.setLastSelection(0);
            this._lineSeparator = "\r\n";
            this._isPreserveSelected = false;
        } else if (this._unixRadioBtn.isSelected()) {
            this.setLastSelection(1);
            this._lineSeparator = "\n";
            this._isPreserveSelected = false;
        } else {
            this.setLastSelection(2);
            this._lineSeparator = "\r";
            this._isPreserveSelected = false;
        }
        this._isOKClicked = true;
        this.dispose();
    }

    private void _cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

