/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BaseCellEditor;
import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.TimeCellEditorDialog;
import com.sybase.util.SybButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;

class TimeCellEditor
extends BaseCellEditor {
    private static final String POPUP_COMMAND = "togglePopup";
    protected static JSpinner _spinner = null;
    protected static SpinnerWithButton _spinnerWithButton = null;
    protected static KeyStroke _buttonKeyStroke = null;

    TimeCellEditor() {
    }

    static JSpinner createSpinner() {
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setCalendarField(13);
        JSpinner jSpinner = new JSpinner(spinnerDateModel);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(jSpinner, simpleDateFormat.toPattern());
        jSpinner.setEditor(dateEditor);
        return jSpinner;
    }

    private void discoverButtonKeyStroke() {
        if (_buttonKeyStroke == null) {
            JComboBox jComboBox = new JComboBox();
            InputMap inputMap = jComboBox.getInputMap(1);
            KeyStroke[] keyStrokeArray = inputMap.allKeys();
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                Object object = inputMap.get(keyStrokeArray[i]);
                if (object == null || !object.toString().equals(POPUP_COMMAND)) continue;
                _buttonKeyStroke = keyStrokeArray[i];
                break;
            }
        }
    }

    static KeyStroke getButtonKeyStroke() {
        return _buttonKeyStroke;
    }

    @Override
    protected Component createEditor(JTable jTable, int n) {
        JComponent jComponent;
        if (this._showNullItem || this._showDefaultValueItem) {
            if (_spinnerWithButton == null) {
                this.discoverButtonKeyStroke();
                _spinnerWithButton = new SpinnerWithButton();
                _spinnerWithButton.setBackground(jTable.getBackground());
            }
            jComponent = _spinnerWithButton;
        } else {
            if (_spinner == null) {
                _spinner = TimeCellEditor.createSpinner();
                this.setEditorBorder(_spinner);
            }
            jComponent = _spinner;
        }
        return jComponent;
    }

    @Override
    protected void setInitialValue(Object object) {
        if (this._editor == _spinner) {
            if (object == null || object instanceof String && object.toString().length() == 0) {
                object = Calendar.getInstance().getTime();
            }
            _spinner.setValue(object);
        } else {
            _spinnerWithButton.setValue(object);
        }
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        object = this._editor == _spinner ? _spinner.getValue() : _spinnerWithButton.getValue();
        if (object != null && object.getClass() == Date.class) {
            object = new Time(((Date)object).getTime());
        }
        return object;
    }

    class SpinnerWithButton
    extends JPanel
    implements ActionListener {
        Object _value = null;
        JSpinner _swbSpinner = TimeCellEditor.createSpinner();
        JLabel _label;
        JButton _button;
        boolean _popupVisible = false;
        TimeCellEditorDialog _dlg = null;

        SpinnerWithButton() {
            TimeCellEditor.this.setEditorBorder(this._swbSpinner);
            this._button = new SybButton("...");
            this._button.setFocusable(false);
            this._button.setMargin(new Insets(2, 2, 2, 2));
            this._button.addActionListener(this);
            if (_buttonKeyStroke != null) {
                this.registerKeyboardAction(this, TimeCellEditor.POPUP_COMMAND, _buttonKeyStroke, 1);
            }
            this._label = new JLabel();
            TimeCellEditor.this.setEditorBorder(this._label);
            this.setLayout(new BorderLayout());
            this.add(this._button);
        }

        void setValue(Object object) {
            this._value = object;
            Component component = this.getComponent(0);
            if (object == null || object instanceof DefaultValue) {
                if (component != this._label) {
                    this.removeAll();
                    this.add((Component)this._label, "Center");
                    this.add((Component)this._button, "East");
                    this.validate();
                }
                if (object == null) {
                    this._label.setText(TimeCellEditor.this._nullDisplayText);
                } else {
                    this._label.setText(TimeCellEditor.this._defaultDisplayText);
                }
            } else {
                if (component != this._swbSpinner) {
                    this.removeAll();
                    this.add((Component)this._swbSpinner, "Center");
                    this.add((Component)this._button, "East");
                    this.validate();
                }
                this._swbSpinner.setValue(object);
            }
            this.repaint();
        }

        Object getValue() {
            return this._value;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.togglePopupVisibility();
        }

        private void togglePopupVisibility() {
            if (this._dlg == null) {
                this._popupVisible = false;
            } else {
                this._popupVisible = this._dlg.isVisible();
                if (!this._popupVisible) {
                    long l = System.currentTimeMillis();
                    long l2 = this._dlg.getDeactivationTime();
                    this._dlg = null;
                    if (l2 != 0L && l - l2 < 250L) {
                        return;
                    }
                }
            }
            boolean bl = this._popupVisible = !this._popupVisible;
            if (this._popupVisible) {
                Rectangle rectangle = this.getBounds();
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, this);
                point.y += rectangle.height;
                Object object = this._value == null || this._value instanceof DefaultValue ? this._value : this._swbSpinner.getValue();
                this._dlg = TimeCellEditorDialog.create(this, object, TimeCellEditor.this._showNullItem, TimeCellEditor.this._showDefaultValueItem, point);
            } else if (this._dlg != null) {
                this._dlg.close();
                this._dlg = null;
            }
        }
    }
}

