/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.TimeCellEditor;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class TimeCellEditorDialog
extends JDialog
implements ActionListener,
ItemListener,
WindowListener {
    private static final String ESCAPE_COMMAND = "Esc";
    private static final String ENTER_COMMAND = "Enter";
    private JSpinner _spinner = null;
    private SybRadioButton _time = null;
    private SybRadioButton _null = null;
    private SybRadioButton _default = null;
    private TimeCellEditor.SpinnerWithButton _editor = null;
    private long _deactivationTime = 0L;

    static TimeCellEditorDialog create(TimeCellEditor.SpinnerWithButton spinnerWithButton, Object object, boolean bl, boolean bl2, Point point) {
        TimeCellEditorDialog timeCellEditorDialog;
        Container container = SwingUtilities.getAncestorOfClass(Dialog.class, spinnerWithButton);
        if (container != null) {
            timeCellEditorDialog = new TimeCellEditorDialog((Dialog)container, spinnerWithButton, object, bl, bl2, point);
        } else {
            container = SwingUtilities.getAncestorOfClass(Frame.class, spinnerWithButton);
            timeCellEditorDialog = new TimeCellEditorDialog((Frame)container, spinnerWithButton, object, bl, bl2, point);
        }
        UIUtils.ensureWindowIsVisible((Window)timeCellEditorDialog);
        timeCellEditorDialog.setVisible(true);
        return timeCellEditorDialog;
    }

    private TimeCellEditorDialog(Frame frame, TimeCellEditor.SpinnerWithButton spinnerWithButton, Object object, boolean bl, boolean bl2, Point point) {
        super(frame);
        this.createUI(object, spinnerWithButton, bl, bl2, point);
    }

    private TimeCellEditorDialog(Dialog dialog, TimeCellEditor.SpinnerWithButton spinnerWithButton, Object object, boolean bl, boolean bl2, Point point) {
        super(dialog);
        this.createUI(object, spinnerWithButton, bl, bl2, point);
    }

    private void createUI(Object object, TimeCellEditor.SpinnerWithButton spinnerWithButton, boolean bl, boolean bl2, Point point) {
        this._editor = spinnerWithButton;
        this.setUndecorated(true);
        JRootPane jRootPane = this.getRootPane();
        Container container = jRootPane.getContentPane();
        this.addWindowListener(this);
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.windowBorder), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._time = new SybRadioButton(resultSetTableResourcesBase.get("TimeEditorTime"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._time, gridBagConstraints);
        this._spinner = TimeCellEditor.createSpinner();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._spinner, gridBagConstraints);
        this._null = new SybRadioButton(resultSetTableResourcesBase.get("TimeEditorNull"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        if (bl) {
            jPanel2.add((Component)this._null, gridBagConstraints);
        }
        this._default = new SybRadioButton(resultSetTableResourcesBase.get("TimeEditorDefault"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        if (bl2) {
            jPanel2.add((Component)this._default, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        this._time.addItemListener((ItemListener)this);
        this._null.addItemListener((ItemListener)this);
        this._default.addItemListener((ItemListener)this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._time);
        buttonGroup.add((AbstractButton)this._null);
        buttonGroup.add((AbstractButton)this._default);
        jPanel.add((Component)jPanel2, "Center");
        if (object == null || object.toString().length() == 0) {
            this._spinner.setValue(Calendar.getInstance().getTime());
            this._null.setSelected(true);
        } else if (object instanceof DefaultValue) {
            this._spinner.setValue(Calendar.getInstance().getTime());
            this._default.setSelected(true);
        } else {
            this._spinner.setValue(object);
            this._time.setSelected(true);
        }
        if (!bl) {
            this._null.setEnabled(false);
        }
        if (!bl2) {
            this._default.setEnabled(false);
        }
        jRootPane.registerKeyboardAction(this, ESCAPE_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, ENTER_COMMAND, KeyStroke.getKeyStroke(10, 0), 1);
        KeyStroke keyStroke = TimeCellEditor.getButtonKeyStroke();
        if (keyStroke != null) {
            jRootPane.registerKeyboardAction(this, ENTER_COMMAND, keyStroke, 1);
        }
        container.add(jPanel);
        this.pack();
        if (this._null.isSelected()) {
            this._null.requestFocusInWindow();
        } else if (this._default.isSelected()) {
            this._default.requestFocusInWindow();
        } else {
            this._spinner.requestFocusInWindow();
        }
        if (point != null) {
            this.setLocation(point);
        }
    }

    private void destroy() {
        if (this._spinner != null) {
            this._spinner = null;
        }
        if (this._time != null) {
            this._time.removeItemListener((ItemListener)this);
            this._time = null;
        }
        if (this._null != null) {
            this._null.removeItemListener((ItemListener)this);
            this._null = null;
        }
        if (this._default != null) {
            this._default.removeItemListener((ItemListener)this);
            this._default = null;
        }
        this._editor = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this._time.isSelected();
        this._spinner.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(ESCAPE_COMMAND)) {
                this.close();
            } else if (string.equals(ENTER_COMMAND)) {
                this.handleOK();
            }
        }
    }

    void close() {
        this.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimeCellEditorDialog.this.destroy();
            }
        });
    }

    private void handleOK() {
        if (!this.isVisible()) {
            return;
        }
        Object object = this._null.isSelected() ? null : (this._default.isSelected() ? new DefaultValue() : this._spinner.getValue());
        this._editor.setValue(object);
        this.close();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this._deactivationTime = System.currentTimeMillis();
        this.handleOK();
    }

    long getDeactivationTime() {
        return this._deactivationTime;
    }
}

