/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BaseCellEditor;
import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.TimestampCellEditorDialog;
import com.sybase.util.SybButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class TimestampCellEditor
extends BaseCellEditor {
    private static final String POPUP_COMMAND = "togglePopup";
    protected static TextFieldWithButton _textFieldWithButton = null;
    protected static KeyStroke _buttonKeyStroke = null;
    private static DateFormat[] _dateTimeFormatters = new DateFormat[]{DateFormat.getDateTimeInstance(2, 2), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm")};

    TimestampCellEditor() {
    }

    private void discoverButtonKeyStroke() {
        if (_buttonKeyStroke == null) {
            JComboBox jComboBox = new JComboBox();
            InputMap inputMap = jComboBox.getInputMap(1);
            KeyStroke[] keyStrokeArray = inputMap.allKeys();
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                Object object = inputMap.get(keyStrokeArray[i]);
                if (object == null || !object.toString().equals(POPUP_COMMAND)) continue;
                _buttonKeyStroke = keyStrokeArray[i];
                break;
            }
        }
    }

    static KeyStroke getButtonKeyStroke() {
        return _buttonKeyStroke;
    }

    @Override
    protected Component createEditor(JTable jTable, int n) {
        if (_textFieldWithButton == null) {
            this.discoverButtonKeyStroke();
            _textFieldWithButton = new TextFieldWithButton();
            _textFieldWithButton.setBackground(jTable.getBackground());
        }
        return _textFieldWithButton;
    }

    @Override
    protected void setInitialValue(Object object) {
        if (object != null && object instanceof String && object.toString().trim().length() == 0) {
            object = this._showNullItem ? null : new Timestamp(Calendar.getInstance().getTimeInMillis());
        }
        _textFieldWithButton.setValue(object);
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        object = _textFieldWithButton.getValue();
        return object;
    }

    static String formatTimestamp(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        String string = dateFormat.format(date);
        return string;
    }

    static Timestamp parseTimestamp(String string) {
        Timestamp timestamp = null;
        for (int i = 0; i < _dateTimeFormatters.length; ++i) {
            try {
                Date date = _dateTimeFormatters[i].parse(string);
                timestamp = new Timestamp(date.getTime());
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        if (timestamp == null) {
            // empty if block
        }
        return timestamp;
    }

    class TextFieldWithButton
    extends JPanel
    implements ActionListener {
        Object _value = null;
        JTextField _dateField = new JTextField();
        JLabel _label;
        JButton _button;
        boolean _popupVisible = false;
        TimestampCellEditorDialog _dlg = null;

        TextFieldWithButton() {
            TimestampCellEditor.this.setEditorBorder(this._dateField);
            this._button = new SybButton("...");
            this._button.setFocusable(false);
            this._button.setMargin(new Insets(2, 2, 2, 2));
            this._button.addActionListener(this);
            this._label = new JLabel();
            this.setLayout(new BorderLayout());
            this.add(this._button);
            if (_buttonKeyStroke != null) {
                this.registerKeyboardAction(this, TimestampCellEditor.POPUP_COMMAND, _buttonKeyStroke, 1);
            }
        }

        void setValue(Object object) {
            this._value = object;
            Component component = this.getComponent(0);
            if (object == null || object instanceof DefaultValue) {
                if (component != this._label) {
                    this.removeAll();
                    this.add((Component)this._label, "Center");
                    this.add((Component)this._button, "East");
                    this.validate();
                }
                if (object == null) {
                    this._label.setText(TimestampCellEditor.this._nullDisplayText);
                } else {
                    this._label.setText(TimestampCellEditor.this._defaultDisplayText);
                }
            } else {
                if (component != this._dateField) {
                    this.removeAll();
                    this.add((Component)this._dateField, "Center");
                    this.add((Component)this._button, "East");
                    this.validate();
                }
                if (!(object instanceof Timestamp)) {
                    throw new IllegalArgumentException("Expected Timestamp value, but got " + object.getClass().getName());
                }
                this._dateField.setText(TimestampCellEditor.formatTimestamp((Timestamp)object));
            }
            this.repaint();
        }

        Object getValue() {
            if (this._value != null && !(this._value instanceof DefaultValue)) {
                this._value = TimestampCellEditor.parseTimestamp(this._dateField.getText());
            }
            return this._value;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.togglePopupVisibility();
        }

        private void togglePopupVisibility() {
            if (this._dlg == null) {
                this._popupVisible = false;
            } else {
                this._popupVisible = this._dlg.isVisible();
                if (!this._popupVisible) {
                    long l = System.currentTimeMillis();
                    long l2 = this._dlg.getDeactivationTime();
                    this._dlg = null;
                    if (l2 != 0L && l - l2 < 250L) {
                        return;
                    }
                }
            }
            boolean bl = this._popupVisible = !this._popupVisible;
            if (this._popupVisible) {
                Rectangle rectangle = this.getBounds();
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, this);
                point.y += rectangle.height;
                Object object = this._value == null || this._value instanceof DefaultValue ? this._value : TimestampCellEditor.parseTimestamp(this._dateField.getText());
                this._dlg = TimestampCellEditorDialog.create(this, object, TimestampCellEditor.this._showNullItem, TimestampCellEditor.this._showDefaultValueItem, point);
            } else if (this._dlg != null) {
                this._dlg.close();
                this._dlg = null;
            }
        }
    }
}

