/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.datechooser.DateChangeEvent;
import com.sybase.datechooser.DateChangeListener;
import com.sybase.datechooser.SybDateChooserPanel;
import com.sybase.resultSetTable.DateCellEditor;
import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.ResultSetTableResourcesBase;
import com.sybase.resultSetTable.TimeCellEditor;
import com.sybase.resultSetTable.TimestampCellEditor;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class TimestampCellEditorDialog
extends JDialog
implements ActionListener,
DateChangeListener,
DocumentListener,
ItemListener,
WindowListener {
    private static final String ESCAPE_COMMAND = "Esc";
    private static final String ENTER_COMMAND = "Enter";
    private SybLabel _timeLabel = null;
    private JSpinner _spinner = null;
    private SybLabel _dateLabel = null;
    private JTextField _dateField = null;
    private SybDateChooserPanel _dateChooser = null;
    private SybRadioButton _timestamp = null;
    private SybRadioButton _null = null;
    private SybRadioButton _default = null;
    private TimestampCellEditor.TextFieldWithButton _editor = null;
    private long _deactivationTime = 0L;

    static TimestampCellEditorDialog create(TimestampCellEditor.TextFieldWithButton textFieldWithButton, Object object, boolean bl, boolean bl2, Point point) {
        TimestampCellEditorDialog timestampCellEditorDialog;
        Container container = SwingUtilities.getAncestorOfClass(Dialog.class, textFieldWithButton);
        if (container != null) {
            timestampCellEditorDialog = new TimestampCellEditorDialog((Dialog)container, textFieldWithButton, object, bl, bl2, point);
        } else {
            container = SwingUtilities.getAncestorOfClass(Frame.class, textFieldWithButton);
            timestampCellEditorDialog = new TimestampCellEditorDialog((Frame)container, textFieldWithButton, object, bl, bl2, point);
        }
        UIUtils.ensureWindowIsVisible((Window)timestampCellEditorDialog);
        timestampCellEditorDialog.setVisible(true);
        return timestampCellEditorDialog;
    }

    private TimestampCellEditorDialog(Frame frame, TimestampCellEditor.TextFieldWithButton textFieldWithButton, Object object, boolean bl, boolean bl2, Point point) {
        super(frame);
        this.createUI(object, textFieldWithButton, bl, bl2, point);
    }

    private TimestampCellEditorDialog(Dialog dialog, TimestampCellEditor.TextFieldWithButton textFieldWithButton, Object object, boolean bl, boolean bl2, Point point) {
        super(dialog);
        this.createUI(object, textFieldWithButton, bl, bl2, point);
    }

    private void createUI(Object object, TimestampCellEditor.TextFieldWithButton textFieldWithButton, boolean bl, boolean bl2, Point point) {
        this._editor = textFieldWithButton;
        this.setUndecorated(true);
        JRootPane jRootPane = this.getRootPane();
        Container container = jRootPane.getContentPane();
        this.addWindowListener(this);
        ResultSetTableResourcesBase resultSetTableResourcesBase = ResultSetTableResourcesBase.getBundle();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.windowBorder), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._timestamp = new SybRadioButton(resultSetTableResourcesBase.get("TimestampEditorTimestamp"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._timestamp, gridBagConstraints);
        this._timeLabel = new SybLabel(resultSetTableResourcesBase.get("TimestampEditorTime"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        jPanel2.add((Component)this._timeLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this._spinner = TimeCellEditor.createSpinner();
        this._timeLabel.setLabelFor((Component)this._spinner);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel2.add((Component)this._spinner, gridBagConstraints);
        this._dateLabel = new SybLabel(resultSetTableResourcesBase.get("TimestampEditorDate"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        jPanel2.add((Component)this._dateLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this._dateField = new JTextField();
        this._dateLabel.setLabelFor((Component)this._dateField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._dateField, gridBagConstraints);
        this._dateChooser = new SybDateChooserPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._dateChooser, gridBagConstraints);
        this._null = new SybRadioButton(resultSetTableResourcesBase.get("TimestampEditorNull"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        if (bl) {
            jPanel2.add((Component)this._null, gridBagConstraints);
        }
        this._default = new SybRadioButton(resultSetTableResourcesBase.get("TimestampEditorDefault"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        if (bl2) {
            jPanel2.add((Component)this._default, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        this._timestamp.addItemListener((ItemListener)this);
        this._null.addItemListener((ItemListener)this);
        this._default.addItemListener((ItemListener)this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._timestamp);
        buttonGroup.add((AbstractButton)this._null);
        buttonGroup.add((AbstractButton)this._default);
        jPanel.add((Component)jPanel2, "Center");
        if (object == null || object.toString().length() == 0) {
            Date date = Calendar.getInstance().getTime();
            this._spinner.setValue(date);
            this._dateField.setText(DateCellEditor.formatDate(date));
            this._dateChooser.setSelectedDate(date);
            this._null.setSelected(true);
        } else if (object instanceof DefaultValue) {
            Date date = Calendar.getInstance().getTime();
            this._spinner.setValue(date);
            this._dateField.setText(DateCellEditor.formatDate(date));
            this._dateChooser.setSelectedDate(date);
            this._default.setSelected(true);
        } else {
            if (!(object instanceof Timestamp)) {
                throw new IllegalArgumentException("Expected Timestamp value, but got " + object.getClass().getName());
            }
            this._spinner.setValue(object);
            this._dateField.setText(DateCellEditor.formatDate((Date)object));
            this._dateChooser.setSelectedDate((Date)object);
            this._timestamp.setSelected(true);
        }
        if (!bl) {
            this._null.setEnabled(false);
        }
        if (!bl2) {
            this._default.setEnabled(false);
        }
        this._dateField.getDocument().addDocumentListener(this);
        this._dateChooser.addDateChangeListener((DateChangeListener)this);
        jRootPane.registerKeyboardAction(this, ESCAPE_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, ENTER_COMMAND, KeyStroke.getKeyStroke(10, 0), 1);
        KeyStroke keyStroke = TimestampCellEditor.getButtonKeyStroke();
        if (keyStroke != null) {
            jRootPane.registerKeyboardAction(this, ENTER_COMMAND, keyStroke, 1);
        }
        container.add(jPanel);
        this.pack();
        if (this._null.isSelected()) {
            this._null.requestFocusInWindow();
        } else if (this._default.isSelected()) {
            this._default.requestFocusInWindow();
        } else {
            this._spinner.requestFocusInWindow();
        }
        if (point != null) {
            this.setLocation(point);
        }
    }

    private void destroy() {
        if (this._spinner != null) {
            this._spinner = null;
        }
        if (this._dateField != null) {
            this._dateField.getDocument().removeDocumentListener(this);
            this._dateField = null;
        }
        if (this._dateChooser != null) {
            this._dateChooser.removeDateChangeListener((DateChangeListener)this);
            this._dateChooser.destroy();
            this._dateChooser = null;
        }
        if (this._timestamp != null) {
            this._timestamp.removeItemListener((ItemListener)this);
            this._timestamp = null;
        }
        if (this._null != null) {
            this._null.removeItemListener((ItemListener)this);
            this._null = null;
        }
        if (this._default != null) {
            this._default.removeItemListener((ItemListener)this);
            this._default = null;
        }
        this._editor = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this._timestamp.isSelected();
        this._timeLabel.setEnabled(bl);
        this._spinner.setEnabled(bl);
        this._dateLabel.setEnabled(bl);
        this._dateField.setEnabled(bl);
        this._dateChooser.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(ESCAPE_COMMAND)) {
                this.close();
            } else if (string.equals(ENTER_COMMAND)) {
                this.handleOK();
            }
        }
    }

    void close() {
        this.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimestampCellEditorDialog.this.destroy();
            }
        });
    }

    private void handleOK() {
        Object object;
        if (!this.isVisible()) {
            return;
        }
        if (this._null.isSelected()) {
            object = null;
        } else if (this._default.isSelected()) {
            object = new DefaultValue();
        } else {
            Date date = (Date)this._spinner.getValue();
            Date date2 = this._dateChooser.getSelectedDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date2);
            int n = calendar.get(1);
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            calendar.setTime(date);
            int n4 = calendar.get(10);
            int n5 = calendar.get(12);
            int n6 = calendar.get(13);
            calendar.set(n, n2, n3, n4, n5, n6);
            object = new Timestamp(calendar.getTimeInMillis());
        }
        this._editor.setValue(object);
        this.close();
    }

    public void dateChanged(DateChangeEvent dateChangeEvent) {
        this._dateField.setText(DateCellEditor.formatDate(dateChangeEvent.getDate()));
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateDateChooser();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateDateChooser();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateDateChooser();
    }

    private void updateDateChooser() {
        Date date;
        String string = this._dateField.getText().trim();
        if (string != null && string.length() > 0 && (date = DateCellEditor.parseDate(string)) != null) {
            this._dateChooser.removeDateChangeListener((DateChangeListener)this);
            this._dateChooser.setSelectedDate(date);
            this._dateChooser.addDateChangeListener((DateChangeListener)this);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this._deactivationTime = System.currentTimeMillis();
        this.handleOK();
    }

    long getDeactivationTime() {
        return this._deactivationTime;
    }
}

