/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BinaryCellEditor;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.UniqueIdentifierRenderer;
import com.sybase.util.Dbg;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.MaskFormatter;

class UniqueIdentifierEditor
extends BinaryCellEditor {
    private static final String GUID_MASK = "HHHHHHHH-HHHH-HHHH-HHHH-HHHHHHHHHHHH";
    private static final String PLAIN_GUID_MASK = "HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH";
    private BorderlessFormattedTextField _formattedField;
    private MyComboBoxEditor _comboBoxEditor = null;
    private boolean _useHyphens = true;

    UniqueIdentifierEditor(boolean bl) {
        this._useHyphens = bl;
    }

    @Override
    protected String convertCellValueToString(Object object) {
        return UniqueIdentifierRenderer.blobToString((byte[])object, this._useHyphens);
    }

    @Override
    protected Object convertStringToCellValue(String string) {
        return this.stringToBlob(string);
    }

    private byte[] stringToBlob(String string) {
        byte[] byArray = new byte[16];
        Arrays.fill(byArray, (byte)0);
        try {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (this._useHyphens && (i == 8 || i == 13 || i == 18 || i == 23)) continue;
                int n2 = Character.digit(string.charAt(i), 16);
                int n3 = Character.digit(string.charAt(i + 1), 16);
                if (n2 == -1 || n3 == -1) {
                    throw new NumberFormatException("Invalid hex number: " + string.charAt(i) + string.charAt(i + 1));
                }
                byArray[n++] = (byte)(n2 * 16 + n3);
                if (n != 16) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return byArray;
    }

    private JFormattedTextField getFormattedField() {
        if (this._formattedField == null) {
            try {
                MaskFormatter maskFormatter = this._useHyphens ? new MaskFormatter(GUID_MASK) : new MaskFormatter(PLAIN_GUID_MASK);
                maskFormatter.setPlaceholderCharacter('0');
                this._formattedField = new BorderlessFormattedTextField(maskFormatter);
                this._formattedField.setFocusLostBehavior(0);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this._formattedField;
    }

    @Override
    protected Component createEditor(JTable jTable, int n) {
        Component component = super.createEditor(jTable, n);
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            JFormattedTextField jFormattedTextField = this.getFormattedField();
            String string = ((NullAwareTable)jTable).getNullDisplayString();
            this._comboBoxEditor = new MyComboBoxEditor(jFormattedTextField, string, this._useHyphens);
            this._comboBoxEditor.getEditorComponent().addKeyListener(this);
            jComboBox.setEditor(this._comboBoxEditor);
        } else {
            component = this.getFormattedField();
        }
        return component;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static class BorderlessFormattedTextField
    extends JFormattedTextField {
        BorderlessFormattedTextField(JFormattedTextField.AbstractFormatter abstractFormatter) {
            super(abstractFormatter);
            InputMap inputMap = this.getInputMap(0);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            inputMap.put(keyStroke, "null");
            keyStroke = KeyStroke.getKeyStroke(27, 0);
            inputMap.put(keyStroke, "null");
        }

        @Override
        public void setBorder(Border border) {
        }
    }

    static class MyComboBoxEditor
    implements ComboBoxEditor,
    KeyListener {
        private JFormattedTextField _editor;
        private String _nullString;
        private String _nullStringMask = null;
        private boolean _isShowingNullValue = false;
        private boolean _useHyphens;

        MyComboBoxEditor(JFormattedTextField jFormattedTextField, String string, boolean bl) {
            this._editor = jFormattedTextField;
            jFormattedTextField.addKeyListener(this);
            this._nullString = string;
            this._useHyphens = bl;
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this._editor.addActionListener(actionListener);
        }

        @Override
        public Component getEditorComponent() {
            return this._editor;
        }

        @Override
        public Object getItem() {
            try {
                this._editor.commitEdit();
            }
            catch (ParseException parseException) {
                Dbg.printlnEx((Throwable)parseException, (String)"Could not commit edit");
            }
            Object object = this._editor.getValue();
            if (object != null) {
                object = object.toString();
            }
            return object;
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this._editor.removeActionListener(actionListener);
        }

        @Override
        public void selectAll() {
            this._editor.selectAll();
            this._editor.requestFocus();
        }

        @Override
        public void setItem(Object object) {
            if (object != null && object instanceof String) {
                String string = (String)object;
                this._isShowingNullValue = string.equals(this._nullString);
                if (this._isShowingNullValue) {
                    if (this._nullStringMask == null) {
                        char[] cArray = new char[this._nullString.length()];
                        Arrays.fill(cArray, '*');
                        this._nullStringMask = new String(cArray);
                    }
                    this.setMask(this._nullStringMask);
                } else if (this._useHyphens) {
                    this.setMask(UniqueIdentifierEditor.GUID_MASK);
                } else {
                    this.setMask(UniqueIdentifierEditor.PLAIN_GUID_MASK);
                }
                this._editor.setValue(object);
                this._editor.setText(string);
            }
        }

        private void setMask(String string) {
            MaskFormatter maskFormatter = (MaskFormatter)this._editor.getFormatter();
            try {
                maskFormatter.setMask(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (this._isShowingNullValue && (n = keyEvent.getKeyCode()) != 27 && n != 10) {
                this._isShowingNullValue = false;
                if (this._useHyphens) {
                    this.setMask(UniqueIdentifierEditor.GUID_MASK);
                } else {
                    this.setMask(UniqueIdentifierEditor.PLAIN_GUID_MASK);
                }
                this._editor.setValue("");
                this._editor.setText("");
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

