/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sortableTable;

import com.sybase.sortableTable.SortableTableHeaderRenderer;
import com.sybase.sortableTable.SortedTableModel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortableTable
extends JTable
implements MouseListener {
    boolean _sortAscending = true;
    JTableHeader _tableHeader;
    SortedTableModel _sortedTableModel;

    public SortableTable() {
        this.initializeHeader();
    }

    public SortableTable(TableModel tableModel) {
        super(tableModel);
        this.initializeHeader();
    }

    public SortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initializeHeader();
    }

    public SortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initializeHeader();
    }

    public SortableTable(int n, int n2) {
        super(n, n2);
        this.initializeHeader();
    }

    public SortableTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.initializeHeader();
    }

    public SortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initializeHeader();
    }

    private void initializeHeader() {
        this._tableHeader = this.getTableHeader();
        if (this._tableHeader != null) {
            this._tableHeader.setDefaultRenderer(new SortableTableHeaderRenderer(this));
            boolean bl = true;
            MouseListener[] mouseListenerArray = this._tableHeader.getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length && bl; ++i) {
                if (mouseListenerArray[i] != this) continue;
                bl = false;
            }
            if (bl) {
                this._tableHeader.addMouseListener(this);
            }
        }
    }

    @Override
    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != jTableHeader) {
            super.setTableHeader(jTableHeader);
            if (this._tableHeader != null) {
                this._tableHeader.removeMouseListener(this);
            }
            this.initializeHeader();
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        TableModel tableModel2;
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        if (this._sortedTableModel == null) {
            this._sortedTableModel = new SortedTableModel();
        }
        if ((tableModel2 = this._sortedTableModel.getModel()) != tableModel) {
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            this.dataModel = this._sortedTableModel;
            tableModel.addTableModelListener(this);
            if (this.getColumnModel() != null) {
                this.tableChanged(new TableModelEvent(this._sortedTableModel, -1));
            }
            this._sortedTableModel.setModel(tableModel);
            this.firePropertyChange("model", tableModel2, tableModel);
        }
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableStructureChanged();
        }
    }

    @Override
    public TableModel getModel() {
        boolean bl;
        block3: {
            bl = false;
            try {
                Object object = null;
                object.hashCode();
            }
            catch (Exception exception) {
                String[] stringArray = this.trace(exception);
                if (stringArray[2].indexOf("com.sybase.sortableTable.SortableTable") <= -1 && stringArray[2].indexOf("javax.swing.JTable") <= -1) break block3;
                bl = true;
            }
        }
        if (bl) {
            return this._sortedTableModel;
        }
        return this._sortedTableModel.getModel();
    }

    public Class getColumnClass(int n) {
        return this._sortedTableModel.getModel().getColumnClass(this.convertColumnIndexToModel(n));
    }

    @Override
    public void createDefaultColumnsFromModel() {
        SortedTableModel sortedTableModel = this._sortedTableModel;
        if (sortedTableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i = 0; i < sortedTableModel.getColumnCount(); ++i) {
                TableColumn tableColumn = new TableColumn(i);
                this.addColumn(tableColumn);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this._sortedTableModel.getRowCount();
    }

    @Override
    public String getColumnName(int n) {
        return this._sortedTableModel.getColumnName(this.convertColumnIndexToModel(n));
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._sortedTableModel.getValueAt(n, this.convertColumnIndexToModel(n2));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this._sortedTableModel.setValueAt(object, n, this.convertColumnIndexToModel(n2));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._sortedTableModel.isCellEditable(n, this.convertColumnIndexToModel(n2));
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        String string = this._sortedTableModel.getColumnName(n);
        if (tableColumn.getHeaderValue() == null) {
            tableColumn.setHeaderValue(string);
        }
        this.getColumnModel().addColumn(tableColumn);
    }

    String[] trace(Throwable throwable) {
        Vector<String> vector = new Vector<String>();
        try {
            String string;
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
            while ((string = bufferedReader.readLine()) != null) {
                vector.addElement(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (this.isEnabled() && mouseEvent.getSource() == this._tableHeader && this.isColumnSortable(n = this.convertColumnIndexToModel(this._tableHeader.columnAtPoint(mouseEvent.getPoint())))) {
            int[] nArray = this.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this._sortedTableModel.convertRowIndexToModel(nArray[i]);
            }
            this.editingRow = this.getEditingRow();
            if (this.editingRow > -1) {
                this.editingRow = this._sortedTableModel.convertRowIndexToModel(this.editingRow);
            }
            if (n != this._sortedTableModel.getSortColumn()) {
                this._sortAscending = true;
                this._sortedTableModel.setSortColumn(n);
            } else {
                this._sortAscending = !this._sortAscending;
            }
            this._tableHeader.revalidate();
            this._tableHeader.repaint();
            this._sortedTableModel.sort(n, this._sortAscending);
            this.tableChanged(new TableModelEvent(this._sortedTableModel));
            this.clearSelection();
            for (int n2 : nArray) {
                int n3 = this._sortedTableModel.convertRowIndexToView(n2);
                this.addRowSelectionInterval(n3, n3);
            }
            if (this.editingRow > -1) {
                this.setEditingRow(this._sortedTableModel.convertRowIndexToView(this.editingRow));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent != null) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getLastRow();
            if (n > -1 && n2 > -1 && n2 < this._sortedTableModel.getRowCount()) {
                tableModelEvent = new TableModelEvent((TableModel)tableModelEvent.getSource(), this._sortedTableModel.convertRowIndexToView(n), this._sortedTableModel.convertRowIndexToView(n2), tableModelEvent.getColumn(), tableModelEvent.getType());
            }
        }
        super.tableChanged(tableModelEvent);
    }

    public int getSortColumn() {
        return this._sortedTableModel.getSortColumn();
    }

    public void setSortColumn(int n) {
        if (this.isColumnSortable(n)) {
            int[] nArray = this.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this._sortedTableModel.convertRowIndexToModel(nArray[i]);
            }
            this.editingRow = this.getEditingRow();
            if (this.editingRow > -1) {
                this.editingRow = this._sortedTableModel.convertRowIndexToModel(this.editingRow);
            }
            this._sortAscending = this.isSortAscending();
            if (this._tableHeader != null) {
                this._tableHeader.revalidate();
                this._tableHeader.repaint();
            }
            this._sortedTableModel.sort(n, this._sortAscending);
            this.tableChanged(new TableModelEvent(this._sortedTableModel));
            this.clearSelection();
            for (int n2 : nArray) {
                int n3 = this._sortedTableModel.convertRowIndexToView(n2);
                this.addRowSelectionInterval(n3, n3);
            }
            if (this.editingRow > -1) {
                this.setEditingRow(this._sortedTableModel.convertRowIndexToView(this.editingRow));
            }
        }
    }

    public boolean isSortAscending() {
        return this._sortedTableModel.isSortAscending();
    }

    public void setSortAscending(boolean bl) {
        this._sortedTableModel.setSortAscending(bl);
    }

    public boolean isColumnSortable(int n) {
        return n >= 0 && n < this.getColumnCount();
    }

    @Override
    public int convertRowIndexToView(int n) {
        return this._sortedTableModel.convertRowIndexToView(n);
    }

    @Override
    public int convertRowIndexToModel(int n) {
        return this._sortedTableModel.convertRowIndexToModel(n);
    }

    public void destroy() {
        if (this._tableHeader != null) {
            this._tableHeader.removeMouseListener(this);
        }
    }
}

