/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sortableTable;

import com.sybase.sortableTable.SortableTable;
import com.sybase.sortableTable.SortableTableArrowIcon;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SortableTableHeaderRenderer
implements TableCellRenderer {
    private TableCellRenderer _renderer;
    private int _alignment;
    private static final TableCellRenderer DUMMY_RENDERER = new DefaultTableCellRenderer.UIResource();
    private TableHeaderUI headerUI;

    public SortableTableHeaderRenderer(JTable jTable) {
        this(jTable, 2);
    }

    public SortableTableHeaderRenderer(JTable jTable, int n) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (jTableHeader != null) {
            this._renderer = jTableHeader.getDefaultRenderer();
        }
        this._alignment = n;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.checkAndFix(jTable);
        Component component = this._renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)component;
            defaultTableCellRenderer.setHorizontalAlignment(this._alignment);
            defaultTableCellRenderer.setHorizontalTextPosition(2);
            defaultTableCellRenderer.setForeground(jTable.isEnabled() ? UIManager.getColor("TableHeader.foreground") : UIManager.getColor("Label.disabledForeground"));
            if (jTable instanceof SortableTable) {
                SortableTable sortableTable = (SortableTable)jTable;
                if (sortableTable.getSortColumn() == sortableTable.convertColumnIndexToModel(n2)) {
                    defaultTableCellRenderer.setIcon(sortableTable.isSortAscending() ? SortableTableArrowIcon.ICON_ASCENDING : SortableTableArrowIcon.ICON_DESCENDING);
                } else {
                    defaultTableCellRenderer.setIcon(null);
                }
            }
        }
        return component;
    }

    private void checkAndFix(JTable jTable) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (this.headerUI == null || this.headerUI != jTableHeader.getUI()) {
            TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
            jTableHeader.setDefaultRenderer(DUMMY_RENDERER);
            jTableHeader.updateUI();
            this.headerUI = jTableHeader.getUI();
            this._renderer = jTableHeader.getDefaultRenderer();
            if (this._renderer == null || this._renderer == tableCellRenderer || this._renderer == DUMMY_RENDERER) {
                this._renderer = new JTableHeader().getDefaultRenderer();
            }
            jTableHeader.setDefaultRenderer(tableCellRenderer);
        }
    }
}

