/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sqldoc;

import com.sybase.sqldoc.Config;
import com.sybase.sqldoc.ProcedureInfo;
import com.sybase.sqldoc.SQLDocException;
import com.sybase.sqldoc.SourceReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DatabaseReader
implements SourceReader {
    private Connection _connection;
    private Vector<ProcedureInfo> _procedures;
    private Vector<ProcedureInfo> _triggers;
    private Vector<ProcedureInfo> _events;
    private Vector<ProcedureInfo> _views;
    private Vector<String> _procNames;
    private String _schema = null;
    private boolean _isSA10;

    public DatabaseReader(Connection connection, String string) {
        this._schema = string;
        this._connection = connection;
        this._isSA10 = this.isSA10DB();
    }

    @Override
    public Vector<ProcedureInfo> getProcedures() throws SQLDocException {
        if (this._procedures == null) {
            this.generateProcedureInfo();
        }
        return this._procedures;
    }

    @Override
    public Vector<String> getProcNames() throws SQLDocException {
        if (this._procNames == null) {
            this.generateProcedureInfo();
        }
        return this._procNames;
    }

    @Override
    public Vector<ProcedureInfo> getTriggers() throws SQLDocException {
        if (this._triggers == null) {
            this.generateTriggerInfo();
        }
        return this._triggers;
    }

    @Override
    public Vector<ProcedureInfo> getEvents() throws SQLDocException {
        if (this._events == null) {
            this.generateEventInfo();
        }
        return this._events;
    }

    @Override
    public Vector<ProcedureInfo> getViews() throws SQLDocException {
        if (this._views == null) {
            this.generateViewInfo();
        }
        return this._views;
    }

    private void generateProcedureInfo() throws SQLDocException {
        try {
            boolean bl = Config.getInstance().hasOption('y');
            String string = this._isSA10 ? "SELECT p.proc_name, p.proc_defn || '\n', p.remarks, u.user_name FROM SYS.SYSPROCEDURE p, SYS.SYSUSER u WHERE p.creator IN (SELECT user_id FROM SYS.SYSUSER WHERE user_name LIKE ?) AND p.creator=u.user_id" : "SELECT p.proc_name, p.proc_defn || '\n', p.remarks, u.user_name FROM SYS.SYSPROCEDURE p, SYS.SYSUSERPERM u WHERE p.creator IN (SELECT user_id FROM SYS.SYSUSERPERM WHERE user_name LIKE ?) AND p.creator=u.user_id";
            if (!bl && (this._schema == null || this._schema.isEmpty() || "dbo".equals(this._schema))) {
                string = string + " AND NOT ( p.proc_name IN (SELECT name FROM DBO.EXCLUDEOBJECT WHERE type='P') AND u.user_name='dbo' OR u.user_name='SYS' )";
            }
            PreparedStatement preparedStatement = this._connection.prepareStatement(string);
            if (this._schema == null || this._schema.isEmpty()) {
                preparedStatement.setString(1, "%");
            } else {
                preparedStatement.setString(1, this._schema);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            this._procedures = new Vector();
            this._procNames = new Vector();
            while (resultSet.next()) {
                ProcedureInfo procedureInfo = new ProcedureInfo();
                procedureInfo._name = resultSet.getString(1);
                procedureInfo._def = resultSet.getString(2);
                procedureInfo._comment = resultSet.getString(3);
                procedureInfo._owner = resultSet.getString(4);
                this._procedures.add(procedureInfo);
                this._procNames.add(procedureInfo._owner + "." + procedureInfo._name);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new SQLDocException(sQLException, false);
        }
    }

    private void generateTriggerInfo() throws SQLDocException {
        try {
            String string = this._isSA10 ? "SELECT G.trigger_name, G.trigger_defn || '\n', G.remarks, U.user_name FROM SYS.SYSTRIGGER G JOIN SYS.SYSTAB T ON T.table_id = G.table_id JOIN SYS.SYSUSER U ON U.user_id = T.creator WHERE G.foreign_key_id IS NULL AND U.user_name LIKE ?" : "SELECT G.trigger_name, G.trigger_defn || '\n', G.remarks, U.user_name FROM SYS.SYSTRIGGER G JOIN SYS.SYSTABLE T ON T.table_id = G.table_id JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator WHERE G.foreign_key_id IS NULL AND U.user_name LIKE ?";
            PreparedStatement preparedStatement = this._connection.prepareStatement(string);
            if (this._schema == null || this._schema.isEmpty()) {
                preparedStatement.setString(1, "%");
            } else {
                preparedStatement.setString(1, this._schema);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            this._triggers = new Vector();
            while (resultSet.next()) {
                ProcedureInfo procedureInfo = new ProcedureInfo();
                procedureInfo._name = resultSet.getString(1);
                procedureInfo._def = resultSet.getString(2);
                procedureInfo._comment = resultSet.getString(3);
                procedureInfo._owner = resultSet.getString(4);
                this._triggers.add(procedureInfo);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new SQLDocException(sQLException, false);
        }
    }

    private void generateEventInfo() throws SQLDocException {
        try {
            String string = this._isSA10 ? "SELECT E.event_name, E.action || '\n', E.remarks, U.user_name FROM SYS.SYSEVENT E JOIN SYS.SYSUSER U ON U.user_id = E.creator WHERE U.user_name LIKE ?" : "SELECT E.event_name, E.action || '\n', E.remarks, U.user_name FROM SYS.SYSEVENT E JOIN SYS.SYSUSERPERMS U ON U.user_id = E.creator WHERE U.user_name LIKE ?";
            PreparedStatement preparedStatement = this._connection.prepareStatement(string);
            if (this._schema == null || this._schema.isEmpty()) {
                preparedStatement.setString(1, "%");
            } else {
                preparedStatement.setString(1, this._schema);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            this._events = new Vector();
            while (resultSet.next()) {
                ProcedureInfo procedureInfo = new ProcedureInfo();
                procedureInfo._name = resultSet.getString(1);
                procedureInfo._def = resultSet.getString(2);
                procedureInfo._comment = resultSet.getString(3);
                procedureInfo._owner = resultSet.getString(4);
                this._events.add(procedureInfo);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new SQLDocException(sQLException, false);
        }
    }

    private void generateViewInfo() throws SQLDocException {
        try {
            String string = this._isSA10 ? "SELECT T.table_name, V.view_def || '\n', R.remarks, U.user_name FROM SYS.SYSVIEW V JOIN SYS.SYSTAB T ON V.view_object_id = T.object_id JOIN SYS.SYSUSER U ON U.user_id = T.creator LEFT OUTER JOIN SYS.SYSREMARK R ON R.object_id = T.object_id WHERE U.user_name LIKE ?" : "SELECT T.table_name, T.view_def || '\n', T.remarks, U.user_name FROM SYS.SYSTABLE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator WHERE T.table_type = 'VIEW' AND U.user_name LIKE ?";
            PreparedStatement preparedStatement = this._connection.prepareStatement(string);
            if (this._schema == null || this._schema.isEmpty()) {
                preparedStatement.setString(1, "%");
            } else {
                preparedStatement.setString(1, this._schema);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            this._views = new Vector();
            while (resultSet.next()) {
                ProcedureInfo procedureInfo = new ProcedureInfo();
                procedureInfo._name = resultSet.getString(1);
                procedureInfo._def = resultSet.getString(2);
                procedureInfo._comment = resultSet.getString(3);
                procedureInfo._owner = resultSet.getString(4);
                this._views.add(procedureInfo);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new SQLDocException(sQLException, false);
        }
    }

    private boolean isSA10DB() {
        int n = 0;
        try {
            String string;
            int n2;
            Statement statement = this._connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PROPERTY( 'ProductVersion' )");
            if (resultSet.next() && (n2 = (string = resultSet.getString(1)).indexOf(46)) >= 0) {
                n = Integer.parseInt(string.substring(0, n2));
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            n = 0;
        }
        return n >= 10;
    }
}

