/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sqldoc;

import com.sybase.sqldoc.ChangeInfo;
import com.sybase.sqldoc.Config;
import com.sybase.sqldoc.DatabaseReader;
import com.sybase.sqldoc.ProcedureInfo;
import com.sybase.sqldoc.ProgressReporter;
import com.sybase.sqldoc.SQLDocConstants;
import com.sybase.sqldoc.SQLDocException;
import com.sybase.sqldoc.SQLDocResourcesBase;
import com.sybase.sqldoc.Utilities;
import com.sybase.sqldoc.html.HTMLWriter;
import com.sybase.sqldoc.html.jcc.MyLexer;
import com.sybase.sqldoc.jcc.SQLLexer;
import com.sybase.sqldoc.jcc.Token;
import com.sybase.sqldoc.jcc.comment.Comment;
import com.sybase.sqldoc.jcc.comment.CommentRecognizer;
import java.io.File;
import java.io.StringReader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SQLDoc {
    private static SQLLexer _lexer = null;
    private static MyLexer _myLexer = null;
    private ProgressReporter _reporter;
    private static Connection _conn;
    private static int _status;
    private static double _increment;
    private static boolean _isSinglePage;
    private static boolean _processComments;
    private Vector<ProcedureInfo> _procedures = null;
    private Vector<ProcedureInfo> _triggers = null;
    private Vector<ProcedureInfo> _events = null;
    private Vector<ProcedureInfo> _views = null;
    private Vector<String> _procNames = null;
    private Vector<String> _tablesRefd = null;
    private SQLDocResourcesBase _res;

    public SQLDoc() {
        _status = 1;
        _increment = 1.0;
        this._tablesRefd = new Vector();
        this._res = SQLDocResourcesBase.getBundle();
        if (null == _lexer) {
            _lexer = new SQLLexer(new StringReader(""));
        } else {
            SQLLexer.ReInit(new StringReader(""));
        }
        if (_myLexer == null) {
            _myLexer = new MyLexer(new StringReader(""));
        } else {
            MyLexer.ReInit(new StringReader(""));
        }
    }

    public static void main(String[] stringArray) throws SQLDocException {
    }

    public static void generateDocument(Connection connection, Config config, ProgressReporter progressReporter) throws SQLDocException {
        _conn = connection;
        SQLDoc sQLDoc = new SQLDoc();
        sQLDoc.setReporter(progressReporter);
        Thread.currentThread().setPriority(1);
        _isSinglePage = config.hasOption('s');
        _processComments = !config.hasOption('n');
        boolean bl = config.hasOption('p');
        HTMLWriter hTMLWriter = new HTMLWriter(_isSinglePage, bl);
        try {
            Document document = sQLDoc.getDocument();
            hTMLWriter.write(document, new File(config.getDir()), sQLDoc.getReporter(), _status);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (SQLDocException sQLDocException) {
            throw sQLDocException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLDocException(outOfMemoryError, false);
        }
        catch (Throwable throwable) {
            throw new SQLDocException(throwable, true);
        }
    }

    public ProgressReporter getReporter() {
        return this._reporter;
    }

    public void setReporter(ProgressReporter progressReporter) {
        this._reporter = progressReporter;
    }

    public Document getDocument() throws SQLDocException, InterruptedException {
        DocumentBuilder documentBuilder;
        this.checkInterrupted();
        Config config = Config.getInstance();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SQLDocException(parserConfigurationException, false);
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("SQLDOC");
        document.appendChild(element);
        Element element2 = document.createElement("DBN");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(config.getDBN()));
        Element element3 = document.createElement("PROCEDURES");
        element.appendChild(element3);
        Element element4 = document.createElement("TRIGGERS");
        element.appendChild(element4);
        Element element5 = document.createElement("EVENTS");
        element.appendChild(element5);
        Element element6 = document.createElement("VIEWS");
        element.appendChild(element6);
        this.log(this._res.get("MSG_GETTING_INFO_FROM_DB"));
        DatabaseReader databaseReader = new DatabaseReader(_conn, config.getOwner());
        this._procedures = databaseReader.getProcedures();
        this._triggers = databaseReader.getTriggers();
        this._events = databaseReader.getEvents();
        this._views = databaseReader.getViews();
        this._procNames = databaseReader.getProcNames();
        if (this._reporter != null) {
            this._reporter.setMaxLength(100);
            int n = this._procedures.size() + this._triggers.size() + this._events.size() + this._views.size();
            _increment = _isSinglePage ? 85.0 / (double)n : 47.0 / (double)n;
        }
        this.addProcedures(document, element3);
        this.addTriggers(document, element4);
        this.addEvents(document, element5);
        this.addViews(document, element6);
        if (this._reporter != null) {
            _status = _isSinglePage ? 85 : 47;
            this._reporter.setProgress(_status++);
        }
        return document;
    }

    public static String composeFilenameForDBObject(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('.');
        stringBuilder.append(string2);
        if (string3 != null) {
            stringBuilder.append('.');
            stringBuilder.append(string3);
        }
        stringBuilder.append(".html");
        String string4 = SQLDoc.escapeFilename(stringBuilder.toString());
        return string4;
    }

    public static String escapeFilename(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            String string2 = "0000" + Integer.toString(c, 16);
            stringBuilder.append(string2.substring(string2.length() - 4));
        }
        string = stringBuilder.toString();
        return string;
    }

    private int addProcedures(Document document, Element element) throws InterruptedException {
        this.checkInterrupted();
        double d = _status;
        this.log(this._res.get("MSG_CREATING_PROCS"));
        for (ProcedureInfo procedureInfo : this._procedures) {
            Object object;
            Object object2;
            Object object3;
            this.checkInterrupted();
            if (this._reporter != null) {
                _status = (int)Math.floor(d += _increment);
                this._reporter.setProgress(_status);
            }
            this.log(this._res.getFormatted("MSG_ADDING_PROC", procedureInfo._name));
            Element element2 = document.createElement("PROCEDURE");
            element.appendChild(element2);
            Element element3 = document.createElement("NAME");
            element3.appendChild(document.createTextNode(procedureInfo._name));
            element2.appendChild(element3);
            Element element4 = document.createElement("SCHEMA");
            element4.appendChild(document.createTextNode(procedureInfo._owner));
            element2.appendChild(element4);
            Element element5 = document.createElement("FILENAME");
            element5.appendChild(document.createTextNode(SQLDoc.composeFilenameForDBObject(procedureInfo._owner, procedureInfo._name, null)));
            element2.appendChild(element5);
            ChangeInfo changeInfo = this.getChangeInfo(procedureInfo._def, procedureInfo._name);
            Document document2 = changeInfo.getDocument();
            if (document2 != null) {
                object3 = document.importNode(document2.getDocumentElement(), true);
                element2.appendChild((Node)object3);
            }
            if ((object3 = this.getReferences(procedureInfo)) != null && ((ReferenceInfo[])object3).length > 0) {
                object2 = document.createElement("REFERENCES");
                element2.appendChild((Node)object2);
                object = object3;
                int n = ((ReferenceInfo[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object4 = object[i];
                    Element element6 = document.createElement("REFERENCE");
                    Element element7 = document.createElement("NAME");
                    Element element8 = document.createElement("SCHEMA");
                    if (((ReferenceInfo)object4)._owner == null) {
                        ((ReferenceInfo)object4)._owner = "";
                    }
                    element7.appendChild(document.createTextNode(((ReferenceInfo)object4)._name));
                    element8.appendChild(document.createTextNode(((ReferenceInfo)object4)._owner));
                    element6.appendChild(element7);
                    element6.appendChild(element8);
                    object2.appendChild(element6);
                }
            }
            if (_processComments && procedureInfo._comment != null && (object = ((Comment)(object2 = CommentRecognizer.scanComment(procedureInfo._comment))).getDocument()) != null) {
                Node node = document.importNode(object.getDocumentElement(), true);
                element2.appendChild(node);
            }
            object2 = document.createElement("DEF");
            element2.appendChild((Node)object2);
            object2.appendChild(document.createCDATASection(this.addSyntaxColor((ReferenceInfo[])object3, procedureInfo._def, _isSinglePage)));
        }
        this.log(this._res.get("MSG_PROCS_CREATED"));
        return this._procedures.size();
    }

    private int addTriggers(Document document, Element element) throws InterruptedException {
        this.checkInterrupted();
        double d = _status;
        this.log(this._res.get("MSG_CREATING_TRIGGERS"));
        for (ProcedureInfo procedureInfo : this._triggers) {
            Object object;
            Object object2;
            Object object3;
            this.checkInterrupted();
            if (this._reporter != null) {
                _status = (int)Math.floor(d += _increment);
                this._reporter.setProgress(_status);
            }
            this.log(this._res.getFormatted("MSG_ADDING_TRIGGER", procedureInfo._name));
            Element element2 = document.createElement("TRIGGER");
            element.appendChild(element2);
            Element element3 = document.createElement("NAME");
            element3.appendChild(document.createTextNode(procedureInfo._name));
            element2.appendChild(element3);
            Element element4 = document.createElement("SCHEMA");
            element4.appendChild(document.createTextNode(procedureInfo._owner));
            element2.appendChild(element4);
            Element element5 = document.createElement("FILENAME");
            element5.appendChild(document.createTextNode(SQLDoc.composeFilenameForDBObject(procedureInfo._owner, procedureInfo._name, "tr")));
            element2.appendChild(element5);
            ChangeInfo changeInfo = this.getChangeInfo(procedureInfo._def, procedureInfo._name);
            Document document2 = changeInfo.getDocument();
            if (document2 != null) {
                object3 = document.importNode(document2.getDocumentElement(), true);
                element2.appendChild((Node)object3);
            }
            if ((object3 = this.getReferences(procedureInfo)) != null && ((ReferenceInfo[])object3).length > 0) {
                object2 = document.createElement("REFERENCES");
                element2.appendChild((Node)object2);
                object = object3;
                int n = ((ReferenceInfo[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object4 = object[i];
                    Element element6 = document.createElement("REFERENCE");
                    Element element7 = document.createElement("NAME");
                    Element element8 = document.createElement("SCHEMA");
                    if (((ReferenceInfo)object4)._owner == null) {
                        ((ReferenceInfo)object4)._owner = "";
                    }
                    element7.appendChild(document.createTextNode(((ReferenceInfo)object4)._name));
                    element8.appendChild(document.createTextNode(((ReferenceInfo)object4)._owner));
                    element6.appendChild(element7);
                    element6.appendChild(element8);
                    object2.appendChild(element6);
                }
            }
            if (_processComments && procedureInfo._comment != null && (object = ((Comment)(object2 = CommentRecognizer.scanComment(procedureInfo._comment))).getDocument()) != null) {
                Node node = document.importNode(object.getDocumentElement(), true);
                element2.appendChild(node);
            }
            object2 = document.createElement("DEF");
            element2.appendChild((Node)object2);
            object2.appendChild(document.createCDATASection(this.addSyntaxColor((ReferenceInfo[])object3, procedureInfo._def, _isSinglePage)));
        }
        this.log(this._res.get("MSG_TRIGGERS_CREATED"));
        return this._triggers.size();
    }

    private int addEvents(Document document, Element element) throws InterruptedException {
        this.checkInterrupted();
        double d = _status;
        this.log(this._res.get("MSG_CREATING_EVENTS"));
        for (ProcedureInfo procedureInfo : this._events) {
            Object object;
            Object object2;
            Object object3;
            this.checkInterrupted();
            if (this._reporter != null) {
                _status = (int)Math.floor(d += _increment);
                this._reporter.setProgress(_status);
            }
            this.log(this._res.getFormatted("MSG_ADDING_EVENT", procedureInfo._name));
            Element element2 = document.createElement("EVENT");
            element.appendChild(element2);
            Element element3 = document.createElement("NAME");
            element3.appendChild(document.createTextNode(procedureInfo._name));
            element2.appendChild(element3);
            Element element4 = document.createElement("SCHEMA");
            element4.appendChild(document.createTextNode(procedureInfo._owner));
            element2.appendChild(element4);
            Element element5 = document.createElement("FILENAME");
            element5.appendChild(document.createTextNode(SQLDoc.composeFilenameForDBObject(procedureInfo._owner, procedureInfo._name, "ev")));
            element2.appendChild(element5);
            ChangeInfo changeInfo = this.getChangeInfo(procedureInfo._def, procedureInfo._name);
            Document document2 = changeInfo.getDocument();
            if (document2 != null) {
                object3 = document.importNode(document2.getDocumentElement(), true);
                element2.appendChild((Node)object3);
            }
            if ((object3 = this.getReferences(procedureInfo)) != null && ((ReferenceInfo[])object3).length > 0) {
                object2 = document.createElement("REFERENCES");
                element2.appendChild((Node)object2);
                object = object3;
                int n = ((ReferenceInfo[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object4 = object[i];
                    Element element6 = document.createElement("REFERENCE");
                    Element element7 = document.createElement("NAME");
                    Element element8 = document.createElement("SCHEMA");
                    if (((ReferenceInfo)object4)._owner == null) {
                        ((ReferenceInfo)object4)._owner = "";
                    }
                    element7.appendChild(document.createTextNode(((ReferenceInfo)object4)._name));
                    element8.appendChild(document.createTextNode(((ReferenceInfo)object4)._owner));
                    element6.appendChild(element7);
                    element6.appendChild(element8);
                    object2.appendChild(element6);
                }
            }
            if (_processComments && procedureInfo._comment != null && (object = ((Comment)(object2 = CommentRecognizer.scanComment(procedureInfo._comment))).getDocument()) != null) {
                Node node = document.importNode(object.getDocumentElement(), true);
                element2.appendChild(node);
            }
            object2 = document.createElement("DEF");
            element2.appendChild((Node)object2);
            object2.appendChild(document.createCDATASection(this.addSyntaxColor(null, procedureInfo._def, _isSinglePage)));
        }
        this.log(this._res.get("MSG_EVENTS_CREATED"));
        return this._events.size();
    }

    private int addViews(Document document, Element element) throws InterruptedException {
        this.checkInterrupted();
        double d = _status;
        this.log(this._res.get("MSG_CREATING_VIEWS"));
        for (ProcedureInfo procedureInfo : this._views) {
            Object object;
            Document document2;
            this.checkInterrupted();
            if (this._reporter != null) {
                _status = (int)Math.floor(d += _increment);
                this._reporter.setProgress(_status);
            }
            this.log(this._res.getFormatted("MSG_ADDING_VIEW", procedureInfo._name));
            Element element2 = document.createElement("VIEW");
            element.appendChild(element2);
            Element element3 = document.createElement("NAME");
            element3.appendChild(document.createTextNode(procedureInfo._name));
            element2.appendChild(element3);
            Element element4 = document.createElement("SCHEMA");
            element4.appendChild(document.createTextNode(procedureInfo._owner));
            element2.appendChild(element4);
            Element element5 = document.createElement("FILENAME");
            element5.appendChild(document.createTextNode(SQLDoc.composeFilenameForDBObject(procedureInfo._owner, procedureInfo._name, "vi")));
            element2.appendChild(element5);
            if (_processComments && procedureInfo._comment != null && (document2 = ((Comment)(object = CommentRecognizer.scanComment(procedureInfo._comment))).getDocument()) != null) {
                Node node = document.importNode(document2.getDocumentElement(), true);
                element2.appendChild(node);
            }
            object = document.createElement("DEF");
            element2.appendChild((Node)object);
            object.appendChild(document.createCDATASection(this.addSyntaxColor(null, procedureInfo._def, _isSinglePage)));
        }
        this.log(this._res.get("MSG_VIEWS_CREATED"));
        return this._views.size();
    }

    private ChangeInfo getChangeInfo(String string, String string2) {
        ChangeInfo changeInfo = new ChangeInfo(string2);
        SQLLexer.ReInit(new StringReader(string));
        Token token = SQLLexer.getNextToken();
        while (token.kind != 0) {
            Token token2;
            Token token3;
            Token token4 = SQLLexer.getToken(1);
            if (token4.kind == 0) break;
            if (token.kind == 98) {
                if (token4.kind == 105) {
                    token3 = SQLLexer.getToken(2);
                    token2 = SQLLexer.getToken(3);
                    Token token5 = SQLLexer.getToken(4);
                    if (token2.kind == 269) {
                        changeInfo.addInsert(token5.image);
                        this._tablesRefd.add(token5.image);
                    } else {
                        changeInfo.addInsert(token3.image);
                        this._tablesRefd.add(token3.image);
                    }
                    token = SQLLexer.getNextToken();
                    while (token.kind != 220 && token.kind != 181 && token.kind != 0) {
                        token = SQLLexer.getNextToken();
                    }
                } else if (token4.kind == 255) {
                    token3 = SQLLexer.getToken(2);
                    token2 = SQLLexer.getToken(3);
                    if (token3.kind == 269) {
                        changeInfo.addInsert(token2.image);
                        this._tablesRefd.add(token2.image);
                    } else {
                        changeInfo.addInsert(token4.image);
                        this._tablesRefd.add(token4.image);
                    }
                    token = SQLLexer.getNextToken();
                    while (token.kind != 220 && token.kind != 181 && token.kind != 0) {
                        token = SQLLexer.getNextToken();
                    }
                }
            } else if (token.kind == 215) {
                if (token4.kind == 77) {
                    this.skip(1);
                } else if (token4.kind == 205) {
                    this.skip(2);
                }
                token = SQLLexer.getNextToken();
                if (token.kind == 255) {
                    while (token.kind != 185 && token.kind != 153) {
                        token4 = SQLLexer.getToken(1);
                        if (token.kind != 266 && token4.kind != 269 && token.kind != 269) {
                            changeInfo.addUpdate(token.image);
                            this._tablesRefd.add(token.image);
                        }
                        token = SQLLexer.getNextToken();
                    }
                }
            } else if (token.kind == 54) {
                if (token4.kind == 77) {
                    this.skip(1);
                } else if (token4.kind == 205) {
                    this.skip(2);
                }
                token4 = SQLLexer.getToken(1);
                if (token4.kind == 82) {
                    this.skip(1);
                }
                token4 = SQLLexer.getToken(1);
                if (token4.kind == 255) {
                    token3 = SQLLexer.getToken(2);
                    token2 = SQLLexer.getToken(3);
                    if (token3.kind == 269) {
                        changeInfo.addDelete(token2.image);
                        this._tablesRefd.add(token2.image);
                        this.skip(3);
                    } else {
                        changeInfo.addDelete(token4.image);
                        this._tablesRefd.add(token4.image);
                        this.skip(1);
                    }
                    token4 = SQLLexer.getToken(1);
                    if (token4.kind == 82) {
                        this.skip(1);
                        while (true) {
                            token = SQLLexer.getNextToken();
                            token4 = SQLLexer.getToken(1);
                            if (token4.kind == 269) {
                                this.skip(2);
                                continue;
                            }
                            if (token.kind == 269) {
                                this.skip(1);
                                continue;
                            }
                            changeInfo.addDelete(token.image);
                            this._tablesRefd.add(token.image);
                            if (token4.kind != 266) break;
                        }
                    }
                }
            } else if (token.kind == 208) {
                if (token4.kind == 198) {
                    this.skip(1);
                    token4 = SQLLexer.getToken(1);
                    token3 = SQLLexer.getToken(2);
                    token2 = SQLLexer.getToken(3);
                    if (token3.kind == 269) {
                        changeInfo.addDelete(token2.image);
                        this._tablesRefd.add(token2.image);
                        this.skip(3);
                    } else {
                        changeInfo.addDelete(token4.image);
                        this._tablesRefd.add(token4.image);
                        this.skip(1);
                    }
                }
            } else if (token.kind == 154) {
                Token token6 = SQLLexer.getNextToken();
                changeInfo.addRaiserror(token6.image);
            }
            token = SQLLexer.getNextToken();
        }
        return changeInfo;
    }

    private ReferenceInfo[] getReferences(ProcedureInfo procedureInfo) {
        ReferenceInfo[] referenceInfoArray;
        HashMap<String, ReferenceInfo> hashMap = new HashMap<String, ReferenceInfo>();
        SQLLexer.ReInit(new StringReader(procedureInfo._def));
        try {
            while (true) {
                referenceInfoArray = _lexer.getNextToken();
                if (referenceInfoArray.kind != 0) {
                    Token token = SQLLexer.getToken(1);
                    if (token.kind != 0) {
                        Token token2 = SQLLexer.getToken(2);
                        if (token2.kind != 0) {
                            ReferenceInfo referenceInfo;
                            Token token3 = SQLLexer.getToken(3);
                            if (referenceInfoArray.kind == 23 || referenceInfoArray.kind == 72) {
                                referenceInfo = new ReferenceInfo();
                                if (!(token.kind != 254 && token.kind != 255 || token2.kind != 269 || token3.kind != 254 && token3.kind != 255)) {
                                    referenceInfo._owner = token.image;
                                    referenceInfo._name = token3.image;
                                    this.addReference(hashMap, referenceInfo, procedureInfo._owner);
                                    this.skip(3);
                                    continue;
                                }
                                if (token.kind != 254 && token.kind != 255) continue;
                                referenceInfo._owner = null;
                                referenceInfo._name = token.image;
                                this.addReference(hashMap, referenceInfo, procedureInfo._owner);
                                this.skip(1);
                                continue;
                            }
                            if (referenceInfoArray.kind != 152 && token2.kind == 280 && token.kind == 255 && referenceInfoArray.kind != 269 && referenceInfoArray.kind != 84) {
                                referenceInfo = new ReferenceInfo(null, token.image);
                                this.addReference(hashMap, referenceInfo, procedureInfo._owner);
                                this.skip(2);
                                continue;
                            }
                            if (referenceInfoArray.kind != 207 || token.kind != 69 || token2.kind != 255) continue;
                            referenceInfo = new ReferenceInfo("evtOwner", token2.image);
                            this.addReference(hashMap, referenceInfo, procedureInfo._owner);
                            this.skip(2);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        referenceInfoArray = new ReferenceInfo[hashMap.size()];
        hashMap.values().toArray(referenceInfoArray);
        return referenceInfoArray;
    }

    private void addReference(HashMap<String, ReferenceInfo> hashMap, ReferenceInfo referenceInfo, String string) {
        if (referenceInfo == null || referenceInfo._name == null) {
            return;
        }
        referenceInfo._name = referenceInfo._name.replace("\"", "");
        if (referenceInfo._owner != null) {
            referenceInfo._owner = referenceInfo._owner.replace("\"", "");
        }
        if (referenceInfo._owner == null || referenceInfo._owner.isEmpty()) {
            referenceInfo._owner = this.resolveRef(referenceInfo._name, string);
        }
        if (!this.isBuiltInFunction(referenceInfo._name) && !this._tablesRefd.contains(referenceInfo._name)) {
            hashMap.put(referenceInfo.toString().toLowerCase(), referenceInfo);
        }
    }

    private String resolveRef(String string, String string2) {
        if (string2 != null && !string2.isEmpty() && this.isValidName(string2 + "." + string)) {
            return string2;
        }
        int n = 0;
        ProcedureInfo procedureInfo = null;
        for (ProcedureInfo procedureInfo2 : this._procedures) {
            if (!procedureInfo2._name.equalsIgnoreCase(string)) continue;
            ++n;
            procedureInfo = procedureInfo2;
        }
        if (n == 1 && procedureInfo != null) {
            return procedureInfo._owner;
        }
        return null;
    }

    private String addSyntaxColor(ReferenceInfo[] referenceInfoArray, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        MyLexer.ReInit(new StringReader(string));
        com.sybase.sqldoc.html.jcc.Token token = _myLexer.getNextToken();
        while (token.kind != 0) {
            if (token.kind >= 5 && token.kind <= 237) {
                stringBuilder.append(Utilities.addColor(token.image.toUpperCase(), SQLDocConstants.COLOR_KEYWORD));
            } else if (token.kind == 4 || token.kind == 3 || token.kind == 2) {
                stringBuilder.append(Utilities.addColor(token.image, SQLDocConstants.COLOR_COMMENT));
            } else if (token.kind == 253) {
                String string2 = _isSinglePage ? token.image.replaceAll("<", "&lt;") : token.image;
                string2 = string2.replaceAll(">", "&gt;");
                stringBuilder.append(Utilities.addColor(string2, SQLDocConstants.COLOR_STRING));
            } else {
                stringBuilder.append(token.image);
            }
            token = _myLexer.getNextToken();
        }
        return stringBuilder.toString();
    }

    private boolean isValidName(String string) {
        if (this._procNames == null) {
            return false;
        }
        return this._procNames.contains(string);
    }

    private boolean isBuiltInFunction(String string) {
        return this.caseInsensitiveBinarySearch(SQLDocConstants.SA10bifs, string);
    }

    private boolean caseInsensitiveBinarySearch(String[] stringArray, String string) {
        int n = 0;
        int n2 = stringArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            int n4 = stringArray[n3].compareToIgnoreCase(string);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    private void skip(int n) {
        for (int i = 0; i < n; ++i) {
            SQLLexer.getNextToken();
        }
    }

    private void log(String string) {
        if (this._reporter != null) {
            this._reporter.setStatusString(string);
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    static {
        _isSinglePage = false;
        _processComments = true;
    }

    private class ReferenceInfo {
        String _owner;
        String _name;

        ReferenceInfo(String string, String string2) {
            this._owner = string;
            this._name = string2;
        }

        ReferenceInfo() {
            this._owner = null;
            this._name = null;
        }

        public String toString() {
            return this._owner + "." + this._name;
        }
    }
}

