/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sqldoc.html;

import com.sybase.sqldoc.DocumentWriter;
import com.sybase.sqldoc.ProgressReporter;
import com.sybase.sqldoc.SQLDoc;
import com.sybase.sqldoc.SQLDocConstants;
import com.sybase.sqldoc.SQLDocException;
import com.sybase.sqldoc.SQLDocResourcesBase;
import com.sybase.util.FileUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLWriter
implements DocumentWriter {
    private boolean _isSinglePage;
    private boolean _sortByName;
    private File _dir;
    private int _status;
    private ProgressReporter _reporter;
    private XPath _xpath;
    private SQLDocResourcesBase _res;
    private TransformerFactory _transFact;
    private int _lastStatus = -1;

    public HTMLWriter(boolean bl, boolean bl2) {
        this._isSinglePage = bl;
        this._sortByName = bl2;
        this._xpath = XPathFactory.newInstance().newXPath();
        this._res = SQLDocResourcesBase.getBundle();
        this._transFact = TransformerFactory.newInstance();
    }

    @Override
    public void write(Document document, File file, ProgressReporter progressReporter, int n) throws InterruptedException, SQLDocException {
        this.checkInterrupted();
        this._status = n;
        if (null != progressReporter) {
            this._reporter = progressReporter;
        }
        this._dir = file;
        if (!file.exists()) {
            file.mkdirs();
        }
        this.log(this._res.get("MSG_WRITING_HTML_START"));
        try {
            this.writeIndex(document);
            this.writeList(document);
            this.writeDetails(document);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new SQLDocException(xPathExpressionException, true);
        }
        catch (TransformerException transformerException) {
            throw new SQLDocException(transformerException, false);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLDocException(outOfMemoryError, false);
        }
        this.log(this._res.getFormatted("MSG_WRITING_HTML_DONE", "index.html"));
        if (this._reporter != null) {
            this._reporter.done();
        }
    }

    private void updateStatus(int n) {
        if (this._reporter != null) {
            if (this._lastStatus == n) {
                return;
            }
            if (n > 99) {
                n = 99;
            }
            this._reporter.setProgress(n);
        }
    }

    private void log(String string) {
        if (null != this._reporter) {
            this._reporter.setStatusString(string);
        }
    }

    private void writeIndex(Document document) throws XPathExpressionException, InterruptedException, SQLDocException {
        this.checkInterrupted();
        this.log(this._res.getFormatted("MSG_WRITING_PAGE", "index.html"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("<html>");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("<head>");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("\t<title>");
        stringBuilder.append(this._res.get("INDEX_TITLE_TEXT"));
        Node node = (Node)this._xpath.evaluate("/SQLDOC/DBN/text()", document, XPathConstants.NODE);
        if (null != node) {
            stringBuilder.append(node.getNodeValue());
        }
        this.updateStatus(this._status++);
        stringBuilder.append("</title>");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("</head>");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("<frameset cols=\"25%,75%\">");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("\t<frame src=\"procList.html\" name=\"list\" scrolling=\"yes\">");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("\t<frame src=\"\" name=\"detail\">");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("</frameset>");
        stringBuilder.append(SQLDocConstants.NEWLINE);
        stringBuilder.append("</html>");
        this.writeToFile(stringBuilder.toString(), "index.html", false);
        this.updateStatus(this._status++);
    }

    private void writeToFile(String string, String string2, boolean bl) throws SQLDocException {
        block13: {
            BufferedWriter bufferedWriter = null;
            try {
                string2 = SQLDoc.escapeFilename(string2);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this._dir, string2)), "utf-8"));
                if (!bl) {
                    bufferedWriter.write(string);
                    break block13;
                }
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    block16: {
                        block14: {
                            block15: {
                                n2 = string.charAt(i);
                                if (n2 != 38 || i + 3 >= n) break block14;
                                if (string.charAt(i + 1) != 'l' || string.charAt(i + 2) != 't' || string.charAt(i + 3) != ';') break block15;
                                n2 = 60;
                                i += 3;
                                break block16;
                            }
                            if (string.charAt(i + 1) != 'g' || string.charAt(i + 2) != 't' || string.charAt(i + 3) != ';') break block16;
                            n2 = 62;
                            i += 3;
                            break block16;
                        }
                        if (n2 == 160) {
                            bufferedWriter.write("&nbsp;");
                            continue;
                        }
                    }
                    bufferedWriter.write(n2);
                }
            }
            catch (IOException iOException) {
                throw new SQLDocException(this._res.get("ERR_COULD_NOT_WRITE_FILE"), iOException, false);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void writeStreamToFile(InputStream inputStream, String string) throws SQLDocException {
        try {
            string = SQLDoc.escapeFilename(string);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this._dir, string));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SQLDocException(this._res.get("ERR_COULD_NOT_WRITE_FILE"), iOException, false);
        }
    }

    private void writeList(Document document) throws InterruptedException, TransformerException, SQLDocException {
        StreamSource streamSource;
        InputStream inputStream;
        this.checkInterrupted();
        this.log(this._res.getFormatted("MSG_WRITING_PAGE", "procList.html"));
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("LOCALIZE");
        Element element3 = document.createElement("HEADING");
        Element element4 = document.createElement("TRHEADING");
        Element element5 = document.createElement("EVHEADING");
        Element element6 = document.createElement("VIHEADING");
        element3.appendChild(document.createCDATASection(this._res.get("PROC_HEADING")));
        element4.appendChild(document.createCDATASection(this._res.get("TRIGGER_HEADING")));
        element5.appendChild(document.createCDATASection(this._res.get("EVENT_HEADING")));
        element6.appendChild(document.createCDATASection(this._res.get("VIEW_HEADING")));
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        element2.appendChild(element6);
        element.appendChild(element2);
        this.updateStatus(this._status++);
        if (this._isSinglePage) {
            if (this._sortByName) {
                inputStream = this.getClass().getResourceAsStream("procList_single_name.xsl");
                streamSource = new StreamSource(inputStream);
            } else {
                inputStream = this.getClass().getResourceAsStream("procList_single_schema.xsl");
                streamSource = new StreamSource(inputStream);
            }
        } else if (this._sortByName) {
            inputStream = this.getClass().getResourceAsStream("procList_mult_name.xsl");
            streamSource = new StreamSource(inputStream);
        } else {
            inputStream = this.getClass().getResourceAsStream("procList_mult_schema.xsl");
            streamSource = new StreamSource(inputStream);
        }
        this.updateStatus(this._status++);
        File file = new File(this._dir, "procList.html");
        this.applyTransform(document, streamSource, file);
        element.removeChild(element2);
        if (!this._sortByName) {
            inputStream = this.getClass().getResourceAsStream("collapse.png");
            this.writeStreamToFile(inputStream, "collapse.png");
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputStream = this.getClass().getResourceAsStream("expand.png");
            this.writeStreamToFile(inputStream, "expand.png");
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.updateStatus(this._status++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDetails(Document document) throws InterruptedException, XPathExpressionException, TransformerException, SQLDocException {
        InputStream inputStream;
        BufferedReader bufferedReader = null;
        this.checkInterrupted();
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("LOCALIZE");
        Element element3 = document.createElement("HEADING");
        Element element4 = document.createElement("USAGES");
        Element element5 = document.createElement("SOURCE");
        Element element6 = document.createElement("TRREFS");
        Element element7 = document.createElement("EVUSAGES");
        Element element8 = document.createElement("EVREFS");
        element3.appendChild(document.createCDATASection(this._res.get("REF_HEADING")));
        element4.appendChild(document.createCDATASection(this._res.get("USAGE_HEADING")));
        element5.appendChild(document.createCDATASection(this._res.get("SOURCE_HEADING")));
        element6.appendChild(document.createCDATASection(this._res.get("TRIGGER_REFS")));
        element7.appendChild(document.createCDATASection(this._res.get("EVENT_USAGES")));
        element8.appendChild(document.createCDATASection(this._res.get("EVENT_REFS")));
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        element2.appendChild(element6);
        element2.appendChild(element7);
        element2.appendChild(element8);
        element.appendChild(element2);
        if (this._isSinglePage) {
            this.log(this._res.getFormatted("MSG_WRITING_PAGE", "detail.html"));
            inputStream = this.getClass().getResourceAsStream("details_single.xsl");
            StreamSource streamSource = new StreamSource(inputStream);
            this._status += 4;
            this.updateStatus(this._status);
            File file = new File(this._dir, "detail.html");
            this.applyTransform(document, streamSource, file);
            this._status += 5;
            this.updateStatus(this._status);
        } else {
            File file;
            this.log(this._res.get("MSG_GENERATE_PROC_HTML"));
            inputStream = this.getClass().getResourceAsStream("details_mult.xsl");
            StreamSource streamSource = new StreamSource(inputStream);
            ++this._status;
            this.updateStatus(this._status);
            try {
                file = FileUtil.createSecureTempFile((String)"sqldoc", (String)"xml");
                file.deleteOnExit();
            }
            catch (IOException iOException) {
                throw new SQLDocException(iOException.getLocalizedMessage(), false);
            }
            this.applyTransform(document, streamSource, file);
            int n = 0;
            NodeList nodeList = document.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeName().equals("SQLDOC")) {
                        NodeList nodeList2 = node.getChildNodes();
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Node node2 = nodeList2.item(j);
                            String string = node2.getNodeName();
                            if (!string.equals("PROCEDURES") && !string.equals("TRIGGERS") && !string.equals("EVENTS") && !string.equals("VIEWS")) continue;
                            n += node2.getChildNodes().getLength();
                        }
                    }
                    document.removeChild(node);
                }
            }
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                MySAXHandler mySAXHandler = new MySAXHandler(n);
                sAXParser.parse(new InputSource(bufferedReader), (DefaultHandler)mySAXHandler);
            }
            catch (IOException iOException) {
                throw new SQLDocException(iOException, false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SQLDocException(parserConfigurationException, false);
            }
            catch (SAXException sAXException) {
                Throwable throwable = sAXException.getCause();
                if (throwable != null && !(throwable instanceof InterruptedException)) {
                    throw new SQLDocException(throwable, false);
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        inputStream = this.getClass().getResourceAsStream("details.css");
        this.writeStreamToFile(inputStream, "details.css");
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void applyTransform(Document document, Source source, File file) throws TransformerException {
        BufferedWriter bufferedWriter = null;
        DOMSource dOMSource = new DOMSource(document);
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            StreamResult streamResult = new StreamResult(bufferedWriter);
            Transformer transformer = this._transFact.newTransformer(source);
            transformer.transform(dOMSource, streamResult);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TransformerException(fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TransformerException(unsupportedEncodingException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    class MySAXHandler
    extends DefaultHandler {
        private StringBuilder _content = new StringBuilder();
        private String _name = null;
        private String _schema = null;
        private String _def = null;
        private int _filesProcessed;
        private int _fileCount;

        MySAXHandler(int n) {
            this._fileCount = n;
            this._filesProcessed = 0;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this._content.setLength(0);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = null;
            if (Thread.currentThread().isInterrupted()) {
                throw new SAXException(new InterruptedException());
            }
            if (string3.equals("NAME")) {
                this._name = this._content.toString();
                this._content.setLength(0);
            } else if (string3.equals("SCHEMA")) {
                this._schema = this._content.toString();
                this._content.setLength(0);
            } else if (string3.equals("DEF")) {
                int n = this._content.length();
                StringBuilder stringBuilder = new StringBuilder(n);
                for (int i = 0; i < n - 1; ++i) {
                    char c = this._content.charAt(i);
                    if (c == '\n' && this._content.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    stringBuilder.append(c);
                }
                this._def = stringBuilder.toString();
                this._content.setLength(0);
            } else if (string3.equals("PROCEDURE")) {
                string4 = SQLDoc.composeFilenameForDBObject(this._schema, this._name, null);
            } else if (string3.equals("TRIGGER")) {
                string4 = SQLDoc.composeFilenameForDBObject(this._schema, this._name, "tr");
            } else if (string3.equals("EVENT")) {
                string4 = SQLDoc.composeFilenameForDBObject(this._schema, this._name, "ev");
            } else if (string3.equals("VIEW")) {
                string4 = SQLDoc.composeFilenameForDBObject(this._schema, this._name, "vi");
            }
            if (string4 != null) {
                HTMLWriter.this.log(HTMLWriter.this._res.getFormatted("MSG_WRITING_PAGE", this._schema + "." + this._name));
                ++this._filesProcessed;
                HTMLWriter.this.updateStatus(HTMLWriter.this._status + 45 * this._filesProcessed / this._fileCount);
                try {
                    HTMLWriter.this.writeToFile(this._def, string4, true);
                }
                catch (SQLDocException sQLDocException) {
                    throw new SAXException(sQLDocException);
                }
                this._def = null;
                this._name = null;
                this._schema = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this._content.append(cArray, n, n2);
        }
    }
}

