/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.sqldoc.jcc.comment;

import com.sybase.sqldoc.SQLDocResourcesBase;
import com.sybase.sqldoc.jcc.comment.CommentTag;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Comment {
    public String text;
    public CommentTag[] tags;

    public Document getDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("COMMENT");
        Element element2 = document.createElement("TEXT");
        element.appendChild(element2);
        element2.appendChild(document.createCDATASection(this.text == null ? "" : this.text));
        if (null != this.tags) {
            Element element3 = document.createElement("TAGS");
            element.appendChild(element3);
            for (CommentTag commentTag : this.tags) {
                Element element4 = document.createElement("TAG");
                Element element5 = document.createElement("NAME");
                Element element6 = document.createElement("VALUE");
                element5.appendChild(document.createTextNode(this.getTagName(commentTag)));
                element6.appendChild(document.createCDATASection(commentTag.text));
                element4.appendChild(element5);
                element4.appendChild(element6);
                element3.appendChild(element4);
            }
        }
        document.appendChild(element);
        return document;
    }

    private String getTagName(CommentTag commentTag) {
        SQLDocResourcesBase sQLDocResourcesBase = SQLDocResourcesBase.getBundle();
        String string = commentTag.name;
        if (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        if ("@param".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("PARAMETER_TAG");
        }
        if ("@author".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("AUTHOR_TAG");
        }
        if ("@exception".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("EXCEPTION_TAG");
        }
        if ("@httpvar".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("HTTPVAR_TAG");
        }
        if ("@resultset".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("RESULTSET_TAG");
        }
        if ("@see".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("SEE_TAG");
        }
        if ("@return".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("RETURN_TAG");
        }
        if ("@version".equalsIgnoreCase(string)) {
            return sQLDocResourcesBase.get("VERSION_TAG");
        }
        return string.substring(1) + ":";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(this.text);
        stringBuffer.append(string);
        for (CommentTag commentTag : this.tags) {
            stringBuffer.append(commentTag.toString());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

