/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.storedProcedureParameterTable;

import com.sybase.storedProcedureParameterTable.StoredProcedureParameterTableMessages;
import java.awt.SystemColor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class StoredProcedureParameterTableModel
extends AbstractTableModel {
    private static final short NAME_COLUMN = 0;
    private static final short VALUE_COLUMN = 1;
    private static final short DATATYPE_COLUMN = 2;
    protected ArrayList<Parameter> _parameters;
    protected String[] _columnNames;
    protected String _procedureSchema = null;
    protected String _procedureName = null;
    ResourceBundle _bundle = null;
    private boolean _isFunction = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoredProcedureParameterTableModel(Connection connection, String string, String string2, String string3) throws SQLException {
        DatabaseMetaData databaseMetaData = null;
        ResultSet resultSet = null;
        this._bundle = StoredProcedureParameterTableMessages.getInstance();
        try {
            databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, "%");
            this._parameters = new ArrayList();
            while (resultSet.next()) {
                if (this._procedureSchema == null) {
                    this._procedureSchema = resultSet.getString(2);
                }
                if (this._procedureName == null) {
                    this._procedureName = resultSet.getString(3);
                }
                String string4 = resultSet.getString(4);
                short s = resultSet.getShort(5);
                short s2 = resultSet.getShort(6);
                String string5 = resultSet.getString(7);
                int n = resultSet.getInt(8);
                int n2 = resultSet.getInt(9);
                short s3 = resultSet.getShort(10);
                short s4 = resultSet.getShort(11);
                short s5 = resultSet.getShort(12);
                String string6 = resultSet.getString(13);
                switch (s2) {
                    case 2: 
                    case 3: {
                        string5 = string5 + "(" + n + "," + s3 + ")";
                        break;
                    }
                    case -3: 
                    case -2: 
                    case 1: 
                    case 6: 
                    case 12: {
                        string5 = string5 + "(" + n + ")";
                    }
                }
                if (s == 5) {
                    this._isFunction = true;
                }
                if (s != 1 && s != 2) continue;
                Parameter parameter = new Parameter(string4, string5, string6, s2, s5, s);
                this._parameters.add(parameter);
            }
            this._columnNames = new String[]{this._bundle.getString("1"), this._bundle.getString("2"), this._bundle.getString("3")};
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
    }

    @Override
    public int getRowCount() {
        return this._parameters.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n > this._parameters.size()) {
            throw new IllegalArgumentException("Row " + n + " is invalid. It must be between 0 and " + this._parameters.size());
        }
        Parameter parameter = this._parameters.get(n);
        String string = n2 == 0 ? parameter.name : (n2 == 1 ? parameter.value : (n2 == 2 ? parameter.typeName : null));
        return string;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n > this._parameters.size()) {
            throw new IllegalArgumentException("Row " + n + " is invalid. It must be between 0 and " + this._parameters.size());
        }
        if (n2 != 1) {
            throw new IllegalArgumentException("Column " + n2 + " is invalid. It must be " + 1);
        }
        Parameter parameter = this._parameters.get(n);
        parameter.value = object == null ? null : object.toString();
    }

    String getToolTipText(int n) {
        StringBuffer stringBuffer = new StringBuffer(256);
        Parameter parameter = this._parameters.get(n);
        stringBuffer.append("<html><body>");
        stringBuffer.append("<table border=0 cellspacing=0 cellpadding=1>");
        stringBuffer.append("<tr>");
        stringBuffer.append("<td colspan=3 align=center nowrap bgcolor=#");
        stringBuffer.append(Integer.toHexString(SystemColor.activeCaption.getRGB() & 0xFFFFFF));
        stringBuffer.append("><font color=#");
        stringBuffer.append(Integer.toHexString(SystemColor.activeCaptionText.getRGB() & 0xFFFFFF));
        stringBuffer.append("><b>");
        stringBuffer.append(StoredProcedureParameterTableModel.escapeForHTML(parameter.name));
        stringBuffer.append("</b></font></td></tr>");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (parameter.parmType != 0) {
            arrayList.add(this._bundle.getString("4"));
            switch (parameter.parmType) {
                case 1: {
                    arrayList.add(this._bundle.getString("5"));
                    break;
                }
                case 2: {
                    arrayList.add(this._bundle.getString("6"));
                    break;
                }
                case 4: {
                    arrayList.add(this._bundle.getString("7"));
                    break;
                }
                case 5: {
                    arrayList.add(this._bundle.getString("8"));
                    break;
                }
                case 3: {
                    arrayList.add(this._bundle.getString("9"));
                }
            }
        }
        arrayList.add(this._bundle.getString("10"));
        arrayList.add(StoredProcedureParameterTableModel.escapeForHTML(parameter.typeName));
        if (parameter.comment != null && parameter.comment.length() > 0) {
            arrayList.add(this._bundle.getString("11"));
            arrayList.add(StoredProcedureParameterTableModel.escapeForHTML(parameter.comment));
        }
        if (parameter.nullable != 2) {
            arrayList.add(this._bundle.getString("12"));
            if (parameter.nullable == 0) {
                arrayList.add(this._bundle.getString("14"));
            } else {
                arrayList.add(this._bundle.getString("13"));
            }
        }
        int n2 = arrayList.size();
        for (int i = 0; i < n2; i += 2) {
            stringBuffer.append("<tr><td nowrap><b>");
            stringBuffer.append(((String)arrayList.get(i)).toString());
            stringBuffer.append("</b></td><td nowrap width=5>&nbsp;</td><td nowrap>");
            stringBuffer.append(((String)arrayList.get(i + 1)).toString());
            stringBuffer.append("</td></tr>");
        }
        stringBuffer.append("</table>");
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    private static String escapeForHTML(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 50);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    short getSQLType(int n) {
        if (n > this._parameters.size()) {
            throw new IllegalArgumentException("Row " + n + " is invalid. It must be between 0 and " + this._parameters.size());
        }
        Parameter parameter = this._parameters.get(n);
        return parameter.sqlType;
    }

    String getSQLStatement() {
        if (this._isFunction) {
            return this.getSelectStatement();
        }
        return this.getCallStatement();
    }

    private String getCallStatement() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("CALL ");
        if (this._procedureSchema != null && !this._procedureSchema.isEmpty()) {
            stringBuilder.append(this.quoteIdentifier(this._procedureSchema));
            stringBuilder.append('.');
        }
        stringBuilder.append(this.quoteIdentifier(this._procedureName));
        stringBuilder.append('(');
        int n = this._parameters.size();
        for (int i = 0; i < n; ++i) {
            Parameter parameter = this._parameters.get(i);
            if (i > 0 && stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '(') {
                stringBuilder.append(",");
            }
            if (parameter.value == null) {
                stringBuilder.append(this.quoteIdentifier(parameter.name)).append(" = ").append("null");
                continue;
            }
            if (parameter.value.equals(this._bundle.getString("15"))) continue;
            if (parameter.sqlType == 91 || parameter.sqlType == 92 || parameter.sqlType == 93 || parameter.sqlType == -1 || parameter.sqlType == 12 || parameter.sqlType == 1) {
                stringBuilder.append(this.quoteIdentifier(parameter.name)).append(" = ").append(this.quoteData(parameter.value));
                continue;
            }
            stringBuilder.append(this.quoteIdentifier(parameter.name)).append(" = ").append(parameter.value);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String getSelectStatement() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("SELECT ");
        if (this._procedureSchema != null && !this._procedureSchema.isEmpty()) {
            stringBuilder.append(this.quoteIdentifier(this._procedureSchema));
            stringBuilder.append('.');
        }
        stringBuilder.append(this.quoteIdentifier(this._procedureName));
        stringBuilder.append('(');
        int n = this._parameters.size();
        for (int i = 0; i < n; ++i) {
            Parameter parameter = this._parameters.get(i);
            if (i > 0 && stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '(') {
                stringBuilder.append(",");
            }
            if (parameter.value == null) {
                stringBuilder.append("null");
                continue;
            }
            if (parameter.value.equals(this._bundle.getString("15"))) continue;
            if (parameter.sqlType == 91 || parameter.sqlType == 92 || parameter.sqlType == 93 || parameter.sqlType == -1 || parameter.sqlType == 12 || parameter.sqlType == 1) {
                stringBuilder.append(this.quoteData(parameter.value));
                continue;
            }
            stringBuilder.append(parameter.value);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String quoteIdentifier(String string) {
        return this.quote(string, '\"');
    }

    private String quoteData(String string) {
        return this.quote(string, '\'');
    }

    private String quote(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 8);
        stringBuilder.append(c);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    static class Parameter {
        String name;
        String value;
        String typeName;
        String comment;
        short sqlType;
        short nullable;
        short parmType;

        Parameter(String string, String string2, String string3, short s, short s2, short s3) {
            this.name = string;
            this.value = null;
            this.typeName = string2;
            this.comment = string3;
            this.sqlType = s;
            this.parmType = s3;
        }
    }
}

