/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.treeTable;

import com.sybase.treeTable.AbstractCellEditor;
import com.sybase.treeTable.JTreeTableNode;
import com.sybase.treeTable.TreeTableCellTextChangeEvent;
import com.sybase.treeTable.TreeTableCellTextChangeListener;
import com.sybase.treeTable.TreeTableEditorEvent;
import com.sybase.treeTable.TreeTableEditorListener;
import com.sybase.treeTable.TreeTableModel;
import com.sybase.treeTable.TreeTableModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    protected TreeTableModel _treeTableModel;
    private Vector<TreeTableCellTextChangeListener> _treeTableCellTextChangeListeners = new Vector();
    private Vector<TreeTableEditorListener> _treeTableEditorListeners = new Vector();
    private String[] _columnNameCache = null;
    private Integer[] _columnWidthsCache = null;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.setTreeTableModel(treeTableModel);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(this.getRowHeight());
    }

    public void addTreeTableCellTextChangeListener(TreeTableCellTextChangeListener treeTableCellTextChangeListener) {
        this._treeTableCellTextChangeListeners.add(treeTableCellTextChangeListener);
    }

    public void removeTreeTableCellTextChangeListener(TreeTableCellTextChangeListener treeTableCellTextChangeListener) {
        this._treeTableCellTextChangeListeners.remove(treeTableCellTextChangeListener);
    }

    protected void fireTreeTableCellTextChanged(int n, int n2, Object object) {
        TreeTableCellTextChangeEvent treeTableCellTextChangeEvent = new TreeTableCellTextChangeEvent(this, n, n2, object);
        int n3 = this._treeTableCellTextChangeListeners.size();
        for (int i = 0; i < n3; ++i) {
            this._treeTableCellTextChangeListeners.get(i).valueChanged(treeTableCellTextChangeEvent);
        }
    }

    public void addTreeTableEditorListener(TreeTableEditorListener treeTableEditorListener) {
        this._treeTableEditorListeners.add(treeTableEditorListener);
    }

    public void removeTreeTableEditorListener(TreeTableEditorListener treeTableEditorListener) {
        this._treeTableEditorListeners.remove(treeTableEditorListener);
    }

    protected void fireTreeTableEditingStopped(int n, int n2, Object object) {
        TreeTableCellTextChangeEvent treeTableCellTextChangeEvent = new TreeTableCellTextChangeEvent(this, n, n2, object);
        int n3 = this._treeTableEditorListeners.size();
        for (int i = 0; i < n3; ++i) {
            this._treeTableEditorListeners.get(i).editingStopped(treeTableCellTextChangeEvent);
        }
    }

    protected void fireTreeTableEditingCanceled(int n, int n2) {
        TreeTableEditorEvent treeTableEditorEvent = new TreeTableEditorEvent(this, n, n2);
        int n3 = this._treeTableEditorListeners.size();
        for (int i = 0; i < n3; ++i) {
            this._treeTableEditorListeners.get(i).editingCanceled(treeTableEditorEvent);
        }
    }

    public void releaseResources() {
        this._treeTableCellTextChangeListeners.clear();
        this._treeTableCellTextChangeListeners = null;
        this._treeTableEditorListeners.clear();
        this._treeTableEditorListeners = null;
        this._columnNameCache = null;
        this._columnWidthsCache = null;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreeTableModel getTreeTableModel() {
        return this._treeTableModel;
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        this._treeTableModel = treeTableModel;
        this.tree = new TreeTableCellRenderer(this._treeTableModel);
        this.tree.setCellRenderer(new MyRenderer());
        super.setModel(new TreeTableModelAdapter(this._treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
    }

    public void saveColumnWidths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this._treeTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            arrayList.add(tableColumn.getHeaderValue().toString());
            arrayList2.add(tableColumn.getPreferredWidth());
        }
        this._columnNameCache = arrayList.toArray(new String[arrayList.size()]);
        this._columnWidthsCache = arrayList2.toArray(new Integer[arrayList2.size()]);
    }

    public boolean restoreColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this._treeTableModel.getColumnCount();
        if (this._columnNameCache != null && n == this._columnNameCache.length) {
            TableColumn tableColumn;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                tableColumn = tableColumnModel.getColumn(n2);
                if (tableColumn.getHeaderValue().toString().equals(this._columnNameCache[n2])) continue;
                this._columnNameCache = null;
                this._columnWidthsCache = null;
            }
            for (n2 = 0; n2 < n; ++n2) {
                tableColumn = tableColumnModel.getColumn(n2);
                tableColumn.setPreferredWidth(this._columnWidthsCache[n2]);
            }
            return true;
        }
        this._columnNameCache = null;
        this._columnWidthsCache = null;
        return false;
    }

    public void setInitialColumnWidths() {
        if (!this.restoreColumnWidths()) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = this._treeTableModel.getColumnCount();
            int n2 = this.getPreferredScrollableViewportSize().height;
            int n3 = n2 / this.getRowHeight();
            int n4 = this.getRowCount();
            int n5 = Math.min(n4, n3);
            if (n5 < 10 && n4 >= 10) {
                n5 = 10;
            }
            for (int i = 0; i < n; ++i) {
                Object object;
                TableCellRenderer tableCellRenderer;
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                int n6 = 0;
                JTableHeader jTableHeader = this.getTableHeader();
                if (jTableHeader != null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                    object = tableColumn.getHeaderValue();
                    if (object != null) {
                        n6 = tableCellRenderer.getTableCellRendererComponent(null, (Object)object, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                    }
                }
                for (int j = 0; j < n5; ++j) {
                    tableCellRenderer = this.getCellRenderer(j, i);
                    object = this.getModel().getValueAt(j, i);
                    if (object == null && j >= (n5 = Math.min(this.getRowCount(), 10))) break;
                    int n7 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                    n6 = Math.max(n6, n7);
                }
                tableColumn.setPreferredWidth(n6 + 2);
            }
        }
        this.doLayout();
    }

    static class MyRenderer
    extends DefaultTreeCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof JTreeTableNode) {
                this.setIcon(((JTreeTableNode)object).getIcon());
            }
            return this;
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JTreeTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int i = JTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                    if (JTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this;
        }
    }
}

