/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.treeTable;

import com.sybase.treeTable.JTreeTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class TreeTableCellTextEditor
extends AbstractCellEditor
implements TableCellEditor,
DocumentListener {
    private Object _data = null;
    private int _editingRow;
    private int _editingColumn;
    private JTreeTable _treeTable;
    private JTextField _textField;
    private static final String EMPTY_STRING = "";

    public TreeTableCellTextEditor(JTreeTable jTreeTable) {
        this._treeTable = jTreeTable;
        this._textField = new JTextField();
        this._textField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this._textField.getForeground(), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this._textField.getDocument().addDocumentListener(this);
    }

    private void handleDocumentEvent() {
        this._data = this._textField.getText();
        this._treeTable.fireTreeTableCellTextChanged(this._editingRow, this._editingColumn, this._data);
    }

    public void releaseResources() {
        this._textField.getDocument().removeDocumentListener(this);
        this._treeTable = null;
        this._textField = null;
    }

    private void listenToEvents(boolean bl) {
        if (bl) {
            this._textField.getDocument().addDocumentListener(this);
            InputMap inputMap = this._textField.getInputMap(0);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            inputMap.put(keyStroke, "stopEditing");
            keyStroke = KeyStroke.getKeyStroke(27, 0);
            inputMap.put(keyStroke, "cancelEditing");
            ActionMap actionMap = this._textField.getActionMap();
            actionMap.put("stopEditing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableCellTextEditor.this.stopCellEditing();
                }
            });
            actionMap.put("cancelEditing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableCellTextEditor.this.cancelCellEditing();
                }
            });
        } else {
            this._textField.getDocument().removeDocumentListener(this);
            InputMap inputMap = this._textField.getInputMap(0);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            inputMap.remove(keyStroke);
            keyStroke = KeyStroke.getKeyStroke(27, 0);
            inputMap.remove(keyStroke);
            ActionMap actionMap = this._textField.getActionMap();
            actionMap.remove("stopEditing");
            actionMap.remove("cancelEditing");
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this._data = object;
        this._editingRow = n;
        this._editingColumn = n2;
        this.listenToEvents(false);
        if (this._data == null) {
            this._textField.setText(EMPTY_STRING);
        } else {
            this._textField.setText(this._data.toString());
        }
        this.listenToEvents(true);
        return this._textField;
    }

    @Override
    public Object getCellEditorValue() {
        return this._data;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this._treeTable.fireTreeTableEditingCanceled(this._editingRow, this._editingColumn);
    }

    @Override
    public boolean stopCellEditing() {
        boolean bl = super.stopCellEditing();
        if (bl) {
            this._data = this._textField.getText();
            this._treeTable.fireTreeTableEditingStopped(this._editingRow, this._editingColumn, this._data);
        }
        return bl;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent();
    }
}

