/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.updateService;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.ianywhere.updates.UpdateHelper;
import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.customization.CustomizerHost;
import com.sybase.util.DialogUtils;
import com.sybase.util.FileLocator;
import com.sybase.util.HTMLWindow;
import com.sybase.util.SybButton;
import com.sybase.util.UIUtils;
import ianywhere.updateService.UpdateServiceClientCustomizationPage;
import ianywhere.updateService.UpdateServiceClientEvent;
import ianywhere.updateService.UpdateServiceClientListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class UpdateServiceClient {
    public static final int UPDATES = 0;
    public static final int NO_UPDATES = 1;
    public static final int CANCELLED = 2;
    public static final int ERROR = 3;
    static final int ON_STARTUP = 0;
    static final int DAILY = 1;
    static final int WEEKLY = 2;
    static final int MONTHLY = 3;
    static final int NEVER = 4;
    private static CustomizableUpdateServiceClient _customizableUpdateServiceClient;
    private boolean _busy = false;
    private boolean _keepChecking = true;
    private JComponent _updateComponent;
    private CheckForUpdatesDialog _checkForUpdatesDialog;
    private EventListenerList _listenerList = new EventListenerList();
    private Preferences _preferences;
    private static String _preferenceID;
    private boolean _nogui;
    static String _helpFolder;
    static String _helpPrefix;
    static String _helpSuffix;
    static final String LAST_CHECK_DATE = "lastCheckDate";
    static final String FREQUENCY = "frequency";
    static final String EXPRESS_BUG_FIX = "expressBugFix";
    static final String VERIFIED_BUG_FIX = "verifiedBugFix";
    static final String MAINTENANCE_RELEASE = "maintenanceRelease";
    static final String INFORMATION = "information";
    static final String THERE_ARE_NO_UPDATES_AVAILABLE_AT_THIS_TIME = "THERE_ARE_NO_UPDATES_AVAILABLE_AT_THIS_TIME";
    static final String UNABLE_TO_CONTACT_UPDATE_SERVER_QUITING = "UNABLE_TO_CONTACT_UPDATE_SERVER_QUITING";
    static final String CHECKING_FOR_UPDATES_TITLE = "CHECKING_FOR_UPDATES_TITLE";
    static final String CHECKING_FOR_UPDATES = "CHECKING_FOR_UPDATES";
    static final String CONTACTING_SERVER = "CONTACTING_SERVER";
    static final String CHECKING_FOR_LATEST_VERSIONS = "CHECKING_FOR_LATEST_VERSIONS";
    static final String ERROR_MALFORMED_URL = "ERROR_MALFORMED_URL";
    static final String ERROR_COULD_NOT_ESTABLISH_CONNECTION = "ERROR_COULD_NOT_ESTABLISH_CONNECTION";
    static final String FETCHING_UPDATE_MESSAGE = "FETCHING_UPDATE_MESSAGE";
    static final String BROWSER_TITLE = "BROWSER_TITLE";
    static final String CANCEL_BUTTON = "CANCEL_BUTTON";
    static final String OK_BUTTON = "OK_BUTTON";
    static final String DETAILS_LABEL = "DETAILS_LABEL";
    static final String CUSTOMIZER_TITLE = "CUSTOMIZER_TITLE";
    static final String CUSTOMIZER_WHEN_TO_CHECK = "CUSTOMIZER_WHEN_TO_CHECK";
    static final String CUSTOMIZER_ON_APPLICATION_STARTUP = "CUSTOMIZER_ON_APPLICATION_STARTUP";
    static final String CUSTOMIZER_DAILY = "CUSTOMIZER_DAILY";
    static final String CUSTOMIZER_WEEKLY = "CUSTOMIZER_WEEKLY";
    static final String CUSTOMIZER_MONTHLY = "CUSTOMIZER_MONTHLY";
    static final String CUSTOMIZER_NEVER = "CUSTOMIZER_NEVER";
    static final String CUSTOMIZER_WHAT_TO_CHECK_FOR = "CUSTOMIZER_WHAT_TO_CHECK_FOR";
    static final String CUSTOMIZER_EXPRESS_BUG_FIX = "CUSTOMIZER_EXPRESS_BUG_FIX";
    static final String CUSTOMIZER_VERIFIED_BUG_FIX = "CUSTOMIZER_VERIFIED_BUG_FIX";
    static final String CUSTOMIZER_MAINTENANCE_RELEASE = "CUSTOMIZER_MAINTENANCE_RELEASE";
    static final String CUSTOMIZER_OTHER_INFORMATION = "CUSTOMIZER_OTHER_INFORMATION";

    public UpdateServiceClient(String string, boolean bl) {
        this._nogui = bl;
        String string2 = string.replace(' ', '_').replace('.', '_');
        this._preferences = Preferences.userRoot().node(_preferenceID + "/" + string2);
    }

    public boolean isBusy() {
        return this._busy;
    }

    public boolean isShowingDialog() {
        return this._checkForUpdatesDialog != null && this._checkForUpdatesDialog.isVisible();
    }

    public void cancelCheckForUpdates() {
        this._keepChecking = false;
    }

    public JComponent getCheckForUpdatesComponent() {
        if (this._updateComponent == null) {
            this._updateComponent = new UpdateComponent();
        }
        return this._updateComponent;
    }

    public void showCheckForUpdatesDialog(Frame frame) {
        this._checkForUpdatesDialog = new CheckForUpdatesDialog(frame);
        UIUtils.ensureWindowIsVisible((Window)this._checkForUpdatesDialog);
        this._checkForUpdatesDialog.setVisible(true);
        this.checkForUpdates(true);
    }

    public void showCheckForUpdatesDialog(Dialog dialog) {
        this._checkForUpdatesDialog = new CheckForUpdatesDialog(dialog);
        UIUtils.ensureWindowIsVisible((Window)this._checkForUpdatesDialog);
        this._checkForUpdatesDialog.setVisible(true);
        this.checkForUpdates(true);
    }

    public void addUpdateServiceClientListener(UpdateServiceClientListener updateServiceClientListener) {
        this._listenerList.add(UpdateServiceClientListener.class, updateServiceClientListener);
    }

    public void removeUpdateServiceClientListener(UpdateServiceClientListener updateServiceClientListener) {
        this._listenerList.remove(UpdateServiceClientListener.class, updateServiceClientListener);
    }

    public String getUpdateURL() {
        String string = UpdateHelper.getUpdatesURL((boolean)this._preferences.getBoolean(MAINTENANCE_RELEASE, true), (boolean)this._preferences.getBoolean(INFORMATION, true), (boolean)this._preferences.getBoolean(EXPRESS_BUG_FIX, true));
        return string;
    }

    void fireCheckForUpdatesComplete(Object object, int n) {
        this._busy = false;
        if (n == 0 || n == 1) {
            this._preferences.putLong(LAST_CHECK_DATE, System.currentTimeMillis());
            try {
                this._preferences.flush();
                this._preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        if (!this._nogui) {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    ((UpdateComponent)this._updateComponent).getProgressBar().setIndeterminate(false);
                    ((UpdateComponent)this._updateComponent).getProgressBar().setValue(100);
                    ((UpdateComponent)this._updateComponent).getDetailsLabel().setText(UpdateServiceClient.getI18NMessage(THERE_ARE_NO_UPDATES_AVAILABLE_AT_THIS_TIME));
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    ((UpdateComponent)this._updateComponent).getProgressBar().setIndeterminate(false);
                    ((UpdateComponent)this._updateComponent).getProgressBar().setValue(100);
                    ((UpdateComponent)this._updateComponent).getDetailsLabel().setText(UpdateServiceClient.getI18NMessage(UNABLE_TO_CONTACT_UPDATE_SERVER_QUITING));
                    break;
                }
            }
        }
        Object[] objectArray = this._listenerList.getListenerList();
        UpdateServiceClientEvent updateServiceClientEvent = new UpdateServiceClientEvent(object, n);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UpdateServiceClientListener.class) continue;
            ((UpdateServiceClientListener)objectArray[i + 1]).checkForUpdatesComplete(updateServiceClientEvent);
        }
    }

    public void checkForUpdates() {
        this.checkForUpdates(false);
    }

    public void checkForUpdates(boolean bl) {
        UpdateChecker updateChecker = new UpdateChecker(bl);
        updateChecker.start();
    }

    public void destroy() {
    }

    public static Customizable getCustomizable(String string) {
        if (_customizableUpdateServiceClient == null) {
            _customizableUpdateServiceClient = new CustomizableUpdateServiceClient(string);
        }
        return _customizableUpdateServiceClient;
    }

    private static ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("language", System.getProperty("user.language", null));
        String string2 = System.getProperty("country", System.getProperty("user.region", null));
        if (string != null && string2 != null) {
            try {
                resourceBundle = ResourceBundle.getBundle("ianywhere.updateService.UpdateServiceClientResourceBundle", new Locale(string, string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("ianywhere.updateService.UpdateServiceClientResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("ianywhere.updateService.UpdateServiceClientResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name ianywhere.updateService.UpdateServiceClientResourceBundle", "", "");
        }
        return resourceBundle;
    }

    static final String getI18NMessage(String string) {
        String string2 = "";
        try {
            string2 = (String)UpdateServiceClient.getResourceBundle().getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            ExceptionHandler.handleException((Throwable)missingResourceException);
        }
        return string2;
    }

    public static void setHelpFolder(String string, String string2, String string3) {
        _helpFolder = string;
        _helpPrefix = string2;
        _helpSuffix = string3;
    }

    static {
        _preferenceID = "ianywhere/updateService/11";
    }

    private static class UpdateComponent
    extends JPanel {
        private JProgressBar _progress = new JProgressBar();
        private JLabel _headerLabel;
        private JLabel _detailsLabel;

        UpdateComponent() {
            super(new GridBagLayout());
            this._progress.setStringPainted(true);
            this._progress.setString(UpdateServiceClient.getI18NMessage(UpdateServiceClient.CONTACTING_SERVER));
            this._progress.setValue(1);
            this._progress.setIndeterminate(true);
            this._headerLabel = new JLabel(UpdateServiceClient.getI18NMessage(UpdateServiceClient.CHECKING_FOR_UPDATES));
            this._detailsLabel = new JLabel(" ");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(UpdateServiceClient.getI18NMessage(UpdateServiceClient.DETAILS_LABEL)));
            jPanel.add((Component)this._detailsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._headerLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this._progress, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 0, 5), 0, 0));
        }

        JProgressBar getProgressBar() {
            return this._progress;
        }

        JLabel getHeaderLabel() {
            return this._headerLabel;
        }

        JLabel getDetailsLabel() {
            return this._detailsLabel;
        }
    }

    private class CheckForUpdatesDialog
    extends JDialog
    implements ActionListener,
    UpdateServiceClientListener {
        private JButton _cancelButton;

        CheckForUpdatesDialog(Frame frame) {
            super(frame, false);
            this.init(frame);
        }

        CheckForUpdatesDialog(Dialog dialog) {
            super(dialog, false);
            this.init(dialog);
        }

        private void init(Window window) {
            UpdateServiceClient.this.addUpdateServiceClientListener(this);
            this.setDefaultCloseOperation(1);
            JComponent jComponent = UpdateServiceClient.this.getCheckForUpdatesComponent();
            this._cancelButton = new SybButton(UpdateServiceClient.getI18NMessage(UpdateServiceClient.CANCEL_BUTTON));
            this._cancelButton.addActionListener(this);
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CheckForUpdatesDialog.this.setVisible(false);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            InputMap inputMap = this._cancelButton.getInputMap(2);
            ActionMap actionMap = this._cancelButton.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(keyStroke, "cancel");
                actionMap.put("cancel", abstractAction);
            }
            this.setTitle(UpdateServiceClient.getI18NMessage(UpdateServiceClient.CHECKING_FOR_UPDATES_TITLE));
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add(Box.createHorizontalStrut(400), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add((Component)this._cancelButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.getContentPane().add(jPanel);
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(window);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._cancelButton) {
                UpdateServiceClient.this.cancelCheckForUpdates();
                this.setVisible(false);
            }
        }

        @Override
        public void checkForUpdatesComplete(UpdateServiceClientEvent updateServiceClientEvent) {
            int n = updateServiceClientEvent.getStatus();
            if (n == 0 || n == 2) {
                this.setVisible(false);
            } else if (n == 1 || n == 3) {
                this._cancelButton.setText(UpdateServiceClient.getI18NMessage(UpdateServiceClient.OK_BUTTON));
            }
        }

        void destroy() {
            UpdateServiceClient.this.removeUpdateServiceClientListener(this);
            this._cancelButton.removeActionListener(this);
            DialogUtils.removeComponents((Container)this);
        }
    }

    private class UpdateChecker
    extends Thread {
        boolean _checkNow = false;

        UpdateChecker(boolean bl) {
            this.setPriority(1);
            this._checkNow = bl;
        }

        @Override
        public void run() {
            block36: {
                String string;
                String string2;
                Object object;
                Object object2;
                block38: {
                    boolean bl;
                    File file;
                    if (!UpdateServiceClient.this._nogui && UpdateServiceClient.this._updateComponent == null) {
                        UpdateServiceClient.this._updateComponent = new UpdateComponent();
                    }
                    if (!this._checkNow) {
                        int n = UpdateServiceClient.this._preferences.getInt(UpdateServiceClient.FREQUENCY, 4);
                        long l = UpdateServiceClient.this._preferences.getLong(UpdateServiceClient.LAST_CHECK_DATE, 0L);
                        object2 = new GregorianCalendar();
                        ((Calendar)object2).setTime(new Date(l));
                        object = new GregorianCalendar();
                        switch (n) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                if (((Calendar)object2).get(1) != ((Calendar)object).get(1) || ((Calendar)object2).get(1) == ((Calendar)object).get(1) && ((Calendar)object2).get(6) != ((Calendar)object).get(6)) break;
                                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 1);
                                return;
                            }
                            case 2: {
                                if (((Calendar)object2).get(1) != ((Calendar)object).get(1) || ((Calendar)object2).get(1) == ((Calendar)object).get(1) && ((Calendar)object2).get(3) != ((Calendar)object).get(3)) break;
                                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 1);
                                return;
                            }
                            case 3: {
                                if (((Calendar)object2).get(1) != ((Calendar)object).get(1) || ((Calendar)object2).get(1) == ((Calendar)object).get(1) && ((Calendar)object2).get(2) != ((Calendar)object).get(2)) break;
                                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 1);
                                return;
                            }
                            case 4: {
                                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 1);
                                return;
                            }
                        }
                    }
                    UpdateServiceClient.this._busy = true;
                    UpdateServiceClient.this._keepChecking = true;
                    if (!UpdateServiceClient.this._nogui) {
                        ((UpdateComponent)UpdateServiceClient.this._updateComponent).getHeaderLabel().setText(UpdateServiceClient.getI18NMessage(UpdateServiceClient.CHECKING_FOR_UPDATES));
                        ((UpdateComponent)UpdateServiceClient.this._updateComponent).getProgressBar().setStringPainted(false);
                        ((UpdateComponent)UpdateServiceClient.this._updateComponent).getDetailsLabel().setText(UpdateServiceClient.getI18NMessage(UpdateServiceClient.CONTACTING_SERVER));
                        ((UpdateComponent)UpdateServiceClient.this._updateComponent).getProgressBar().setValue(1);
                        ((UpdateComponent)UpdateServiceClient.this._updateComponent).getProgressBar().setIndeterminate(true);
                    }
                    if (!UpdateServiceClient.this._keepChecking) break block36;
                    string2 = null;
                    string = null;
                    if (!UpdateHelper.isInstalled()) break block38;
                    if (!FileLocator.isInstalled() || (file = FileLocator.find((String)"installed.ini")) == null || !(bl = UpdateHelper.init((String)file.getParent()))) break block36;
                    string2 = UpdateHelper.getUpdatesURL((boolean)UpdateServiceClient.this._preferences.getBoolean(UpdateServiceClient.MAINTENANCE_RELEASE, true), (boolean)UpdateServiceClient.this._preferences.getBoolean(UpdateServiceClient.INFORMATION, true), (boolean)UpdateServiceClient.this._preferences.getBoolean(UpdateServiceClient.EXPRESS_BUG_FIX, true));
                    string = UpdateHelper.getHasUpdatesURL((boolean)UpdateServiceClient.this._preferences.getBoolean(UpdateServiceClient.MAINTENANCE_RELEASE, true), (boolean)UpdateServiceClient.this._preferences.getBoolean(UpdateServiceClient.INFORMATION, true), (boolean)UpdateServiceClient.this._preferences.getBoolean(UpdateServiceClient.EXPRESS_BUG_FIX, true));
                }
                if (string2 == null) {
                    string2 = UpdateServiceClient.this.getUpdateURL();
                    string = string2 + "&confirm=true";
                }
                if (UpdateServiceClient.this._keepChecking) {
                    boolean bl = false;
                    if (!UpdateServiceClient.this._nogui) {
                        ((UpdateComponent)UpdateServiceClient.this._updateComponent).getProgressBar().setValue(25);
                        ((UpdateComponent)UpdateServiceClient.this._updateComponent).getDetailsLabel().setText(UpdateServiceClient.getI18NMessage(UpdateServiceClient.CHECKING_FOR_LATEST_VERSIONS));
                    }
                    if (UpdateServiceClient.this._keepChecking) {
                        String string3;
                        BufferedReader bufferedReader;
                        InputStream inputStream;
                        block37: {
                            try {
                                object2 = new URL(string);
                                object = ((URL)object2).openConnection();
                                ((URLConnection)object).setDoInput(true);
                                ((URLConnection)object).setDoOutput(true);
                                ((URLConnection)object).setUseCaches(false);
                                inputStream = ((URLConnection)object).getInputStream();
                                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                                string3 = bufferedReader.readLine();
                                if (string3 == null) {
                                    UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 3);
                                    break block36;
                                }
                                if (string3.equals("hasMessages")) {
                                    bl = true;
                                }
                                bufferedReader.close();
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (UpdateServiceClient.this._nogui) {
                                    System.err.println(UpdateServiceClient.getI18NMessage(UpdateServiceClient.ERROR_MALFORMED_URL) + string2);
                                }
                                if (UpdateServiceClient.this._nogui) break block37;
                                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 3);
                                break block36;
                            }
                            catch (IOException iOException) {
                                if (UpdateServiceClient.this._nogui) {
                                    System.err.println(UpdateServiceClient.getI18NMessage(UpdateServiceClient.ERROR_COULD_NOT_ESTABLISH_CONNECTION) + string2);
                                }
                                if (UpdateServiceClient.this._nogui) break block37;
                                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 3);
                                break block36;
                            }
                        }
                        if (UpdateServiceClient.this._keepChecking) {
                            if (bl) {
                                if (UpdateServiceClient.this._nogui) {
                                    try {
                                        object2 = new URL(string2);
                                        object = ((URL)object2).openConnection();
                                        ((URLConnection)object).setDoInput(true);
                                        ((URLConnection)object).setDoOutput(true);
                                        ((URLConnection)object).setUseCaches(false);
                                        ((URLConnection)object).setRequestProperty("Content-Type", "plain/text");
                                        inputStream = ((URLConnection)object).getInputStream();
                                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                                        System.out.println();
                                        while ((string3 = bufferedReader.readLine()) != null) {
                                            System.out.println(string3);
                                        }
                                        bufferedReader.close();
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        System.err.println(UpdateServiceClient.getI18NMessage(UpdateServiceClient.ERROR_MALFORMED_URL) + string2);
                                        System.exit(-1);
                                    }
                                    catch (IOException iOException) {
                                        System.err.println(UpdateServiceClient.getI18NMessage(UpdateServiceClient.ERROR_COULD_NOT_ESTABLISH_CONNECTION) + string2);
                                        System.exit(-1);
                                    }
                                    UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 0);
                                } else {
                                    ((UpdateComponent)UpdateServiceClient.this._updateComponent).getProgressBar().setValue(50);
                                    ((UpdateComponent)UpdateServiceClient.this._updateComponent).getDetailsLabel().setText(UpdateServiceClient.getI18NMessage(UpdateServiceClient.FETCHING_UPDATE_MESSAGE));
                                    ((UpdateComponent)UpdateServiceClient.this._updateComponent).getProgressBar().setIndeterminate(false);
                                    ((UpdateComponent)UpdateServiceClient.this._updateComponent).getProgressBar().setValue(100);
                                    if (!HTMLWindow.isBrowserSupported() && string2.indexOf(63) > -1) {
                                        object2 = Locale.getDefault().getLanguage();
                                        string2 = string2 + "&Accept-Language=" + (String)object2 + "&User-Agent=SC500";
                                        if (((String)object2).equals("ja")) {
                                            string2 = string2 + "&Accept-Charset=Shift_JIS";
                                        }
                                    }
                                    HTMLWindow.open((String)string2, (String)UpdateServiceClient.getI18NMessage(UpdateServiceClient.BROWSER_TITLE), null, (int)400, (int)400);
                                    UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 0);
                                }
                            } else if (!UpdateServiceClient.this._nogui) {
                                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 1);
                            }
                        }
                    }
                }
            }
            UpdateServiceClient.this._busy = false;
            if (!UpdateServiceClient.this._keepChecking) {
                UpdateServiceClient.this.fireCheckForUpdatesComplete(UpdateServiceClient.this, 2);
            }
        }
    }

    static class CustomizableUpdateServiceClient
    implements Customizable {
        private static String _applicationKey;
        private static Preferences _preferences;
        private static byte[] _preferenceBackup;

        CustomizableUpdateServiceClient(String string) {
            _applicationKey = string;
            _preferences = Preferences.userRoot().node(_preferenceID + "/" + string.replace(' ', '_').replace('.', '_'));
            this.backupPreferences();
        }

        private void backupPreferences() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                _preferences.exportNode(byteArrayOutputStream);
                _preferenceBackup = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Throwable)iOException);
            }
            catch (BackingStoreException backingStoreException) {
                ExceptionHandler.handleException((Throwable)backingStoreException);
            }
        }

        protected Preferences getPreferences() {
            return _preferences;
        }

        public CustomizationPage[] getCustomizationPages() {
            return new CustomizationPage[]{new UpdateServiceClientCustomizationPage(this)};
        }

        public Icon getCustomizationGroupIcon() {
            return ASAComponentsImageLoader.getImageIcon("update_service", 1001);
        }

        public String getCustomizationGroupTitle() {
            return UpdateServiceClient.getI18NMessage(UpdateServiceClient.CUSTOMIZER_TITLE);
        }

        public void acceptChanges() {
            try {
                _preferences.flush();
                _preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            this.backupPreferences();
        }

        public void rejectChanges() {
            try {
                _preferences.clear();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_preferenceBackup);
                Preferences.importPreferences(byteArrayInputStream);
                _preferences.sync();
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Throwable)iOException);
            }
            catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
                ExceptionHandler.handleException((Throwable)invalidPreferencesFormatException);
            }
            catch (BackingStoreException backingStoreException) {
                ExceptionHandler.handleException((Throwable)backingStoreException);
            }
        }

        public CustomizerHost getCustomizerHost() {
            return null;
        }

        public void setCustomizerHost(CustomizerHost customizerHost) {
        }
    }
}

