/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.asn1.ASN1EncodingException;
import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.asn1der.asn1.aa;
import com.certicom.ecc.asn1der.asn1.ab;
import com.certicom.ecc.asn1der.asn1.i;
import com.certicom.ecc.asn1der.asn1.l;
import com.certicom.ecc.asn1der.asn1.w;
import com.certicom.ecc.asn1der.asn1.y;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;

public class CCMSTARParameter
extends i
implements Zeroizeable {
    private ab aI;
    private Params aF;
    private int aH = 0;
    private boolean aG = false;
    public static final int EMPTY = 0;
    public static final int NO_AUTH = 1;
    public static final int AUTH = 2;

    public CCMSTARParameter() {
        this.aH = 0;
        this.aI = null;
        this.aF = null;
    }

    public CCMSTARParameter(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("CCMSTAR Parameter : Missing nonce");
        }
        this.aH = 1;
        this.aI = new ab(byArray);
        this.aF = null;
    }

    public CCMSTARParameter(byte[] byArray, byte[] byArray2, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException("CCMSTAR Parameter : Missing nonce");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("CCMSTAR Parameter : Missing associatedData");
        }
        if (byArray2 != null && n < 1) {
            throw new IllegalArgumentException("CCMSTAR Parameter : Invalid mac Length");
        }
        this.aI = null;
        this.aF = new Params(byArray, byArray2, n);
        this.aH = 2;
    }

    public byte typeTag() {
        switch (this.aH) {
            case 1: {
                return this.aI.typeTag();
            }
            case 2: {
                return this.aF.typeTag();
            }
        }
        return 0;
    }

    public int getEncodingStyle() {
        return this.aH;
    }

    public byte[] getNonce() {
        if (this.aF != null) {
            return this.aF.getNonce();
        }
        if (this.aI != null) {
            return this.aI.int();
        }
        return null;
    }

    public byte[] getAssociatedData() {
        if (this.aF != null) {
            return this.aF.getAssociatedData();
        }
        return null;
    }

    public int getMacLength() {
        if (this.aF != null) {
            return this.aF.getMacLength();
        }
        return 0;
    }

    protected void encodeContents(aa aa2) throws ASN1EncodingException {
        switch (this.aH) {
            case 1: {
                this.aI.a(aa2);
                break;
            }
            case 2: {
                this.aF.a(aa2);
                break;
            }
            default: {
                throw new ASN1EncodingException("CCMSTAR Parameters : Encoding failed");
            }
        }
    }

    protected void decodeContents(w w2) throws ASN1ParsingException {
        if (w2.if() == 16) {
            this.aH = 2;
            this.aF = new Params();
            this.aF.a(w2);
        } else if (w2.if() == 4) {
            this.aH = 1;
            this.aI = new ab();
            this.aI.a(w2);
        } else {
            throw new ASN1ParsingException("CCMSTAR Parameters : Decoding failed");
        }
    }

    public boolean isZeroized() {
        return this.aG;
    }

    public boolean testZeroizationState() {
        return this.aG;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.aI = new ab();
        this.aF.zeroize();
        this.aF = null;
        this.aH = 1;
        this.aG = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        return Conversion.OS2Hex((byte[])this.a(), (int)2);
    }

    final class Params
    extends y
    implements Zeroizeable {
        private ab cl;
        private ab cj;
        private l cm;
        private boolean ck = false;

        Params() {
            this.cl = new ab();
            this.cj = new ab();
            this.cm = new l();
        }

        Params(byte[] byArray, byte[] byArray2, int n) {
            this.cl = new ab(byArray);
            this.cj = new ab(byArray2);
            this.cm = new l(n);
        }

        public int getMacLength() {
            return this.cm.new().intValue();
        }

        public byte[] getAssociatedData() {
            return this.cj.int();
        }

        public byte[] getNonce() {
            return this.cl.int();
        }

        public void decodeContents(w w2) throws ASN1ParsingException {
            this.cl.a(w2);
            this.cj.a(w2);
            this.cm.a(w2);
        }

        public void encodeContents(aa aa2) throws ASN1EncodingException {
            this.cl.a(aa2);
            this.cj.a(aa2);
            this.cm.a(aa2);
        }

        public boolean isZeroized() {
            return this.ck;
        }

        public boolean testZeroizationState() {
            return this.ck;
        }

        public boolean canReuse() {
            return false;
        }

        public void zeroize() throws FIPSException {
            this.cl = new ab();
            this.cj = new ab();
            this.cm = new l(0);
            this.ck = true;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.isZeroized()) {
                this.zeroize();
            }
        }
    }
}

