/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.FpParams;
import com.certicom.ecc.jcae.ECF2mParams;
import com.certicom.ecc.jcae.ECFpParams;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.interfaces.F2mParams;
import javax.security.spec.F2mParameterSpec;
import javax.security.spec.FpParameterSpec;

public final class CurveList {
    public static final int FPCURVE = 1;
    public static final int F2MCURVE = 2;

    public static AlgorithmParameterSpec byName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        ECParams eCParams = com.certicom.ecc.scheme.CurveList.byName((String)string);
        if (eCParams == null) {
            throw new IllegalArgumentException("curve not found");
        }
        if (eCParams instanceof com.certicom.ecc.interfaces.F2mParams || eCParams instanceof FpParams) {
            return CurveList.convertParams(eCParams, false);
        }
        throw new IllegalArgumentException("unknown parameter type");
    }

    public static AlgorithmParameterSpec byOID(String string) {
        return CurveList.byName(string);
    }

    public static AlgorithmParameterSpec bySize(int n, int n2) {
        ECParams eCParams;
        if (n2 == 1) {
            n2 = 0;
        }
        if (n2 == 2) {
            n2 = 1;
        }
        if ((eCParams = com.certicom.ecc.scheme.CurveList.bySize((int)n, (int)n2)) == null) {
            throw new IllegalArgumentException("illegal parameters");
        }
        if (n2 == 0 || n2 == 1) {
            return CurveList.convertParams(eCParams, false);
        }
        throw new IllegalArgumentException("unknown parameter type");
    }

    public static AlgorithmParameterSpec convertParams(javax.security.interfaces.ECParams eCParams) {
        String string = eCParams.getOID();
        try {
            return CurveList.byOID(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            byte[] byArray = eCParams.getA();
            byte[] byArray2 = eCParams.getB();
            byte[] byArray3 = eCParams.getSeed();
            byte[] byArray4 = eCParams.getGx();
            byte[] byArray5 = eCParams.getGy();
            byte[] byArray6 = eCParams.getPointOrder();
            int n = eCParams.getCofactor();
            if (eCParams instanceof F2mParams) {
                int n2 = eCParams.getSize();
                int[] nArray = ((F2mParams)eCParams).getBasis();
                return new ECF2mParams(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n, n2, nArray, string);
            }
            if (eCParams instanceof javax.security.interfaces.FpParams) {
                byte[] byArray7 = ((javax.security.interfaces.FpParams)eCParams).getPrime();
                return new ECFpParams(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n, byArray7, string);
            }
            throw new IllegalArgumentException("unknown parameter type");
        }
    }

    public static AlgorithmParameterSpec convertParams(ECParams eCParams, boolean bl) {
        byte[] byArray = eCParams.getA();
        byte[] byArray2 = eCParams.getB();
        byte[] byArray3 = eCParams.getSeed();
        byte[] byArray4 = eCParams.getPoint().getX();
        byte[] byArray5 = eCParams.getPoint().getY();
        byte[] byArray6 = eCParams.getPointOrder();
        int n = eCParams.getCofactor();
        String string = eCParams.getOID();
        if (eCParams instanceof com.certicom.ecc.interfaces.F2mParams) {
            int n2 = eCParams.getSize();
            int[] nArray = ((com.certicom.ecc.interfaces.F2mParams)eCParams).getBasis();
            if (!bl) {
                return new ECF2mParams(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n, n2, nArray, string);
            }
            return new F2mParameterSpec(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n, n2, nArray, string);
        }
        if (eCParams instanceof FpParams) {
            byte[] byArray7 = ((FpParams)eCParams).getPrime();
            if (!bl) {
                return new ECFpParams(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n, byArray7, string);
            }
            return new FpParameterSpec(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n, byArray7, string);
        }
        throw new IllegalArgumentException("unknown parameter type");
    }
}

