/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.DHDefaultParams;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.spec.X942ParameterSpec;
import com.certicom.ecc.spec.X942PrivateKeySpec;
import com.certicom.ecc.spec.X942PublicKeySpec;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.ConversionException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DHKPGenSpi
extends KeyPairGeneratorSpi {
    private static final AlgorithmParameterSpec if = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P512), new BigInteger(1, DHDefaultParams.DEFAULT_Q512), new BigInteger(1, DHDefaultParams.DEFAULT_G512));
    private static final AlgorithmParameterSpec new = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P768), new BigInteger(1, DHDefaultParams.DEFAULT_Q768), new BigInteger(1, DHDefaultParams.DEFAULT_G768));
    private static final AlgorithmParameterSpec int = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P1024), new BigInteger(1, DHDefaultParams.DEFAULT_Q1024), new BigInteger(1, DHDefaultParams.DEFAULT_G1024));
    private SecureRandom for;
    private AlgorithmParameterSpec try;
    CryptoTransform a;
    KeyFactory do;

    public DHKPGenSpi() throws InstantiationException {
        try {
            this.do = KeyFactory.getInstance("DH", "Certicom");
            this.a = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"DSAKEYGEN");
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        DHPublicKeySpec dHPublicKeySpec;
        DHPrivateKeySpec dHPrivateKeySpec;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.for == null) {
            this.for = new SecureRandom();
        }
        if (this.try == null) {
            this.try = int;
        }
        if (this.a.getMode() == 0) {
            try {
                this.initialize(this.try, this.for);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        Object[] objectArray = (Object[])this.a.transformToObject(null, 0, 0, true);
        if (this.try instanceof DSAParameterSpec) {
            bigInteger2 = ((DSAParameterSpec)this.try).getP();
            bigInteger = ((DSAParameterSpec)this.try).getG();
        } else {
            bigInteger2 = ((DHParameterSpec)this.try).getP();
            bigInteger = ((DHParameterSpec)this.try).getG();
        }
        if (this.try instanceof X942ParameterSpec) {
            dHPrivateKeySpec = new X942PrivateKeySpec(new BigInteger(1, (byte[])objectArray[0]), bigInteger2, bigInteger, ((X942ParameterSpec)this.try).getQ(), ((X942ParameterSpec)this.try).getJ(), ((X942ParameterSpec)this.try).getSeed(), ((X942ParameterSpec)this.try).getCounter());
            dHPublicKeySpec = new X942PublicKeySpec(new BigInteger(1, (byte[])objectArray[1]), bigInteger2, bigInteger, ((X942ParameterSpec)this.try).getQ(), ((X942ParameterSpec)this.try).getJ(), ((X942ParameterSpec)this.try).getSeed(), ((X942ParameterSpec)this.try).getCounter());
        } else {
            dHPrivateKeySpec = new DHPrivateKeySpec(new BigInteger(1, (byte[])objectArray[0]), bigInteger2, bigInteger);
            dHPublicKeySpec = new DHPublicKeySpec(new BigInteger(1, (byte[])objectArray[1]), bigInteger2, bigInteger);
        }
        try {
            PrivateKey privateKey = this.do.generatePrivate(dHPrivateKeySpec);
            PublicKey publicKey = this.do.generatePublic(dHPublicKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
            return null;
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        Object[] objectArray = null;
        if (algorithmParameterSpec instanceof DSAParameterSpec) {
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            try {
                byArray3 = Conversion.I2OSP((BigInteger)dSAParameterSpec.getP(), (int)-1);
            }
            catch (ConversionException conversionException) {
                byArray3 = dSAParameterSpec.getP().toByteArray();
            }
            try {
                byArray2 = Conversion.I2OSP((BigInteger)dSAParameterSpec.getQ(), (int)-1);
            }
            catch (ConversionException conversionException) {
                byArray2 = dSAParameterSpec.getQ().toByteArray();
            }
            try {
                byArray = Conversion.I2OSP((BigInteger)dSAParameterSpec.getG(), (int)-1);
            }
            catch (ConversionException conversionException) {
                byArray = dSAParameterSpec.getG().toByteArray();
            }
            objectArray = new Object[]{byArray3, byArray2, byArray};
        } else if (algorithmParameterSpec instanceof DHParameterSpec) {
            byte[] byArray;
            byte[] byArray4;
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            try {
                byArray4 = Conversion.I2OSP((BigInteger)dHParameterSpec.getP(), (int)-1);
            }
            catch (ConversionException conversionException) {
                byArray4 = dHParameterSpec.getP().toByteArray();
            }
            int n = dHParameterSpec.getL();
            Object var7_16 = n < 0 || n > dHParameterSpec.getP().bitLength() ? null : null;
            try {
                byArray = Conversion.I2OSP((BigInteger)dHParameterSpec.getG(), (int)-1);
            }
            catch (ConversionException conversionException) {
                byArray = dHParameterSpec.getG().toByteArray();
            }
            objectArray = new Object[]{byArray4, var7_16, byArray};
        }
        if (objectArray == null) {
            throw new InvalidAlgorithmParameterException("wrong params.");
        }
        this.try = algorithmParameterSpec;
        this.for = secureRandom;
        this.a.init(5, objectArray, (Random)this.for);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        block5: {
            try {
                if (n == 512) {
                    this.initialize(if, secureRandom);
                    break block5;
                }
                if (n == 768) {
                    this.initialize(new, secureRandom);
                    break block5;
                }
                if (n == 1024) {
                    this.initialize(int, secureRandom);
                    break block5;
                }
                throw new IllegalArgumentException("no default parameters size: " + n);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
            }
        }
    }
}

