/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import java.math.BigInteger;

public class DHKeyParams
implements Zeroizeable {
    private BigInteger dk;
    private BigInteger dj;
    private int dh;
    private boolean di = false;

    public DHKeyParams() {
    }

    public DHKeyParams(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, 0);
    }

    public DHKeyParams(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        this.dk = bigInteger;
        this.dj = bigInteger2;
        this.dh = n;
    }

    public DHKeyParams(DHKeyParams dHKeyParams) {
        this.dk = dHKeyParams.getP();
        this.dj = dHKeyParams.getG();
        this.dh = dHKeyParams.getL();
    }

    public BigInteger getP() {
        return this.dk;
    }

    public BigInteger getG() {
        return this.dj;
    }

    public int getL() {
        return this.dh;
    }

    public String toString() {
        return "[ P: " + this.dk.toString(16) + " G: " + this.dj.toString(16) + " L: " + this.dh + " ]";
    }

    public boolean isZeroized() {
        return this.di;
    }

    public boolean testZeroizationState() {
        return this.di;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.dk = BigInteger.ZERO;
        this.dj = BigInteger.ZERO;
        this.dh = 0;
        this.di = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

