/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.a.a.d;
import com.certicom.ecc.asn1der.asn1.ASN1EncodingException;
import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.asn1der.asn1.a;
import com.certicom.ecc.asn1der.asn1.aa;
import com.certicom.ecc.asn1der.asn1.e;
import com.certicom.ecc.asn1der.asn1.l;
import com.certicom.ecc.asn1der.asn1.x;
import com.certicom.ecc.asn1der.b.c;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.jcae.DHKeyParams;
import com.certicom.ecc.jcae.X942KeyParams;
import com.certicom.ecc.spec.X942PrivateKeySpec;
import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;

public class DHPrivateKeyImpl
implements DHPrivateKey,
Zeroizeable {
    private BigInteger Z;
    protected DHKeyParams ab;
    private boolean aa = false;

    public DHPrivateKeyImpl() {
    }

    public DHPrivateKeyImpl(DSAPrivateKey dSAPrivateKey) {
        this.Z = dSAPrivateKey.getX();
        DSAParams dSAParams = dSAPrivateKey.getParams();
        this.ab = new DHKeyParams(dSAParams.getP(), dSAParams.getG(), dSAParams.getQ().bitLength());
    }

    public DHPrivateKeyImpl(DSAPrivateKeySpec dSAPrivateKeySpec) {
        this.Z = dSAPrivateKeySpec.getX();
        this.ab = new DHKeyParams(dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getG(), dSAPrivateKeySpec.getQ().bitLength());
    }

    public DHPrivateKeyImpl(DHPrivateKey dHPrivateKey) {
        this.Z = dHPrivateKey.getX();
        DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
        this.ab = new DHKeyParams(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL());
    }

    public DHPrivateKeyImpl(DHPrivateKeySpec dHPrivateKeySpec) {
        this.Z = dHPrivateKeySpec.getX();
        this.ab = new DHKeyParams(dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG(), this.Z.bitLength());
    }

    public DHPrivateKeyImpl(X942PrivateKeySpec x942PrivateKeySpec) {
        this.Z = x942PrivateKeySpec.getX();
        this.ab = new X942KeyParams(x942PrivateKeySpec.getP(), x942PrivateKeySpec.getG(), x942PrivateKeySpec.getQ(), x942PrivateKeySpec.getJ(), x942PrivateKeySpec.getSeed(), x942PrivateKeySpec.getCounter());
    }

    public DHPrivateKeyImpl(byte[] byArray) throws IOException, ASN1ParsingException {
        com.certicom.ecc.asn1der.a.b.a a2 = new com.certicom.ecc.asn1der.a.b.a();
        a2.do(byArray);
        com.certicom.ecc.asn1der.b.d d2 = a2.z();
        e e2 = d2.Z();
        if (e2.toString().equals("1.2.840.113549.1.3.1")) {
            a a3 = d2.Y();
            this.ab = new DHKeyParams(((d)a3).x(), ((d)a3).y(), ((d)a3).w());
        } else if (e2.toString().equals("1.2.840.10046.2.1")) {
            a a4 = d2.Y();
            this.ab = new X942KeyParams(((com.certicom.ecc.asn1der.b.a)a4).R(), ((com.certicom.ecc.asn1der.b.a)a4).T(), ((com.certicom.ecc.asn1der.b.a)a4).P(), ((com.certicom.ecc.asn1der.b.a)a4).Q(), ((com.certicom.ecc.asn1der.b.a)a4).S().W(), ((com.certicom.ecc.asn1der.b.a)a4).S().X());
        } else {
            throw new IOException("Security_InvalidAlgorithmIdentifier");
        }
        l l2 = new l();
        l2.do(a2.A());
        this.Z = new BigInteger(1, l2.int());
    }

    public BigInteger getX() {
        return this.Z;
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.ab.getP(), this.ab.getG(), this.ab.getL());
    }

    public String getFormat() {
        if (SystemConfig.getConfig().getFormat() == 10) {
            return "RAW";
        }
        return "X.509";
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String toString() {
        return "[ Private key: " + this.Z.toString(16) + " Parameters: " + this.ab.toString() + " ]";
    }

    public byte[] getEncoded() {
        if (SystemConfig.getConfig().getFormat() == 10) {
            throw new IllegalStateException("Cannot encode in RAW mode.");
        }
        try {
            com.certicom.ecc.asn1der.a.b.a a2;
            c c2;
            x x2 = new x();
            new l(this.Z).a((aa)x2);
            byte[] byArray = x2.if();
            if (this.ab instanceof X942KeyParams) {
                c2 = new c(((X942KeyParams)this.ab).getSeed(), ((X942KeyParams)this.ab).getCounter());
                a2 = new com.certicom.ecc.asn1der.a.b.a(new com.certicom.ecc.asn1der.b.d("1.2.840.10046.2.1", (a)new com.certicom.ecc.asn1der.b.a(((X942KeyParams)this.ab).getP(), ((X942KeyParams)this.ab).getG(), ((X942KeyParams)this.ab).getQ(), ((X942KeyParams)this.ab).getJ(), c2)), byArray);
            } else {
                a2 = new com.certicom.ecc.asn1der.a.b.a(new com.certicom.ecc.asn1der.b.d("1.2.840.113549.1.3.1", (a)new d(this.ab.getP(), this.ab.getG(), this.ab.getL())), byArray);
            }
            c2 = new x();
            a2.a((aa)c2);
            return c2.if();
        }
        catch (ASN1EncodingException aSN1EncodingException) {
            throw new IllegalStateException("Could not encode private key");
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IllegalStateException("Could not encode private key");
        }
    }

    public boolean isZeroized() {
        return this.aa;
    }

    public boolean testZeroizationState() {
        return this.aa;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.Z = BigInteger.ZERO;
        if (this.ab != null) {
            this.ab.zeroize();
        }
        this.aa = true;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

