/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.a.a.d;
import com.certicom.ecc.asn1der.asn1.ASN1EncodingException;
import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.asn1der.asn1.a;
import com.certicom.ecc.asn1der.asn1.aa;
import com.certicom.ecc.asn1der.asn1.e;
import com.certicom.ecc.asn1der.asn1.l;
import com.certicom.ecc.asn1der.asn1.x;
import com.certicom.ecc.asn1der.b.b;
import com.certicom.ecc.asn1der.b.c;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.jcae.DHKeyParams;
import com.certicom.ecc.jcae.X942KeyParams;
import com.certicom.ecc.spec.X942PublicKeySpec;
import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHPublicKeyImpl
implements DHPublicKey,
Zeroizeable {
    private BigInteger Y;
    protected DHKeyParams X;
    private boolean W = false;

    public DHPublicKeyImpl() {
    }

    public DHPublicKeyImpl(DSAPublicKey dSAPublicKey) {
        this.Y = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        this.X = new DHKeyParams(dSAParams.getP(), dSAParams.getG(), dSAParams.getQ().bitLength());
    }

    public DHPublicKeyImpl(DSAPublicKeySpec dSAPublicKeySpec) {
        this.Y = dSAPublicKeySpec.getY();
        this.X = new DHKeyParams(dSAPublicKeySpec.getP(), dSAPublicKeySpec.getG(), dSAPublicKeySpec.getQ().bitLength());
    }

    public DHPublicKeyImpl(DHPublicKey dHPublicKey) {
        this.Y = dHPublicKey.getY();
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        this.X = new DHKeyParams(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL());
    }

    public DHPublicKeyImpl(DHPublicKeySpec dHPublicKeySpec) {
        this.Y = dHPublicKeySpec.getY();
        this.X = new DHKeyParams(dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
    }

    public DHPublicKeyImpl(X942PublicKeySpec x942PublicKeySpec) {
        this.Y = x942PublicKeySpec.getY();
        this.X = new X942KeyParams(x942PublicKeySpec.getP(), x942PublicKeySpec.getG(), x942PublicKeySpec.getQ(), x942PublicKeySpec.getJ(), x942PublicKeySpec.getSeed(), x942PublicKeySpec.getCounter());
    }

    public DHPublicKeyImpl(byte[] byArray) throws IOException, ASN1ParsingException {
        b b2 = new b();
        b2.do(byArray);
        com.certicom.ecc.asn1der.b.d d2 = b2.V();
        e e2 = d2.Z();
        if (e2.toString().equals("1.2.840.113549.1.3.1")) {
            a a2 = d2.Y();
            this.X = new DHKeyParams(((d)a2).x(), ((d)a2).y(), ((d)a2).w());
        } else if (e2.toString().equals("1.2.840.10046.2.1")) {
            a a3 = d2.Y();
            this.X = new X942KeyParams(((com.certicom.ecc.asn1der.b.a)a3).R(), ((com.certicom.ecc.asn1der.b.a)a3).T(), ((com.certicom.ecc.asn1der.b.a)a3).P(), ((com.certicom.ecc.asn1der.b.a)a3).Q(), ((com.certicom.ecc.asn1der.b.a)a3).S().W(), ((com.certicom.ecc.asn1der.b.a)a3).S().X());
        } else {
            throw new IOException("Security_InvalidAlgorithmIdentifier");
        }
        l l2 = new l();
        l2.do(b2.U());
        this.Y = new BigInteger(1, l2.int());
    }

    public BigInteger getY() {
        return this.Y;
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.X.getP(), this.X.getG(), this.X.getL());
    }

    public String getFormat() {
        if (SystemConfig.getConfig().getFormat() == 10) {
            return "RAW";
        }
        return "X.509";
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String toString() {
        return "[ Public key: " + this.Y.toString(16) + " Parameters: " + this.X.toString() + " ]";
    }

    public byte[] getEncoded() {
        if (SystemConfig.getConfig().getFormat() == 10) {
            throw new IllegalStateException("Cannot encode in RAW mode.");
        }
        try {
            b b2;
            c c2;
            x x2 = new x();
            new l(this.Y).a((aa)x2);
            byte[] byArray = x2.if();
            if (this.X instanceof X942KeyParams) {
                c2 = new c(((X942KeyParams)this.X).getSeed(), ((X942KeyParams)this.X).getCounter());
                b2 = new b(new com.certicom.ecc.asn1der.b.d("1.2.840.10046.2.1", (a)new com.certicom.ecc.asn1der.b.a(((X942KeyParams)this.X).getP(), ((X942KeyParams)this.X).getG(), ((X942KeyParams)this.X).getQ(), ((X942KeyParams)this.X).getJ(), c2)), byArray);
            } else {
                b2 = new b(new com.certicom.ecc.asn1der.b.d("1.2.840.113549.1.3.1", (a)new d(this.X.getP(), this.X.getG(), this.X.getL())), byArray);
            }
            c2 = new x();
            b2.a((aa)c2);
            return c2.if();
        }
        catch (ASN1EncodingException aSN1EncodingException) {
            throw new IllegalStateException("Could not encode public key");
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IllegalStateException("Could not encode public key");
        }
    }

    public boolean isZeroized() {
        return this.W;
    }

    public boolean testZeroizationState() {
        return this.W;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.Y = BigInteger.ZERO;
        if (this.X != null) {
            this.X.zeroize();
        }
        this.W = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

