/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.ConversionException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Random;

public class DSASignatureSpi
extends SignatureSpi {
    private CryptoTransform a = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"DSA");

    protected DSASignatureSpi(int n) {
        this.a.setHashMode(n);
    }

    public DSASignatureSpi() {
        this(2);
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not DSA private key.");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        DSAParams dSAParams = dSAPrivateKey.getParams();
        try {
            byArray4 = Conversion.I2OSP((BigInteger)dSAParams.getP(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray4 = dSAParams.getP().toByteArray();
        }
        try {
            byArray3 = Conversion.I2OSP((BigInteger)dSAParams.getQ(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray3 = dSAParams.getQ().toByteArray();
        }
        try {
            byArray2 = Conversion.I2OSP((BigInteger)dSAParams.getG(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray2 = dSAParams.getG().toByteArray();
        }
        try {
            byArray = Conversion.I2OSP((BigInteger)dSAPrivateKey.getX(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray = dSAPrivateKey.getX().toByteArray();
        }
        this.a.init(1, new Object[]{byArray4, byArray3, byArray2, byArray}, (Random)this.a());
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not DSA public key.");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        try {
            byArray4 = Conversion.I2OSP((BigInteger)dSAParams.getP(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray4 = dSAParams.getP().toByteArray();
        }
        try {
            byArray3 = Conversion.I2OSP((BigInteger)dSAParams.getQ(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray3 = dSAParams.getQ().toByteArray();
        }
        try {
            byArray2 = Conversion.I2OSP((BigInteger)dSAParams.getG(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray2 = dSAParams.getG().toByteArray();
        }
        try {
            byArray = Conversion.I2OSP((BigInteger)dSAPublicKey.getY(), (int)-1);
        }
        catch (ConversionException conversionException) {
            byArray = dSAPublicKey.getY().toByteArray();
        }
        this.a.init(2, new Object[]{byArray4, byArray3, byArray2, byArray}, null);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("this method is not supported.");
    }

    protected byte[] engineSign() throws SignatureException {
        return this.a.transform(null, 0, 0, true);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.a.transform(new byte[]{by}, 0, 1, false);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.a.transform(byArray, n, n2, false);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.a.verify(byArray, 0, byArray.length);
    }

    private SecureRandom a() {
        if (this.appRandom == null) {
            this.appRandom = new SecureRandom();
        }
        return this.appRandom;
    }
}

