/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.F2mParams;
import com.certicom.ecc.interfaces.FpParams;
import com.certicom.ecc.jcae.CurveList;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.ecc.util.JDKVersion;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.spec.CurveOIDParameterSpec;

public final class ECAlgParamsSpi
extends AlgorithmParametersSpi
implements Zeroizeable {
    private ECParams c1;
    private byte[] c0;
    private String c6;
    private int c3;
    private String cZ;
    private boolean c5 = SystemConfig.getConfig().getFormat() == 10;
    private boolean c7 = false;
    private static Class c2 = class$javax$security$spec$ECParameterSpec == null ? (class$javax$security$spec$ECParameterSpec = ECAlgParamsSpi.class$("javax.security.spec.ECParameterSpec")) : class$javax$security$spec$ECParameterSpec;
    private static Class c4 = class$javax$security$spec$CurveOIDParameterSpec == null ? (class$javax$security$spec$CurveOIDParameterSpec = ECAlgParamsSpi.class$("javax.security.spec.CurveOIDParameterSpec")) : class$javax$security$spec$CurveOIDParameterSpec;
    static /* synthetic */ Class class$javax$security$spec$ECParameterSpec;
    static /* synthetic */ Class class$javax$security$spec$CurveOIDParameterSpec;
    static /* synthetic */ Class class$com$certicom$ecc$interfaces$ECParams;

    public ECAlgParamsSpi() {
        this.c3 = SystemConfig.getConfig().getPtCompression();
        this.cZ = SystemConfig.getConfig().getCurve();
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded(null);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        Object object;
        String string2;
        if (this.c5) {
            throw new IllegalStateException("method non-functional in raw format");
        }
        String string3 = string2 = string == null ? "namedCurve" : string;
        if (this.c0 == null || !string2.equals(this.c6)) {
            try {
                Object[] objectArray;
                object = CryptoCodec.getInstance((String)"ECParams", (int)11);
                if (string2.equals("ImplicitlyCA")) {
                    object.init(1, null);
                } else if (string2.equals("namedCurve")) {
                    objectArray = this.c1.getOID();
                    if (objectArray == null) {
                        throw new IOException("curve does not have an OID to encode");
                    }
                    object.init(1, new Object[]{objectArray});
                } else if (string2.equals("ECParameters")) {
                    objectArray = null;
                    if (this.c1 instanceof FpParams) {
                        objectArray = new Object[8];
                        objectArray[0] = new Integer(1);
                        objectArray[7] = ((FpParams)this.c1).getPrime();
                    } else {
                        int n = ((F2mParams)this.c1).basisType();
                        int[] nArray = ((F2mParams)this.c1).getBasis();
                        if (n == 0) {
                            objectArray = new Object[9];
                            objectArray[8] = new Integer(1);
                        } else if (n == 1) {
                            objectArray = new Object[10];
                            objectArray[8] = new Integer(2);
                            objectArray[9] = new Integer(nArray[0]);
                        } else {
                            objectArray = new Object[12];
                            objectArray[8] = new Integer(3);
                            objectArray[9] = new Integer(nArray[0]);
                            objectArray[10] = new Integer(nArray[1]);
                            objectArray[11] = new Integer(nArray[2]);
                        }
                        objectArray[0] = new Integer(2);
                        objectArray[7] = new Integer(this.c1.getSize());
                    }
                    objectArray[1] = this.c1.getA();
                    objectArray[2] = this.c1.getB();
                    objectArray[3] = this.c1.getSeed();
                    objectArray[4] = this.c1.getPoint().getEncoded(this.c3);
                    objectArray[5] = this.c1.getPointOrder();
                    objectArray[6] = new Integer(this.c1.getCofactor());
                    object.init(1, objectArray);
                } else {
                    throw new IOException("format unrecognized");
                }
                objectArray = object.codecToObject(null, true);
                this.c0 = (byte[])objectArray[1];
                this.c6 = string2;
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException instanceof IllegalArgumentException || runtimeException instanceof IllegalStateException) {
                    throw new IOException(runtimeException.getMessage());
                }
                throw runtimeException;
            }
        }
        object = new byte[this.c0.length];
        System.arraycopy(this.c0, 0, object, 0, ((CryptoCodec)object).length);
        return object;
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        algorithmParameterSpec = c2.isAssignableFrom(clazz) ? CurveList.convertParams(this.c1, true) : (c4.isAssignableFrom(clazz) ? new CurveOIDParameterSpec(this.c1.getOID()) : JDKVersion.getTranslator().translateECParams_1_3_to_1_5(clazz, (AlgorithmParameterSpec)this.c1));
        if (algorithmParameterSpec == null) {
            algorithmParameterSpec = (AlgorithmParameterSpec)this.c1;
        }
        if (clazz.isInstance(algorithmParameterSpec)) {
            return algorithmParameterSpec;
        }
        throw new InvalidParameterSpecException("specification class: " + clazz.getName() + " incompatible with our parameter class " + algorithmParameterSpec.getClass());
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        algorithmParameterSpec = JDKVersion.getTranslator().translateECParams_1_5_to_1_3(class$com$certicom$ecc$interfaces$ECParams == null ? (class$com$certicom$ecc$interfaces$ECParams = ECAlgParamsSpi.class$("com.certicom.ecc.interfaces.ECParams")) : class$com$certicom$ecc$interfaces$ECParams, algorithmParameterSpec);
        if (algorithmParameterSpec instanceof javax.security.interfaces.ECParams) {
            this.c1 = (ECParams)CurveList.convertParams((javax.security.interfaces.ECParams)algorithmParameterSpec);
        } else if (algorithmParameterSpec instanceof CurveOIDParameterSpec) {
            this.c1 = (ECParams)CurveList.byOID(((CurveOIDParameterSpec)algorithmParameterSpec).getOID());
        } else if (algorithmParameterSpec instanceof ECParams) {
            this.c1 = (ECParams)algorithmParameterSpec;
        } else {
            throw new InvalidParameterSpecException("curve specification class unknown.");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, null);
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (this.c5) {
            throw new IllegalStateException("method non-functional in raw format");
        }
        if (byArray == null) {
            throw new IOException("params is null!");
        }
        try {
            CryptoCodec cryptoCodec = CryptoCodec.getInstance((String)"ECParams", (int)11);
            cryptoCodec.init(2, null);
            Object[] objectArray = cryptoCodec.codecToObject(byArray, 0, byArray.length, true);
            String string2 = objectArray[1].toString();
            if (string2.equals("ImplicitlyCA")) {
                this.c1 = (ECParams)CurveList.byName(string2);
            } else {
                if (string2.equals("ECParameters")) {
                    throw new IOException("No support for encoding of full params");
                }
                this.c1 = (ECParams)CurveList.byOID(string2);
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof IllegalArgumentException || runtimeException instanceof IllegalStateException) {
                throw new IOException(runtimeException.getMessage());
            }
            throw runtimeException;
        }
    }

    protected String engineToString() {
        if (this.c1 == null) {
            return "[ curve: 0 ]";
        }
        return this.c1.toString();
    }

    public String toString() {
        return this.engineToString();
    }

    public boolean isZeroized() {
        return this.c7;
    }

    public boolean testZeroizationState() {
        return this.c7;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        if (this.c0 != null) {
            Arrays.fill(this.c0, (byte)0);
        }
        this.c1 = null;
        this.c7 = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

