/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.BlockCipherSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RC5CipherSpi
extends BlockCipherSpi {
    public RC5CipherSpi() {
        super((CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"RC5"), "RC5");
    }

    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey && key.getAlgorithm().equals("RC5")) {
            int n = key.getEncoded().length;
            if (n > 16) {
                throw new InvalidKeyException("Invalid RC5 key length.");
            }
            return n * 8;
        }
        throw new InvalidKeyException("Invalid RC5 key.");
    }

    protected final void if(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey) || !key.getAlgorithm().equals("RC5")) {
            throw new InvalidKeyException("wrong key");
        }
        if (key.getEncoded().length > 16) {
            throw new InvalidKeyException("key too large.");
        }
        this.f[0] = this.h;
        this.f[2] = key.getEncoded();
        if (algorithmParameterSpec == null) {
            if (!this.h.equals("ECB")) {
                if (this.k == 4) {
                    throw new InvalidAlgorithmParameterException("wrong params");
                }
                byte[] byArray = new byte[this.engineGetBlockSize()];
                if (this.e == null) {
                    new SecureRandom().nextBytes(byArray);
                } else {
                    this.e.nextBytes(byArray);
                }
                this.f[3] = byArray;
            }
            this.f[1] = new Integer(16);
        } else if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)algorithmParameterSpec;
            int n = rC5ParameterSpec.getWordSize();
            int n2 = rC5ParameterSpec.getRounds();
            if (n != 32 || n2 > 16 || rC5ParameterSpec.getIV() == null && !this.h.equals("ECB")) {
                throw new InvalidAlgorithmParameterException("Incorrect parameter values.");
            }
            if (this.h.equals("ECB") && rC5ParameterSpec.getIV() != null) {
                throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            }
            this.f[1] = new Integer(n2);
            this.f[3] = rC5ParameterSpec.getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (this.h.equalsIgnoreCase("ECB")) {
                throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            }
            this.f[3] = ((IvParameterSpec)algorithmParameterSpec).getIV();
            this.f[1] = new Integer(16);
        } else {
            throw new InvalidAlgorithmParameterException("wrong params");
        }
    }
}

